setInterval(setClock, 1000);

const hourHand = document.querySelector("[data-hour-hand]");
const minuteHand = document.querySelector("[data-minute-hand]");
const secondHand = document.querySelector("[data-second-hand]");

function setClock() {
   const currentDate = new Date();
   const secondsRatio = currentDate.getSeconds() / 60;
   const minutesRatio = (secondsRatio + currentDate.getMinutes()) / 60;
   const hoursRatio = (minutesRatio + currentDate.getHours()) / 12;
   setRotation(secondHand, secondsRatio);
   setRotation(minuteHand, minutesRatio);
   setRotation(hourHand, hoursRatio);
}

function setRotation(element, rotate) {
   element.style.setProperty("--rotate", rotate * 360);
}

setClock();