<?php
/**
 * FontAwesome.php
 * @author Revin Roman
 * @link https://rmrevin.ru
 */

namespace rmrevin\yii\fontawesome;

use rmrevin\yii\fontawesome\component;

/**
 * Class FA
 * @package rmrevin\yii\fontawesome
 */
class FontAwesome
{
    /**
     * CSS class prefix
     * @var string
     */
    public static $cssPrefix = 'fa';

    /**
     * CSS class prefix
     * @var string
     */
    public static $basePrefix = 'fa';

    /**
     * Creates an `Icon` component that can be used to FontAwesome html icon
     *
     * @param string $name
     * @param array $options
     * @return component\Icon
     */
    public static function icon($name, $options = [])
    {
        return new component\Icon(static::$cssPrefix, $name, $options);
    }

    /**
     * Shortcut for `icon()` method
     * @param string $name
     * @param array $options
     * @return component\Icon
     * @see icon()
     *
     */
    public static function i($name, $options = [])
    {
        return static::icon($name, $options);
    }

    /**
     * Creates an `Stack` component that can be used to FontAwesome html icon
     *
     * @param array $options
     * @return component\Stack
     */
    public static function stack($options = [])
    {
        return new component\Stack(static::$cssPrefix, $options);
    }

    /**
     * Shortcut for `stack()` method
     * @param array $options
     * @return component\Stack
     * @see stack()
     *
     */
    public static function s($options = [])
    {
        return static::stack($options);
    }

    /**
     * @param array $options
     * @return component\UnorderedList
     */
    public static function ul($options = [])
    {
        return new component\UnorderedList(static::$cssPrefix, $options);
    }

    /**
     * Size values
     * @see component\Icon::size
     */
    const SIZE_LARGE = 'lg';
    const SIZE_LG = 'lg';
    const SIZE_SMALL = 'sm';
    const SIZE_SM = 'sm';
    const SIZE_EXTRA_SMALL = 'xs';
    const SIZE_XS = 'xs';
    const SIZE_2X = '2x';
    const SIZE_3X = '3x';
    const SIZE_4X = '4x';
    const SIZE_5X = '5x';
    const SIZE_6X = '6x';
    const SIZE_7X = '7x';
    const SIZE_8X = '8x';
    const SIZE_9X = '9x';
    const SIZE_10X = '10x';

    /**
     * Rotate values
     * @see component\Icon::rotate
     */
    const ROTATE_90 = '90';
    const ROTATE_180 = '180';
    const ROTATE_270 = '270';

    /**
     * Flip values
     * @see component\Icon::flip
     */
    const FLIP_HORIZONTAL = 'horizontal';
    const FLIP_VERTICAL = 'vertical';

    /**
     * Icons name
     */
    const _500PX = '500px';
    const _ACCESSIBLE_ICON = 'accessible-icon';
    const _ACCUSOFT = 'accusoft';
    const _ACQUISITIONS_INCORPORATED = 'acquisitions-incorporated';
    const _AD = 'ad';
    const _ADDRESS_BOOK = 'address-book';
    const _ADDRESS_CARD = 'address-card';
    const _ADJUST = 'adjust';
    const _ADN = 'adn';
    const _ADOBE = 'adobe';
    const _ADVERSAL = 'adversal';
    const _AFFILIATETHEME = 'affiliatetheme';
    const _AIR_FRESHENER = 'air-freshener';
    const _AIRBNB = 'airbnb';
    const _ALGOLIA = 'algolia';
    const _ALIGN_CENTER = 'align-center';
    const _ALIGN_JUSTIFY = 'align-justify';
    const _ALIGN_LEFT = 'align-left';
    const _ALIGN_RIGHT = 'align-right';
    const _ALIPAY = 'alipay';
    const _ALLERGIES = 'allergies';
    const _AMAZON = 'amazon';
    const _AMAZON_PAY = 'amazon-pay';
    const _AMBULANCE = 'ambulance';
    const _AMERICAN_SIGN_LANGUAGE_INTERPRETING = 'american-sign-language-interpreting';
    const _AMILIA = 'amilia';
    const _ANCHOR = 'anchor';
    const _ANDROID = 'android';
    const _ANGELLIST = 'angellist';
    const _ANGLE_DOUBLE_DOWN = 'angle-double-down';
    const _ANGLE_DOUBLE_LEFT = 'angle-double-left';
    const _ANGLE_DOUBLE_RIGHT = 'angle-double-right';
    const _ANGLE_DOUBLE_UP = 'angle-double-up';
    const _ANGLE_DOWN = 'angle-down';
    const _ANGLE_LEFT = 'angle-left';
    const _ANGLE_RIGHT = 'angle-right';
    const _ANGLE_UP = 'angle-up';
    const _ANGRY = 'angry';
    const _ANGRYCREATIVE = 'angrycreative';
    const _ANGULAR = 'angular';
    const _ANKH = 'ankh';
    const _APP_STORE = 'app-store';
    const _APP_STORE_IOS = 'app-store-ios';
    const _APPER = 'apper';
    const _APPLE = 'apple';
    const _APPLE_ALT = 'apple-alt';
    const _APPLE_PAY = 'apple-pay';
    const _ARCHIVE = 'archive';
    const _ARCHWAY = 'archway';
    const _ARROW_ALT_CIRCLE_DOWN = 'arrow-alt-circle-down';
    const _ARROW_ALT_CIRCLE_LEFT = 'arrow-alt-circle-left';
    const _ARROW_ALT_CIRCLE_RIGHT = 'arrow-alt-circle-right';
    const _ARROW_ALT_CIRCLE_UP = 'arrow-alt-circle-up';
    const _ARROW_CIRCLE_DOWN = 'arrow-circle-down';
    const _ARROW_CIRCLE_LEFT = 'arrow-circle-left';
    const _ARROW_CIRCLE_RIGHT = 'arrow-circle-right';
    const _ARROW_CIRCLE_UP = 'arrow-circle-up';
    const _ARROW_DOWN = 'arrow-down';
    const _ARROW_LEFT = 'arrow-left';
    const _ARROW_RIGHT = 'arrow-right';
    const _ARROW_UP = 'arrow-up';
    const _ARROWS_ALT = 'arrows-alt';
    const _ARROWS_ALT_H = 'arrows-alt-h';
    const _ARROWS_ALT_V = 'arrows-alt-v';
    const _ARTSTATION = 'artstation';
    const _ASSISTIVE_LISTENING_SYSTEMS = 'assistive-listening-systems';
    const _ASTERISK = 'asterisk';
    const _ASYMMETRIK = 'asymmetrik';
    const _AT = 'at';
    const _ATLAS = 'atlas';
    const _ATLASSIAN = 'atlassian';
    const _ATOM = 'atom';
    const _AUDIBLE = 'audible';
    const _AUDIO_DESCRIPTION = 'audio-description';
    const _AUTOPREFIXER = 'autoprefixer';
    const _AVIANEX = 'avianex';
    const _AVIATO = 'aviato';
    const _AWARD = 'award';
    const _AWS = 'aws';
    const _BABY = 'baby';
    const _BABY_CARRIAGE = 'baby-carriage';
    const _BACKSPACE = 'backspace';
    const _BACKWARD = 'backward';
    const _BACON = 'bacon';
    const _BALANCE_SCALE = 'balance-scale';
    const _BALANCE_SCALE_LEFT = 'balance-scale-left';
    const _BALANCE_SCALE_RIGHT = 'balance-scale-right';
    const _BAN = 'ban';
    const _BAND_AID = 'band-aid';
    const _BANDCAMP = 'bandcamp';
    const _BARCODE = 'barcode';
    const _BARS = 'bars';
    const _BASEBALL_BALL = 'baseball-ball';
    const _BASKETBALL_BALL = 'basketball-ball';
    const _BATH = 'bath';
    const _BATTERY_EMPTY = 'battery-empty';
    const _BATTERY_FULL = 'battery-full';
    const _BATTERY_HALF = 'battery-half';
    const _BATTERY_QUARTER = 'battery-quarter';
    const _BATTERY_THREE_QUARTERS = 'battery-three-quarters';
    const _BATTLE_NET = 'battle-net';
    const _BED = 'bed';
    const _BEER = 'beer';
    const _BEHANCE = 'behance';
    const _BEHANCE_SQUARE = 'behance-square';
    const _BELL = 'bell';
    const _BELL_SLASH = 'bell-slash';
    const _BEZIER_CURVE = 'bezier-curve';
    const _BIBLE = 'bible';
    const _BICYCLE = 'bicycle';
    const _BIKING = 'biking';
    const _BIMOBJECT = 'bimobject';
    const _BINOCULARS = 'binoculars';
    const _BIOHAZARD = 'biohazard';
    const _BIRTHDAY_CAKE = 'birthday-cake';
    const _BITBUCKET = 'bitbucket';
    const _BITCOIN = 'bitcoin';
    const _BITY = 'bity';
    const _BLACK_TIE = 'black-tie';
    const _BLACKBERRY = 'blackberry';
    const _BLENDER = 'blender';
    const _BLENDER_PHONE = 'blender-phone';
    const _BLIND = 'blind';
    const _BLOG = 'blog';
    const _BLOGGER = 'blogger';
    const _BLOGGER_B = 'blogger-b';
    const _BLUETOOTH = 'bluetooth';
    const _BLUETOOTH_B = 'bluetooth-b';
    const _BOLD = 'bold';
    const _BOLT = 'bolt';
    const _BOMB = 'bomb';
    const _BONE = 'bone';
    const _BONG = 'bong';
    const _BOOK = 'book';
    const _BOOK_DEAD = 'book-dead';
    const _BOOK_MEDICAL = 'book-medical';
    const _BOOK_OPEN = 'book-open';
    const _BOOK_READER = 'book-reader';
    const _BOOKMARK = 'bookmark';
    const _BOOTSTRAP = 'bootstrap';
    const _BORDER_ALL = 'border-all';
    const _BORDER_NONE = 'border-none';
    const _BORDER_STYLE = 'border-style';
    const _BOWLING_BALL = 'bowling-ball';
    const _BOX = 'box';
    const _BOX_OPEN = 'box-open';
    const _BOXES = 'boxes';
    const _BRAILLE = 'braille';
    const _BRAIN = 'brain';
    const _BREAD_SLICE = 'bread-slice';
    const _BRIEFCASE = 'briefcase';
    const _BRIEFCASE_MEDICAL = 'briefcase-medical';
    const _BROADCAST_TOWER = 'broadcast-tower';
    const _BROOM = 'broom';
    const _BRUSH = 'brush';
    const _BTC = 'btc';
    const _BUFFER = 'buffer';
    const _BUG = 'bug';
    const _BUILDING = 'building';
    const _BULLHORN = 'bullhorn';
    const _BULLSEYE = 'bullseye';
    const _BURN = 'burn';
    const _BUROMOBELEXPERTE = 'buromobelexperte';
    const _BUS = 'bus';
    const _BUS_ALT = 'bus-alt';
    const _BUSINESS_TIME = 'business-time';
    const _BUY_N_LARGE = 'buy-n-large';
    const _BUYSELLADS = 'buysellads';
    const _CALCULATOR = 'calculator';
    const _CALENDAR = 'calendar';
    const _CALENDAR_ALT = 'calendar-alt';
    const _CALENDAR_CHECK = 'calendar-check';
    const _CALENDAR_DAY = 'calendar-day';
    const _CALENDAR_MINUS = 'calendar-minus';
    const _CALENDAR_PLUS = 'calendar-plus';
    const _CALENDAR_TIMES = 'calendar-times';
    const _CALENDAR_WEEK = 'calendar-week';
    const _CAMERA = 'camera';
    const _CAMERA_RETRO = 'camera-retro';
    const _CAMPGROUND = 'campground';
    const _CANADIAN_MAPLE_LEAF = 'canadian-maple-leaf';
    const _CANDY_CANE = 'candy-cane';
    const _CANNABIS = 'cannabis';
    const _CAPSULES = 'capsules';
    const _CAR = 'car';
    const _CAR_ALT = 'car-alt';
    const _CAR_BATTERY = 'car-battery';
    const _CAR_CRASH = 'car-crash';
    const _CAR_SIDE = 'car-side';
    const _CARET_DOWN = 'caret-down';
    const _CARET_LEFT = 'caret-left';
    const _CARET_RIGHT = 'caret-right';
    const _CARET_SQUARE_DOWN = 'caret-square-down';
    const _CARET_SQUARE_LEFT = 'caret-square-left';
    const _CARET_SQUARE_RIGHT = 'caret-square-right';
    const _CARET_SQUARE_UP = 'caret-square-up';
    const _CARET_UP = 'caret-up';
    const _CARROT = 'carrot';
    const _CART_ARROW_DOWN = 'cart-arrow-down';
    const _CART_PLUS = 'cart-plus';
    const _CASH_REGISTER = 'cash-register';
    const _CAT = 'cat';
    const _CC_AMAZON_PAY = 'cc-amazon-pay';
    const _CC_AMEX = 'cc-amex';
    const _CC_APPLE_PAY = 'cc-apple-pay';
    const _CC_DINERS_CLUB = 'cc-diners-club';
    const _CC_DISCOVER = 'cc-discover';
    const _CC_JCB = 'cc-jcb';
    const _CC_MASTERCARD = 'cc-mastercard';
    const _CC_PAYPAL = 'cc-paypal';
    const _CC_STRIPE = 'cc-stripe';
    const _CC_VISA = 'cc-visa';
    const _CENTERCODE = 'centercode';
    const _CENTOS = 'centos';
    const _CERTIFICATE = 'certificate';
    const _CHAIR = 'chair';
    const _CHALKBOARD = 'chalkboard';
    const _CHALKBOARD_TEACHER = 'chalkboard-teacher';
    const _CHARGING_STATION = 'charging-station';
    const _CHART_AREA = 'chart-area';
    const _CHART_BAR = 'chart-bar';
    const _CHART_LINE = 'chart-line';
    const _CHART_PIE = 'chart-pie';
    const _CHECK = 'check';
    const _CHECK_CIRCLE = 'check-circle';
    const _CHECK_DOUBLE = 'check-double';
    const _CHECK_SQUARE = 'check-square';
    const _CHEESE = 'cheese';
    const _CHESS = 'chess';
    const _CHESS_BISHOP = 'chess-bishop';
    const _CHESS_BOARD = 'chess-board';
    const _CHESS_KING = 'chess-king';
    const _CHESS_KNIGHT = 'chess-knight';
    const _CHESS_PAWN = 'chess-pawn';
    const _CHESS_QUEEN = 'chess-queen';
    const _CHESS_ROOK = 'chess-rook';
    const _CHEVRON_CIRCLE_DOWN = 'chevron-circle-down';
    const _CHEVRON_CIRCLE_LEFT = 'chevron-circle-left';
    const _CHEVRON_CIRCLE_RIGHT = 'chevron-circle-right';
    const _CHEVRON_CIRCLE_UP = 'chevron-circle-up';
    const _CHEVRON_DOWN = 'chevron-down';
    const _CHEVRON_LEFT = 'chevron-left';
    const _CHEVRON_RIGHT = 'chevron-right';
    const _CHEVRON_UP = 'chevron-up';
    const _CHILD = 'child';
    const _CHROME = 'chrome';
    const _CHROMECAST = 'chromecast';
    const _CHURCH = 'church';
    const _CIRCLE = 'circle';
    const _CIRCLE_NOTCH = 'circle-notch';
    const _CITY = 'city';
    const _CLINIC_MEDICAL = 'clinic-medical';
    const _CLIPBOARD = 'clipboard';
    const _CLIPBOARD_CHECK = 'clipboard-check';
    const _CLIPBOARD_LIST = 'clipboard-list';
    const _CLOCK = 'clock';
    const _CLONE = 'clone';
    const _CLOSED_CAPTIONING = 'closed-captioning';
    const _CLOUD = 'cloud';
    const _CLOUD_DOWNLOAD_ALT = 'cloud-download-alt';
    const _CLOUD_MEATBALL = 'cloud-meatball';
    const _CLOUD_MOON = 'cloud-moon';
    const _CLOUD_MOON_RAIN = 'cloud-moon-rain';
    const _CLOUD_RAIN = 'cloud-rain';
    const _CLOUD_SHOWERS_HEAVY = 'cloud-showers-heavy';
    const _CLOUD_SUN = 'cloud-sun';
    const _CLOUD_SUN_RAIN = 'cloud-sun-rain';
    const _CLOUD_UPLOAD_ALT = 'cloud-upload-alt';
    const _CLOUDSCALE = 'cloudscale';
    const _CLOUDSMITH = 'cloudsmith';
    const _CLOUDVERSIFY = 'cloudversify';
    const _COCKTAIL = 'cocktail';
    const _CODE = 'code';
    const _CODE_BRANCH = 'code-branch';
    const _CODEPEN = 'codepen';
    const _CODIEPIE = 'codiepie';
    const _COFFEE = 'coffee';
    const _COG = 'cog';
    const _COGS = 'cogs';
    const _COINS = 'coins';
    const _COLUMNS = 'columns';
    const _COMMENT = 'comment';
    const _COMMENT_ALT = 'comment-alt';
    const _COMMENT_DOLLAR = 'comment-dollar';
    const _COMMENT_DOTS = 'comment-dots';
    const _COMMENT_MEDICAL = 'comment-medical';
    const _COMMENT_SLASH = 'comment-slash';
    const _COMMENTS = 'comments';
    const _COMMENTS_DOLLAR = 'comments-dollar';
    const _COMPACT_DISC = 'compact-disc';
    const _COMPASS = 'compass';
    const _COMPRESS = 'compress';
    const _COMPRESS_ARROWS_ALT = 'compress-arrows-alt';
    const _CONCIERGE_BELL = 'concierge-bell';
    const _CONFLUENCE = 'confluence';
    const _CONNECTDEVELOP = 'connectdevelop';
    const _CONTAO = 'contao';
    const _COOKIE = 'cookie';
    const _COOKIE_BITE = 'cookie-bite';
    const _COPY = 'copy';
    const _COPYRIGHT = 'copyright';
    const _COTTON_BUREAU = 'cotton-bureau';
    const _COUCH = 'couch';
    const _CPANEL = 'cpanel';
    const _CREATIVE_COMMONS = 'creative-commons';
    const _CREATIVE_COMMONS_BY = 'creative-commons-by';
    const _CREATIVE_COMMONS_NC = 'creative-commons-nc';
    const _CREATIVE_COMMONS_NC_EU = 'creative-commons-nc-eu';
    const _CREATIVE_COMMONS_NC_JP = 'creative-commons-nc-jp';
    const _CREATIVE_COMMONS_ND = 'creative-commons-nd';
    const _CREATIVE_COMMONS_PD = 'creative-commons-pd';
    const _CREATIVE_COMMONS_PD_ALT = 'creative-commons-pd-alt';
    const _CREATIVE_COMMONS_REMIX = 'creative-commons-remix';
    const _CREATIVE_COMMONS_SA = 'creative-commons-sa';
    const _CREATIVE_COMMONS_SAMPLING = 'creative-commons-sampling';
    const _CREATIVE_COMMONS_SAMPLING_PLUS = 'creative-commons-sampling-plus';
    const _CREATIVE_COMMONS_SHARE = 'creative-commons-share';
    const _CREATIVE_COMMONS_ZERO = 'creative-commons-zero';
    const _CREDIT_CARD = 'credit-card';
    const _CRITICAL_ROLE = 'critical-role';
    const _CROP = 'crop';
    const _CROP_ALT = 'crop-alt';
    const _CROSS = 'cross';
    const _CROSSHAIRS = 'crosshairs';
    const _CROW = 'crow';
    const _CROWN = 'crown';
    const _CRUTCH = 'crutch';
    const _CSS3 = 'css3';
    const _CSS3_ALT = 'css3-alt';
    const _CUBE = 'cube';
    const _CUBES = 'cubes';
    const _CUT = 'cut';
    const _CUTTLEFISH = 'cuttlefish';
    const _D_AND_D = 'd-and-d';
    const _D_AND_D_BEYOND = 'd-and-d-beyond';
    const _DASHCUBE = 'dashcube';
    const _DATABASE = 'database';
    const _DEAF = 'deaf';
    const _DELICIOUS = 'delicious';
    const _DEMOCRAT = 'democrat';
    const _DEPLOYDOG = 'deploydog';
    const _DESKPRO = 'deskpro';
    const _DESKTOP = 'desktop';
    const _DEV = 'dev';
    const _DEVIANTART = 'deviantart';
    const _DHARMACHAKRA = 'dharmachakra';
    const _DHL = 'dhl';
    const _DIAGNOSES = 'diagnoses';
    const _DIASPORA = 'diaspora';
    const _DICE = 'dice';
    const _DICE_D20 = 'dice-d20';
    const _DICE_D6 = 'dice-d6';
    const _DICE_FIVE = 'dice-five';
    const _DICE_FOUR = 'dice-four';
    const _DICE_ONE = 'dice-one';
    const _DICE_SIX = 'dice-six';
    const _DICE_THREE = 'dice-three';
    const _DICE_TWO = 'dice-two';
    const _DIGG = 'digg';
    const _DIGITAL_OCEAN = 'digital-ocean';
    const _DIGITAL_TACHOGRAPH = 'digital-tachograph';
    const _DIRECTIONS = 'directions';
    const _DISCORD = 'discord';
    const _DISCOURSE = 'discourse';
    const _DIVIDE = 'divide';
    const _DIZZY = 'dizzy';
    const _DNA = 'dna';
    const _DOCHUB = 'dochub';
    const _DOCKER = 'docker';
    const _DOG = 'dog';
    const _DOLLAR_SIGN = 'dollar-sign';
    const _DOLLY = 'dolly';
    const _DOLLY_FLATBED = 'dolly-flatbed';
    const _DONATE = 'donate';
    const _DOOR_CLOSED = 'door-closed';
    const _DOOR_OPEN = 'door-open';
    const _DOT_CIRCLE = 'dot-circle';
    const _DOVE = 'dove';
    const _DOWNLOAD = 'download';
    const _DRAFT2DIGITAL = 'draft2digital';
    const _DRAFTING_COMPASS = 'drafting-compass';
    const _DRAGON = 'dragon';
    const _DRAW_POLYGON = 'draw-polygon';
    const _DRIBBBLE = 'dribbble';
    const _DRIBBBLE_SQUARE = 'dribbble-square';
    const _DROPBOX = 'dropbox';
    const _DRUM = 'drum';
    const _DRUM_STEELPAN = 'drum-steelpan';
    const _DRUMSTICK_BITE = 'drumstick-bite';
    const _DRUPAL = 'drupal';
    const _DUMBBELL = 'dumbbell';
    const _DUMPSTER = 'dumpster';
    const _DUMPSTER_FIRE = 'dumpster-fire';
    const _DUNGEON = 'dungeon';
    const _DYALOG = 'dyalog';
    const _EARLYBIRDS = 'earlybirds';
    const _EBAY = 'ebay';
    const _EDGE = 'edge';
    const _EDIT = 'edit';
    const _EGG = 'egg';
    const _EJECT = 'eject';
    const _ELEMENTOR = 'elementor';
    const _ELLIPSIS_H = 'ellipsis-h';
    const _ELLIPSIS_V = 'ellipsis-v';
    const _ELLO = 'ello';
    const _EMBER = 'ember';
    const _EMPIRE = 'empire';
    const _ENVELOPE = 'envelope';
    const _ENVELOPE_OPEN = 'envelope-open';
    const _ENVELOPE_OPEN_TEXT = 'envelope-open-text';
    const _ENVELOPE_SQUARE = 'envelope-square';
    const _ENVIRA = 'envira';
    const _EQUALS = 'equals';
    const _ERASER = 'eraser';
    const _ERLANG = 'erlang';
    const _ETHEREUM = 'ethereum';
    const _ETHERNET = 'ethernet';
    const _ETSY = 'etsy';
    const _EURO_SIGN = 'euro-sign';
    const _EVERNOTE = 'evernote';
    const _EXCHANGE_ALT = 'exchange-alt';
    const _EXCLAMATION = 'exclamation';
    const _EXCLAMATION_CIRCLE = 'exclamation-circle';
    const _EXCLAMATION_TRIANGLE = 'exclamation-triangle';
    const _EXPAND = 'expand';
    const _EXPAND_ARROWS_ALT = 'expand-arrows-alt';
    const _EXPEDITEDSSL = 'expeditedssl';
    const _EXTERNAL_LINK_ALT = 'external-link-alt';
    const _EXTERNAL_LINK_SQUARE_ALT = 'external-link-square-alt';
    const _EYE = 'eye';
    const _EYE_DROPPER = 'eye-dropper';
    const _EYE_SLASH = 'eye-slash';
    const _FACEBOOK = 'facebook';
    const _FACEBOOK_F = 'facebook-f';
    const _FACEBOOK_MESSENGER = 'facebook-messenger';
    const _FACEBOOK_SQUARE = 'facebook-square';
    const _FAN = 'fan';
    const _FANTASY_FLIGHT_GAMES = 'fantasy-flight-games';
    const _FAST_BACKWARD = 'fast-backward';
    const _FAST_FORWARD = 'fast-forward';
    const _FAX = 'fax';
    const _FEATHER = 'feather';
    const _FEATHER_ALT = 'feather-alt';
    const _FEDEX = 'fedex';
    const _FEDORA = 'fedora';
    const _FEMALE = 'female';
    const _FIGHTER_JET = 'fighter-jet';
    const _FIGMA = 'figma';
    const _FILE = 'file';
    const _FILE_ALT = 'file-alt';
    const _FILE_ARCHIVE = 'file-archive';
    const _FILE_AUDIO = 'file-audio';
    const _FILE_CODE = 'file-code';
    const _FILE_CONTRACT = 'file-contract';
    const _FILE_CSV = 'file-csv';
    const _FILE_DOWNLOAD = 'file-download';
    const _FILE_EXCEL = 'file-excel';
    const _FILE_EXPORT = 'file-export';
    const _FILE_IMAGE = 'file-image';
    const _FILE_IMPORT = 'file-import';
    const _FILE_INVOICE = 'file-invoice';
    const _FILE_INVOICE_DOLLAR = 'file-invoice-dollar';
    const _FILE_MEDICAL = 'file-medical';
    const _FILE_MEDICAL_ALT = 'file-medical-alt';
    const _FILE_PDF = 'file-pdf';
    const _FILE_POWERPOINT = 'file-powerpoint';
    const _FILE_PRESCRIPTION = 'file-prescription';
    const _FILE_SIGNATURE = 'file-signature';
    const _FILE_UPLOAD = 'file-upload';
    const _FILE_VIDEO = 'file-video';
    const _FILE_WORD = 'file-word';
    const _FILL = 'fill';
    const _FILL_DRIP = 'fill-drip';
    const _FILM = 'film';
    const _FILTER = 'filter';
    const _FINGERPRINT = 'fingerprint';
    const _FIRE = 'fire';
    const _FIRE_ALT = 'fire-alt';
    const _FIRE_EXTINGUISHER = 'fire-extinguisher';
    const _FIREFOX = 'firefox';
    const _FIRST_AID = 'first-aid';
    const _FIRST_ORDER = 'first-order';
    const _FIRST_ORDER_ALT = 'first-order-alt';
    const _FIRSTDRAFT = 'firstdraft';
    const _FISH = 'fish';
    const _FIST_RAISED = 'fist-raised';
    const _FLAG = 'flag';
    const _FLAG_CHECKERED = 'flag-checkered';
    const _FLAG_USA = 'flag-usa';
    const _FLASK = 'flask';
    const _FLICKR = 'flickr';
    const _FLIPBOARD = 'flipboard';
    const _FLUSHED = 'flushed';
    const _FLY = 'fly';
    const _FOLDER = 'folder';
    const _FOLDER_MINUS = 'folder-minus';
    const _FOLDER_OPEN = 'folder-open';
    const _FOLDER_PLUS = 'folder-plus';
    const _FONT = 'font';
    const _FONT_AWESOME = 'font-awesome';
    const _FONT_AWESOME_ALT = 'font-awesome-alt';
    const _FONT_AWESOME_FLAG = 'font-awesome-flag';
    const _FONT_AWESOME_LOGO_FULL = 'font-awesome-logo-full';
    const _FONTICONS = 'fonticons';
    const _FONTICONS_FI = 'fonticons-fi';
    const _FOOTBALL_BALL = 'football-ball';
    const _FORT_AWESOME = 'fort-awesome';
    const _FORT_AWESOME_ALT = 'fort-awesome-alt';
    const _FORUMBEE = 'forumbee';
    const _FORWARD = 'forward';
    const _FOURSQUARE = 'foursquare';
    const _FREE_CODE_CAMP = 'free-code-camp';
    const _FREEBSD = 'freebsd';
    const _FROG = 'frog';
    const _FROWN = 'frown';
    const _FROWN_OPEN = 'frown-open';
    const _FULCRUM = 'fulcrum';
    const _FUNNEL_DOLLAR = 'funnel-dollar';
    const _FUTBOL = 'futbol';
    const _GALACTIC_REPUBLIC = 'galactic-republic';
    const _GALACTIC_SENATE = 'galactic-senate';
    const _GAMEPAD = 'gamepad';
    const _GAS_PUMP = 'gas-pump';
    const _GAVEL = 'gavel';
    const _GEM = 'gem';
    const _GENDERLESS = 'genderless';
    const _GET_POCKET = 'get-pocket';
    const _GG = 'gg';
    const _GG_CIRCLE = 'gg-circle';
    const _GHOST = 'ghost';
    const _GIFT = 'gift';
    const _GIFTS = 'gifts';
    const _GIT = 'git';
    const _GIT_ALT = 'git-alt';
    const _GIT_SQUARE = 'git-square';
    const _GITHUB = 'github';
    const _GITHUB_ALT = 'github-alt';
    const _GITHUB_SQUARE = 'github-square';
    const _GITKRAKEN = 'gitkraken';
    const _GITLAB = 'gitlab';
    const _GITTER = 'gitter';
    const _GLASS_CHEERS = 'glass-cheers';
    const _GLASS_MARTINI = 'glass-martini';
    const _GLASS_MARTINI_ALT = 'glass-martini-alt';
    const _GLASS_WHISKEY = 'glass-whiskey';
    const _GLASSES = 'glasses';
    const _GLIDE = 'glide';
    const _GLIDE_G = 'glide-g';
    const _GLOBE = 'globe';
    const _GLOBE_AFRICA = 'globe-africa';
    const _GLOBE_AMERICAS = 'globe-americas';
    const _GLOBE_ASIA = 'globe-asia';
    const _GLOBE_EUROPE = 'globe-europe';
    const _GOFORE = 'gofore';
    const _GOLF_BALL = 'golf-ball';
    const _GOODREADS = 'goodreads';
    const _GOODREADS_G = 'goodreads-g';
    const _GOOGLE = 'google';
    const _GOOGLE_DRIVE = 'google-drive';
    const _GOOGLE_PLAY = 'google-play';
    const _GOOGLE_PLUS = 'google-plus';
    const _GOOGLE_PLUS_G = 'google-plus-g';
    const _GOOGLE_PLUS_SQUARE = 'google-plus-square';
    const _GOOGLE_WALLET = 'google-wallet';
    const _GOPURAM = 'gopuram';
    const _GRADUATION_CAP = 'graduation-cap';
    const _GRATIPAY = 'gratipay';
    const _GRAV = 'grav';
    const _GREATER_THAN = 'greater-than';
    const _GREATER_THAN_EQUAL = 'greater-than-equal';
    const _GRIMACE = 'grimace';
    const _GRIN = 'grin';
    const _GRIN_ALT = 'grin-alt';
    const _GRIN_BEAM = 'grin-beam';
    const _GRIN_BEAM_SWEAT = 'grin-beam-sweat';
    const _GRIN_HEARTS = 'grin-hearts';
    const _GRIN_SQUINT = 'grin-squint';
    const _GRIN_SQUINT_TEARS = 'grin-squint-tears';
    const _GRIN_STARS = 'grin-stars';
    const _GRIN_TEARS = 'grin-tears';
    const _GRIN_TONGUE = 'grin-tongue';
    const _GRIN_TONGUE_SQUINT = 'grin-tongue-squint';
    const _GRIN_TONGUE_WINK = 'grin-tongue-wink';
    const _GRIN_WINK = 'grin-wink';
    const _GRIP_HORIZONTAL = 'grip-horizontal';
    const _GRIP_LINES = 'grip-lines';
    const _GRIP_LINES_VERTICAL = 'grip-lines-vertical';
    const _GRIP_VERTICAL = 'grip-vertical';
    const _GRIPFIRE = 'gripfire';
    const _GRUNT = 'grunt';
    const _GUITAR = 'guitar';
    const _GULP = 'gulp';
    const _H_SQUARE = 'h-square';
    const _HACKER_NEWS = 'hacker-news';
    const _HACKER_NEWS_SQUARE = 'hacker-news-square';
    const _HACKERRANK = 'hackerrank';
    const _HAMBURGER = 'hamburger';
    const _HAMMER = 'hammer';
    const _HAMSA = 'hamsa';
    const _HAND_HOLDING = 'hand-holding';
    const _HAND_HOLDING_HEART = 'hand-holding-heart';
    const _HAND_HOLDING_USD = 'hand-holding-usd';
    const _HAND_LIZARD = 'hand-lizard';
    const _HAND_MIDDLE_FINGER = 'hand-middle-finger';
    const _HAND_PAPER = 'hand-paper';
    const _HAND_PEACE = 'hand-peace';
    const _HAND_POINT_DOWN = 'hand-point-down';
    const _HAND_POINT_LEFT = 'hand-point-left';
    const _HAND_POINT_RIGHT = 'hand-point-right';
    const _HAND_POINT_UP = 'hand-point-up';
    const _HAND_POINTER = 'hand-pointer';
    const _HAND_ROCK = 'hand-rock';
    const _HAND_SCISSORS = 'hand-scissors';
    const _HAND_SPOCK = 'hand-spock';
    const _HANDS = 'hands';
    const _HANDS_HELPING = 'hands-helping';
    const _HANDSHAKE = 'handshake';
    const _HANUKIAH = 'hanukiah';
    const _HARD_HAT = 'hard-hat';
    const _HASHTAG = 'hashtag';
    const _HAT_COWBOY = 'hat-cowboy';
    const _HAT_COWBOY_SIDE = 'hat-cowboy-side';
    const _HAT_WIZARD = 'hat-wizard';
    const _HAYKAL = 'haykal';
    const _HDD = 'hdd';
    const _HEADING = 'heading';
    const _HEADPHONES = 'headphones';
    const _HEADPHONES_ALT = 'headphones-alt';
    const _HEADSET = 'headset';
    const _HEART = 'heart';
    const _HEART_BROKEN = 'heart-broken';
    const _HEARTBEAT = 'heartbeat';
    const _HELICOPTER = 'helicopter';
    const _HIGHLIGHTER = 'highlighter';
    const _HIKING = 'hiking';
    const _HIPPO = 'hippo';
    const _HIPS = 'hips';
    const _HIRE_A_HELPER = 'hire-a-helper';
    const _HISTORY = 'history';
    const _HOCKEY_PUCK = 'hockey-puck';
    const _HOLLY_BERRY = 'holly-berry';
    const _HOME = 'home';
    const _HOOLI = 'hooli';
    const _HORNBILL = 'hornbill';
    const _HORSE = 'horse';
    const _HORSE_HEAD = 'horse-head';
    const _HOSPITAL = 'hospital';
    const _HOSPITAL_ALT = 'hospital-alt';
    const _HOSPITAL_SYMBOL = 'hospital-symbol';
    const _HOT_TUB = 'hot-tub';
    const _HOTDOG = 'hotdog';
    const _HOTEL = 'hotel';
    const _HOTJAR = 'hotjar';
    const _HOURGLASS = 'hourglass';
    const _HOURGLASS_END = 'hourglass-end';
    const _HOURGLASS_HALF = 'hourglass-half';
    const _HOURGLASS_START = 'hourglass-start';
    const _HOUSE_DAMAGE = 'house-damage';
    const _HOUZZ = 'houzz';
    const _HRYVNIA = 'hryvnia';
    const _HTML5 = 'html5';
    const _HUBSPOT = 'hubspot';
    const _I_CURSOR = 'i-cursor';
    const _ICE_CREAM = 'ice-cream';
    const _ICICLES = 'icicles';
    const _ICONS = 'icons';
    const _ID_BADGE = 'id-badge';
    const _ID_CARD = 'id-card';
    const _ID_CARD_ALT = 'id-card-alt';
    const _IGLOO = 'igloo';
    const _IMAGE = 'image';
    const _IMAGES = 'images';
    const _IMDB = 'imdb';
    const _INBOX = 'inbox';
    const _INDENT = 'indent';
    const _INDUSTRY = 'industry';
    const _INFINITY = 'infinity';
    const _INFO = 'info';
    const _INFO_CIRCLE = 'info-circle';
    const _INSTAGRAM = 'instagram';
    const _INTERCOM = 'intercom';
    const _INTERNET_EXPLORER = 'internet-explorer';
    const _INVISION = 'invision';
    const _IOXHOST = 'ioxhost';
    const _ITALIC = 'italic';
    const _ITCH_IO = 'itch-io';
    const _ITUNES = 'itunes';
    const _ITUNES_NOTE = 'itunes-note';
    const _JAVA = 'java';
    const _JEDI = 'jedi';
    const _JEDI_ORDER = 'jedi-order';
    const _JENKINS = 'jenkins';
    const _JIRA = 'jira';
    const _JOGET = 'joget';
    const _JOINT = 'joint';
    const _JOOMLA = 'joomla';
    const _JOURNAL_WHILLS = 'journal-whills';
    const _JS = 'js';
    const _JS_SQUARE = 'js-square';
    const _JSFIDDLE = 'jsfiddle';
    const _KAABA = 'kaaba';
    const _KAGGLE = 'kaggle';
    const _KEY = 'key';
    const _KEYBASE = 'keybase';
    const _KEYBOARD = 'keyboard';
    const _KEYCDN = 'keycdn';
    const _KHANDA = 'khanda';
    const _KICKSTARTER = 'kickstarter';
    const _KICKSTARTER_K = 'kickstarter-k';
    const _KISS = 'kiss';
    const _KISS_BEAM = 'kiss-beam';
    const _KISS_WINK_HEART = 'kiss-wink-heart';
    const _KIWI_BIRD = 'kiwi-bird';
    const _KORVUE = 'korvue';
    const _LANDMARK = 'landmark';
    const _LANGUAGE = 'language';
    const _LAPTOP = 'laptop';
    const _LAPTOP_CODE = 'laptop-code';
    const _LAPTOP_MEDICAL = 'laptop-medical';
    const _LARAVEL = 'laravel';
    const _LASTFM = 'lastfm';
    const _LASTFM_SQUARE = 'lastfm-square';
    const _LAUGH = 'laugh';
    const _LAUGH_BEAM = 'laugh-beam';
    const _LAUGH_SQUINT = 'laugh-squint';
    const _LAUGH_WINK = 'laugh-wink';
    const _LAYER_GROUP = 'layer-group';
    const _LEAF = 'leaf';
    const _LEANPUB = 'leanpub';
    const _LEMON = 'lemon';
    const _LESS = 'less';
    const _LESS_THAN = 'less-than';
    const _LESS_THAN_EQUAL = 'less-than-equal';
    const _LEVEL_DOWN_ALT = 'level-down-alt';
    const _LEVEL_UP_ALT = 'level-up-alt';
    const _LIFE_RING = 'life-ring';
    const _LIGHTBULB = 'lightbulb';
    const _LINE = 'line';
    const _LINK = 'link';
    const _LINKEDIN = 'linkedin';
    const _LINKEDIN_IN = 'linkedin-in';
    const _LINODE = 'linode';
    const _LINUX = 'linux';
    const _LIRA_SIGN = 'lira-sign';
    const _LIST = 'list';
    const _LIST_ALT = 'list-alt';
    const _LIST_OL = 'list-ol';
    const _LIST_UL = 'list-ul';
    const _LOCATION_ARROW = 'location-arrow';
    const _LOCK = 'lock';
    const _LOCK_OPEN = 'lock-open';
    const _LONG_ARROW_ALT_DOWN = 'long-arrow-alt-down';
    const _LONG_ARROW_ALT_LEFT = 'long-arrow-alt-left';
    const _LONG_ARROW_ALT_RIGHT = 'long-arrow-alt-right';
    const _LONG_ARROW_ALT_UP = 'long-arrow-alt-up';
    const _LOW_VISION = 'low-vision';
    const _LUGGAGE_CART = 'luggage-cart';
    const _LYFT = 'lyft';
    const _MAGENTO = 'magento';
    const _MAGIC = 'magic';
    const _MAGNET = 'magnet';
    const _MAIL_BULK = 'mail-bulk';
    const _MAILCHIMP = 'mailchimp';
    const _MALE = 'male';
    const _MANDALORIAN = 'mandalorian';
    const _MAP = 'map';
    const _MAP_MARKED = 'map-marked';
    const _MAP_MARKED_ALT = 'map-marked-alt';
    const _MAP_MARKER = 'map-marker';
    const _MAP_MARKER_ALT = 'map-marker-alt';
    const _MAP_PIN = 'map-pin';
    const _MAP_SIGNS = 'map-signs';
    const _MARKDOWN = 'markdown';
    const _MARKER = 'marker';
    const _MARS = 'mars';
    const _MARS_DOUBLE = 'mars-double';
    const _MARS_STROKE = 'mars-stroke';
    const _MARS_STROKE_H = 'mars-stroke-h';
    const _MARS_STROKE_V = 'mars-stroke-v';
    const _MASK = 'mask';
    const _MASTODON = 'mastodon';
    const _MAXCDN = 'maxcdn';
    const _MDB = 'mdb';
    const _MEDAL = 'medal';
    const _MEDAPPS = 'medapps';
    const _MEDIUM = 'medium';
    const _MEDIUM_M = 'medium-m';
    const _MEDKIT = 'medkit';
    const _MEDRT = 'medrt';
    const _MEETUP = 'meetup';
    const _MEGAPORT = 'megaport';
    const _MEH = 'meh';
    const _MEH_BLANK = 'meh-blank';
    const _MEH_ROLLING_EYES = 'meh-rolling-eyes';
    const _MEMORY = 'memory';
    const _MENDELEY = 'mendeley';
    const _MENORAH = 'menorah';
    const _MERCURY = 'mercury';
    const _METEOR = 'meteor';
    const _MICROCHIP = 'microchip';
    const _MICROPHONE = 'microphone';
    const _MICROPHONE_ALT = 'microphone-alt';
    const _MICROPHONE_ALT_SLASH = 'microphone-alt-slash';
    const _MICROPHONE_SLASH = 'microphone-slash';
    const _MICROSCOPE = 'microscope';
    const _MICROSOFT = 'microsoft';
    const _MINUS = 'minus';
    const _MINUS_CIRCLE = 'minus-circle';
    const _MINUS_SQUARE = 'minus-square';
    const _MITTEN = 'mitten';
    const _MIX = 'mix';
    const _MIXCLOUD = 'mixcloud';
    const _MIZUNI = 'mizuni';
    const _MOBILE = 'mobile';
    const _MOBILE_ALT = 'mobile-alt';
    const _MODX = 'modx';
    const _MONERO = 'monero';
    const _MONEY_BILL = 'money-bill';
    const _MONEY_BILL_ALT = 'money-bill-alt';
    const _MONEY_BILL_WAVE = 'money-bill-wave';
    const _MONEY_BILL_WAVE_ALT = 'money-bill-wave-alt';
    const _MONEY_CHECK = 'money-check';
    const _MONEY_CHECK_ALT = 'money-check-alt';
    const _MONUMENT = 'monument';
    const _MOON = 'moon';
    const _MORTAR_PESTLE = 'mortar-pestle';
    const _MOSQUE = 'mosque';
    const _MOTORCYCLE = 'motorcycle';
    const _MOUNTAIN = 'mountain';
    const _MOUSE = 'mouse';
    const _MOUSE_POINTER = 'mouse-pointer';
    const _MUG_HOT = 'mug-hot';
    const _MUSIC = 'music';
    const _NAPSTER = 'napster';
    const _NEOS = 'neos';
    const _NETWORK_WIRED = 'network-wired';
    const _NEUTER = 'neuter';
    const _NEWSPAPER = 'newspaper';
    const _NIMBLR = 'nimblr';
    const _NODE = 'node';
    const _NODE_JS = 'node-js';
    const _NOT_EQUAL = 'not-equal';
    const _NOTES_MEDICAL = 'notes-medical';
    const _NPM = 'npm';
    const _NS8 = 'ns8';
    const _NUTRITIONIX = 'nutritionix';
    const _OBJECT_GROUP = 'object-group';
    const _OBJECT_UNGROUP = 'object-ungroup';
    const _ODNOKLASSNIKI = 'odnoklassniki';
    const _ODNOKLASSNIKI_SQUARE = 'odnoklassniki-square';
    const _OIL_CAN = 'oil-can';
    const _OLD_REPUBLIC = 'old-republic';
    const _OM = 'om';
    const _OPENCART = 'opencart';
    const _OPENID = 'openid';
    const _OPERA = 'opera';
    const _OPTIN_MONSTER = 'optin-monster';
    const _ORCID = 'orcid';
    const _OSI = 'osi';
    const _OTTER = 'otter';
    const _OUTDENT = 'outdent';
    const _PAGE4 = 'page4';
    const _PAGELINES = 'pagelines';
    const _PAGER = 'pager';
    const _PAINT_BRUSH = 'paint-brush';
    const _PAINT_ROLLER = 'paint-roller';
    const _PALETTE = 'palette';
    const _PALFED = 'palfed';
    const _PALLET = 'pallet';
    const _PAPER_PLANE = 'paper-plane';
    const _PAPERCLIP = 'paperclip';
    const _PARACHUTE_BOX = 'parachute-box';
    const _PARAGRAPH = 'paragraph';
    const _PARKING = 'parking';
    const _PASSPORT = 'passport';
    const _PASTAFARIANISM = 'pastafarianism';
    const _PASTE = 'paste';
    const _PATREON = 'patreon';
    const _PAUSE = 'pause';
    const _PAUSE_CIRCLE = 'pause-circle';
    const _PAW = 'paw';
    const _PAYPAL = 'paypal';
    const _PEACE = 'peace';
    const _PEN = 'pen';
    const _PEN_ALT = 'pen-alt';
    const _PEN_FANCY = 'pen-fancy';
    const _PEN_NIB = 'pen-nib';
    const _PEN_SQUARE = 'pen-square';
    const _PENCIL_ALT = 'pencil-alt';
    const _PENCIL_RULER = 'pencil-ruler';
    const _PENNY_ARCADE = 'penny-arcade';
    const _PEOPLE_CARRY = 'people-carry';
    const _PEPPER_HOT = 'pepper-hot';
    const _PERCENT = 'percent';
    const _PERCENTAGE = 'percentage';
    const _PERISCOPE = 'periscope';
    const _PERSON_BOOTH = 'person-booth';
    const _PHABRICATOR = 'phabricator';
    const _PHOENIX_FRAMEWORK = 'phoenix-framework';
    const _PHOENIX_SQUADRON = 'phoenix-squadron';
    const _PHONE = 'phone';
    const _PHONE_ALT = 'phone-alt';
    const _PHONE_SLASH = 'phone-slash';
    const _PHONE_SQUARE = 'phone-square';
    const _PHONE_SQUARE_ALT = 'phone-square-alt';
    const _PHONE_VOLUME = 'phone-volume';
    const _PHOTO_VIDEO = 'photo-video';
    const _PHP = 'php';
    const _PIED_PIPER = 'pied-piper';
    const _PIED_PIPER_ALT = 'pied-piper-alt';
    const _PIED_PIPER_HAT = 'pied-piper-hat';
    const _PIED_PIPER_PP = 'pied-piper-pp';
    const _PIGGY_BANK = 'piggy-bank';
    const _PILLS = 'pills';
    const _PINTEREST = 'pinterest';
    const _PINTEREST_P = 'pinterest-p';
    const _PINTEREST_SQUARE = 'pinterest-square';
    const _PIZZA_SLICE = 'pizza-slice';
    const _PLACE_OF_WORSHIP = 'place-of-worship';
    const _PLANE = 'plane';
    const _PLANE_ARRIVAL = 'plane-arrival';
    const _PLANE_DEPARTURE = 'plane-departure';
    const _PLAY = 'play';
    const _PLAY_CIRCLE = 'play-circle';
    const _PLAYSTATION = 'playstation';
    const _PLUG = 'plug';
    const _PLUS = 'plus';
    const _PLUS_CIRCLE = 'plus-circle';
    const _PLUS_SQUARE = 'plus-square';
    const _PODCAST = 'podcast';
    const _POLL = 'poll';
    const _POLL_H = 'poll-h';
    const _POO = 'poo';
    const _POO_STORM = 'poo-storm';
    const _POOP = 'poop';
    const _PORTRAIT = 'portrait';
    const _POUND_SIGN = 'pound-sign';
    const _POWER_OFF = 'power-off';
    const _PRAY = 'pray';
    const _PRAYING_HANDS = 'praying-hands';
    const _PRESCRIPTION = 'prescription';
    const _PRESCRIPTION_BOTTLE = 'prescription-bottle';
    const _PRESCRIPTION_BOTTLE_ALT = 'prescription-bottle-alt';
    const _PRINT = 'print';
    const _PROCEDURES = 'procedures';
    const _PRODUCT_HUNT = 'product-hunt';
    const _PROJECT_DIAGRAM = 'project-diagram';
    const _PUSHED = 'pushed';
    const _PUZZLE_PIECE = 'puzzle-piece';
    const _PYTHON = 'python';
    const _QQ = 'qq';
    const _QRCODE = 'qrcode';
    const _QUESTION = 'question';
    const _QUESTION_CIRCLE = 'question-circle';
    const _QUIDDITCH = 'quidditch';
    const _QUINSCAPE = 'quinscape';
    const _QUORA = 'quora';
    const _QUOTE_LEFT = 'quote-left';
    const _QUOTE_RIGHT = 'quote-right';
    const _QURAN = 'quran';
    const _R_PROJECT = 'r-project';
    const _RADIATION = 'radiation';
    const _RADIATION_ALT = 'radiation-alt';
    const _RAINBOW = 'rainbow';
    const _RANDOM = 'random';
    const _RASPBERRY_PI = 'raspberry-pi';
    const _RAVELRY = 'ravelry';
    const _REACT = 'react';
    const _REACTEUROPE = 'reacteurope';
    const _README = 'readme';
    const _REBEL = 'rebel';
    const _RECEIPT = 'receipt';
    const _RECORD_VINYL = 'record-vinyl';
    const _RECYCLE = 'recycle';
    const _RED_RIVER = 'red-river';
    const _REDDIT = 'reddit';
    const _REDDIT_ALIEN = 'reddit-alien';
    const _REDDIT_SQUARE = 'reddit-square';
    const _REDHAT = 'redhat';
    const _REDO = 'redo';
    const _REDO_ALT = 'redo-alt';
    const _REGISTERED = 'registered';
    const _REMOVE_FORMAT = 'remove-format';
    const _RENREN = 'renren';
    const _REPLY = 'reply';
    const _REPLY_ALL = 'reply-all';
    const _REPLYD = 'replyd';
    const _REPUBLICAN = 'republican';
    const _RESEARCHGATE = 'researchgate';
    const _RESOLVING = 'resolving';
    const _RESTROOM = 'restroom';
    const _RETWEET = 'retweet';
    const _REV = 'rev';
    const _RIBBON = 'ribbon';
    const _RING = 'ring';
    const _ROAD = 'road';
    const _ROBOT = 'robot';
    const _ROCKET = 'rocket';
    const _ROCKETCHAT = 'rocketchat';
    const _ROCKRMS = 'rockrms';
    const _ROUTE = 'route';
    const _RSS = 'rss';
    const _RSS_SQUARE = 'rss-square';
    const _RUBLE_SIGN = 'ruble-sign';
    const _RULER = 'ruler';
    const _RULER_COMBINED = 'ruler-combined';
    const _RULER_HORIZONTAL = 'ruler-horizontal';
    const _RULER_VERTICAL = 'ruler-vertical';
    const _RUNNING = 'running';
    const _RUPEE_SIGN = 'rupee-sign';
    const _SAD_CRY = 'sad-cry';
    const _SAD_TEAR = 'sad-tear';
    const _SAFARI = 'safari';
    const _SALESFORCE = 'salesforce';
    const _SASS = 'sass';
    const _SATELLITE = 'satellite';
    const _SATELLITE_DISH = 'satellite-dish';
    const _SAVE = 'save';
    const _SCHLIX = 'schlix';
    const _SCHOOL = 'school';
    const _SCREWDRIVER = 'screwdriver';
    const _SCRIBD = 'scribd';
    const _SCROLL = 'scroll';
    const _SD_CARD = 'sd-card';
    const _SEARCH = 'search';
    const _SEARCH_DOLLAR = 'search-dollar';
    const _SEARCH_LOCATION = 'search-location';
    const _SEARCH_MINUS = 'search-minus';
    const _SEARCH_PLUS = 'search-plus';
    const _SEARCHENGIN = 'searchengin';
    const _SEEDLING = 'seedling';
    const _SELLCAST = 'sellcast';
    const _SELLSY = 'sellsy';
    const _SERVER = 'server';
    const _SERVICESTACK = 'servicestack';
    const _SHAPES = 'shapes';
    const _SHARE = 'share';
    const _SHARE_ALT = 'share-alt';
    const _SHARE_ALT_SQUARE = 'share-alt-square';
    const _SHARE_SQUARE = 'share-square';
    const _SHEKEL_SIGN = 'shekel-sign';
    const _SHIELD_ALT = 'shield-alt';
    const _SHIP = 'ship';
    const _SHIPPING_FAST = 'shipping-fast';
    const _SHIRTSINBULK = 'shirtsinbulk';
    const _SHOE_PRINTS = 'shoe-prints';
    const _SHOPPING_BAG = 'shopping-bag';
    const _SHOPPING_BASKET = 'shopping-basket';
    const _SHOPPING_CART = 'shopping-cart';
    const _SHOPWARE = 'shopware';
    const _SHOWER = 'shower';
    const _SHUTTLE_VAN = 'shuttle-van';
    const _SIGN = 'sign';
    const _SIGN_IN_ALT = 'sign-in-alt';
    const _SIGN_LANGUAGE = 'sign-language';
    const _SIGN_OUT_ALT = 'sign-out-alt';
    const _SIGNAL = 'signal';
    const _SIGNATURE = 'signature';
    const _SIM_CARD = 'sim-card';
    const _SIMPLYBUILT = 'simplybuilt';
    const _SISTRIX = 'sistrix';
    const _SITEMAP = 'sitemap';
    const _SITH = 'sith';
    const _SKATING = 'skating';
    const _SKETCH = 'sketch';
    const _SKIING = 'skiing';
    const _SKIING_NORDIC = 'skiing-nordic';
    const _SKULL = 'skull';
    const _SKULL_CROSSBONES = 'skull-crossbones';
    const _SKYATLAS = 'skyatlas';
    const _SKYPE = 'skype';
    const _SLACK = 'slack';
    const _SLACK_HASH = 'slack-hash';
    const _SLASH = 'slash';
    const _SLEIGH = 'sleigh';
    const _SLIDERS_H = 'sliders-h';
    const _SLIDESHARE = 'slideshare';
    const _SMILE = 'smile';
    const _SMILE_BEAM = 'smile-beam';
    const _SMILE_WINK = 'smile-wink';
    const _SMOG = 'smog';
    const _SMOKING = 'smoking';
    const _SMOKING_BAN = 'smoking-ban';
    const _SMS = 'sms';
    const _SNAPCHAT = 'snapchat';
    const _SNAPCHAT_GHOST = 'snapchat-ghost';
    const _SNAPCHAT_SQUARE = 'snapchat-square';
    const _SNOWBOARDING = 'snowboarding';
    const _SNOWFLAKE = 'snowflake';
    const _SNOWMAN = 'snowman';
    const _SNOWPLOW = 'snowplow';
    const _SOCKS = 'socks';
    const _SOLAR_PANEL = 'solar-panel';
    const _SORT = 'sort';
    const _SORT_ALPHA_DOWN = 'sort-alpha-down';
    const _SORT_ALPHA_DOWN_ALT = 'sort-alpha-down-alt';
    const _SORT_ALPHA_UP = 'sort-alpha-up';
    const _SORT_ALPHA_UP_ALT = 'sort-alpha-up-alt';
    const _SORT_AMOUNT_DOWN = 'sort-amount-down';
    const _SORT_AMOUNT_DOWN_ALT = 'sort-amount-down-alt';
    const _SORT_AMOUNT_UP = 'sort-amount-up';
    const _SORT_AMOUNT_UP_ALT = 'sort-amount-up-alt';
    const _SORT_DOWN = 'sort-down';
    const _SORT_NUMERIC_DOWN = 'sort-numeric-down';
    const _SORT_NUMERIC_DOWN_ALT = 'sort-numeric-down-alt';
    const _SORT_NUMERIC_UP = 'sort-numeric-up';
    const _SORT_NUMERIC_UP_ALT = 'sort-numeric-up-alt';
    const _SORT_UP = 'sort-up';
    const _SOUNDCLOUD = 'soundcloud';
    const _SOURCETREE = 'sourcetree';
    const _SPA = 'spa';
    const _SPACE_SHUTTLE = 'space-shuttle';
    const _SPEAKAP = 'speakap';
    const _SPEAKER_DECK = 'speaker-deck';
    const _SPELL_CHECK = 'spell-check';
    const _SPIDER = 'spider';
    const _SPINNER = 'spinner';
    const _SPLOTCH = 'splotch';
    const _SPOTIFY = 'spotify';
    const _SPRAY_CAN = 'spray-can';
    const _SQUARE = 'square';
    const _SQUARE_FULL = 'square-full';
    const _SQUARE_ROOT_ALT = 'square-root-alt';
    const _SQUARESPACE = 'squarespace';
    const _STACK_EXCHANGE = 'stack-exchange';
    const _STACK_OVERFLOW = 'stack-overflow';
    const _STACKPATH = 'stackpath';
    const _STAMP = 'stamp';
    const _STAR = 'star';
    const _STAR_AND_CRESCENT = 'star-and-crescent';
    const _STAR_HALF = 'star-half';
    const _STAR_HALF_ALT = 'star-half-alt';
    const _STAR_OF_DAVID = 'star-of-david';
    const _STAR_OF_LIFE = 'star-of-life';
    const _STAYLINKED = 'staylinked';
    const _STEAM = 'steam';
    const _STEAM_SQUARE = 'steam-square';
    const _STEAM_SYMBOL = 'steam-symbol';
    const _STEP_BACKWARD = 'step-backward';
    const _STEP_FORWARD = 'step-forward';
    const _STETHOSCOPE = 'stethoscope';
    const _STICKER_MULE = 'sticker-mule';
    const _STICKY_NOTE = 'sticky-note';
    const _STOP = 'stop';
    const _STOP_CIRCLE = 'stop-circle';
    const _STOPWATCH = 'stopwatch';
    const _STORE = 'store';
    const _STORE_ALT = 'store-alt';
    const _STRAVA = 'strava';
    const _STREAM = 'stream';
    const _STREET_VIEW = 'street-view';
    const _STRIKETHROUGH = 'strikethrough';
    const _STRIPE = 'stripe';
    const _STRIPE_S = 'stripe-s';
    const _STROOPWAFEL = 'stroopwafel';
    const _STUDIOVINARI = 'studiovinari';
    const _STUMBLEUPON = 'stumbleupon';
    const _STUMBLEUPON_CIRCLE = 'stumbleupon-circle';
    const _SUBSCRIPT = 'subscript';
    const _SUBWAY = 'subway';
    const _SUITCASE = 'suitcase';
    const _SUITCASE_ROLLING = 'suitcase-rolling';
    const _SUN = 'sun';
    const _SUPERPOWERS = 'superpowers';
    const _SUPERSCRIPT = 'superscript';
    const _SUPPLE = 'supple';
    const _SURPRISE = 'surprise';
    const _SUSE = 'suse';
    const _SWATCHBOOK = 'swatchbook';
    const _SWIFT = 'swift';
    const _SWIMMER = 'swimmer';
    const _SWIMMING_POOL = 'swimming-pool';
    const _SYMFONY = 'symfony';
    const _SYNAGOGUE = 'synagogue';
    const _SYNC = 'sync';
    const _SYNC_ALT = 'sync-alt';
    const _SYRINGE = 'syringe';
    const _TABLE = 'table';
    const _TABLE_TENNIS = 'table-tennis';
    const _TABLET = 'tablet';
    const _TABLET_ALT = 'tablet-alt';
    const _TABLETS = 'tablets';
    const _TACHOMETER_ALT = 'tachometer-alt';
    const _TAG = 'tag';
    const _TAGS = 'tags';
    const _TAPE = 'tape';
    const _TASKS = 'tasks';
    const _TAXI = 'taxi';
    const _TEAMSPEAK = 'teamspeak';
    const _TEETH = 'teeth';
    const _TEETH_OPEN = 'teeth-open';
    const _TELEGRAM = 'telegram';
    const _TELEGRAM_PLANE = 'telegram-plane';
    const _TEMPERATURE_HIGH = 'temperature-high';
    const _TEMPERATURE_LOW = 'temperature-low';
    const _TENCENT_WEIBO = 'tencent-weibo';
    const _TENGE = 'tenge';
    const _TERMINAL = 'terminal';
    const _TEXT_HEIGHT = 'text-height';
    const _TEXT_WIDTH = 'text-width';
    const _TH = 'th';
    const _TH_LARGE = 'th-large';
    const _TH_LIST = 'th-list';
    const _THE_RED_YETI = 'the-red-yeti';
    const _THEATER_MASKS = 'theater-masks';
    const _THEMECO = 'themeco';
    const _THEMEISLE = 'themeisle';
    const _THERMOMETER = 'thermometer';
    const _THERMOMETER_EMPTY = 'thermometer-empty';
    const _THERMOMETER_FULL = 'thermometer-full';
    const _THERMOMETER_HALF = 'thermometer-half';
    const _THERMOMETER_QUARTER = 'thermometer-quarter';
    const _THERMOMETER_THREE_QUARTERS = 'thermometer-three-quarters';
    const _THINK_PEAKS = 'think-peaks';
    const _THUMBS_DOWN = 'thumbs-down';
    const _THUMBS_UP = 'thumbs-up';
    const _THUMBTACK = 'thumbtack';
    const _TICKET_ALT = 'ticket-alt';
    const _TIMES = 'times';
    const _TIMES_CIRCLE = 'times-circle';
    const _TINT = 'tint';
    const _TINT_SLASH = 'tint-slash';
    const _TIRED = 'tired';
    const _TOGGLE_OFF = 'toggle-off';
    const _TOGGLE_ON = 'toggle-on';
    const _TOILET = 'toilet';
    const _TOILET_PAPER = 'toilet-paper';
    const _TOOLBOX = 'toolbox';
    const _TOOLS = 'tools';
    const _TOOTH = 'tooth';
    const _TORAH = 'torah';
    const _TORII_GATE = 'torii-gate';
    const _TRACTOR = 'tractor';
    const _TRADE_FEDERATION = 'trade-federation';
    const _TRADEMARK = 'trademark';
    const _TRAFFIC_LIGHT = 'traffic-light';
    const _TRAIN = 'train';
    const _TRAM = 'tram';
    const _TRANSGENDER = 'transgender';
    const _TRANSGENDER_ALT = 'transgender-alt';
    const _TRASH = 'trash';
    const _TRASH_ALT = 'trash-alt';
    const _TRASH_RESTORE = 'trash-restore';
    const _TRASH_RESTORE_ALT = 'trash-restore-alt';
    const _TREE = 'tree';
    const _TRELLO = 'trello';
    const _TRIPADVISOR = 'tripadvisor';
    const _TROPHY = 'trophy';
    const _TRUCK = 'truck';
    const _TRUCK_LOADING = 'truck-loading';
    const _TRUCK_MONSTER = 'truck-monster';
    const _TRUCK_MOVING = 'truck-moving';
    const _TRUCK_PICKUP = 'truck-pickup';
    const _TSHIRT = 'tshirt';
    const _TTY = 'tty';
    const _TUMBLR = 'tumblr';
    const _TUMBLR_SQUARE = 'tumblr-square';
    const _TV = 'tv';
    const _TWITCH = 'twitch';
    const _TWITTER = 'twitter';
    const _TWITTER_SQUARE = 'twitter-square';
    const _TYPO3 = 'typo3';
    const _UBER = 'uber';
    const _UBUNTU = 'ubuntu';
    const _UIKIT = 'uikit';
    const _UMBRACO = 'umbraco';
    const _UMBRELLA = 'umbrella';
    const _UMBRELLA_BEACH = 'umbrella-beach';
    const _UNDERLINE = 'underline';
    const _UNDO = 'undo';
    const _UNDO_ALT = 'undo-alt';
    const _UNIREGISTRY = 'uniregistry';
    const _UNIVERSAL_ACCESS = 'universal-access';
    const _UNIVERSITY = 'university';
    const _UNLINK = 'unlink';
    const _UNLOCK = 'unlock';
    const _UNLOCK_ALT = 'unlock-alt';
    const _UNTAPPD = 'untappd';
    const _UPLOAD = 'upload';
    const _UPS = 'ups';
    const _USB = 'usb';
    const _USER = 'user';
    const _USER_ALT = 'user-alt';
    const _USER_ALT_SLASH = 'user-alt-slash';
    const _USER_ASTRONAUT = 'user-astronaut';
    const _USER_CHECK = 'user-check';
    const _USER_CIRCLE = 'user-circle';
    const _USER_CLOCK = 'user-clock';
    const _USER_COG = 'user-cog';
    const _USER_EDIT = 'user-edit';
    const _USER_FRIENDS = 'user-friends';
    const _USER_GRADUATE = 'user-graduate';
    const _USER_INJURED = 'user-injured';
    const _USER_LOCK = 'user-lock';
    const _USER_MD = 'user-md';
    const _USER_MINUS = 'user-minus';
    const _USER_NINJA = 'user-ninja';
    const _USER_NURSE = 'user-nurse';
    const _USER_PLUS = 'user-plus';
    const _USER_SECRET = 'user-secret';
    const _USER_SHIELD = 'user-shield';
    const _USER_SLASH = 'user-slash';
    const _USER_TAG = 'user-tag';
    const _USER_TIE = 'user-tie';
    const _USER_TIMES = 'user-times';
    const _USERS = 'users';
    const _USERS_COG = 'users-cog';
    const _USPS = 'usps';
    const _USSUNNAH = 'ussunnah';
    const _UTENSIL_SPOON = 'utensil-spoon';
    const _UTENSILS = 'utensils';
    const _VAADIN = 'vaadin';
    const _VECTOR_SQUARE = 'vector-square';
    const _VENUS = 'venus';
    const _VENUS_DOUBLE = 'venus-double';
    const _VENUS_MARS = 'venus-mars';
    const _VIACOIN = 'viacoin';
    const _VIADEO = 'viadeo';
    const _VIADEO_SQUARE = 'viadeo-square';
    const _VIAL = 'vial';
    const _VIALS = 'vials';
    const _VIBER = 'viber';
    const _VIDEO = 'video';
    const _VIDEO_SLASH = 'video-slash';
    const _VIHARA = 'vihara';
    const _VIMEO = 'vimeo';
    const _VIMEO_SQUARE = 'vimeo-square';
    const _VIMEO_V = 'vimeo-v';
    const _VINE = 'vine';
    const _VK = 'vk';
    const _VNV = 'vnv';
    const _VOICEMAIL = 'voicemail';
    const _VOLLEYBALL_BALL = 'volleyball-ball';
    const _VOLUME_DOWN = 'volume-down';
    const _VOLUME_MUTE = 'volume-mute';
    const _VOLUME_OFF = 'volume-off';
    const _VOLUME_UP = 'volume-up';
    const _VOTE_YEA = 'vote-yea';
    const _VR_CARDBOARD = 'vr-cardboard';
    const _VUEJS = 'vuejs';
    const _WALKING = 'walking';
    const _WALLET = 'wallet';
    const _WAREHOUSE = 'warehouse';
    const _WATER = 'water';
    const _WAVE_SQUARE = 'wave-square';
    const _WAZE = 'waze';
    const _WEEBLY = 'weebly';
    const _WEIBO = 'weibo';
    const _WEIGHT = 'weight';
    const _WEIGHT_HANGING = 'weight-hanging';
    const _WEIXIN = 'weixin';
    const _WHATSAPP = 'whatsapp';
    const _WHATSAPP_SQUARE = 'whatsapp-square';
    const _WHEELCHAIR = 'wheelchair';
    const _WHMCS = 'whmcs';
    const _WIFI = 'wifi';
    const _WIKIPEDIA_W = 'wikipedia-w';
    const _WIND = 'wind';
    const _WINDOW_CLOSE = 'window-close';
    const _WINDOW_MAXIMIZE = 'window-maximize';
    const _WINDOW_MINIMIZE = 'window-minimize';
    const _WINDOW_RESTORE = 'window-restore';
    const _WINDOWS = 'windows';
    const _WINE_BOTTLE = 'wine-bottle';
    const _WINE_GLASS = 'wine-glass';
    const _WINE_GLASS_ALT = 'wine-glass-alt';
    const _WIX = 'wix';
    const _WIZARDS_OF_THE_COAST = 'wizards-of-the-coast';
    const _WOLF_PACK_BATTALION = 'wolf-pack-battalion';
    const _WON_SIGN = 'won-sign';
    const _WORDPRESS = 'wordpress';
    const _WORDPRESS_SIMPLE = 'wordpress-simple';
    const _WPBEGINNER = 'wpbeginner';
    const _WPEXPLORER = 'wpexplorer';
    const _WPFORMS = 'wpforms';
    const _WPRESSR = 'wpressr';
    const _WRENCH = 'wrench';
    const _X_RAY = 'x-ray';
    const _XBOX = 'xbox';
    const _XING = 'xing';
    const _XING_SQUARE = 'xing-square';
    const _Y_COMBINATOR = 'y-combinator';
    const _YAHOO = 'yahoo';
    const _YAMMER = 'yammer';
    const _YANDEX = 'yandex';
    const _YANDEX_INTERNATIONAL = 'yandex-international';
    const _YARN = 'yarn';
    const _YELP = 'yelp';
    const _YEN_SIGN = 'yen-sign';
    const _YIN_YANG = 'yin-yang';
    const _YOAST = 'yoast';
    const _YOUTUBE = 'youtube';
    const _YOUTUBE_SQUARE = 'youtube-square';
    const _ZHIHU = 'zhihu';
}
