import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { mapToCssModules, tagPropType } from './utils';

const propTypes = {
  /** Add custom class */
  className: PropTypes.string,
  /** Change underlying component's CSS base class name */
  cssModule: PropTypes.object,
  /** Set a custom element for this component */
  tag: tagPropType,
  type: PropTypes.string,
  /** Pass children so this component can wrap the child elements */
  children: PropTypes.node,
};

const defaultProps = {
  tag: 'button',
  type: 'button',
};

function NavbarToggler(props) {
  const { className, cssModule, children, tag: Tag, ...attributes } = props;

  const classes = mapToCssModules(
    classNames(className, 'navbar-toggler'),
    cssModule,
  );

  return (
    <Tag aria-label="Toggle navigation" {...attributes} className={classes}>
      {children || (
        <span className={mapToCssModules('navbar-toggler-icon', cssModule)} />
      )}
    </Tag>
  );
}

NavbarToggler.propTypes = propTypes;
NavbarToggler.defaultProps = defaultProps;

export default NavbarToggler;
