# Generated by Django 4.1 on 2023-04-16 13:11

import datetime
from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('username', models.CharField(max_length=100, primary_key=True, serialize=False, unique=True)),
                ('phone', models.CharField(blank=True, max_length=10)),
                ('is_recruiter', models.BooleanField(default=False)),
                ('is_candidate', models.BooleanField(default=False)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Apptitude',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('question', models.TextField(unique=True)),
                ('answer_position', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(4)], verbose_name='answer_position')),
                ('category', models.CharField(choices=[['All', 'All'], ['Profit and Loss', 'Profit and Loss'], ['Time and Work', 'Time and Work'], ['Time and Distance', 'Time and Distance'], ['Number System', 'Number System'], ['Average', 'Average'], ['Percentage', 'Percentage'], ['Ratio and Proportion', 'Ratio and Proportion'], ['Mensuration', 'Mensuration'], ['Simple Interest', 'Simple Interest'], ['Compound Interest', 'Compound Interest'], ['Algebra', 'Algebra'], ['Geometry', 'Geometry'], ['Trigonometry', 'Trigonometry'], ['Data Interpretation', 'Data Interpretation'], ['Miscellaneous', 'Miscellaneous']], default='All', max_length=100)),
                ('difficulty', models.IntegerField(choices=[[1, 'Easy'], [2, 'Medium'], [3, 'Hard']], default=1)),
                ('added_by', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, related_name='choices', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Challenge',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('note', models.TextField(default='No Note')),
                ('difficulty', models.IntegerField(choices=[[1, 'Easy'], [2, 'Medium'], [3, 'Hard']], default=1)),
                ('category', models.CharField(choices=[['All', 'All'], ['Profit and Loss', 'Profit and Loss'], ['Time and Work', 'Time and Work'], ['Time and Distance', 'Time and Distance'], ['Number System', 'Number System'], ['Average', 'Average'], ['Percentage', 'Percentage'], ['Ratio and Proportion', 'Ratio and Proportion'], ['Mensuration', 'Mensuration'], ['Simple Interest', 'Simple Interest'], ['Compound Interest', 'Compound Interest'], ['Algebra', 'Algebra'], ['Geometry', 'Geometry'], ['Trigonometry', 'Trigonometry'], ['Data Interpretation', 'Data Interpretation'], ['Miscellaneous', 'Miscellaneous']], default='All', max_length=100)),
                ('start_time', models.DateTimeField(auto_now_add=True)),
                ('end_time', models.DateTimeField(default=datetime.datetime(2023, 4, 17, 18, 41, 40, 377242))),
                ('questions', models.ManyToManyField(to='corival.apptitude')),
            ],
        ),
        migrations.CreateModel(
            name='Contest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('description', models.TextField()),
                ('category', models.CharField(choices=[['All', 'All'], ['Profit and Loss', 'Profit and Loss'], ['Time and Work', 'Time and Work'], ['Time and Distance', 'Time and Distance'], ['Number System', 'Number System'], ['Average', 'Average'], ['Percentage', 'Percentage'], ['Ratio and Proportion', 'Ratio and Proportion'], ['Mensuration', 'Mensuration'], ['Simple Interest', 'Simple Interest'], ['Compound Interest', 'Compound Interest'], ['Algebra', 'Algebra'], ['Geometry', 'Geometry'], ['Trigonometry', 'Trigonometry'], ['Data Interpretation', 'Data Interpretation'], ['Miscellaneous', 'Miscellaneous']], default='All', max_length=100)),
                ('difficulty', models.IntegerField(choices=[[1, 'Easy'], [2, 'Medium'], [3, 'Hard']], default=1)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contests', to=settings.AUTH_USER_MODEL)),
                ('questions', models.ManyToManyField(to='corival.apptitude')),
            ],
        ),
        migrations.CreateModel(
            name='Practice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('difficulty', models.IntegerField(choices=[[1, 'Easy'], [2, 'Medium'], [3, 'Hard']], default=1)),
                ('category', models.CharField(choices=[['All', 'All'], ['Profit and Loss', 'Profit and Loss'], ['Time and Work', 'Time and Work'], ['Time and Distance', 'Time and Distance'], ['Number System', 'Number System'], ['Average', 'Average'], ['Percentage', 'Percentage'], ['Ratio and Proportion', 'Ratio and Proportion'], ['Mensuration', 'Mensuration'], ['Simple Interest', 'Simple Interest'], ['Compound Interest', 'Compound Interest'], ['Algebra', 'Algebra'], ['Geometry', 'Geometry'], ['Trigonometry', 'Trigonometry'], ['Data Interpretation', 'Data Interpretation'], ['Miscellaneous', 'Miscellaneous']], default='All', max_length=100)),
                ('start_time', models.DateTimeField(auto_now_add=True)),
                ('end_time', models.DateTimeField()),
                ('score', models.IntegerField(default=0)),
                ('created_by', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, related_name='practice', to=settings.AUTH_USER_MODEL)),
                ('questions', models.ManyToManyField(to='corival.apptitude')),
            ],
        ),
        migrations.CreateModel(
            name='Candidate',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('mathematics', models.IntegerField(default=0)),
                ('description', models.TextField(blank=True, default='Hi there! I am using Corival')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('corival.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Recruiter',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('company', models.CharField(blank=True, max_length=100)),
                ('verified', models.BooleanField(default=False)),
                ('position', models.CharField(blank=True, max_length=100)),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('corival.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='ContestSubmission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_taken', models.DurationField()),
                ('user_choice', models.IntegerField(default=0, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(4)], verbose_name='user_choice')),
                ('answer', models.BooleanField(default=False)),
                ('apptitude', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to='corival.apptitude')),
                ('contest', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to='corival.contest')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ContestLeaderboard',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('score', models.IntegerField(default=0)),
                ('time_taken', models.TimeField(null=True)),
                ('contest', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leaderboard', to='corival.contest')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leaderboard', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-score'],
            },
        ),
        migrations.CreateModel(
            name='ChallengeSubmission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timm_took', models.TimeField()),
                ('answer', models.BooleanField(default=False)),
                ('apptitude', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='challenge_submissions', to='corival.apptitude')),
                ('challenge', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to='corival.challenge')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='challenge_submissions', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ChallengeLeaderboard',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('score', models.IntegerField(default=0)),
                ('challenge', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leaderboard', to='corival.challenge')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='challenge_leaderboard', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-score'],
            },
        ),
        migrations.CreateModel(
            name='PracticeSubmission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_choice', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(4)])),
                ('time_taken', models.DurationField()),
                ('answer', models.BooleanField(default=False)),
                ('apptitude', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, related_name='practice_submissions', to='corival.apptitude')),
                ('practice', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to='corival.practice')),
                ('user', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, related_name='practice_submissions', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('practice', 'user', 'apptitude')},
            },
        ),
        migrations.CreateModel(
            name='Choice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('choice', models.CharField(max_length=100, verbose_name='Choice')),
                ('position', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(4)], verbose_name='position')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='choices', to='corival.apptitude')),
            ],
            options={
                'ordering': ('position',),
                'unique_together': {('question', 'choice'), ('question', 'position')},
            },
        ),
        migrations.AddField(
            model_name='challenge',
            name='reciever',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='challenges_recieved', to='corival.candidate'),
        ),
        migrations.AddField(
            model_name='challenge',
            name='sender',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='challenges_sent', to='corival.candidate'),
        ),
    ]
