# Contribution Guidelines

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

## Code of Conduct

By participating, you are expected to uphold this code. Please report unacceptable behavior to me.

## How Can I Contribute?

This is an open source project and requires help from the community. Any contributions from the community are very
much welcome! Be it "only" reporting bugs or actually contributing code to the repository.

### Reporting Bugs

This Project is by no means perfect. If you find something is not working as expected we are glad to receive an
issue report from you. Please make sure to
[search for similar issues](https://github.com/ritik3131/RealTime-Chatapp/issues) first.

If you did not find any related issues, please report a [new issue](https://github.com/ritik3131/RealTime-Chatapp/issues).
In order to be able to react efficiently we ask you to provide us with the following information:

- A small code example that reproduces the issue ([mcve](https://stackoverflow.com/help/mcve))

Please also abide to these rules:

- Formulate the issue in English.
- Provide a **clear and descriptive** title
- Stick to the issue template
- Make sure code is properly indented and
  [formatted](https://help.github.com/articles/basic-writing-and-formatting-syntax/#quoting-code) (Use ``` around
  code blocks). Attach large code snippets as file.

Note that this is an open source project and don't expect us to fix every issue immediately. Please also consider
fixing the issue yourself and preparing a pull request. Sometimes a pointer to a specific line of code already helps
a lot. We will happily discuss and merge contributions from the community!

### Pull requests

We are very happy about pull requests from the community and will discuss and merge them in a timely manner. When
preparing a pull request please follow these guidelines:

- Make sure the issue is assigned to you before creating pull request
