﻿import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { KnockoutTemplateReactComponent, registerReactControl } from 'dotvvm-jscomponent-react';
import { LineChart, XAxis, Tooltip, CartesianGrid, Line, Dot } from 'recharts';

// react component
function RechartComponent(props: any) {
    return (
        <LineChart
            width={400}
            height={400}
            data={props.data}
            margin={{ top: 5, right: 20, left: 10, bottom: 5 }} >
            <XAxis dataKey="name" />
            <Tooltip />
            <CartesianGrid stroke="#f5f5f5" />
            {
                Object.keys(props.data[0]).slice(1).map((s, i) =>
                    <Line type="monotone"
                        dataKey={s}
                        stroke={"#" + (i * 4).toString() + "87908"}
                        yAxisId={i}
                        onMouseEnter={(_) => props.onMouse(s)} />)
            }
        </LineChart>
    );
}

function TemplateSelector(props) {
    return <div>
        <KnockoutTemplateReactComponent
            wrapperTag="p"
            wrapperAttributes={{ className: props.condition ? "template1" : "template2" }}
            templateName={props.condition ? props.template1 : props.template2}
            getChildContext={c => c.extend({ $kokos: 1 })} />
    </div>
}

const Button = ({ text, click, dataUI }) =>
    <button onClick={e => click()} data-ui={dataUI}>{text}</button>

// DotVVM Context importer 
export default (context) => ({
    $controls: {
        recharts: registerReactControl(RechartComponent, { context, onMouse() { /* default empty method */ } }),
        TemplateSelector: registerReactControl(TemplateSelector),
        Button: registerReactControl(Button)
    }
})
