namespace DotVVM.Samples.Common.Api.Owin {
    class ClientBase {
        public transformOptions(options: RequestInit) {
            options.credentials = "same-origin";
            return Promise.resolve(options);
        }
    }
    /* tslint:disable */
    /* eslint-disable */
    //----------------------
    // <auto-generated>
    //     Generated using the NSwag toolchain v13.13.2.0 (NJsonSchema v10.5.2.0 (Newtonsoft.Json v10.0.0.0)) (http://NSwag.org)
    // </auto-generated>
    //----------------------
    // ReSharper disable InconsistentNaming
    
    export class CompaniesClient extends ClientBase {
        private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
        private baseUrl: string;
        protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;
    
        constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
            super();
            this.http = http ? http : <any>window;
            this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "http://localhost:61453";
        }
    
        /**
         * @return OK
         */
        get(): Promise<CompanyOfString[]> {
            let url_ = this.baseUrl + "/api/companies";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGet(_response);
            });
        }
    
        protected processGet(response: Response): Promise<CompanyOfString[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(CompanyOfString.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<CompanyOfString[]>(<any>null);
        }
    
        /**
         * @param sortingOptions (optional) 
         * @param sortingOptions_SortDescending (optional) 
         * @param sortingOptions_SortExpression (optional) 
         * @return OK
         */
        getWithSorting(sortingOptions?: any | null | undefined, sortingOptions_SortDescending?: boolean | null | undefined, sortingOptions_SortExpression?: string | null | undefined): Promise<GridViewDataSetOfCompanyOfBoolean> {
            let url_ = this.baseUrl + "/api/companies/sorted?";
            if (sortingOptions !== undefined && sortingOptions !== null)
                url_ += "sortingOptions=" + encodeURIComponent("" + sortingOptions) + "&";
            if (sortingOptions_SortDescending !== undefined && sortingOptions_SortDescending !== null)
                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
            if (sortingOptions_SortExpression !== undefined && sortingOptions_SortExpression !== null)
                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetWithSorting(_response);
            });
        }
    
        protected processGetWithSorting(response: Response): Promise<GridViewDataSetOfCompanyOfBoolean> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfBoolean.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfBoolean>(<any>null);
        }
    
        /**
         * @param pagingOptions (optional) 
         * @param pagingOptions_PageIndex (optional) 
         * @param pagingOptions_PageSize (optional) 
         * @param pagingOptions_TotalItemsCount (optional) 
         * @return OK
         */
        getWithPaging(pagingOptions?: any | null | undefined, pagingOptions_PageIndex?: number | null | undefined, pagingOptions_PageSize?: number | null | undefined, pagingOptions_TotalItemsCount?: number | null | undefined): Promise<GridViewDataSetOfCompanyOfString> {
            let url_ = this.baseUrl + "/api/companies/paged?";
            if (pagingOptions !== undefined && pagingOptions !== null)
                url_ += "pagingOptions=" + encodeURIComponent("" + pagingOptions) + "&";
            if (pagingOptions_PageIndex !== undefined && pagingOptions_PageIndex !== null)
                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
            if (pagingOptions_PageSize !== undefined && pagingOptions_PageSize !== null)
                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
            if (pagingOptions_TotalItemsCount !== undefined && pagingOptions_TotalItemsCount !== null)
                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetWithPaging(_response);
            });
        }
    
        protected processGetWithPaging(response: Response): Promise<GridViewDataSetOfCompanyOfString> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfString.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfString>(<any>null);
        }
    
        /**
         * @param sortingOptions (optional) 
         * @param sortingOptions_SortDescending (optional) 
         * @param sortingOptions_SortExpression (optional) 
         * @param pagingOptions (optional) 
         * @param pagingOptions_PageIndex (optional) 
         * @param pagingOptions_PageSize (optional) 
         * @param pagingOptions_TotalItemsCount (optional) 
         * @return OK
         */
        getWithSortingAndPaging(sortingOptions?: any | null | undefined, sortingOptions_SortDescending?: boolean | null | undefined, sortingOptions_SortExpression?: string | null | undefined, pagingOptions?: any | null | undefined, pagingOptions_PageIndex?: number | null | undefined, pagingOptions_PageSize?: number | null | undefined, pagingOptions_TotalItemsCount?: number | null | undefined): Promise<GridViewDataSetOfCompanyOfString> {
            let url_ = this.baseUrl + "/api/companies/sortedandpaged?";
            if (sortingOptions !== undefined && sortingOptions !== null)
                url_ += "sortingOptions=" + encodeURIComponent("" + sortingOptions) + "&";
            if (sortingOptions_SortDescending !== undefined && sortingOptions_SortDescending !== null)
                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
            if (sortingOptions_SortExpression !== undefined && sortingOptions_SortExpression !== null)
                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
            if (pagingOptions !== undefined && pagingOptions !== null)
                url_ += "pagingOptions=" + encodeURIComponent("" + pagingOptions) + "&";
            if (pagingOptions_PageIndex !== undefined && pagingOptions_PageIndex !== null)
                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
            if (pagingOptions_PageSize !== undefined && pagingOptions_PageSize !== null)
                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
            if (pagingOptions_TotalItemsCount !== undefined && pagingOptions_TotalItemsCount !== null)
                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetWithSortingAndPaging(_response);
            });
        }
    
        protected processGetWithSortingAndPaging(response: Response): Promise<GridViewDataSetOfCompanyOfString> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfString.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfString>(<any>null);
        }
    }
    
    export class OrdersClient extends ClientBase {
        private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
        private baseUrl: string;
        protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;
    
        constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
            super();
            this.http = http ? http : <any>window;
            this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "http://localhost:61453";
        }
    
        /**
         * @param pageIndex (optional) 
         * @param pageSize (optional) 
         * @return OK
         */
        get(companyId: number, pageIndex?: number | null | undefined, pageSize?: number | null | undefined): Promise<Order[]> {
            let url_ = this.baseUrl + "/api/orders?";
            if (companyId === undefined || companyId === null)
                throw new Error("The parameter 'companyId' must be defined and cannot be null.");
            else
                url_ += "companyId=" + encodeURIComponent("" + companyId) + "&";
            if (pageIndex !== undefined && pageIndex !== null)
                url_ += "pageIndex=" + encodeURIComponent("" + pageIndex) + "&";
            if (pageSize !== undefined && pageSize !== null)
                url_ += "pageSize=" + encodeURIComponent("" + pageSize) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGet(_response);
            });
        }
    
        protected processGet(response: Response): Promise<Order[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(Order.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<Order[]>(<any>null);
        }
    
        /**
         * @return OK
         */
        post(order: Order): Promise<any> {
            let url_ = this.baseUrl + "/api/orders";
            url_ = url_.replace(/[?&]$/, "");
    
            const content_ = JSON.stringify(order);
    
            let options_ = <RequestInit>{
                body: content_,
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processPost(_response);
            });
        }
    
        protected processPost(response: Response): Promise<any> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<any>(<any>null);
        }
    
        /**
         * @return OK
         */
        getItem(orderId: number): Promise<Order> {
            let url_ = this.baseUrl + "/api/orders/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetItem(_response);
            });
        }
    
        protected processGetItem(response: Response): Promise<Order> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = Order.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<Order>(<any>null);
        }
    
        /**
         * @return OK
         */
        put(orderId: number, order: Order): Promise<any> {
            let url_ = this.baseUrl + "/api/orders/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            const content_ = JSON.stringify(order);
    
            let options_ = <RequestInit>{
                body: content_,
                method: "PUT",
                headers: {
                    "Content-Type": "application/json",
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processPut(_response);
            });
        }
    
        protected processPut(response: Response): Promise<any> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<any>(<any>null);
        }
    
        /**
         * @return No Content
         */
        delete(orderId: number): Promise<void> {
            let url_ = this.baseUrl + "/api/orders/delete/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "DELETE",
                headers: {
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processDelete(_response);
            });
        }
    
        protected processDelete(response: Response): Promise<void> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 204) {
                return response.text().then((_responseText) => {
                return;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<void>(<any>null);
        }
    }
    
    export class ResetClient extends ClientBase {
        private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
        private baseUrl: string;
        protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;
    
        constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
            super();
            this.http = http ? http : <any>window;
            this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "http://localhost:61453";
        }
    
        /**
         * @return No Content
         */
        resetData(): Promise<void> {
            let url_ = this.baseUrl + "/api/reset/reset";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "POST",
                headers: {
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processResetData(_response);
            });
        }
    
        protected processResetData(response: Response): Promise<void> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 204) {
                return response.text().then((_responseText) => {
                return;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<void>(<any>null);
        }
    }
    
    export class CompanyOfString implements ICompanyOfString {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: string | null;
    
        constructor(data?: ICompanyOfString) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.Id = _data["Id"] !== undefined ? _data["Id"] : <any>null;
                this.Name = _data["Name"] !== undefined ? _data["Name"] : <any>null;
                this.Owner = _data["Owner"] !== undefined ? _data["Owner"] : <any>null;
                this.Department = _data["Department"] !== undefined ? _data["Department"] : <any>null;
            }
        }
    
        static fromJS(data: any): CompanyOfString {
            data = typeof data === 'object' ? data : {};
            let result = new CompanyOfString();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["Id"] = this.Id !== undefined ? this.Id : <any>null;
            data["Name"] = this.Name !== undefined ? this.Name : <any>null;
            data["Owner"] = this.Owner !== undefined ? this.Owner : <any>null;
            data["Department"] = this.Department !== undefined ? this.Department : <any>null;
            return data; 
        }
    }
    
    export interface ICompanyOfString {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: string | null;
    }
    
    export class SortingOptions implements ISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    
        constructor(data?: ISortingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.SortDescending = _data["SortDescending"] !== undefined ? _data["SortDescending"] : <any>null;
                this.SortExpression = _data["SortExpression"] !== undefined ? _data["SortExpression"] : <any>null;
            }
        }
    
        static fromJS(data: any): SortingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new SortingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["SortDescending"] = this.SortDescending !== undefined ? this.SortDescending : <any>null;
            data["SortExpression"] = this.SortExpression !== undefined ? this.SortExpression : <any>null;
            return data; 
        }
    }
    
    export interface ISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    }
    
    export class GridViewDataSetOfCompanyOfBoolean implements IGridViewDataSetOfCompanyOfBoolean {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfBoolean[] | null;
        PagingOptions?: IPagingOptions | null;
        RowEditOptions?: IRowEditOptions | null;
        SortingOptions?: ISortingOptions | null;
    
        constructor(data?: IGridViewDataSetOfCompanyOfBoolean) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.IsRefreshRequired = _data["IsRefreshRequired"] !== undefined ? _data["IsRefreshRequired"] : <any>null;
                if (Array.isArray(_data["Items"])) {
                    this.Items = [] as any;
                    for (let item of _data["Items"])
                        this.Items!.push(CompanyOfBoolean.fromJS(item));
                }
                else {
                    this.Items = <any>null;
                }
                this.PagingOptions = _data["PagingOptions"] ? IPagingOptions.fromJS(_data["PagingOptions"]) : <any>null;
                this.RowEditOptions = _data["RowEditOptions"] ? IRowEditOptions.fromJS(_data["RowEditOptions"]) : <any>null;
                this.SortingOptions = _data["SortingOptions"] ? ISortingOptions.fromJS(_data["SortingOptions"]) : <any>null;
            }
        }
    
        static fromJS(data: any): GridViewDataSetOfCompanyOfBoolean {
            data = typeof data === 'object' ? data : {};
            let result = new GridViewDataSetOfCompanyOfBoolean();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["IsRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : <any>null;
            if (Array.isArray(this.Items)) {
                data["Items"] = [];
                for (let item of this.Items)
                    data["Items"].push(item.toJSON());
            }
            data["PagingOptions"] = this.PagingOptions ? this.PagingOptions.toJSON() : <any>null;
            data["RowEditOptions"] = this.RowEditOptions ? this.RowEditOptions.toJSON() : <any>null;
            data["SortingOptions"] = this.SortingOptions ? this.SortingOptions.toJSON() : <any>null;
            return data; 
        }
    }
    
    export interface IGridViewDataSetOfCompanyOfBoolean {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfBoolean[] | null;
        PagingOptions?: IPagingOptions | null;
        RowEditOptions?: IRowEditOptions | null;
        SortingOptions?: ISortingOptions | null;
    }
    
    export class CompanyOfBoolean implements ICompanyOfBoolean {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: boolean | null;
    
        constructor(data?: ICompanyOfBoolean) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.Id = _data["Id"] !== undefined ? _data["Id"] : <any>null;
                this.Name = _data["Name"] !== undefined ? _data["Name"] : <any>null;
                this.Owner = _data["Owner"] !== undefined ? _data["Owner"] : <any>null;
                this.Department = _data["Department"] !== undefined ? _data["Department"] : <any>null;
            }
        }
    
        static fromJS(data: any): CompanyOfBoolean {
            data = typeof data === 'object' ? data : {};
            let result = new CompanyOfBoolean();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["Id"] = this.Id !== undefined ? this.Id : <any>null;
            data["Name"] = this.Name !== undefined ? this.Name : <any>null;
            data["Owner"] = this.Owner !== undefined ? this.Owner : <any>null;
            data["Department"] = this.Department !== undefined ? this.Department : <any>null;
            return data; 
        }
    }
    
    export interface ICompanyOfBoolean {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: boolean | null;
    }
    
    export class IPagingOptions implements IIPagingOptions {
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        readonly IsFirstPage?: boolean | null;
        readonly IsLastPage?: boolean | null;
        readonly PagesCount?: number | null;
        readonly NearPageIndexes?: number[] | null;
    
        constructor(data?: IIPagingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.PageIndex = _data["PageIndex"] !== undefined ? _data["PageIndex"] : <any>null;
                this.PageSize = _data["PageSize"] !== undefined ? _data["PageSize"] : <any>null;
                this.TotalItemsCount = _data["TotalItemsCount"] !== undefined ? _data["TotalItemsCount"] : <any>null;
                (<any>this).IsFirstPage = _data["IsFirstPage"] !== undefined ? _data["IsFirstPage"] : <any>null;
                (<any>this).IsLastPage = _data["IsLastPage"] !== undefined ? _data["IsLastPage"] : <any>null;
                (<any>this).PagesCount = _data["PagesCount"] !== undefined ? _data["PagesCount"] : <any>null;
                if (Array.isArray(_data["NearPageIndexes"])) {
                    (<any>this).NearPageIndexes = [] as any;
                    for (let item of _data["NearPageIndexes"])
                        (<any>this).NearPageIndexes!.push(item);
                }
                else {
                    (<any>this).NearPageIndexes = <any>null;
                }
            }
        }
    
        static fromJS(data: any): IPagingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new IPagingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["PageIndex"] = this.PageIndex !== undefined ? this.PageIndex : <any>null;
            data["PageSize"] = this.PageSize !== undefined ? this.PageSize : <any>null;
            data["TotalItemsCount"] = this.TotalItemsCount !== undefined ? this.TotalItemsCount : <any>null;
            data["IsFirstPage"] = this.IsFirstPage !== undefined ? this.IsFirstPage : <any>null;
            data["IsLastPage"] = this.IsLastPage !== undefined ? this.IsLastPage : <any>null;
            data["PagesCount"] = this.PagesCount !== undefined ? this.PagesCount : <any>null;
            if (Array.isArray(this.NearPageIndexes)) {
                data["NearPageIndexes"] = [];
                for (let item of this.NearPageIndexes)
                    data["NearPageIndexes"].push(item);
            }
            return data; 
        }
    }
    
    export interface IIPagingOptions {
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        IsFirstPage?: boolean | null;
        IsLastPage?: boolean | null;
        PagesCount?: number | null;
        NearPageIndexes?: number[] | null;
    }
    
    export class IRowEditOptions implements IIRowEditOptions {
        PrimaryKeyPropertyName?: string | null;
        EditRowId?: any | null;
    
        constructor(data?: IIRowEditOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.PrimaryKeyPropertyName = _data["PrimaryKeyPropertyName"] !== undefined ? _data["PrimaryKeyPropertyName"] : <any>null;
                this.EditRowId = _data["EditRowId"] !== undefined ? _data["EditRowId"] : <any>null;
            }
        }
    
        static fromJS(data: any): IRowEditOptions {
            data = typeof data === 'object' ? data : {};
            let result = new IRowEditOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["PrimaryKeyPropertyName"] = this.PrimaryKeyPropertyName !== undefined ? this.PrimaryKeyPropertyName : <any>null;
            data["EditRowId"] = this.EditRowId !== undefined ? this.EditRowId : <any>null;
            return data; 
        }
    }
    
    export interface IIRowEditOptions {
        PrimaryKeyPropertyName?: string | null;
        EditRowId?: any | null;
    }
    
    export class ISortingOptions implements IISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    
        constructor(data?: IISortingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.SortDescending = _data["SortDescending"] !== undefined ? _data["SortDescending"] : <any>null;
                this.SortExpression = _data["SortExpression"] !== undefined ? _data["SortExpression"] : <any>null;
            }
        }
    
        static fromJS(data: any): ISortingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new ISortingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["SortDescending"] = this.SortDescending !== undefined ? this.SortDescending : <any>null;
            data["SortExpression"] = this.SortExpression !== undefined ? this.SortExpression : <any>null;
            return data; 
        }
    }
    
    export interface IISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    }
    
    export class PagingOptions implements IPagingOptions {
        NearPageIndexesProvider?: INearPageIndexesProvider | null;
        readonly IsFirstPage?: boolean | null;
        readonly IsLastPage?: boolean | null;
        readonly PagesCount?: number | null;
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        readonly NearPageIndexes?: number[] | null;
    
        constructor(data?: IPagingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.NearPageIndexesProvider = _data["NearPageIndexesProvider"] ? INearPageIndexesProvider.fromJS(_data["NearPageIndexesProvider"]) : <any>null;
                (<any>this).IsFirstPage = _data["IsFirstPage"] !== undefined ? _data["IsFirstPage"] : <any>null;
                (<any>this).IsLastPage = _data["IsLastPage"] !== undefined ? _data["IsLastPage"] : <any>null;
                (<any>this).PagesCount = _data["PagesCount"] !== undefined ? _data["PagesCount"] : <any>null;
                this.PageIndex = _data["PageIndex"] !== undefined ? _data["PageIndex"] : <any>null;
                this.PageSize = _data["PageSize"] !== undefined ? _data["PageSize"] : <any>null;
                this.TotalItemsCount = _data["TotalItemsCount"] !== undefined ? _data["TotalItemsCount"] : <any>null;
                if (Array.isArray(_data["NearPageIndexes"])) {
                    (<any>this).NearPageIndexes = [] as any;
                    for (let item of _data["NearPageIndexes"])
                        (<any>this).NearPageIndexes!.push(item);
                }
                else {
                    (<any>this).NearPageIndexes = <any>null;
                }
            }
        }
    
        static fromJS(data: any): PagingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new PagingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["NearPageIndexesProvider"] = this.NearPageIndexesProvider ? this.NearPageIndexesProvider.toJSON() : <any>null;
            data["IsFirstPage"] = this.IsFirstPage !== undefined ? this.IsFirstPage : <any>null;
            data["IsLastPage"] = this.IsLastPage !== undefined ? this.IsLastPage : <any>null;
            data["PagesCount"] = this.PagesCount !== undefined ? this.PagesCount : <any>null;
            data["PageIndex"] = this.PageIndex !== undefined ? this.PageIndex : <any>null;
            data["PageSize"] = this.PageSize !== undefined ? this.PageSize : <any>null;
            data["TotalItemsCount"] = this.TotalItemsCount !== undefined ? this.TotalItemsCount : <any>null;
            if (Array.isArray(this.NearPageIndexes)) {
                data["NearPageIndexes"] = [];
                for (let item of this.NearPageIndexes)
                    data["NearPageIndexes"].push(item);
            }
            return data; 
        }
    }
    
    export interface IPagingOptions {
        NearPageIndexesProvider?: INearPageIndexesProvider | null;
        IsFirstPage?: boolean | null;
        IsLastPage?: boolean | null;
        PagesCount?: number | null;
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        NearPageIndexes?: number[] | null;
    }
    
    export class INearPageIndexesProvider implements IINearPageIndexesProvider {
    
        constructor(data?: IINearPageIndexesProvider) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
        }
    
        static fromJS(data: any): INearPageIndexesProvider {
            data = typeof data === 'object' ? data : {};
            let result = new INearPageIndexesProvider();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            return data; 
        }
    }
    
    export interface IINearPageIndexesProvider {
    }
    
    export class GridViewDataSetOfCompanyOfString implements IGridViewDataSetOfCompanyOfString {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfString[] | null;
        PagingOptions?: IPagingOptions | null;
        RowEditOptions?: IRowEditOptions | null;
        SortingOptions?: ISortingOptions | null;
    
        constructor(data?: IGridViewDataSetOfCompanyOfString) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.IsRefreshRequired = _data["IsRefreshRequired"] !== undefined ? _data["IsRefreshRequired"] : <any>null;
                if (Array.isArray(_data["Items"])) {
                    this.Items = [] as any;
                    for (let item of _data["Items"])
                        this.Items!.push(CompanyOfString.fromJS(item));
                }
                else {
                    this.Items = <any>null;
                }
                this.PagingOptions = _data["PagingOptions"] ? IPagingOptions.fromJS(_data["PagingOptions"]) : <any>null;
                this.RowEditOptions = _data["RowEditOptions"] ? IRowEditOptions.fromJS(_data["RowEditOptions"]) : <any>null;
                this.SortingOptions = _data["SortingOptions"] ? ISortingOptions.fromJS(_data["SortingOptions"]) : <any>null;
            }
        }
    
        static fromJS(data: any): GridViewDataSetOfCompanyOfString {
            data = typeof data === 'object' ? data : {};
            let result = new GridViewDataSetOfCompanyOfString();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["IsRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : <any>null;
            if (Array.isArray(this.Items)) {
                data["Items"] = [];
                for (let item of this.Items)
                    data["Items"].push(item.toJSON());
            }
            data["PagingOptions"] = this.PagingOptions ? this.PagingOptions.toJSON() : <any>null;
            data["RowEditOptions"] = this.RowEditOptions ? this.RowEditOptions.toJSON() : <any>null;
            data["SortingOptions"] = this.SortingOptions ? this.SortingOptions.toJSON() : <any>null;
            return data; 
        }
    }
    
    export interface IGridViewDataSetOfCompanyOfString {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfString[] | null;
        PagingOptions?: IPagingOptions | null;
        RowEditOptions?: IRowEditOptions | null;
        SortingOptions?: ISortingOptions | null;
    }
    
    export class Order implements IOrder {
        Id?: number | null;
        Number?: string | null;
        Date?: Date | null;
        companyId?: number | null;
        OrderItems?: OrderItem[] | null;
    
        constructor(data?: IOrder) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.Id = _data["Id"] !== undefined ? _data["Id"] : <any>null;
                this.Number = _data["Number"] !== undefined ? _data["Number"] : <any>null;
                this.Date = _data["Date"] ? new Date(_data["Date"].toString()) : <any>null;
                this.companyId = _data["companyId"] !== undefined ? _data["companyId"] : <any>null;
                if (Array.isArray(_data["OrderItems"])) {
                    this.OrderItems = [] as any;
                    for (let item of _data["OrderItems"])
                        this.OrderItems!.push(OrderItem.fromJS(item));
                }
                else {
                    this.OrderItems = <any>null;
                }
            }
        }
    
        static fromJS(data: any): Order {
            data = typeof data === 'object' ? data : {};
            let result = new Order();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["Id"] = this.Id !== undefined ? this.Id : <any>null;
            data["Number"] = this.Number !== undefined ? this.Number : <any>null;
            data["Date"] = this.Date ? this.Date.toISOString() : <any>null;
            data["companyId"] = this.companyId !== undefined ? this.companyId : <any>null;
            if (Array.isArray(this.OrderItems)) {
                data["OrderItems"] = [];
                for (let item of this.OrderItems)
                    data["OrderItems"].push(item.toJSON());
            }
            return data; 
        }
    }
    
    export interface IOrder {
        Id?: number | null;
        Number?: string | null;
        Date?: Date | null;
        companyId?: number | null;
        OrderItems?: OrderItem[] | null;
    }
    
    export class OrderItem implements IOrderItem {
        Id?: number | null;
        Text?: string | null;
        Amount?: number | null;
        Discount?: number | null;
        IsOnStock?: boolean | null;
    
        constructor(data?: IOrderItem) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.Id = _data["Id"] !== undefined ? _data["Id"] : <any>null;
                this.Text = _data["Text"] !== undefined ? _data["Text"] : <any>null;
                this.Amount = _data["Amount"] !== undefined ? _data["Amount"] : <any>null;
                this.Discount = _data["Discount"] !== undefined ? _data["Discount"] : <any>null;
                this.IsOnStock = _data["IsOnStock"] !== undefined ? _data["IsOnStock"] : <any>null;
            }
        }
    
        static fromJS(data: any): OrderItem {
            data = typeof data === 'object' ? data : {};
            let result = new OrderItem();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["Id"] = this.Id !== undefined ? this.Id : <any>null;
            data["Text"] = this.Text !== undefined ? this.Text : <any>null;
            data["Amount"] = this.Amount !== undefined ? this.Amount : <any>null;
            data["Discount"] = this.Discount !== undefined ? this.Discount : <any>null;
            data["IsOnStock"] = this.IsOnStock !== undefined ? this.IsOnStock : <any>null;
            return data; 
        }
    }
    
    export interface IOrderItem {
        Id?: number | null;
        Text?: string | null;
        Amount?: number | null;
        Discount?: number | null;
        IsOnStock?: boolean | null;
    }
    
    export class ApiException extends Error {
        message: string;
        status: number;
        response: string;
        headers: { [key: string]: any; };
        result: any;
    
        constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
            super();
    
            this.message = message;
            this.status = status;
            this.response = response;
            this.headers = headers;
            this.result = result;
        }
    
        protected isApiException = true;
    
        static isApiException(obj: any): obj is ApiException {
            return obj.isApiException === true;
        }
    }
    
    function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
        if (result !== null && result !== undefined)
            throw result;
        else
            throw new ApiException(message, status, response, headers, null);
    }
}
