var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DotVVM;
(function (DotVVM) {
    var Samples;
    (function (Samples) {
        var Common;
        (function (Common) {
            var Api;
            (function (Api) {
                var Owin;
                (function (Owin) {
                    var ClientBase = /** @class */ (function () {
                        function ClientBase() {
                        }
                        ClientBase.prototype.transformOptions = function (options) {
                            options.credentials = "same-origin";
                            return Promise.resolve(options);
                        };
                        return ClientBase;
                    }());
                    /* tslint:disable */
                    //----------------------
                    // <auto-generated>
                    //     Generated using the NSwag toolchain v11.14.1.0 (NJsonSchema v9.10.24.0 (Newtonsoft.Json v10.0.0.0)) (http://NSwag.org)
                    // </auto-generated>
                    //----------------------
                    // ReSharper disable InconsistentNaming
                    var CompaniesClient = /** @class */ (function (_super) {
                        __extends(CompaniesClient, _super);
                        function CompaniesClient(baseUrl, http) {
                            var _this = _super.call(this) || this;
                            _this.jsonParseReviver = undefined;
                            _this.http = http ? http : window;
                            _this.baseUrl = baseUrl ? baseUrl : "http://localhost:61453";
                            return _this;
                        }
                        /**
                         * @return OK
                         */
                        CompaniesClient.prototype.get = function () {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/companies";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGet(_response);
                            });
                        };
                        CompaniesClient.prototype.processGet = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    if (resultData200 && resultData200.constructor === Array) {
                                        result200 = [];
                                        for (var _i = 0, resultData200_1 = resultData200; _i < resultData200_1.length; _i++) {
                                            var item = resultData200_1[_i];
                                            result200.push(CompanyOfString.fromJS(item));
                                        }
                                    }
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @sortingOptions (optional)
                         * @sortingOptions_SortDescending (optional)
                         * @sortingOptions_SortExpression (optional)
                         * @return OK
                         */
                        CompaniesClient.prototype.getWithSorting = function (sortingOptions) {
                            var _this = this;
                            var sortingOptions_SortDescending = (sortingOptions !== null && typeof sortingOptions === 'object') ? sortingOptions.SortDescending : null;
                            var sortingOptions_SortExpression = (sortingOptions !== null && typeof sortingOptions === 'object') ? sortingOptions.SortExpression : null;
                            var url_ = this.baseUrl + "/api/companies/sorted?";
                            if (sortingOptions_SortDescending !== undefined)
                                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
                            if (sortingOptions_SortExpression !== undefined)
                                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGetWithSorting(_response);
                            });
                        };
                        CompaniesClient.prototype.processGetWithSorting = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    result200 = resultData200 ? GridViewDataSetOfCompanyOfBoolean.fromJS(resultData200) : new GridViewDataSetOfCompanyOfBoolean();
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @pagingOptions (optional)
                         * @pagingOptions_PageIndex (optional)
                         * @pagingOptions_PageSize (optional)
                         * @pagingOptions_TotalItemsCount (optional)
                         * @return OK
                         */
                        CompaniesClient.prototype.getWithPaging = function (pagingOptions) {
                            var _this = this;
                            var pagingOptions_PageIndex = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.PageIndex : null;
                            var pagingOptions_PageSize = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.PageSize : null;
                            var pagingOptions_TotalItemsCount = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.TotalItemsCount : null;
                            var url_ = this.baseUrl + "/api/companies/paged?";
                            if (pagingOptions_PageIndex !== undefined)
                                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
                            if (pagingOptions_PageSize !== undefined)
                                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
                            if (pagingOptions_TotalItemsCount !== undefined)
                                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGetWithPaging(_response);
                            });
                        };
                        CompaniesClient.prototype.processGetWithPaging = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    result200 = resultData200 ? GridViewDataSetOfCompanyOfString.fromJS(resultData200) : new GridViewDataSetOfCompanyOfString();
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @sortingOptions (optional)
                         * @sortingOptions_SortDescending (optional)
                         * @sortingOptions_SortExpression (optional)
                         * @pagingOptions (optional)
                         * @pagingOptions_PageIndex (optional)
                         * @pagingOptions_PageSize (optional)
                         * @pagingOptions_TotalItemsCount (optional)
                         * @return OK
                         */
                        CompaniesClient.prototype.getWithSortingAndPaging = function (sortingOptions, pagingOptions) {
                            var _this = this;
                            var sortingOptions_SortDescending = (sortingOptions !== null && typeof sortingOptions === 'object') ? sortingOptions.SortDescending : null;
                            var sortingOptions_SortExpression = (sortingOptions !== null && typeof sortingOptions === 'object') ? sortingOptions.SortExpression : null;
                            var pagingOptions_PageIndex = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.PageIndex : null;
                            var pagingOptions_PageSize = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.PageSize : null;
                            var pagingOptions_TotalItemsCount = (pagingOptions !== null && typeof pagingOptions === 'object') ? pagingOptions.TotalItemsCount : null;
                            var url_ = this.baseUrl + "/api/companies/sortedandpaged?";
                            if (sortingOptions_SortDescending !== undefined)
                                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
                            if (sortingOptions_SortExpression !== undefined)
                                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
                            if (pagingOptions_PageIndex !== undefined)
                                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
                            if (pagingOptions_PageSize !== undefined)
                                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
                            if (pagingOptions_TotalItemsCount !== undefined)
                                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGetWithSortingAndPaging(_response);
                            });
                        };
                        CompaniesClient.prototype.processGetWithSortingAndPaging = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    result200 = resultData200 ? GridViewDataSetOfCompanyOfString.fromJS(resultData200) : new GridViewDataSetOfCompanyOfString();
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        return CompaniesClient;
                    }(ClientBase));
                    Owin.CompaniesClient = CompaniesClient;
                    var OrdersClient = /** @class */ (function (_super) {
                        __extends(OrdersClient, _super);
                        function OrdersClient(baseUrl, http) {
                            var _this = _super.call(this) || this;
                            _this.jsonParseReviver = undefined;
                            _this.http = http ? http : window;
                            _this.baseUrl = baseUrl ? baseUrl : "http://localhost:61453";
                            return _this;
                        }
                        /**
                         * @pageIndex (optional)
                         * @pageSize (optional)
                         * @return OK
                         */
                        OrdersClient.prototype.get = function (companyId, pageIndex, pageSize) {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/orders?";
                            if (companyId === undefined || companyId === null)
                                throw new Error("The parameter 'companyId' must be defined and cannot be null.");
                            else
                                url_ += "companyId=" + encodeURIComponent("" + companyId) + "&";
                            if (pageIndex !== undefined)
                                url_ += "pageIndex=" + encodeURIComponent("" + pageIndex) + "&";
                            if (pageSize !== undefined)
                                url_ += "pageSize=" + encodeURIComponent("" + pageSize) + "&";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGet(_response);
                            });
                        };
                        OrdersClient.prototype.processGet = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    if (resultData200 && resultData200.constructor === Array) {
                                        result200 = [];
                                        for (var _i = 0, resultData200_2 = resultData200; _i < resultData200_2.length; _i++) {
                                            var item = resultData200_2[_i];
                                            result200.push(Order.fromJS(item));
                                        }
                                    }
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @return OK
                         */
                        OrdersClient.prototype.post = function (order) {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/orders";
                            url_ = url_.replace(/[?&]$/, "");
                            var content_ = JSON.stringify(order);
                            var options_ = {
                                body: content_,
                                method: "POST",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processPost(_response);
                            });
                        };
                        OrdersClient.prototype.processPost = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    if (resultData200) {
                                        result200 = {};
                                        for (var key in resultData200) {
                                            if (resultData200.hasOwnProperty(key))
                                                result200[key] = resultData200[key];
                                        }
                                    }
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @return OK
                         */
                        OrdersClient.prototype.getItem = function (orderId) {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/orders/{orderId}";
                            if (orderId === undefined || orderId === null)
                                throw new Error("The parameter 'orderId' must be defined.");
                            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "GET",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processGetItem(_response);
                            });
                        };
                        OrdersClient.prototype.processGetItem = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    result200 = resultData200 ? Order.fromJS(resultData200) : new Order();
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @return OK
                         */
                        OrdersClient.prototype.put = function (orderId, order) {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/orders/{orderId}";
                            if (orderId === undefined || orderId === null)
                                throw new Error("The parameter 'orderId' must be defined.");
                            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
                            url_ = url_.replace(/[?&]$/, "");
                            var content_ = JSON.stringify(order);
                            var options_ = {
                                body: content_,
                                method: "PUT",
                                headers: new Headers({
                                    "Content-Type": "application/json",
                                    "Accept": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processPut(_response);
                            });
                        };
                        OrdersClient.prototype.processPut = function (response) {
                            var _this = this;
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 200) {
                                return response.text().then(function (_responseText) {
                                    var result200 = null;
                                    var resultData200 = _responseText === "" ? null : JSON.parse(_responseText, _this.jsonParseReviver);
                                    if (resultData200) {
                                        result200 = {};
                                        for (var key in resultData200) {
                                            if (resultData200.hasOwnProperty(key))
                                                result200[key] = resultData200[key];
                                        }
                                    }
                                    return result200;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        /**
                         * @return No Content
                         */
                        OrdersClient.prototype["delete"] = function (orderId) {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/orders/delete/{orderId}";
                            if (orderId === undefined || orderId === null)
                                throw new Error("The parameter 'orderId' must be defined.");
                            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "DELETE",
                                headers: new Headers({
                                    "Content-Type": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processDelete(_response);
                            });
                        };
                        OrdersClient.prototype.processDelete = function (response) {
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 204) {
                                return response.text().then(function (_responseText) {
                                    return;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        return OrdersClient;
                    }(ClientBase));
                    Owin.OrdersClient = OrdersClient;
                    var ResetClient = /** @class */ (function (_super) {
                        __extends(ResetClient, _super);
                        function ResetClient(baseUrl, http) {
                            var _this = _super.call(this) || this;
                            _this.jsonParseReviver = undefined;
                            _this.http = http ? http : window;
                            _this.baseUrl = baseUrl ? baseUrl : "http://localhost:61453";
                            return _this;
                        }
                        /**
                         * @return No Content
                         */
                        ResetClient.prototype.resetData = function () {
                            var _this = this;
                            var url_ = this.baseUrl + "/api/reset/reset";
                            url_ = url_.replace(/[?&]$/, "");
                            var options_ = {
                                method: "POST",
                                headers: new Headers({
                                    "Content-Type": "application/json"
                                })
                            };
                            return this.transformOptions(options_).then(function (transformedOptions_) {
                                return _this.http.fetch(url_, transformedOptions_);
                            }).then(function (_response) {
                                return _this.processResetData(_response);
                            });
                        };
                        ResetClient.prototype.processResetData = function (response) {
                            var status = response.status;
                            var _headers = {};
                            if (response.headers && response.headers.forEach) {
                                response.headers.forEach(function (v, k) { return _headers[k] = v; });
                            }
                            ;
                            if (status === 204) {
                                return response.text().then(function (_responseText) {
                                    return;
                                });
                            }
                            else if (status !== 200 && status !== 204) {
                                return response.text().then(function (_responseText) {
                                    return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                                });
                            }
                            return Promise.resolve(null);
                        };
                        return ResetClient;
                    }(ClientBase));
                    Owin.ResetClient = ResetClient;
                    var CompanyOfString = /** @class */ (function () {
                        function CompanyOfString(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        CompanyOfString.prototype.init = function (data) {
                            if (data) {
                                this.Id = data["Id"] !== undefined ? data["Id"] : null;
                                this.Name = data["Name"] !== undefined ? data["Name"] : null;
                                this.Owner = data["Owner"] !== undefined ? data["Owner"] : null;
                                this.Department = data["Department"] !== undefined ? data["Department"] : null;
                            }
                        };
                        CompanyOfString.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new CompanyOfString();
                            result.init(data);
                            return result;
                        };
                        CompanyOfString.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["Id"] = this.Id !== undefined ? this.Id : null;
                            data["Name"] = this.Name !== undefined ? this.Name : null;
                            data["Owner"] = this.Owner !== undefined ? this.Owner : null;
                            data["Department"] = this.Department !== undefined ? this.Department : null;
                            return data;
                        };
                        return CompanyOfString;
                    }());
                    Owin.CompanyOfString = CompanyOfString;
                    var SortingOptions = /** @class */ (function () {
                        function SortingOptions(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        SortingOptions.prototype.init = function (data) {
                            if (data) {
                                this.SortDescending = data["SortDescending"] !== undefined ? data["SortDescending"] : null;
                                this.SortExpression = data["SortExpression"] !== undefined ? data["SortExpression"] : null;
                            }
                        };
                        SortingOptions.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new SortingOptions();
                            result.init(data);
                            return result;
                        };
                        SortingOptions.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["SortDescending"] = this.SortDescending !== undefined ? this.SortDescending : null;
                            data["SortExpression"] = this.SortExpression !== undefined ? this.SortExpression : null;
                            return data;
                        };
                        return SortingOptions;
                    }());
                    Owin.SortingOptions = SortingOptions;
                    var GridViewDataSetOfCompanyOfBoolean = /** @class */ (function () {
                        function GridViewDataSetOfCompanyOfBoolean(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        GridViewDataSetOfCompanyOfBoolean.prototype.init = function (data) {
                            if (data) {
                                this.IsRefreshRequired = data["IsRefreshRequired"] !== undefined ? data["IsRefreshRequired"] : null;
                                if (data["Items"] && data["Items"].constructor === Array) {
                                    this.Items = [];
                                    for (var _i = 0, _a = data["Items"]; _i < _a.length; _i++) {
                                        var item = _a[_i];
                                        this.Items.push(CompanyOfBoolean.fromJS(item));
                                    }
                                }
                                this.PagingOptions = data["PagingOptions"] ? IPagingOptions.fromJS(data["PagingOptions"]) : null;
                                this.RowEditOptions = data["RowEditOptions"] ? IRowEditOptions.fromJS(data["RowEditOptions"]) : null;
                                this.SortingOptions = data["SortingOptions"] ? ISortingOptions.fromJS(data["SortingOptions"]) : null;
                            }
                        };
                        GridViewDataSetOfCompanyOfBoolean.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new GridViewDataSetOfCompanyOfBoolean();
                            result.init(data);
                            return result;
                        };
                        GridViewDataSetOfCompanyOfBoolean.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["IsRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : null;
                            if (this.Items && this.Items.constructor === Array) {
                                data["Items"] = [];
                                for (var _i = 0, _a = this.Items; _i < _a.length; _i++) {
                                    var item = _a[_i];
                                    data["Items"].push(item.toJSON());
                                }
                            }
                            data["PagingOptions"] = this.PagingOptions ? this.PagingOptions.toJSON() : null;
                            data["RowEditOptions"] = this.RowEditOptions ? this.RowEditOptions.toJSON() : null;
                            data["SortingOptions"] = this.SortingOptions ? this.SortingOptions.toJSON() : null;
                            return data;
                        };
                        return GridViewDataSetOfCompanyOfBoolean;
                    }());
                    Owin.GridViewDataSetOfCompanyOfBoolean = GridViewDataSetOfCompanyOfBoolean;
                    var CompanyOfBoolean = /** @class */ (function () {
                        function CompanyOfBoolean(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        CompanyOfBoolean.prototype.init = function (data) {
                            if (data) {
                                this.Id = data["Id"] !== undefined ? data["Id"] : null;
                                this.Name = data["Name"] !== undefined ? data["Name"] : null;
                                this.Owner = data["Owner"] !== undefined ? data["Owner"] : null;
                                this.Department = data["Department"] !== undefined ? data["Department"] : null;
                            }
                        };
                        CompanyOfBoolean.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new CompanyOfBoolean();
                            result.init(data);
                            return result;
                        };
                        CompanyOfBoolean.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["Id"] = this.Id !== undefined ? this.Id : null;
                            data["Name"] = this.Name !== undefined ? this.Name : null;
                            data["Owner"] = this.Owner !== undefined ? this.Owner : null;
                            data["Department"] = this.Department !== undefined ? this.Department : null;
                            return data;
                        };
                        return CompanyOfBoolean;
                    }());
                    Owin.CompanyOfBoolean = CompanyOfBoolean;
                    var IPagingOptions = /** @class */ (function () {
                        function IPagingOptions(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        IPagingOptions.prototype.init = function (data) {
                            if (data) {
                                this.PageIndex = data["PageIndex"] !== undefined ? data["PageIndex"] : null;
                                this.PageSize = data["PageSize"] !== undefined ? data["PageSize"] : null;
                                this.TotalItemsCount = data["TotalItemsCount"] !== undefined ? data["TotalItemsCount"] : null;
                                this.IsFirstPage = data["IsFirstPage"] !== undefined ? data["IsFirstPage"] : null;
                                this.IsLastPage = data["IsLastPage"] !== undefined ? data["IsLastPage"] : null;
                                this.PagesCount = data["PagesCount"] !== undefined ? data["PagesCount"] : null;
                                if (data["NearPageIndexes"] && data["NearPageIndexes"].constructor === Array) {
                                    this.NearPageIndexes = [];
                                    for (var _i = 0, _a = data["NearPageIndexes"]; _i < _a.length; _i++) {
                                        var item = _a[_i];
                                        this.NearPageIndexes.push(item);
                                    }
                                }
                            }
                        };
                        IPagingOptions.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new IPagingOptions();
                            result.init(data);
                            return result;
                        };
                        IPagingOptions.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["PageIndex"] = this.PageIndex !== undefined ? this.PageIndex : null;
                            data["PageSize"] = this.PageSize !== undefined ? this.PageSize : null;
                            data["TotalItemsCount"] = this.TotalItemsCount !== undefined ? this.TotalItemsCount : null;
                            data["IsFirstPage"] = this.IsFirstPage !== undefined ? this.IsFirstPage : null;
                            data["IsLastPage"] = this.IsLastPage !== undefined ? this.IsLastPage : null;
                            data["PagesCount"] = this.PagesCount !== undefined ? this.PagesCount : null;
                            if (this.NearPageIndexes && this.NearPageIndexes.constructor === Array) {
                                data["NearPageIndexes"] = [];
                                for (var _i = 0, _a = this.NearPageIndexes; _i < _a.length; _i++) {
                                    var item = _a[_i];
                                    data["NearPageIndexes"].push(item);
                                }
                            }
                            return data;
                        };
                        return IPagingOptions;
                    }());
                    Owin.IPagingOptions = IPagingOptions;
                    var IRowEditOptions = /** @class */ (function () {
                        function IRowEditOptions(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        IRowEditOptions.prototype.init = function (data) {
                            if (data) {
                                this.PrimaryKeyPropertyName = data["PrimaryKeyPropertyName"] !== undefined ? data["PrimaryKeyPropertyName"] : null;
                                if (data["EditRowId"]) {
                                    this.EditRowId = {};
                                    for (var key in data["EditRowId"]) {
                                        if (data["EditRowId"].hasOwnProperty(key))
                                            this.EditRowId[key] = data["EditRowId"][key];
                                    }
                                }
                            }
                        };
                        IRowEditOptions.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new IRowEditOptions();
                            result.init(data);
                            return result;
                        };
                        IRowEditOptions.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["PrimaryKeyPropertyName"] = this.PrimaryKeyPropertyName !== undefined ? this.PrimaryKeyPropertyName : null;
                            if (this.EditRowId) {
                                data["EditRowId"] = {};
                                for (var key in this.EditRowId) {
                                    if (this.EditRowId.hasOwnProperty(key))
                                        data["EditRowId"][key] = this.EditRowId[key] !== undefined ? this.EditRowId[key] : null;
                                }
                            }
                            return data;
                        };
                        return IRowEditOptions;
                    }());
                    Owin.IRowEditOptions = IRowEditOptions;
                    var ISortingOptions = /** @class */ (function () {
                        function ISortingOptions(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        ISortingOptions.prototype.init = function (data) {
                            if (data) {
                                this.SortDescending = data["SortDescending"] !== undefined ? data["SortDescending"] : null;
                                this.SortExpression = data["SortExpression"] !== undefined ? data["SortExpression"] : null;
                            }
                        };
                        ISortingOptions.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new ISortingOptions();
                            result.init(data);
                            return result;
                        };
                        ISortingOptions.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["SortDescending"] = this.SortDescending !== undefined ? this.SortDescending : null;
                            data["SortExpression"] = this.SortExpression !== undefined ? this.SortExpression : null;
                            return data;
                        };
                        return ISortingOptions;
                    }());
                    Owin.ISortingOptions = ISortingOptions;
                    var PagingOptions = /** @class */ (function () {
                        function PagingOptions(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        PagingOptions.prototype.init = function (data) {
                            if (data) {
                                if (data["NearPageIndexesProvider"]) {
                                    this.NearPageIndexesProvider = {};
                                    for (var key in data["NearPageIndexesProvider"]) {
                                        if (data["NearPageIndexesProvider"].hasOwnProperty(key))
                                            this.NearPageIndexesProvider[key] = data["NearPageIndexesProvider"][key];
                                    }
                                }
                                this.IsFirstPage = data["IsFirstPage"] !== undefined ? data["IsFirstPage"] : null;
                                this.IsLastPage = data["IsLastPage"] !== undefined ? data["IsLastPage"] : null;
                                this.PagesCount = data["PagesCount"] !== undefined ? data["PagesCount"] : null;
                                this.PageIndex = data["PageIndex"] !== undefined ? data["PageIndex"] : null;
                                this.PageSize = data["PageSize"] !== undefined ? data["PageSize"] : null;
                                this.TotalItemsCount = data["TotalItemsCount"] !== undefined ? data["TotalItemsCount"] : null;
                                if (data["NearPageIndexes"] && data["NearPageIndexes"].constructor === Array) {
                                    this.NearPageIndexes = [];
                                    for (var _i = 0, _a = data["NearPageIndexes"]; _i < _a.length; _i++) {
                                        var item = _a[_i];
                                        this.NearPageIndexes.push(item);
                                    }
                                }
                            }
                        };
                        PagingOptions.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new PagingOptions();
                            result.init(data);
                            return result;
                        };
                        PagingOptions.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            if (this.NearPageIndexesProvider) {
                                data["NearPageIndexesProvider"] = {};
                                for (var key in this.NearPageIndexesProvider) {
                                    if (this.NearPageIndexesProvider.hasOwnProperty(key))
                                        data["NearPageIndexesProvider"][key] = this.NearPageIndexesProvider[key] !== undefined ? this.NearPageIndexesProvider[key] : null;
                                }
                            }
                            data["IsFirstPage"] = this.IsFirstPage !== undefined ? this.IsFirstPage : null;
                            data["IsLastPage"] = this.IsLastPage !== undefined ? this.IsLastPage : null;
                            data["PagesCount"] = this.PagesCount !== undefined ? this.PagesCount : null;
                            data["PageIndex"] = this.PageIndex !== undefined ? this.PageIndex : null;
                            data["PageSize"] = this.PageSize !== undefined ? this.PageSize : null;
                            data["TotalItemsCount"] = this.TotalItemsCount !== undefined ? this.TotalItemsCount : null;
                            if (this.NearPageIndexes && this.NearPageIndexes.constructor === Array) {
                                data["NearPageIndexes"] = [];
                                for (var _i = 0, _a = this.NearPageIndexes; _i < _a.length; _i++) {
                                    var item = _a[_i];
                                    data["NearPageIndexes"].push(item);
                                }
                            }
                            return data;
                        };
                        return PagingOptions;
                    }());
                    Owin.PagingOptions = PagingOptions;
                    var GridViewDataSetOfCompanyOfString = /** @class */ (function () {
                        function GridViewDataSetOfCompanyOfString(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        GridViewDataSetOfCompanyOfString.prototype.init = function (data) {
                            if (data) {
                                this.IsRefreshRequired = data["IsRefreshRequired"] !== undefined ? data["IsRefreshRequired"] : null;
                                if (data["Items"] && data["Items"].constructor === Array) {
                                    this.Items = [];
                                    for (var _i = 0, _a = data["Items"]; _i < _a.length; _i++) {
                                        var item = _a[_i];
                                        this.Items.push(CompanyOfString.fromJS(item));
                                    }
                                }
                                this.PagingOptions = data["PagingOptions"] ? IPagingOptions.fromJS(data["PagingOptions"]) : null;
                                this.RowEditOptions = data["RowEditOptions"] ? IRowEditOptions.fromJS(data["RowEditOptions"]) : null;
                                this.SortingOptions = data["SortingOptions"] ? ISortingOptions.fromJS(data["SortingOptions"]) : null;
                            }
                        };
                        GridViewDataSetOfCompanyOfString.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new GridViewDataSetOfCompanyOfString();
                            result.init(data);
                            return result;
                        };
                        GridViewDataSetOfCompanyOfString.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["IsRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : null;
                            if (this.Items && this.Items.constructor === Array) {
                                data["Items"] = [];
                                for (var _i = 0, _a = this.Items; _i < _a.length; _i++) {
                                    var item = _a[_i];
                                    data["Items"].push(item.toJSON());
                                }
                            }
                            data["PagingOptions"] = this.PagingOptions ? this.PagingOptions.toJSON() : null;
                            data["RowEditOptions"] = this.RowEditOptions ? this.RowEditOptions.toJSON() : null;
                            data["SortingOptions"] = this.SortingOptions ? this.SortingOptions.toJSON() : null;
                            return data;
                        };
                        return GridViewDataSetOfCompanyOfString;
                    }());
                    Owin.GridViewDataSetOfCompanyOfString = GridViewDataSetOfCompanyOfString;
                    var Order = /** @class */ (function () {
                        function Order(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        Order.prototype.init = function (data) {
                            if (data) {
                                this.Id = data["Id"] !== undefined ? data["Id"] : null;
                                this.Number = data["Number"] !== undefined ? data["Number"] : null;
                                this.Date = data["Date"] ? new Date(data["Date"].toString()) : null;
                                this.companyId = data["companyId"] !== undefined ? data["companyId"] : null;
                                if (data["OrderItems"] && data["OrderItems"].constructor === Array) {
                                    this.OrderItems = [];
                                    for (var _i = 0, _a = data["OrderItems"]; _i < _a.length; _i++) {
                                        var item = _a[_i];
                                        this.OrderItems.push(OrderItem.fromJS(item));
                                    }
                                }
                            }
                        };
                        Order.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new Order();
                            result.init(data);
                            return result;
                        };
                        Order.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["Id"] = this.Id !== undefined ? this.Id : null;
                            data["Number"] = this.Number !== undefined ? this.Number : null;
                            data["Date"] = this.Date ? this.Date.toISOString() : null;
                            data["companyId"] = this.companyId !== undefined ? this.companyId : null;
                            if (this.OrderItems && this.OrderItems.constructor === Array) {
                                data["OrderItems"] = [];
                                for (var _i = 0, _a = this.OrderItems; _i < _a.length; _i++) {
                                    var item = _a[_i];
                                    data["OrderItems"].push(item.toJSON());
                                }
                            }
                            return data;
                        };
                        return Order;
                    }());
                    Owin.Order = Order;
                    var OrderItem = /** @class */ (function () {
                        function OrderItem(data) {
                            if (data) {
                                for (var property in data) {
                                    if (data.hasOwnProperty(property))
                                        this[property] = data[property];
                                }
                            }
                        }
                        OrderItem.prototype.init = function (data) {
                            if (data) {
                                this.Id = data["Id"] !== undefined ? data["Id"] : null;
                                this.Text = data["Text"] !== undefined ? data["Text"] : null;
                                this.Amount = data["Amount"] !== undefined ? data["Amount"] : null;
                                this.Discount = data["Discount"] !== undefined ? data["Discount"] : null;
                                this.IsOnStock = data["IsOnStock"] !== undefined ? data["IsOnStock"] : null;
                            }
                        };
                        OrderItem.fromJS = function (data) {
                            data = typeof data === 'object' ? data : {};
                            var result = new OrderItem();
                            result.init(data);
                            return result;
                        };
                        OrderItem.prototype.toJSON = function (data) {
                            data = typeof data === 'object' ? data : {};
                            data["Id"] = this.Id !== undefined ? this.Id : null;
                            data["Text"] = this.Text !== undefined ? this.Text : null;
                            data["Amount"] = this.Amount !== undefined ? this.Amount : null;
                            data["Discount"] = this.Discount !== undefined ? this.Discount : null;
                            data["IsOnStock"] = this.IsOnStock !== undefined ? this.IsOnStock : null;
                            return data;
                        };
                        return OrderItem;
                    }());
                    Owin.OrderItem = OrderItem;
                    var SwaggerException = /** @class */ (function (_super) {
                        __extends(SwaggerException, _super);
                        function SwaggerException(message, status, response, headers, result) {
                            var _this = _super.call(this) || this;
                            _this.isSwaggerException = true;
                            _this.message = message;
                            _this.status = status;
                            _this.response = response;
                            _this.headers = headers;
                            _this.result = result;
                            return _this;
                        }
                        SwaggerException.isSwaggerException = function (obj) {
                            return obj.isSwaggerException === true;
                        };
                        return SwaggerException;
                    }(Error));
                    Owin.SwaggerException = SwaggerException;
                    function throwException(message, status, response, headers, result) {
                        if (result !== null && result !== undefined)
                            throw result;
                        else
                            throw new SwaggerException(message, status, response, headers, null);
                    }
                })(Owin = Api.Owin || (Api.Owin = {}));
            })(Api = Common.Api || (Common.Api = {}));
        })(Common = Samples.Common || (Samples.Common = {}));
    })(Samples = DotVVM.Samples || (DotVVM.Samples = {}));
})(DotVVM || (DotVVM = {}));
