namespace DotVVM.Samples.Common.Api.AspNetCore {
    class ClientBase {
        public transformOptions(options: RequestInit) {
            options.credentials = "same-origin";
            return Promise.resolve(options);
        }
    }
    /* tslint:disable */
    /* eslint-disable */
    //----------------------
    // <auto-generated>
    //     Generated using the NSwag toolchain v13.13.2.0 (NJsonSchema v10.5.2.0 (Newtonsoft.Json v10.0.0.0)) (http://NSwag.org)
    // </auto-generated>
    //----------------------
    // ReSharper disable InconsistentNaming
    
    export class TestWebApiClientAspNetCore extends ClientBase {
        private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
        private baseUrl: string;
        protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;
    
        constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
            super();
            this.http = http ? http : <any>window;
            this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "http://localhost:5001";
        }
    
        /**
         * @param category (optional) 
         * @return Success
         */
        bindingSharingGetGet(category?: number | null | undefined): Promise<BindingSharingItemDTO[]> {
            let url_ = this.baseUrl + "/api/BindingSharing/get?";
            if (category !== undefined && category !== null)
                url_ += "category=" + encodeURIComponent("" + category) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processBindingSharingGetGet(_response);
            });
        }
    
        protected processBindingSharingGetGet(response: Response): Promise<BindingSharingItemDTO[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(BindingSharingItemDTO.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<BindingSharingItemDTO[]>(<any>null);
        }
    
        /**
         * @return Success
         */
        bindingSharingGetGetWithRouteParam(category: number): Promise<BindingSharingItemDTO[]> {
            let url_ = this.baseUrl + "/api/BindingSharing/getWithRouteParam/{category}";
            if (category === undefined || category === null)
                throw new Error("The parameter 'category' must be defined.");
            url_ = url_.replace("{category}", encodeURIComponent("" + category));
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processBindingSharingGetGetWithRouteParam(_response);
            });
        }
    
        protected processBindingSharingGetGetWithRouteParam(response: Response): Promise<BindingSharingItemDTO[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(BindingSharingItemDTO.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<BindingSharingItemDTO[]>(<any>null);
        }
    
        /**
         * @param category (optional) 
         * @return Success
         */
        bindingSharingPostPost(category?: number | null | undefined): Promise<BindingSharingItemDTO[]> {
            let url_ = this.baseUrl + "/api/BindingSharing/post?";
            if (category !== undefined && category !== null)
                url_ += "category=" + encodeURIComponent("" + category) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "POST",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processBindingSharingPostPost(_response);
            });
        }
    
        protected processBindingSharingPostPost(response: Response): Promise<BindingSharingItemDTO[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(BindingSharingItemDTO.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<BindingSharingItemDTO[]>(<any>null);
        }
    
        /**
         * @return Success
         */
        getCompanies(): Promise<CompanyOfString[]> {
            let url_ = this.baseUrl + "/api/Companies";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetCompanies(_response);
            });
        }
    
        protected processGetCompanies(response: Response): Promise<CompanyOfString[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(CompanyOfString.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<CompanyOfString[]>(<any>null);
        }
    
        /**
         * @param sortingOptions (optional) 
         * @param sortingOptions_SortDescending (optional) 
         * @param sortingOptions_SortExpression (optional) 
         * @return Success
         */
        companiesGetSorted(sortingOptions?: any | null | undefined, sortingOptions_SortDescending?: boolean | null | undefined, sortingOptions_SortExpression?: string | null | undefined): Promise<GridViewDataSetOfCompanyOfBoolean> {
            let url_ = this.baseUrl + "/api/Companies/sorted?";
            if (sortingOptions !== undefined && sortingOptions !== null)
                url_ += "sortingOptions=" + encodeURIComponent("" + sortingOptions) + "&";
            if (sortingOptions_SortDescending !== undefined && sortingOptions_SortDescending !== null)
                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
            if (sortingOptions_SortExpression !== undefined && sortingOptions_SortExpression !== null)
                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processCompaniesGetSorted(_response);
            });
        }
    
        protected processCompaniesGetSorted(response: Response): Promise<GridViewDataSetOfCompanyOfBoolean> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfBoolean.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfBoolean>(<any>null);
        }
    
        /**
         * @param pagingOptions (optional) 
         * @param pagingOptions_PageIndex (optional) 
         * @param pagingOptions_PageSize (optional) 
         * @param pagingOptions_TotalItemsCount (optional) 
         * @return Success
         */
        companiesGetPaged(pagingOptions?: any | null | undefined, pagingOptions_PageIndex?: number | null | undefined, pagingOptions_PageSize?: number | null | undefined, pagingOptions_TotalItemsCount?: number | null | undefined): Promise<GridViewDataSetOfCompanyOfString> {
            let url_ = this.baseUrl + "/api/Companies/paged?";
            if (pagingOptions !== undefined && pagingOptions !== null)
                url_ += "pagingOptions=" + encodeURIComponent("" + pagingOptions) + "&";
            if (pagingOptions_PageIndex !== undefined && pagingOptions_PageIndex !== null)
                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
            if (pagingOptions_PageSize !== undefined && pagingOptions_PageSize !== null)
                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
            if (pagingOptions_TotalItemsCount !== undefined && pagingOptions_TotalItemsCount !== null)
                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processCompaniesGetPaged(_response);
            });
        }
    
        protected processCompaniesGetPaged(response: Response): Promise<GridViewDataSetOfCompanyOfString> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfString.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfString>(<any>null);
        }
    
        /**
         * @param sortingOptions (optional) 
         * @param sortingOptions_SortDescending (optional) 
         * @param sortingOptions_SortExpression (optional) 
         * @param pagingOptions (optional) 
         * @param pagingOptions_PageIndex (optional) 
         * @param pagingOptions_PageSize (optional) 
         * @param pagingOptions_TotalItemsCount (optional) 
         * @return Success
         */
        companiesGetSortedandpaged(sortingOptions?: any | null | undefined, sortingOptions_SortDescending?: boolean | null | undefined, sortingOptions_SortExpression?: string | null | undefined, pagingOptions?: any | null | undefined, pagingOptions_PageIndex?: number | null | undefined, pagingOptions_PageSize?: number | null | undefined, pagingOptions_TotalItemsCount?: number | null | undefined): Promise<GridViewDataSetOfCompanyOfString> {
            let url_ = this.baseUrl + "/api/Companies/sortedandpaged?";
            if (sortingOptions !== undefined && sortingOptions !== null)
                url_ += "sortingOptions=" + encodeURIComponent("" + sortingOptions) + "&";
            if (sortingOptions_SortDescending !== undefined && sortingOptions_SortDescending !== null)
                url_ += "sortingOptions.SortDescending=" + encodeURIComponent("" + sortingOptions_SortDescending) + "&";
            if (sortingOptions_SortExpression !== undefined && sortingOptions_SortExpression !== null)
                url_ += "sortingOptions.SortExpression=" + encodeURIComponent("" + sortingOptions_SortExpression) + "&";
            if (pagingOptions !== undefined && pagingOptions !== null)
                url_ += "pagingOptions=" + encodeURIComponent("" + pagingOptions) + "&";
            if (pagingOptions_PageIndex !== undefined && pagingOptions_PageIndex !== null)
                url_ += "pagingOptions.PageIndex=" + encodeURIComponent("" + pagingOptions_PageIndex) + "&";
            if (pagingOptions_PageSize !== undefined && pagingOptions_PageSize !== null)
                url_ += "pagingOptions.PageSize=" + encodeURIComponent("" + pagingOptions_PageSize) + "&";
            if (pagingOptions_TotalItemsCount !== undefined && pagingOptions_TotalItemsCount !== null)
                url_ += "pagingOptions.TotalItemsCount=" + encodeURIComponent("" + pagingOptions_TotalItemsCount) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processCompaniesGetSortedandpaged(_response);
            });
        }
    
        protected processCompaniesGetSortedandpaged(response: Response): Promise<GridViewDataSetOfCompanyOfString> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = GridViewDataSetOfCompanyOfString.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<GridViewDataSetOfCompanyOfString>(<any>null);
        }
    
        /**
         * @param companyId (optional) 
         * @param pageIndex (optional) 
         * @param pageSize (optional) 
         * @return Success
         */
        getOrdersAll(companyId?: number | null | undefined, pageIndex?: number | null | undefined, pageSize?: number | null | undefined): Promise<Order[]> {
            let url_ = this.baseUrl + "/api/Orders?";
            if (companyId !== undefined && companyId !== null)
                url_ += "companyId=" + encodeURIComponent("" + companyId) + "&";
            if (pageIndex !== undefined && pageIndex !== null)
                url_ += "pageIndex=" + encodeURIComponent("" + pageIndex) + "&";
            if (pageSize !== undefined && pageSize !== null)
                url_ += "pageSize=" + encodeURIComponent("" + pageSize) + "&";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetOrdersAll(_response);
            });
        }
    
        protected processGetOrdersAll(response: Response): Promise<Order[]> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                if (Array.isArray(resultData200)) {
                    result200 = [] as any;
                    for (let item of resultData200)
                        result200!.push(Order.fromJS(item));
                }
                else {
                    result200 = <any>null;
                }
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<Order[]>(<any>null);
        }
    
        /**
         * @param body (optional) 
         * @return Success
         */
        postOrders(body?: Order | null | undefined): Promise<void> {
            let url_ = this.baseUrl + "/api/Orders";
            url_ = url_.replace(/[?&]$/, "");
    
            const content_ = JSON.stringify(body);
    
            let options_ = <RequestInit>{
                body: content_,
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processPostOrders(_response);
            });
        }
    
        protected processPostOrders(response: Response): Promise<void> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                return;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<void>(<any>null);
        }
    
        /**
         * @return Success
         */
        getOrders(orderId: number): Promise<Order> {
            let url_ = this.baseUrl + "/api/Orders/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "GET",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processGetOrders(_response);
            });
        }
    
        protected processGetOrders(response: Response): Promise<Order> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = Order.fromJS(resultData200);
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<Order>(<any>null);
        }
    
        /**
         * @param body (optional) 
         * @return Success
         */
        putOrders(orderId: number, body?: Order | null | undefined): Promise<void> {
            let url_ = this.baseUrl + "/api/Orders/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            const content_ = JSON.stringify(body);
    
            let options_ = <RequestInit>{
                body: content_,
                method: "PUT",
                headers: {
                    "Content-Type": "application/json",
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processPutOrders(_response);
            });
        }
    
        protected processPutOrders(response: Response): Promise<void> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                return;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<void>(<any>null);
        }
    
        /**
         * @return Success
         */
        ordersDeleteDelete(orderId: number): Promise<void> {
            let url_ = this.baseUrl + "/api/Orders/delete/{orderId}";
            if (orderId === undefined || orderId === null)
                throw new Error("The parameter 'orderId' must be defined.");
            url_ = url_.replace("{orderId}", encodeURIComponent("" + orderId));
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "DELETE",
                headers: {
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processOrdersDeleteDelete(_response);
            });
        }
    
        protected processOrdersDeleteDelete(response: Response): Promise<void> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                return;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<void>(<any>null);
        }
    
        /**
         * @return Success
         */
        slowPostRandomNumber(): Promise<number> {
            let url_ = this.baseUrl + "/api/Slow/random-number";
            url_ = url_.replace(/[?&]$/, "");
    
            let options_ = <RequestInit>{
                method: "POST",
                headers: {
                    "Accept": "application/json"
                }
            };
    
            return this.transformOptions(options_).then(transformedOptions_ => {
                return this.http.fetch(url_, transformedOptions_);
            }).then((_response: Response) => {
                return this.processSlowPostRandomNumber(_response);
            });
        }
    
        protected processSlowPostRandomNumber(response: Response): Promise<number> {
            const status = response.status;
            let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
            if (status === 200) {
                return response.text().then((_responseText) => {
                let result200: any = null;
                let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
                return result200;
                });
            } else if (status !== 200 && status !== 204) {
                return response.text().then((_responseText) => {
                return throwException("An unexpected server error occurred.", status, _responseText, _headers);
                });
            }
            return Promise.resolve<number>(<any>null);
        }
    }
    
    export class BindingSharingItemDTO implements IBindingSharingItemDTO {
        id!: number;
        name?: string | null;
    
        constructor(data?: IBindingSharingItemDTO) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.id = _data["id"] !== undefined ? _data["id"] : <any>null;
                this.name = _data["name"] !== undefined ? _data["name"] : <any>null;
            }
        }
    
        static fromJS(data: any): BindingSharingItemDTO {
            data = typeof data === 'object' ? data : {};
            let result = new BindingSharingItemDTO();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["id"] = this.id !== undefined ? this.id : <any>null;
            data["name"] = this.name !== undefined ? this.name : <any>null;
            return data; 
        }
    }
    
    export interface IBindingSharingItemDTO {
        id: number;
        name?: string | null;
    }
    
    export class CompanyOfBoolean implements ICompanyOfBoolean {
        id?: number | null;
        name?: string | null;
        owner?: string | null;
        department?: boolean | null;
    
        constructor(data?: ICompanyOfBoolean) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.id = _data["id"] !== undefined ? _data["id"] : <any>null;
                this.name = _data["name"] !== undefined ? _data["name"] : <any>null;
                this.owner = _data["owner"] !== undefined ? _data["owner"] : <any>null;
                this.department = _data["department"] !== undefined ? _data["department"] : <any>null;
            }
        }
    
        static fromJS(data: any): CompanyOfBoolean {
            data = typeof data === 'object' ? data : {};
            let result = new CompanyOfBoolean();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["id"] = this.id !== undefined ? this.id : <any>null;
            data["name"] = this.name !== undefined ? this.name : <any>null;
            data["owner"] = this.owner !== undefined ? this.owner : <any>null;
            data["department"] = this.department !== undefined ? this.department : <any>null;
            return data; 
        }
    }
    
    export interface ICompanyOfBoolean {
        id?: number | null;
        name?: string | null;
        owner?: string | null;
        department?: boolean | null;
    }
    
    export class CompanyOfString implements ICompanyOfString {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: string | null;
    
        constructor(data?: ICompanyOfString) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.Id = _data["id"] !== undefined ? _data["id"] : <any>null;
                this.Name = _data["name"] !== undefined ? _data["name"] : <any>null;
                this.Owner = _data["owner"] !== undefined ? _data["owner"] : <any>null;
                this.Department = _data["department"] !== undefined ? _data["department"] : <any>null;
            }
        }
    
        static fromJS(data: any): CompanyOfString {
            data = typeof data === 'object' ? data : {};
            let result = new CompanyOfString();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["id"] = this.Id !== undefined ? this.Id : <any>null;
            data["name"] = this.Name !== undefined ? this.Name : <any>null;
            data["owner"] = this.Owner !== undefined ? this.Owner : <any>null;
            data["department"] = this.Department !== undefined ? this.Department : <any>null;
            return data; 
        }
    }
    
    export interface ICompanyOfString {
        Id?: number | null;
        Name?: string | null;
        Owner?: string | null;
        Department?: string | null;
    }
    
    export class GridViewDataSetOfCompanyOfBoolean implements IGridViewDataSetOfCompanyOfBoolean {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfBoolean[] | null;
        pagingOptions?: IPagingOptions | null;
        rowEditOptions?: IRowEditOptions | null;
        sortingOptions?: ISortingOptions | null;
    
        constructor(data?: IGridViewDataSetOfCompanyOfBoolean) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.IsRefreshRequired = _data["isRefreshRequired"] !== undefined ? _data["isRefreshRequired"] : <any>null;
                if (Array.isArray(_data["items"])) {
                    this.Items = [] as any;
                    for (let item of _data["items"])
                        this.Items!.push(CompanyOfBoolean.fromJS(item));
                }
                else {
                    this.Items = <any>null;
                }
                this.pagingOptions = _data["pagingOptions"] ? IPagingOptions.fromJS(_data["pagingOptions"]) : <any>null;
                this.rowEditOptions = _data["rowEditOptions"] ? IRowEditOptions.fromJS(_data["rowEditOptions"]) : <any>null;
                this.sortingOptions = _data["sortingOptions"] ? ISortingOptions.fromJS(_data["sortingOptions"]) : <any>null;
            }
        }
    
        static fromJS(data: any): GridViewDataSetOfCompanyOfBoolean {
            data = typeof data === 'object' ? data : {};
            let result = new GridViewDataSetOfCompanyOfBoolean();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["isRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : <any>null;
            if (Array.isArray(this.Items)) {
                data["items"] = [];
                for (let item of this.Items)
                    data["items"].push(item.toJSON());
            }
            data["pagingOptions"] = this.pagingOptions ? this.pagingOptions.toJSON() : <any>null;
            data["rowEditOptions"] = this.rowEditOptions ? this.rowEditOptions.toJSON() : <any>null;
            data["sortingOptions"] = this.sortingOptions ? this.sortingOptions.toJSON() : <any>null;
            return data; 
        }
    }
    
    export interface IGridViewDataSetOfCompanyOfBoolean {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfBoolean[] | null;
        pagingOptions?: IPagingOptions | null;
        rowEditOptions?: IRowEditOptions | null;
        sortingOptions?: ISortingOptions | null;
    }
    
    export class GridViewDataSetOfCompanyOfString implements IGridViewDataSetOfCompanyOfString {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfString[] | null;
        pagingOptions?: IPagingOptions | null;
        rowEditOptions?: IRowEditOptions | null;
        sortingOptions?: ISortingOptions | null;
    
        constructor(data?: IGridViewDataSetOfCompanyOfString) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.IsRefreshRequired = _data["isRefreshRequired"] !== undefined ? _data["isRefreshRequired"] : <any>null;
                if (Array.isArray(_data["items"])) {
                    this.Items = [] as any;
                    for (let item of _data["items"])
                        this.Items!.push(CompanyOfString.fromJS(item));
                }
                else {
                    this.Items = <any>null;
                }
                this.pagingOptions = _data["pagingOptions"] ? IPagingOptions.fromJS(_data["pagingOptions"]) : <any>null;
                this.rowEditOptions = _data["rowEditOptions"] ? IRowEditOptions.fromJS(_data["rowEditOptions"]) : <any>null;
                this.sortingOptions = _data["sortingOptions"] ? ISortingOptions.fromJS(_data["sortingOptions"]) : <any>null;
            }
        }
    
        static fromJS(data: any): GridViewDataSetOfCompanyOfString {
            data = typeof data === 'object' ? data : {};
            let result = new GridViewDataSetOfCompanyOfString();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["isRefreshRequired"] = this.IsRefreshRequired !== undefined ? this.IsRefreshRequired : <any>null;
            if (Array.isArray(this.Items)) {
                data["items"] = [];
                for (let item of this.Items)
                    data["items"].push(item.toJSON());
            }
            data["pagingOptions"] = this.pagingOptions ? this.pagingOptions.toJSON() : <any>null;
            data["rowEditOptions"] = this.rowEditOptions ? this.rowEditOptions.toJSON() : <any>null;
            data["sortingOptions"] = this.sortingOptions ? this.sortingOptions.toJSON() : <any>null;
            return data; 
        }
    }
    
    export interface IGridViewDataSetOfCompanyOfString {
        IsRefreshRequired?: boolean | null;
        Items?: CompanyOfString[] | null;
        pagingOptions?: IPagingOptions | null;
        rowEditOptions?: IRowEditOptions | null;
        sortingOptions?: ISortingOptions | null;
    }
    
    export class INearPageIndexesProvider implements IINearPageIndexesProvider {
    
        constructor(data?: IINearPageIndexesProvider) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
        }
    
        static fromJS(data: any): INearPageIndexesProvider {
            data = typeof data === 'object' ? data : {};
            let result = new INearPageIndexesProvider();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            return data; 
        }
    }
    
    export interface IINearPageIndexesProvider {
    }
    
    export class IPagingOptions implements IIPagingOptions {
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        readonly IsFirstPage?: boolean | null;
        readonly IsLastPage?: boolean | null;
        readonly PagesCount?: number | null;
        readonly NearPageIndexes?: number[] | null;
    
        constructor(data?: IIPagingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.PageIndex = _data["pageIndex"] !== undefined ? _data["pageIndex"] : <any>null;
                this.PageSize = _data["pageSize"] !== undefined ? _data["pageSize"] : <any>null;
                this.TotalItemsCount = _data["totalItemsCount"] !== undefined ? _data["totalItemsCount"] : <any>null;
                (<any>this).IsFirstPage = _data["isFirstPage"] !== undefined ? _data["isFirstPage"] : <any>null;
                (<any>this).IsLastPage = _data["isLastPage"] !== undefined ? _data["isLastPage"] : <any>null;
                (<any>this).PagesCount = _data["pagesCount"] !== undefined ? _data["pagesCount"] : <any>null;
                if (Array.isArray(_data["nearPageIndexes"])) {
                    (<any>this).NearPageIndexes = [] as any;
                    for (let item of _data["nearPageIndexes"])
                        (<any>this).NearPageIndexes!.push(item);
                }
                else {
                    (<any>this).NearPageIndexes = <any>null;
                }
            }
        }
    
        static fromJS(data: any): IPagingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new IPagingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["pageIndex"] = this.PageIndex !== undefined ? this.PageIndex : <any>null;
            data["pageSize"] = this.PageSize !== undefined ? this.PageSize : <any>null;
            data["totalItemsCount"] = this.TotalItemsCount !== undefined ? this.TotalItemsCount : <any>null;
            data["isFirstPage"] = this.IsFirstPage !== undefined ? this.IsFirstPage : <any>null;
            data["isLastPage"] = this.IsLastPage !== undefined ? this.IsLastPage : <any>null;
            data["pagesCount"] = this.PagesCount !== undefined ? this.PagesCount : <any>null;
            if (Array.isArray(this.NearPageIndexes)) {
                data["nearPageIndexes"] = [];
                for (let item of this.NearPageIndexes)
                    data["nearPageIndexes"].push(item);
            }
            return data; 
        }
    }
    
    export interface IIPagingOptions {
        PageIndex?: number | null;
        PageSize?: number | null;
        TotalItemsCount?: number | null;
        IsFirstPage?: boolean | null;
        IsLastPage?: boolean | null;
        PagesCount?: number | null;
        NearPageIndexes?: number[] | null;
    }
    
    export class IRowEditOptions implements IIRowEditOptions {
        PrimaryKeyPropertyName?: string | null;
        EditRowId?: any | null;
    
        constructor(data?: IIRowEditOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.PrimaryKeyPropertyName = _data["primaryKeyPropertyName"] !== undefined ? _data["primaryKeyPropertyName"] : <any>null;
                this.EditRowId = _data["editRowId"] !== undefined ? _data["editRowId"] : <any>null;
            }
        }
    
        static fromJS(data: any): IRowEditOptions {
            data = typeof data === 'object' ? data : {};
            let result = new IRowEditOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["primaryKeyPropertyName"] = this.PrimaryKeyPropertyName !== undefined ? this.PrimaryKeyPropertyName : <any>null;
            data["editRowId"] = this.EditRowId !== undefined ? this.EditRowId : <any>null;
            return data; 
        }
    }
    
    export interface IIRowEditOptions {
        PrimaryKeyPropertyName?: string | null;
        EditRowId?: any | null;
    }
    
    export class ISortingOptions implements IISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    
        constructor(data?: IISortingOptions) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.SortDescending = _data["sortDescending"] !== undefined ? _data["sortDescending"] : <any>null;
                this.SortExpression = _data["sortExpression"] !== undefined ? _data["sortExpression"] : <any>null;
            }
        }
    
        static fromJS(data: any): ISortingOptions {
            data = typeof data === 'object' ? data : {};
            let result = new ISortingOptions();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["sortDescending"] = this.SortDescending !== undefined ? this.SortDescending : <any>null;
            data["sortExpression"] = this.SortExpression !== undefined ? this.SortExpression : <any>null;
            return data; 
        }
    }
    
    export interface IISortingOptions {
        SortDescending?: boolean | null;
        SortExpression?: string | null;
    }
    
    export class Order implements IOrder {
        id?: number | null;
        Number?: string | null;
        date?: Date | null;
        companyId?: number | null;
        orderItems?: OrderItem[] | null;
    
        constructor(data?: IOrder) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.id = _data["id"] !== undefined ? _data["id"] : <any>null;
                this.Number = _data["Number"] !== undefined ? _data["Number"] : <any>null;
                this.date = _data["date"] ? new Date(_data["date"].toString()) : <any>null;
                this.companyId = _data["companyId"] !== undefined ? _data["companyId"] : <any>null;
                if (Array.isArray(_data["orderItems"])) {
                    this.orderItems = [] as any;
                    for (let item of _data["orderItems"])
                        this.orderItems!.push(OrderItem.fromJS(item));
                }
                else {
                    this.orderItems = <any>null;
                }
            }
        }
    
        static fromJS(data: any): Order {
            data = typeof data === 'object' ? data : {};
            let result = new Order();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["id"] = this.id !== undefined ? this.id : <any>null;
            data["Number"] = this.Number !== undefined ? this.Number : <any>null;
            data["date"] = this.date ? this.date.toISOString() : <any>null;
            data["companyId"] = this.companyId !== undefined ? this.companyId : <any>null;
            if (Array.isArray(this.orderItems)) {
                data["orderItems"] = [];
                for (let item of this.orderItems)
                    data["orderItems"].push(item.toJSON());
            }
            return data; 
        }
    }
    
    export interface IOrder {
        id?: number | null;
        Number?: string | null;
        date?: Date | null;
        companyId?: number | null;
        orderItems?: OrderItem[] | null;
    }
    
    export class OrderItem implements IOrderItem {
        id?: number | null;
        text?: string | null;
        amount?: number | null;
        discount?: number | null;
        isOnStock?: boolean | null;
    
        constructor(data?: IOrderItem) {
            if (data) {
                for (var property in data) {
                    if (data.hasOwnProperty(property))
                        (<any>this)[property] = (<any>data)[property];
                }
            }
        }
    
        init(_data?: any) {
            if (_data) {
                this.id = _data["id"] !== undefined ? _data["id"] : <any>null;
                this.text = _data["text"] !== undefined ? _data["text"] : <any>null;
                this.amount = _data["amount"] !== undefined ? _data["amount"] : <any>null;
                this.discount = _data["discount"] !== undefined ? _data["discount"] : <any>null;
                this.isOnStock = _data["isOnStock"] !== undefined ? _data["isOnStock"] : <any>null;
            }
        }
    
        static fromJS(data: any): OrderItem {
            data = typeof data === 'object' ? data : {};
            let result = new OrderItem();
            result.init(data);
            return result;
        }
    
        toJSON(data?: any) {
            data = typeof data === 'object' ? data : {};
            data["id"] = this.id !== undefined ? this.id : <any>null;
            data["text"] = this.text !== undefined ? this.text : <any>null;
            data["amount"] = this.amount !== undefined ? this.amount : <any>null;
            data["discount"] = this.discount !== undefined ? this.discount : <any>null;
            data["isOnStock"] = this.isOnStock !== undefined ? this.isOnStock : <any>null;
            return data; 
        }
    }
    
    export interface IOrderItem {
        id?: number | null;
        text?: string | null;
        amount?: number | null;
        discount?: number | null;
        isOnStock?: boolean | null;
    }
    
    export class ApiException extends Error {
        message: string;
        status: number;
        response: string;
        headers: { [key: string]: any; };
        result: any;
    
        constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
            super();
    
            this.message = message;
            this.status = status;
            this.response = response;
            this.headers = headers;
            this.result = result;
        }
    
        protected isApiException = true;
    
        static isApiException(obj: any): obj is ApiException {
            return obj.isApiException === true;
        }
    }
    
    function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
        if (result !== null && result !== undefined)
            throw result;
        else
            throw new ApiException(message, status, response, headers, null);
    }
}
