// not a module, available to everyone

type PostbackCommitFunction = () => Promise<DotvvmAfterPostBackEventArgs>

type DotvvmPostbackHandler = {
    execute(next: () => Promise<PostbackCommitFunction>, options: PostbackOptions): Promise<PostbackCommitFunction>
    name?: string
    after?: Array<string | DotvvmPostbackHandler>
    before?: Array<string | DotvvmPostbackHandler>
}

type DotvvmPostbackErrorLike = {
    readonly reason: DotvvmPostbackErrorReason
}

type DotvvmPostbackErrorReason = (
    | { type: 'handler', handlerName: string, message?: string }
    | { type: 'network', err?: any }
    | { type: 'gate' }
    | { type: 'commit', args?: DotvvmErrorEventArgs }
    | { type: 'csrfToken' }
    | { type: 'serverError', status?: number, responseObject: any, response?: Response }
    | { type: 'event' }
    | { type: 'validation', responseObject: any, response?: Response }
    | { type: 'abort' }
    | { type: 'redirect', responseObject: any, response?: Response }
    ) & { options?: PostbackOptions }

type PostbackCommandType = "postback" | "staticCommand" | "spaNavigation"

type PostbackOptions = {
    readonly postbackId: number
    readonly commandType: PostbackCommandType
    readonly args: any[]
    readonly sender?: HTMLElement
    readonly viewModel?: any
    readonly knockoutContext?: KnockoutBindingContext
    serverResponseObject?: any
    validationTargetPath?: string,
    abortSignal?: AbortSignal
}

type DotvvmErrorEventArgs = PostbackOptions & {
    readonly response?: Response
    readonly error: DotvvmPostbackErrorLike
    handled: boolean
}

type DotvvmBeforePostBackEventArgs = PostbackOptions & {
    cancel: boolean
}

type DotvvmAfterPostBackEventArgs = PostbackOptions & {
    /** Set to true in case the postback did not finish and it was cancelled by an event or a postback handler */
    readonly wasInterrupted?: boolean;
    readonly commandResult?: any
    readonly response?: Response
    readonly error?: DotvvmPostbackErrorLike
}

type DotvvmNavigationEventArgs = PostbackOptions & {
    readonly url: string
}

type DotvvmSpaNavigatingEventArgs = DotvvmNavigationEventArgs & {
    cancel: boolean
}

type DotvvmSpaNavigatedEventArgs = DotvvmNavigationEventArgs & {
    readonly response?: Response
}

type DotvvmSpaNavigationFailedEventArgs = DotvvmNavigationEventArgs & {
    readonly response?: Response
    readonly error?: DotvvmPostbackErrorLike
}

type DotvvmRedirectEventArgs = DotvvmNavigationEventArgs & {
    readonly response?: Response
    /** Whether the new url should replace the current url in the browsing history */
    readonly replace: boolean
}

type DotvvmPostbackHandlersStartedEventArgs = PostbackOptions & {
}

type DotvvmPostbackHandlersCompletedEventArgs = PostbackOptions & {
}

type DotvvmPostbackResponseReceivedEventArgs = PostbackOptions & {
    readonly response: Response
}

type DotvvmPostbackCommitInvokedEventArgs = PostbackOptions & {
    readonly response: Response
}

type DotvvmPostbackViewModelUpdatedEventArgs = PostbackOptions & {
    readonly response: Response
}

type DotvvmPostbackRejectedEventArgs = PostbackOptions & {
    readonly error: DotvvmPostbackErrorLike
}

type DotvvmStaticCommandMethodEventArgs = PostbackOptions & {
    readonly methodId: string
    readonly methodArgs: any[]
}

type DotvvmStaticCommandMethodInvokingEventArgs = DotvvmStaticCommandMethodEventArgs & {
}

type DotvvmStaticCommandMethodInvokedEventArgs = DotvvmStaticCommandMethodEventArgs & {
    readonly result: any
    readonly response?: Response
}

type DotvvmStaticCommandMethodFailedEventArgs = DotvvmStaticCommandMethodEventArgs & {
    readonly result?: any
    readonly response?: Response
    readonly error: DotvvmPostbackErrorLike
}

type DotvvmInitEventArgs = {
    readonly viewModel: any
}

type DotvvmInitCompletedEventArgs = {
}

interface DotvvmViewModelInfo {
    viewModel?: any
    viewModelCacheId?: string
    viewModelCache?: any
    renderedResources?: string[]
    url?: string
    virtualDirectory?: string
    typeMetadata: TypeMap
}

interface DotvvmViewModels {
    [name: string]: DotvvmViewModelInfo
    root: DotvvmViewModelInfo
}

interface DotvvmPostbackHandlerCollection {
    [name: string]: ((options: any) => DotvvmPostbackHandler);
}

type DotvvmStaticCommandResponse<T = any> = {
    result: any;
    customData: { [key: string]: any };
    typeMetadata?: TypeMap;
} | {
    action: "redirect",
    url: string,
    replace?: boolean,
    allowSpa?: boolean
};

type DotvvmPostBackHandlerConfiguration = {
    name: string;
    options: (context: KnockoutBindingContext) => any;
}

type ClientFriendlyPostbackHandlerConfiguration =
    | string // just a name
    | DotvvmPostbackHandler // the handler itself
    | DotvvmPostBackHandlerConfiguration // the verbose configuration
    | [string, object] // compressed configuration - [name, handler options]
    | [string, (context: KnockoutBindingContext, data: any) => any] // compressed configuration with binding support - [name, context => handler options]

type PropertyValidationRuleInfo = {
    ruleName: string;
    errorMessage: string;
    parameters: any[];
}

type ValidationRuleTable = {
    [type: string]: {
        [property: string]: [PropertyValidationRuleInfo]
    }
}

type StateUpdate<TViewModel> = (initial: DeepReadonly<TViewModel>) => DeepReadonly<TViewModel>
type UpdateDispatcher<TViewModel> = (update: StateUpdate<TViewModel>) => void

/** Knockout observable, including all child object and arrays */
type DeepKnockoutObservable<T> =
    T extends (infer R)[] ? DeepKnockoutObservableArray<R> :
    T extends object      ? KnockoutObservable<DeepKnockoutObservableObject<T>> :
                            KnockoutObservable<T>;
type DeepKnockoutObservableArray<T> = KnockoutObservableArray<DeepKnockoutObservable<T>>
type DeepKnockoutObservableObject<T> = {
    readonly [P in keyof T]: DeepKnockoutObservable<T[P]>;
}

/** Partial<T>, but including all child objects  */
type DeepPartial<T> =
    T extends object ? { [P in keyof T]?: DeepPartial<T[P]>; } :
    T;
/** Readonly<T>, but including all child objects and arrays  */
type DeepReadonly<T> =
    T extends TypeDefinition ? T :
    T extends (infer R)[] ? readonly DeepReadonly<R>[] :
    T extends object ? { readonly [P in keyof T]: DeepReadonly<T[P]>; } :
    T;

type DotvvmStateContainer<T> = {
    /** A property, returns latest state from dotvvm.state. It does not contain any knockout observable and does not have any propagation delay, as the value in the ko.observables */
    readonly state: DeepReadonly<T>
    /** Sets new state directly into the dotvvm.state.
     * Note that the value arrives into the ko.observables asynchronously, so there might be slight delay */
    readonly setState: (newState: DeepReadonly<T>) => void
    /** Patches the current state and sets it into dotvvm.state.
     * Compared to setState, when property does not exist in the patch parameter, the old value from state is used.
     * Note that the value arrives into the ko.observables asynchronously, so there might be slight delay
     * @example observable.patchState({ Prop2: 0 }) // Only must be specified, although Prop1 also exists and is required  */
    readonly patchState: (patch: DeepReadonly<DeepPartial<T>>) => void
    /** Dispatches update of the state.
     * Note that the value arrives into the ko.observables asynchronously, so there might be slight delay
     * @example observable.updateState(state => [ ...state, newElement ]) // This appends an element to an (observable) array
     * @example observable.updateState(state => state + 1) // Increments the value by one
     * @example observable.updateState(state => ({ ...state, MyProperty: state.MyProperty + 1 })) // Increments the property MyProperty by one
     */
    readonly updateState: UpdateDispatcher<T>
}

/** Knockout observable that is found in the DotVVM ViewModel - all nested objects and arrays are also observable + it has some helper functions (state, patchState, ...) */
type DotvvmObservable<T> =
    DeepKnockoutObservable<T> &
    {
        // deprecated
        /** @deprecated Use updateState instead */
        readonly updater: UpdateDispatcher<T>
    } &
    DotvvmStateContainer<T>

type RootViewModel = {
    $type: string
    $csrfToken?: string
    [name: string]: any
} 

type TypeMap = {
    [typeId: string]: TypeMetadata
}

type DynamicTypeMetadata = {
    debugName?: string,
    type: "dynamic"
}

type ObjectTypeMetadata = {
    type: "object",
    debugName?: string,
    properties: { [prop: string]: PropertyMetadata }
}

type EnumTypeMetadata = {
    type: "enum",
    debugName?: string,
    values: { [name: string]: number },
    isFlags?: boolean
}

type TypeMetadata = ObjectTypeMetadata | EnumTypeMetadata | DynamicTypeMetadata;

type PropertyMetadata = {
    type: TypeDefinition;
    post?: "always" | "pathOnly" | "no";
    update?: "always" | "no";
    validationRules?: PropertyValidationRuleInfo[];
    clientExtenders?: ClientExtenderInfo[]
}

type TypeDefinition = string |
{ readonly type: "nullable", readonly inner: TypeDefinition } |
{ readonly type: "dynamic" } |
    TypeDefinition[];

type ClientExtenderInfo = {
    name: string,
    parameter: any
}

type CoerceErrorType = {
    isError: true
    wasCoerced: false
    message: string
    path: string
    prependPathFragment(fragment: string): void
    value: never
}

type CoerceResult = CoerceErrorType | { value: any, wasCoerced?: boolean, isError?: false };

type DotvvmFileUploadCollection = {
    Files: KnockoutObservableArray<KnockoutObservable<DotvvmFileUploadData>>;
    Progress: KnockoutObservable<number>;
    Error: KnockoutObservable<string>;
    IsBusy: KnockoutObservable<boolean>;
}
type DotvvmFileUploadData = {
    FileId: KnockoutObservable<string>;
    FileName: KnockoutObservable<string>;
    FileSize: KnockoutObservable<DotvvmFileSize>;
    IsFileTypeAllowed: KnockoutObservable<boolean>;
    IsMaxSizeExceeded: KnockoutObservable<boolean>;
    IsAllowed: KnockoutObservable<boolean>;
}
type DotvvmFileSize = {
    Bytes: KnockoutObservable<number>;
    FormattedText: KnockoutObservable<string>;
}

type DotvvmJsComponent = {
    /** Called after each update of dotvvm.state which changes any of the bound properties. Only the changed properties are listed in the `updatedProps` argument. */
    updateProps(updatedProps: { [key: string]: any }): void
    /** Called after the HTMLElement is removed from DOM.
     * The component does not need to remove any child elements, but should clean any external data, such as subscription to dotvvm events */
    dispose?(): void
}
type DotvvmJsComponentFactory = {
    /** Initializes the component on the specified HTMLElement.
     * @param element The root HTMLElement of this component
     * @param props An object listing all constants and `value` bindings from the `dot:JsComponent` instance
     * @param commands An object listing all `command` and `staticCommand` bindings from the `dot:JsComponent` instance
     * @param templates An object listing all content properties of the `dot:JsComponent`. The template is identified using its HTML id attribute, it can be rendered using ko.renderTemplate, KnockoutTemplateReactComponent or KnockoutTemplateSvelteComponent
     * @param setProps A function which will attempt to write a value back into the bound property. Only certain `value` bindings can be updated, an exception is thown if it isn't possible
     * @returns An object which will be notified about subsequent changes to the bound properties and when the component
     */
    create(
        element: HTMLElement,
        props: { [key: string]: any },
        commands: { [key: string]: (args: any[]) => Promise<any> },
        templates: { [key: string]: string },
        setProps: (p: { [key: string]: any }) => void
    ): DotvvmJsComponent
}


type DotvvmViewModuleCommandName = `${'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z'}${string}`

type DotvvmViewModule = {
    $controls?: { [name:string]: DotvvmJsComponentFactory }
    $dispose?: (context: any) => void

    [commandName: DotvvmViewModuleCommandName]: (...args: any[]) => Promise<any> | any
}

type DotvvmModuleContext<TViewModelType = any> = {
    /** Name of the resource defining the view module */
    moduleName: string
    /** Instance of the view module */
    module: any
    /** List of element where this module is mounted. It will be `document.body` for pages and the wrapper tag for markup controls. Most likely, only one element is in the collection. */
    elements: HTMLElement[]
    /** Properties of the markup control which were sent to the client */
    properties: { [name: string]: DotvvmObservable<any> }
    /** <dot:NamedCommand /> declared in the dothtml/dotcontrol view. */
    namedCommands: { [name: string]: (...args: any[]) => Promise<any> }
} & DotvvmStateContainer<TViewModelType>
