using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using DotVVM.Framework.Binding;
using DotVVM.Framework.Hosting;
using DotVVM.Framework.Runtime;
using DotVVM.Framework.Utils;

namespace DotVVM.Framework.Controls
{
    /// <summary>
    /// Used in <see cref="ItemsControl" /> to wrap each data item and generate its unique ID.
    /// </summary>
    public class DataItemContainer : DotvvmControl
    {

        /// <summary>
        /// Initializes a new instance of the <see cref="DataItemContainer"/> class.
        /// </summary>
        public DataItemContainer()
        {
            SetValue(Internal.IsNamingContainerProperty, true);
            SetValue(ClientIDModeProperty, ClientIDMode.AutoGenerated);
        }

        // private DataItemContainer(bool uninitializedCreate)
        // {
        // }
        // static (int hashSeed, DotvvmProperty[] keys, int[] valueTable) keys = PropertyImmutableHashtable.CreateTableWithValues(new [] {
        //     DotvvmBindableObject.DataContextProperty,
        //     DotvvmControl.ClientIDModeProperty,
        //     Internal.DataContextTypeProperty,
        //     Internal.IsNamingContainerProperty,
        //     Internal.PathFragmentProperty,
        //     Internal.UniqueIDProperty,
        // }, new int[] { 1, 2, 3, 4 });
        // public void ResetProperties()
        // {
        // }


        /// <summary>
        /// Gets or sets the index of the data item in the data source control.
        /// </summary>
        int? index = null;
        public int? DataItemIndex
        {
            get
            {
                if (this.index is int) return this.index;

                var value = GetValue(Internal.UniqueIDProperty);
                return value is string id && int.TryParse(id, NumberStyles.Integer, CultureInfo.InvariantCulture, out var index) ? index : (int?)null;
            }
            set { this.index = value; SetValue(Internal.UniqueIDProperty, value?.ToString()); }
        }


        protected override void RenderControl(IHtmlWriter writer, IDotvvmRequestContext context)
        {
            var maybeIndex = DataItemIndex;
            if (maybeIndex is int index)
                writer.WriteKnockoutDataBindComment("dotvvm-SSR-item", index.ToString());

            base.RenderControl(writer, context);

            if (maybeIndex is int)
                writer.WriteKnockoutDataBindEndComment();
        }
    }
}
