---
sidebar_position: 0
slug: /
---

# Explore the OpenAI GPT-3.5 Models 

The goal of this 60-minute lab is to:
* Understand the implementation and capabilities of the GPT-3.5 family of models
* Learn how to use and customize natural language generative AI models using prompt engineering techniques
* Understand the basics of integrating OpenAI models into applications with the API

If you like, you can follow along with a live recording of this lab on YouTube: [Make Azure AI Real: Exploring Azure OpenAI Service](https://www.youtube.com/watch?v=9auAlK1l39Q).

## Pre-requisites

You will need either an Azure Account or an OpenAI account to complete this lab. 

If you do not have an Azure Account, you can create one [create one for free](https://azure.microsoft.com/free/) and receive credits to create and use the services you will use for this lab.

The instructions in this lab refer to the experience using Azure OpenAI Service. There are slight differences when using OpenAI services, which are dicussed in the next section.

## Sections

Once you have completed the Setup step, you can skip ahead to any of the other sections:

1. [Setup](07-Setup.md). Create and deploy the Azure OpenAI resource in the Azure Portal.
1. [OpenAI Setup](08-OpenAI-Setup.md). Alternatively, if you are using OpenAI, differences to be aware of for this lab.
2. [Explore Models](10-Explore-Models.md). Understand the OpenAI natural language models available.
3. [Completions](20-Completions.md). Understand and experiment with prompts and completions.
4. [Tokens](30-Tokens.md). Learn about tokens in OpenAI models.
5. [Applications](40-Applications.md). Learn about applications of natural language generative AI models.
6. [Conversations](50-Conversations.md). Use the Chat playground.
7. [Prompt Engineering](60-Prompt-Engineering.md). Learn how to use prompt engineering to customize the behavior of the model.
8. [Using the API](70-Using-the-API.md). Learn how to use integrate OpenAI models into applications via the API.
9. [Learnings and Resources](80-Learnings-and-Resources.md). Recap and links for further learning.
10. [Extra Credit](90-Extra-Credit.md). If you have time, explore the capabilities of Bing Chat.

## Feedback

We would love to hear your feedback on this lab. Please visit the [Github repository for this lab](https://github.com/revodavid/openai-prompt-engineering-lab) and use the Discussions tab for comments, or the Issues tab for bugs or suggestions.



  




  
