**[Click here to get started on this lab.](https://revodavid.github.io/openai-prompt-engineering-lab/)**

# Explore the OpenAI GPT-3.5 Models

This session is a 60-minute live demonstration of interaction with OpenAI models GPT-3.5 Instruct (gpt-35-turbo-instruct) and GPT-3.5 Turbo (gpt-3.5-turbo). You can follow along with the demonstration live using Use [Azure AI Studio](https://oai.azure.com/portal) or [OpenAI Playground](https://platform.openai.com/playground), or work through the examples in this repository later at your own pace and schedule.

The goal of this 60-minute session is to:
  * Understand the implementation and capabilities of the GPT-3.5 family of models
  * Learn how to use and customize natural language generative AI models using prompt engineering techniques
  * Understand the basics of integrating OpenAI models into applications with the API

## Pre-requisites

You will need an Azure Account or an OpenAI account to complete this lab. If you do not have an Azure Account, you can create one for free [here](https://azure.microsoft.com/en-us/free/), and request access to Azure OpenAI Service [here](https://aka.ms/oai/access).

## Get Started

Visit [the lab website](https://revodavid.github.io/openai-prompt-engineering-lab/) to get started.

Watch a video recording of this lab on YouTube: [Make Azure AI Real: Exploring Azure OpenAI Service](https://www.youtube.com/watch?v=9auAlK1l39Q).

## Overview

This workshop will cover the following topics:

1. Setup: Create and deploy the Azure OpenAI resource in the Azure Portal
1. Explore Models: Understand the natural language models availabe in OpenAI and Azure OpenAI Service.
1. Completions: Understand and experiment with prompts and completions.
1. Tokens: Learn about tokens in OpenAI models.
1. Applications: Learn about applications of natural language generative AI models.
1. Conversations: Using the Chat playground.
1. Prompt Engineering: Learn how to use prompt engineering to customize the behavior of the model.
1. Using the API: Learn how to generate integration code for use with the Azure OpenAI API.
1. Learnings and Resources: Recap and links for further learning.
1. Extra Credit: Explore the capabilities of Bing Chat.

## Citations and Credits

"Explore the OpenAI GPT-3.5 Models", David Smith (Microsoft), 2023. 
When referening this repository, please use the shortlink: https://aka.ms/exploring-gpt35

Presented at Make AI Real in a Day, October 26 2023. 

This repository was created by David Smith (Microsoft). Some content [contributed by](https://github.com/hnky/AzureOpenAIService-Workshop) Henk Boelman (Microsoft) and Amy Boyd (Microsoft). Docusaurus integration by Dave Glover (Microsoft).

## This lab is open source

This website is built using [Docusaurus 2](https://docusaurus.io/), a modern open-source static website generator.

You are free to copy, adapt and use this content according to the terms of the [MIT License](LICENSE). For information on how to configure a fork of this site for deployment, see [Building.md](Building.md).

## Feedback

We would love to hear your feedback on this lab. Please use the Discussions tab for comments, or the Issues tab for bugs or suggestions.

