---
title: A Comprehensive Guide to Self-Learning
author: Reid Doe
avatar: assets/img/common/reid-avatar.png
categories:
  - How-To
tags:
  - Creativity
  - Inspiration
  - Habits
---

One of the most effective methods to understanding the materials that you’re studying is to be passionate about them. This is the beauty of MOOCs — the idea that you can pick and choose to learn exactly and only what you want to.

Don’t jump into a new study without having a plan for it. Whenever you feel discouraged or frustrated, you can take a step back and look at the bigger picture.

There&#8217;s plenty of meaningful applications for learning new skills: to further your career, to find a new skill to freelance or moonlight with, or to contribute to a hobby or non-profit cause for the sake of goodness.

When you have a mindset of passion — of having a reason to learn and a future goal to look forward too — it is far easier to focus and digest material on a deeper level of understanding, beyond simply learning from rote.

**Schedule:** With so much choice and freedom, it can be easy to try to accomplish too many things at once, only to end up neglecting your studies altogether. This is why it’s so important to chart out a path for yourself once you figure out what you want to accomplish.

Ask yourself how much time you’re able to sacrifice and how much effort you’ll sincerely put into this. Once you have those answers, you’ll be able to plan your own curriculum of sorts.

<figure class="wp-caption">

<img data-width="1280" data-height="983" src="https://cdn-images-1.medium.com/max/2560/1*gWYKhWJzQ_lgsdWR3EV4uQ.jpeg" /> <figcaption class="wp-caption-text">Navajo Students Studying Mathematics at Day School | <a href="https://commons.wikimedia.org/wiki/File:Navajo_students_studying_mathematics_at_day_school_-_NARA_-_295155.jpg" target="_blank" rel="noopener noreferrer"><strong>Source</strong></a></figcaption></figure>

#### How to unlock the full potential of a new era of education.

For the past few years, the world of <a href="https://www.mooc-list.com/" target="_blank" rel="noopener noreferrer">MOOC</a> (Massively Open Online Courses) has become a fiercely large phenomenon. Across Medium and <a href="https://www.reddit.com/r/learnprogramming/comments/3zfbp1/heres_a_list_of_221_free_online_programmingcs/" target="_blank" rel="noopener noreferrer">Reddit</a> you can find great, comprehensive lists of free classes you can take:

<https://medium.freecodecamp.com/the-best-free-online-university-courses-for-learning-a-new-world-language-ccf42ad1b5d5>

<!--more-->

<span>T</span>his, however, is not one of those lists. With this new paradigm of learning, there comes the need to figuring out new methods of understanding and synthesising what is being learned. There is no curriculum, no consequences, no deadlines. This requires an exercise in self-reliance to institute. The student, in a way, must also learn how to become the teacher.

Creating lesson plan — let alone a learning path for yourself — is no simple task. And following through with it is another thing entirely. I am no expert myself, so take this rhetoric with a grain of salt. The examples I am going to be showing are only my own, as I’m using myself as a case study.

#### Use It or Lose It

This guide is meant as a way for you to take what you are learning and _apply_ it in a meaningful way. It is not learning for the mere sake of learning — anybody can do that. In fact, that’s what is required of us throughout our schooling years.

The reason we forget what we learn in school is because we don&#8217;t use it in our every day life. In fact, that&#8217;s one of the biggest complaints people have in school.

<figure class="wp-caption">

<img data-width="1070" data-height="570" src="https://cdn-images-1.medium.com/max/800/1*KfQQYIJcIxgSJp8XuL2xPA.png" /> <figcaption class="wp-caption-text">An Old Prototype of My Schedule</figcaption></figure>

### The Elements of a Successful Course

I’m going to break down what I think are the most important aspects when you’re learning something new on your own.

#### 1. The Lesson

The first step is the most important part, obviously. Whether you’re taking an online course, reading a book, or studying another way — you need the content to be able to learn it. However, it’s a mistake to think that this is enough. This is really just the beginning.

#### 2. Note Taking

The second step is to go beyond the course. Note-taking is the most often used method of retention and synthesis of learning. There are many different styles of note-taking — from traditional, to Cornell, to mind-mapping.

The exacts of successful note-taking vary from person-to-person, but I find it’s very useful to begin to index your note-taking with what you expect the themes of your learning are going to be for that lesson, followed by reviewing what the most important things you learned at the end.

There is nothing wrong with a pack-rat mentality of keeping track of everything that you’re learning, so long as it doesn’t detract from you fully comprehending what is most important.

I also suggest that you take notes by hand first — for a few years I tried to take notes on my computer, and found that even though it made organisation and searching a breeze, I felt as though I retained less. Once you have the notes written out, though, I find that _migrating_ them to the computer does help retention and organisation.

#### 3. Flashcards / Quizzes

The third step to better your learning is to then take your notes a step further by converting them into materials that you can test yourself with. This is why it’s so important to make sure you have the most important material kept, so you can easily create Q+A’s for it.

Some courses already have quizzes, which is excellent, but by creating your own, you’re coming up with questions as well as answers.

For flash cards, I recommend the software Anki, and <a href="https://alexvermeer.com/anki-essentials/" target="_blank" rel="noopener noreferrer">this guide</a> for it.

#### 4. Assignments / Projects

The fourth step is what I believe is the most important. Traditionally speaking, assignments are simply another part of the system. They are usually rather dry, and have no inherent value other than for the course itself.

But with MOOCs, you have the ability to push yourself to use the knowledge that you’ve gained to create your own projects that you can freely share and use. _Apply_ your learn and thus gain something outside of the learning as the reward.

A good example of this is that I’m in the process of making a blog with <a href="https://jekyllrb.com/" target="_blank" rel="noopener noreferrer">Jekyll</a>, which has the twofold benefits of learning web development, as well as having a place to document my other learning, which leads into #5.

#### 5. Share Your Work

Once you have finished a course, you have not only have you improved your own learning by creating all of the above resources, but you now also have the opportunity to share them with others.

Create a blog or use other social media to share what you’ve learned and what you’ve made in the process. Find others that you can collaborate and study with. Build a community of learners and creators. There is no reason to go at this alone.

See Also: <a href="http://austinkleon.com/show-your-work/" target="_blank" rel="noopener noreferrer">Show Your Work!</a>

### Additional Tips

- The best skills to learn first are ‘meta-skills’, such as <a href="https://www.coursera.org/learn/learning-how-to-learn" target="_blank" rel="noopener noreferrer">learning how to learn</a>, time management or other skills that you can use in your studying.
- Figure out a system and stick to it. Once you have a schedule made, find a way to link it to your created materials, as well as any other important information. (My personal recommendations would be <a href="https://www.onenote.com/" target="_blank" rel="noopener noreferrer">OneNote</a> for Windows, or using Sublime Text w/ Markdown for Linux.)
- When you’re writing about what you’ve learned, don’t be afraid to add your own personal story or information — conglomerate multiple sources of learning for a more thorough discourse.
