---
id: 221
title: "Getting Unstuck for Creatives"
date: 2020-10-30
author: Brennan K. Brown
layout: post
tags:
  - Creativity
  - Inspiration
  - Habits
author: Reid Doe
avatar: assets/img/common/reid-avatar.png
category: How-To
---

## Taking a novel approach to life and breaking routines.

Okay, let's be real. I've found myself totally trapped in the habitual daily acts that've sprung up thanks to COVID-19, and I'm sure that I'm not alone in that. The lack of travelling different places, meeting new people, having _any_ sort of stimuli apart from our dreaded screens can get _beyond_ boring and frustrating.

This isn't anything new, though. This feeling is the inevitable byproduct of repetitive work. Feeling stuck and on auto-pilot is triggered by repetitive work, and almost all of us, regardless of our occupation, engage in repetitive work.

Here are a few small ideas to break out of that monotony, at least for a little while, particularly for those with a hungry, creative mind.

<!--more-->

**1. Be mindful of input versus output.** Our general consumption is an important, often overlooked factor when talking about getting stuck. What kind of input are you currently engaged in? What are you feeding your creative monster?

Most of our days are spent in _output mode_, the business of making what we make. Whether it's spreadsheets or ad campaigns, we typically give much more than we typically take. Being so focused on what we output that we forget to fill our creative tank as well.

To combat this, engage in some form of inspirational or educational input like reading books, watching movies, or listening to music. Try thumbing through a magazine you've never heard of before, or attending a concert for a new band that you're unfamiliar with!

Choose topics that you're interested in, even if those topics aren't directly related to your daily work. Seek out what inspires you.

**2. Wander outside for awhile.** Author Roman Payne had this to say about people:

> “A person does not grow from the ground like a vine or a tree, one is not part of a plot of land. Mankind has legs so it can wander.”

You need to purposely wander and engage in new experiences, and then bring them back to your normal lives to burn when you need them. The mistake that we often make is believing that those experiences require considerable time and effort--but this isn't true.

If you leave small spaces in your daily calendar, you can have a plethora of new experiences waiting for you when you need them. It's completely safe to get away from your desk and experiencing something new with a short walk.

Keep a new experience journal, either on your smartphone or in a notebook. Separate the listings into four categories: break, lunch, day, and weekend. Start by documenting new experience you'd like to have if you had any of those four time increments available.

**3. Be mindful of patterns (or, your routines).** Your world has changed and it changes every day. Despite this, you consciously or subconsciously create routine in your life.

> What actions or behaviours do you repeatedly make?

Write down your daily, weekly, and monthly routines on a piece of paper. Once you've identified them, make a conscious effort to change one each day, each week, and each month.

You can simply engage in that change for a day and then return to your regularly scheduled program, but do so purposefully and then move on to a different routine.

In doing so, you're training yourself to be more alert and before long you'll start to see opportunities you may have otherwise missed.

**4. Play!** Very few people who are active participants in some aspect of play report problems with getting stuck. Having fun and playing games should be a natural part of your creative process and an integral part of your creative growth.

But few know how to make play work. One way is to use design thinking to create play. In short, try becoming a game maker.

In the context of a creative endeavour, game-making takes on a slightly more purposeful goal: turn everyday tasks into games. A game needs a goal and restrictions. The goal defines the end of the game and the restrictions define the rules and behaviours.

Take an everyday mundane task that you have to do: Set the goal and the _restrictions_ of that activity. The trick to turning everyday tasks into games is to either alter the goal or your limitations.

Try your hand at adding little milestone achievements, or recruit other players. In reality, the art of TK gamification can be applied to any task, and you'll start seeing your everyday routines in a new light.

**5. Busy Hands _aren't_ the Devil's Plaything.** Get handy. It may not seem logical, but studies have shown that the mind is more engaged in problem-solving activities when the hands are active.

Simply put, you think better when your hands are busy.

It seems counter-intuitive to engage in what seems like a distraction in order to attempt to deter distraction, but if you give your hands something to do while your mind is working, you're less likely to pour precious thought into doing something else.

Fill your workspace with hands-on materials to play with. Try bringing in markers, Play-Doh, Legos, pipe cleaners, rubber bands, paper clips, clothespins, and paper cups so there's always something for you to make or build. Don't worry about making something recognizable, just let whatever manifests happen.

> The act of creation happening with your hands is meant to mirror the act of creation happening in your brain.

Doodling is another form of this hand-mind connection. The misconception about doodling is that it's mindless, but in fact, doodling is the result of a very active mind. When you doodle, you give your brain something to process, so it allows you to simultaneously process other ideas because your hands are doing most of the heavy lifting. So try amplifying your doodling.

Leave pads of blank paper nearby and doodle while you generate ideas or talk on the phone. Keeping your hands busy frees the mind to find creative solutions to problems.

### Conclusion

Sure, for the most part we're all stuck inside and don't have a lot of flexibility with our setting or time, but there's always something new to do if you look hard enough.

Take in more inspiration, mindfully wander outside, carefully analyze the routines you have set in place, turn the tasks that you do into games, and don't be afraid to create more just for the sake of it!
