---
title: 6 Ways to Achieve New Things
date: 2020-10-29
author: Brennan K. Brown
layout: post
tags:
  - Goals
  - Habits
  - Inspiration
author: Tilo Smith
avatar: assets/img/common/tilo-avatar.png
---

> Getting back on your horse, no matter how many times you’ve fallen off.

### Project Journal Bar

In <a target="_blank" rel="noreferrer noopener" href="https://medium.com/@brennanbrown/goal-failure-bc3a39a0f418">my last post</a>, I talked about the struggles and failures I’ve faced the past few years. I’ve been thinking about how to tackle my short-comings and problems to solve a single, relatively-simple issue that’s plagued me nearly my entire life: consistency in my work ethic.

There needs to be more hand-holding involved — change does not come quickly nor simply. So I’ve devised an entirely new project for myself: <a href="https://journal.bar/" target="_blank" rel="noreferrer noopener"><strong>Journal Bar</strong></a>. This is a new blog that I’ve made where I’m going to be posting about the progress I’ve been making weekly. The (very simple) ingenious part is that I’m <a href="https://www.beeminder.com/brennanbrown/journalbar" target="_blank" rel="noreferrer noopener">tracking the posts</a> I write.

So, this is a sort of _meta-accountability_ experiment. Having a goal that’s in charge of making sure I keep on-track with all of my other goals. The idea behind this is so simple that I’m kicking myself for not thinking about it sooner.

This idea and the progress I’ve made is very new, but I feel as though I’m going slowly enough to ensure that I don’t fizzle out quickly and lose interest or energy for it. In addition to keeping track of my progress, I’ve also elected to use the blog as a space to write rough ideas that I’ll want to implement into articles later.

Going through the whole Beeminder process again opened my eyes to a few things that I believe will be helpful regarding perseverance with long-term results:

<!--more-->

## <b>1. Be Anti-Circle</b>

It’s said that the definition of insanity is doing the same thing over and over again, but expecting different results. I was sifting through old text files on Dropbox, some all the way back from 2015 when I was back in high school, and I embarrassingly realized that there were certain goals there that I _still_ had been writing down for 2020.

There are times where you need be ruthless and cut-throat with your dreams. There are certain large-scale ambitions that require so much time and energy that you won’t be able to balance them with other things, and they’ll be put on the backburner — over and over again. No matter how many times you tell yourself (or others) that you’re going to start working on it soon, you never really get past the beginning stage.

Instead, look at what you _are_ capable of, right now, with the abilities you have. Keep going with it, build upon what works. Make sure your to-do list isn’t the same thing everyday, make sure your New Year’s resolutions aren’t the same every year. If it’s not working, do something different, don’t run around in circles.

## 2. Eliminate Redundancy

The paradox of choice that we have regarding how exactly we keep track of ourselves and our goals can be crippling. There are certain notes I have on Dropbox, or on Google Drive, or just on my iPhone, or locally on my laptop.

This problem isn’t eliminated if you switch to an analogue system either — you can have ideas and lists scattered between different planners, pocket notebooks, bullet journals, etc.

It’s easy to get caught up in using different software (particularly if it’s mandated by school or work) and not notice that you’re slowly creating a schism in your workflow.

Again, be ruthless and cut-throat, eliminate apps and notebooks that you don’t _really_ need to be using. Boil everything down to the bare essential, just one place that might not be perfect, but at least contains everything so you aren’t repeating yourself or losing track.

## 3. Maintain Product Agnosticism

It’s easy to argue that one particular brand or program is superior in some fashion, but in the lightspeed world of venture capitalism, these companies and start-ups can <a href="https://ourincrediblejourney.tumblr.com/" target="_blank" rel="noreferrer noopener">disappear in an instance</a>.

Don’t allow yourself to get too comfortable using one particular thing. In fact, you should ideally using so5. Microreminders for Microgoalsmething that’s c<a href="https://alternativeto.net/" target="_blank" rel="noreferrer noopener">ompletely free, doesn’t require internet access, and is stable</a>. If something were to happen to the exclusive product you’re using, it might take a toll on your morale, or even worse, you could lose data.

At the very least, have a simple, fail-safe system that you _archive everything_ on. Whether it be a VCS repository, a USB drive, or a secondary laptop with a text editor.

## <b>4. Stack the Goodness</b>

A simple solution to adding multiple new habits or daily tasks into your life is to build them upon things you already are doing very well and effortlessly. Such as taking the time you brush your teeth at night to think of everything you’re grateful for that’s happened during the day.

A particularly good example with the current automated systems I have going is this: I track online courses I take (1) and upload the notes I write to a GitHub repository where I track my commits (2), and all of this is tracked as productive time on RescueTime (3). In a way, I’m keeping up three different good habits with a single action — self-directed learning.

## 5. Prioritize Passion over Tradition

One bad habit I realize I have is that, whenever I feel motivated to try to start working towards a positive progress again, I often do a Google search for “good goals to keep” or “good habits to have”, and I’ve started to realize this does more harm than good.

You shouldn’t try to accomplish something simply because it’s well-known to be a good thing to accomplish — like running a marathon. It will fail due to the lack of motivation behind it. It’s always far better to have a weird, unconventional goal that you find a genuine passion for deep down within. It doesn’t matter what other people think about this, it never has.

## 6. Microreminders for Microgoals

My last suggestion is that the less time and energy something takes to do, then the less time and energy it should take for you to maintain it. It takes a lot of willpower and preparation to start something serious, like exercising three days a week — where you might need to have a community of support and journal weekly to remind yourself why it’s important to keep up.

On the flip side, it’s a lot easier to do something like start flossing after brushing your teeth, and there should be a smaller and less-intrusive reminder to yourself to do that so it doesn’t feel like an overwhelming chore. Tasks in general are usually far less daunting than what we imagine they are, especially the longer with _think_ about doing it than actually doing it.
