---
title: Creating a Contingency Plan
date: 2020-10-28
author: Brennan K. Brown
layout: post
tags:
  - Planning
  - Productivity
  - Writing
author: Yui Doe
avatar: assets/img/common/yui-avatar.png
category: Guides
---

### <b>Failure is Important</b>

Last month, I had the idea to write an article each day for the month. How long did that last? Only five days. No matter how you look at it, that is failure. And it’s not just about the fact I didn’t manage to beat the challenge, it’s more about the principle of the matter. The fact that I failed to keep a promise to myself and others. Why did I let this happen? I think more broadly, it needs to be asked: Why do people do this — so often — in general?

Before I get into that, though, let’s take a look at the bright side of the situation. I managed to write two longform articles that I’m proud of:

<https://writingcooperative.com/my-writing-process-4868f986f97f>

The only reason those posts got written was because, for the first time, I had to churn things out. Challenging myself to write each day for a month made me think long-term and plan out a schedule. It made me think of different topics to explore and ideas to experiment with. In the past, I’ve truthfully just written when inspiration struck.

Not only that, but I joined the <a href="https://medium.com/creators" target="_blank" rel="noopener noreferrer">Medium Partner Program</a> last month as well, which means that I got paid for these stories. It’s the first time I’ve ever been paid for my writing. And seeing that was a wake-up call for me. I was shown that if I put effort into my work and plan things out, then I could make serious side-hustle out of Medium.

<figure class="wp-caption">

<img data-width="3000" data-height="2400" src="https://cdn-images-1.medium.com/max/2560/1*UKfnx1Hgk5RH8DdJoizv7A.jpeg" /> <figcaption class="wp-caption-text"><b>Interior View of Drafting Room in ERB</b> | <a href="https://commons.wikimedia.org/wiki/File:Interior_View_of_Drafting_Room_in_ERB_-_GPN-2000-001447.jpg" target="_blank" rel="noopener noreferrer">Source</a></figcaption></figure>

<figure>

<img data-width="4000" data-height="250" src="https://cdn-images-1.medium.com/max/800/1*75f3FyFy5_WnAC4joYEXJQ.png" />  
</figure>

#### Focusing on only the important stuff is the most valuable thing you can do for yourself.

<b>_Summary:_</b> _This article details why failure is a powerful tool for reflection, and necessary part of life. It then goes on to outline a powerful method to plan for future success by cutting out anything that isn’t essential to your own values._

<!--more-->

<figure>

<img data-width="1291" data-height="479" src="https://cdn-images-1.medium.com/max/800/1*MU3-ZkfLrUMy6BoG7vhnZA.png" />  
</figure>

<b>That’s why failure is so vital</b> — it means that you’re going in the right direction. Having a challenge creates a sense of urgency — a fire underneath your ass that pushes you to actually get things done. If you’re constantly comfortable in life, then you aren’t pushing yourself. You’re a plateau on the verge of decline. A lot of intelligent people would say that failure is a needed stepping stone on the path towards success — but I would disagree. They’re more like positive and negative currents of energy — both being equally needed and powerful.

I have had a lot of failures in life. I’ve made a lot of mistakes that I regret. But all of those actions and consequences have lead me exactly where I am today — with my words in front of your eyes. That’s a powerful thing.

That’s why I realize I need to try harder. I need to take larger risks and allow myself to be more open and vulnerable. I need to look beyond the day-to-day regime that I have in place. Getting serious not only means potentially profound failure — it also means finding and creating deeper and more meaningful purpose. With this article, I’m taking a step back to just sit and think. To adjust what I’m doing and revise who I am — and with the new year just around the corner, I think there’s no better time.

<figure>

<img data-width="1400" data-height="62" src="https://cdn-images-1.medium.com/max/800/1*A1HXExeRru-asgR6_gN4Sw.png" />  
</figure>

### <b>Creating a Focal Point</b>

Back to the question I had on-hand: <b>Why do people fail to keep promises they make to themselves?</b> Sure, I made a compelling argument to the importance of failing at times, but success _is_ endgame. Human psychology is a murky field still in its infancy, and there are a multitude of reasons why people say one thing then do another. We all have obligations and responsibilities — things that take our time and effort away from what we set out to do idealistically. As a self-improvement junkie, I’ve come across a lot of different answers to this question, and subsequent solutions. In this article, I’d like to contribute my own solution — write yourself a contingency plan.

What is a contingency plan? It’s defined as: _A plan designed to take a possible future event or circumstance into account_. As in, planning for the worst-case scenarios which, according to Murphy’s Law, _are_ going to happen. Nobody else is going to help you figuring out a way to stay standing when everything else begins to fall apart. There’s no inherent manual for sticking to your goals when your willpower begins to fade.

<figure>

<img data-width="2400" data-height="1514" src="https://cdn-images-1.medium.com/max/600/1*GO5EtoAdbj4MMIoP7D76Lw.png" />  
</figure>

After reading a lot of literature on the subject, I’ve boiled down what would make a good personal contingency plan into a single sentence: <b>Create a focal point for yourself.</b> What does that mean? It means:   
<b>1)</b> Figure out your values.   
<b>2)** Make them your first priority. **3)</b> Cut the rest of the bullshit out of your life.   
The human mind is an amazingly capable machine, but with so much stimuli, it is spread far too thin. If you were to write out a list of each unique thing you did today — let alone today–you would have dozens of different tasks that require both willpower and brain-power.

We all have more choices and information in front of us than ever before in human history. It’s far too easy to use the technology and potential knowledge available to us in an unhealthy and unproductive way. There’s an emerging trend of _digital detox_, the act of cutting out social media and the internet as a whole from your life. I believe there is merit to this. We all could value from taking some time to sincerely just _sit and think._ To hear your own voice instead of being bombarded with the thousands of the online.

#### Finding Your Values

From our own voice, we can hear our own values. What we truly deem as important — not to others — but to just ourselves. How do you do this in practice? Here’s what I suggest:

1. <b>Clear Your Desk.</b> Place things elsewhere for a period of time in order to have an empty, workable table.

2. <b>Airplane Mode.</b> All devices — even better if they’re put in another room.

3. <b>Start a timer for 30 min.</b> Even longer, if you think you’re capable.

4. <b>Sit and Think.</b> Trap yourself with just a pen and paper.

This is a similar process to free-writing as a <a href="https://betterhumans.coach.me/better-than-meditation-12532d29f6cd" target="_blank" rel="noopener noreferrer">meditation</a>, or a <a href="https://betterhumans.coach.me/better-than-meditation-12532d29f6cd" target="_blank" rel="noopener noreferrer">mind dump</a>, which I think is an additional important activity to do from time to time. However, this isn’t about figuring out what needs to be done in the next week or month. It’s deeper than that.

It’s about writing your <b>mission statement — </b>which I’ll cover in more depth in an upcoming post. <a href="https://jamesclear.com/buffett-focus" target="_blank" rel="noopener noreferrer">Warren Buffet has an infamous exercise</a>, listing the twenty-five things you want to do in life — then cross off everything except the top five. This is what I mean by your focal point — figuring out what you truly want to do — and then figuring out how to do start doing it while cutting out everything else without mercy. Every field of dreams needs a lawnmower.

In order to create ambitious goals and succeed at them, you need to think beyond 2018. It’s about the next five years — it’s about the rest of your life. Having a purpose — a deep-rooted <b>_why_</b>\_ — _connected to the actions you take daily makes it more difficult for you to give up and easier for you to follow-through. It also makes it easier to start again after a failure. This is how to keep the promises that you make to yourself.

<figure>

<img data-width="1400" data-height="62" src="https://cdn-images-1.medium.com/max/800/1*A1HXExeRru-asgR6_gN4Sw.png" />  
</figure>

### <b>My Contingency Plan</b>

As per usual, I enjoy displaying how I personally use the information that I find myself writing about for others. Unlike a lot of other how-to columnists out there, I don’t try to compartmentalize my life from the advice I share. If you are to eat your own dog-food, or in other words, actually set out on the actionable and difficult tasks you preach, then there is a far greater depth to the authenticity that is displayed. With all that being said, here’s what I have devised for my own contingency plan:

1. <b>Do Good Research.</b> Before anything else, I need to learn and educate myself on important and complex topics. I believe this is important for both making better sense of the chaotic world I live in, as well as synthesizing a broad range of material into my own work, like this article. The most important thing to learn is _how to learn well,_ which again, I’ll be covering in a later post.

2. <b>Create Value for Others.</b> There is an overwhelming amount of content being created constantly — most of it being taken for granted by the masses. In order to wade through all the noise, there are those that try to market themselves strategically. While there’s nothing wrong with that, no amount of good marketing can replace going through the effort of creating original and valuable work for people. More than that, though, I’m focused on keeping _value above the fold._ In other words, have the most important information at the beginning, instead of hiding it away and only giving it away in exchange for personal information, such as an e-mail address.

3. <b>Stick to a Single Task.</b> Due to the overwhelming amount of content being created constantly, it’s easier than ever to never truly focus on a single thing for a long stretch of time. And by _truly_ focus, I mean not stopping every ten minutes to check something else. Putting your nose to the grindstone means absolutely everything else is put on the back-burner, at least for an hour.

4. <b>Reach Out.</b> A lot of people view writing as a solitary craft — and it is. But even then, community is everything. The entire idea of Medium is to have an established community of talented people that create good work that deserves discussion and feedback. Having others hold you accountable is far more powerful than trying to hold yourself accountable.

5. <b>Cut the Bullshit.</b> If I come across something that doesn’t fit in the above four actions, I won’t bother with it. <a href="https://medium.com/@brennanbrown/our-finite-everything-8ed4d9d70a2f" target="_blank" rel="noopener noreferrer">Days are too short to let time be wasted.</a> Attention is too limited and finite to allow for meaningless distractions. The human body is too complex and incredible to allow unhealthy foods or lack of physical activity to occur. Each moment, I need to be mindful of what I’m doing, and if I’m pushing myself towards my goals or pulling myself further away from them.
<figure>

<img data-width="1400" data-height="62" src="https://cdn-images-1.medium.com/max/800/1*A1HXExeRru-asgR6_gN4Sw.png" />  
</figure>

#### SUMMARY:

1. <b>Embrace Failure.</b> Recognize the importance of the path that mistakes and regrets have put you on, and the lessons you’ve been taught. More importantly, allow yourself to be vulnerable enough to walk into challenges where failure is bound to happen.

2. <b>Have a Plan.</b> Take a step back from the busywork of the daily schedule and truly think about what you would enjoy doing in the long-term, and figure out how to achieve that. Going a step further, figure out the obstacles in your way and determine how to achieve what you want even amidst a worst-case scenario. This is a personal contingency plan done right.

<b>_Credit:_</b> _Hand-drawn Text Ornaments are_ <a href="https://www.freepik.com/index.php?goto=74&idfoto=1256497" target="_blank" rel="noopener noreferrer"><em>Designs by Freepik</em></a>

<figure class="wp-caption">

<img data-width="2400" data-height="1800" src="https://cdn-images-1.medium.com/max/800/1*pRon9UAtEO-JzTY-7mg1jA.png" /><figcaption class="wp-caption-text"><b>Thanks for Reading!</b></figcaption></figure>

<figure class="wp-caption">

<a href="https://writingcooperative.com/" target="_blank" rel="noopener noreferrer"><img data-width="1099" data-height="139" src="https://cdn-images-1.medium.com/max/800/1*eLY7z6NuxjwFyI1T-dwXcQ.png" /></a><figcaption class="wp-caption-text">Helping each other write better.</figcaption></figure>
