---
title: My Writing Process
date: 2020-10-27
author: Brennan K. Brown
layout: post
tags:
  - Productivity
  - Planning
  - Writing
category: Guides
---

## Five Steps to Go From Brainstorming to Completed Work

<span>L</span>et’s get down to the bare bones to start with: Prepare yourself and focus. Brainstorm and allow yourself to have bad ideas. Outline a thesis. Draft and edit. Cut the non-essential. Now, let’s expand on these ideas…

Today is the third day of November. For some of the day, I’ve been trying to craft a new article to publish. For the large majority though, I’ve just been trying to find new and creative ways to procrastinate!

The first day I wrote about how I’m rebelling against NaNoWriMo this year. <a href="https://medium.com/@brennanbrown/why-i-write-e425cdda0e10" target="_blank" rel="noopener noreferrer">Yesterday</a>, I wrote about _why_ I write — a bit of the philosophical and bigger-picture sort of thinking.

Today, I thought I might as well keep on the same topic and talk about the _how_ I write. To detail how exactly to go from a simple and disorderly idea to a completed and coherent article.

There are many steps to this process — from brainstorms to an outline, from drafting to revisions, until you have something publishable.

<figure class="wp-caption">

<img data-width="3000" data-height="2250" src="https://cdn-images-1.medium.com/max/2560/1*xdeHxfY_NPhNrbAi6OunKw.jpeg" /> <figcaption class="wp-caption-text"><b>Antique Blank</b> | <a href="https://www.pexels.com/photo/antique-blank-camera-classic-269810/" target="_blank" rel="noopener noreferrer">Source</a></figcaption></figure>

## An Aside: GOOD WRITING?

> “All good writing is swimming under water and holding your breath.”   
> — F. Scott Fitzgerald

Writing is a mysterious and elusive artform. Whether it’s technical, creative, or copy — good writing contains something that cannot be taught. A balance needs to be struck between the formless idea and the formulaic structure.

The idea — the actual content — needs to be exciting and novel. But if the presentation — the display and perception of that content — isn’t also good, then the idea will largely be lost. Yet, if the idea is lacking, then no amount of amazing presentation can salvage it.

### 1. PREPARATION: Focus

> “A winning effort begins with preparation.”   
> — Joe Gibbs

<span>D</span>istraction is the worst offender for writing that’s never completed — and often times writing that isn’t even started. Identify and eliminate potential distractions before you begin. Ensure you don’t allow yourself to procrastinate by dealing with them when they arrive.

<b>Be relaxed.</b> Don’t plunge into writing if you’re stressed about a million other things. If you really want to churn out two-thousand words in a single sitting, it has to be your number one priority. Stress also negatively impacts your physical and mental health, which are vital as well. So <a href="https://familydoctor.org/hydration-why-its-so-important/" target="_blank" rel="noopener noreferrer">stay hydrated</a> — have a water bottle handy while you write.

<b>Take a look at your surroundings</b> — create a private workspace. Have music that you enjoy but won’t distract you. I personally love certain background noise, <a href="https://www.noisli.com/" target="_blank" rel="noopener noreferrer">Noisli</a> has a ton of different options. Nearby plants are also always a bonus, and <a href="https://www.theguardian.com/money/2014/aug/31/plants-offices-workers-productive-minimalist-employees" target="_blank" rel="noopener noreferrer">studies have shown</a> they increase happiness and productivity!

<b>Communicate your availability to others</b> before you get into the <a href="https://blog.evernote.com/blog/2017/02/23/deep-work-matters-distracted-world/" target="_blank" rel="noopener noreferrer">deep work of writing</a>. Have a do-not-disturb sign, send out an e-mail or mark on your calendar that you’ll be unavailable.

<b>Unplug and disconnect.</b> The research phase of writing is the only time you should be using the Internet. Use an offline word processor, or write by hand. Keep things more traditional — for linguistics, have a dictionary and thesaurus on hand.

### 2. BRAINSTORM: Bad Ideas > No Ideas.

> “The way to get good ideas is to get lots of ideas and throw the bad ones away.”  
> — Linus Pauling

<b>Go on an idea sprint.</b> If a good idea is key to good writing, how do you obtain good ideas? Perseverance. Set up a specific time each day and set a timer, force yourself to come up with a dozen unique ideas. Some are going to be bad. Most are going to be bad. But a bad idea is far better than no idea at all. You can still work with a bad idea. You can still write about a bad idea.

<b>Find novel stimuli for yourself.</b> Brainstorming is a mental muscle. No great writer waited for a mystic surge of inspiration before beginning. There needs to be an active search for it. Write in different places and environments. Write about topics you’ve never written about before.

<b>Seek inspiration elsewhere.</b> Look at what other people are blogging about. Don’t be afraid to use their work as inspiration — they’ll take it as a compliment. I came up with the idea of one of my <a href="https://medium.com/@brennanbrown/zen-of-housekeeping-cfd37efb744d" target="_blank" rel="noopener noreferrer">favorite articles</a> from reading someone else’s. Use <a href="https://www.thesitsgirls.com/writing-prompts/" target="_blank" rel="noopener noreferrer">prompts and 30-day challenges</a>. The main point is to just get the ball rolling — a good idea is far more likely to appear if the <a href="https://medium.com/@brennanbrown/the-best-time-to-start-a-new-year-s-resolution-is-right-now-ffdd389fbf01" target="_blank" rel="noopener noreferrer">canvas isn’t blank</a>.

### 3. OUTLINE: Craft a Thesis

> “Give me six hours to chop down a tree and I will spend the first four sharpening the axe.”   
> ―Abraham Lincoln

<b>Outline first.</b> Once you’re satisfied with the idea you’re going to be working with, it might be tempting to plunge right into writing by the seat of your pants. However, this will only create more work in the future. Having an outline written will save you time.You won’t be constantly second-guessing yourself — and more importantly, losing focus on the topic at-hand.

<b>Craft the main thesis.</b> Make it abundantly clear to the readers what that thesis is. Then, start carving out different sections, which can then be broken down further into paragraphs. Determine your supporting content — what will help you get your main point across.

<b>Set goals.</b> Take a moment to decide who your ideal audience is. What are they gaining by your writing? The key to goal-setting in writing is relevancy — how will what you create be relevant to others? Take note of what feelings you think your work should invoke.

### 4. DRAFTING & EDITING

> “An architect’s most useful tools are an eraser at the drafting board, and a wrecking bar at the site.”   
> — Frank Lloyd Wright

<b>Write inside-out.</b> Don’t try to write the introduction first, it’s always the hardest part. Instead, go through your outline and pick the section you’d think would be easiest to write, and keep going from there.

<b>Write in sprints</b> — set a timer and don’t stop writing until it ends. Don’t sweat about grammar, spelling, or word-choice. Try to write about one concept per sprint.

<b>Try out different headlines.</b> Your work should drive the headlines you use, not the other way around. They shouldn’t hold up the rest of the writing, either. They don’t have to be perfect, and you might want to change them after publishing. Avoid trying to linger titles in mystery or fear-mongering — people have options, not time. Any headline you use should be able to stand on its own, though, in case it gets pulled to another website.

<b>Make what you’re writing clear </b>— clean up the mud and muck. Group ideas logically. Don’t use two words when one will do — there’s no reason to bloat your work for the word count. Use the active voice as much as possible, and subsequently avoid using the passive voice. Avoid clichés and any other boring or overused language.

<b>The reader is not an algorithm.</b> Don’t try to game the system with writing that exploits search-engine optimization or any other such nonsense.

<b>Organize and edit first</b>, then proofread. A good proofreading trick is to read the entire thing out-loud. A good spell-checking trick is to read the entire thing backwards.

<b>Edit, edit, edit.</b> When editing, don’t try to attempt to do an entire rewrite, instead, do a high-level editorial. Improve without restructuring.

<b>Be mindful of the ending.</b> The conclusion should invite an interaction with the reader. The internet empowers an open and free line of communication between the reader and the writer. Or, point them to other helpful resources.

<b>Review a few more times</b>, just in case. Asking peers for their feedback is always a great idea as well. Then, utilize grammar tools. I personally enjoy using the <a href="https://www.hemingwayapp.com/" target="_blank" rel="noopener noreferrer">Hemingway</a> application, but take its suggestions with a grain of salt. Applications and spell-checkers never catch 100% of errors made, anyways.

### 5. CHOPPING: Be Ruthless

> “Less is more.”   
> — Ludwig Mies van der Rohe

<b>The Internet is chock-full of information.</b> It is also already full of people that want their voices to be heard, and their content to be seen. There has never been such a greater amount of salesmen as there are right now in front of your screen. Everybody is trying to sell something — we live in capitalistic society, after all.

<b>Five-second rule.</b> It takes roughly 2-to-6 seconds to convince a person to stay once they’ve started reading. That’s it. Have something incredible within that incredibly short window of time. Put the most important and interesting information first. Remove long introductions, word-heavy descriptions, and any other <a href="https://thewritepractice.com/purple-prose/" target="_blank" rel="noopener noreferrer">purple prose</a>.

<b>Craft the first paragraph carefully.</b> Because people decide if they’re going to read something so quickly, the first paragraph is the most important one. The reader needs to be drawn in. Ask a question, and then answer somewhere else in the post. Be fearless of the controversial, and state something bold. Note an interesting fact or statistic (with proper reference, of course).

<b>Make work scannable, too.</b> Most people don’t begin reading until they’ve skimmed or scrolled. Use plenty of headings, and bullet-point lists.

<b>Whitespace is your best friend.</b> Too much text strains the eye. Watch out for wordy sentences, or lengthy paragraphs, or too many paragraphs without some sort of break.

<b>Be clear and concise.</b> Functional and pragmatic. Distill your message into the smallest amount of words possible. Short is memorable. If it’s easy to digest, it’s easy to share.

<b>Be ruthless.</b> After your first draft is complete, take a pause. Then, return and cut the word count in half.
