---
title: Disrupting the Attention-based Economy
date: 2020-10-26
author: Brennan K. Brown
layout: post
tags:
  - Productivity
  - Habits
category: Essays
---

When you wake up in the morning and get out of bed — or even before you get out of bed — what’s the first thing that grabs your attention? Whatever it is, it’s going to be responsible for your first thoughts of the day. Throughout the rest of your day, you’ll be faced with a bombardment of distractions that will grab your awareness away from what you’re doing.

We live in an <a href="https://techcrunch.com/2017/07/30/the-attention-economy-created-by-silicon-valley-is-bankrupting-us/" target="_blank" rel="noopener noreferrer"><strong>attention-based economy</strong></a>. Companies and people can only sell you products and services if they first have your attention, after all. This is nothing new, but with the rise of clever marketing statics (ex. Data-collection, branded content, personalized advertisements, etc.) most people are often being sold things without even realizing it.

<figure class="wp-caption">

<img data-width="1024" data-height="768" src="https://cdn-images-1.medium.com/max/2560/1*wm509xrohy46UG3caEwsWQ.png" /> <figcaption class="wp-caption-text"><b>New Office</b> | <a href="https://www.flickr.com/photos/philliecasablanca/3344142642" target="_blank" rel="noopener noreferrer">Source</a></figcaption></figure>

<figure>

<img data-width="4000" data-height="250" src="https://cdn-images-1.medium.com/max/800/1*75f3FyFy5_WnAC4joYEXJQ.png" />  
</figure>

## Stop being easily swayed by anything that’s in front of you. Start living a value-based lifestyle.

<figure>

<img data-width="1400" data-height="62" src="https://cdn-images-1.medium.com/max/800/1*A1HXExeRru-asgR6_gN4Sw.png" />  
</figure>

By way of technology, there have been <a href="https://www.privacytools.io/" target="_blank" rel="noopener noreferrer">privacy tools and blockers</a> created as a way to negate these tactics. However, this is a band-aid solution to a deeper, fundamental problem of society.

This goes beyond the exploits of current revenue models. People easily get caught up paying attention to things that just drain them of their energy. Time and energy wasted on toxicity — reaction instead of action. It is easy to blame advancements in technology and platforms for this, but the uncomfortable truth is that it is a human problem.

There is little we are able to control in life. We cannot control the behavior or actions of others — and we cannot control what’s going to be in today’s news — but we can control ourselves.

If attention is the currency of our modern economy, then our pockets are full at the start of each day. Absolutely nobody can dictate what you spend your time thinking about — no matter how hard they try. Bringing power back to the consumer, then, is simple. The solution is to stop consuming.

This is, of course, far easier said than done. There is a heavy weight of responsibility on our collective shoulders — but it is not an impossible burden to lift. The ability to overhaul this system will come from forming a meritocratic community. To begin our dialogue and actions on the basis of a value-based philosophy instead of an attention-based one.

What does this mean, exactly? Start with the fundamentals — what do you value in life? <a href="https://www.success.com/article/how-to-write-your-personal-mission-statement" target="_blank" rel="noopener noreferrer">What is your self-imposed purpose?</a> These are not easy questions to answer, but again, they’re not impossible. Often times, exactly because of the everyday distractions and white noise that nags at us, we find ourselves too busy to stop and think about these kinds of questions.

Contrary to what you might think, things become far simpler when you truly know what you want out of life and yourself. When you raise your expectations and cut out everything that isn’t actually necessary for you to be happy.

Forge an identity for yourself out of your passion and who you want to become. Use your attention for good — learn new things, create something, help your community, spend time relaxing by doing things you truly love to do instead of mindlessly scrolling through the Internet for a lukewarm buzz.

<figure>

<img data-width="1200" data-height="600" src="https://cdn-images-1.medium.com/max/1200/1*0rrraKR-9n9PmtrtsDemYg.png" />  
</figure>

There is beauty in getting used to the uncomfortable. People <a href="https://www.theguardian.com/media/2017/feb/02/amusing-ourselves-to-death-neil-postman-trump-orwell-huxley" target="_blank" rel="noopener noreferrer">constantly search out entertainment</a> simply because we’ve become so unused to <a href="https://www.npr.org/sections/alltechconsidered/2015/01/12/376717870/bored-and-brilliant-a-challenge-to-disconnect-from-your-phone" target="_blank" rel="noopener noreferrer">boredom and being bored</a>. The modern mind is restless and uneasy — always looking for a distraction — and this is explicitly why the attention-based economy has been able to do so well.

In all honesty, this approach to life is far more difficult. The human brain is designed to sleepwalk into habits and routines and to tread the path of least resistance. Mindfulness needs to be developed, as well as gratitude — we’re conditioned to think we don’t have enough and need to seek out more — even though we most often <a href="https://markmanson.net/everything-you-need" target="_blank" rel="noopener noreferrer">already have everything that we need</a>.

With the sheer pace of advancement in technology and the changing tides of the world at large, nothing comes close to being predictable anymore. It’s honestly a scary thought to think of the path we’re headed down if people continue to allow themselves to be easily swayed and dependent on entertainment. A serious and long pause needs to be taken. By everybody.

<figure class="wp-caption">

<img data-width="2400" data-height="1800" src="https://cdn-images-1.medium.com/max/800/1*pRon9UAtEO-JzTY-7mg1jA.png" /><figcaption class="wp-caption-text"><b>Thanks for Reading!</b></figcaption></figure>
