---
title: The Duality of Purpose and Work
date: 2020-10-25
author: Brennan K. Brown
layout: post
tags:
  - Purpose
  - Inspiration
category: Essays
---

**PART ONE: HAVING FAITH IN GRAND DREAMS.** Understanding the _why_ of the work is the most important thing that’s needed when starting out. It’s so easy to become discouraged when you’re in the the thick of the weeds, when you need to do difficult or tedious. Motivation and discipline to do such work comes from having a bigger picture — a purpose.

This purpose comes from a place of realistic optimism and idealism. It’s a messy and bold goal. A tangible, yet implausible objective without conventional measure or perspective. There’s a lot wrong with the world — and a lot of people that will complain about it — but how can you improve it? What troubles are you willing to tackle head-on for the good of humanity?

<figure class="wp-caption">

<img data-width="5532" data-height="3688" src="https://cdn-images-1.medium.com/max/2560/1*RijfP3sZSfQXb8V_43OzUA.jpeg" /> <figcaption class="wp-caption-text"><b>Person Making Clay Pot</b> | <a href="https://www.pexels.com/photo/ceramic-artisan-clay-mud-110144/" target="_blank" rel="noopener noreferrer">Source</a></figcaption></figure>

## How to effectively go about doing what’s truly important.

<!--more-->

It’s a lot to ask, to a point where most people don’t even push themselves to even attempt it. And those that _do_ attempt to achieve something grand usually stop after failing only once or twice.

The reason so few people succeed in capturing the essence of a heartfelt purpose is a lack of faith. Having the faith in yourself that you’re truly capable of accomplishing that goal, no matter the obstacles, or opinions, or failures that you will inevitably face. It takes a fair amount of foolishness to ever succeed in accomplishing audacious.

Don’t back out of a goal as soon as it looks like it’s going to fail — have more trust than doubt. Many people discuss the learning opportunities that reside in failure, but the truth of the matter is that gritting your teeth and persevering and eventually finding success is a far more enriching learning experience.

It is important to understand the context of where you currently stand in history. Research your contemporaries that have similar goals — especially if they’re currently doing far better than you are. Research the great thinkers and creators of the past, as well. Having this contextual model will not lead you to achievement, but will guide you in the right direction, like a compass.

At the same time, you must not be rigid with your objectives, either. Do not let pride get in your way — redirect your efforts if you need too. Being agile is far more intelligent than abandoning your efforts altogether and starting from square one.

**PART TWO: ELIMINATING EVERYTHING NON-ESSENTIAL.** Simply understanding what you want to accomplish will not allow you to actually get it done. The _what_ of work is doing the technical and nitty-gritty, which is the contrary of the initial motivating and lofty goals.

They both outstandingly require one another. Being only an idealist thinker won’t get anything done. While being only a busy-bee worker won’t get anything _meaningful_ done.

It doesn’t matter if you are clueless when you’re first beginning — that’s normal. Mastery of any knowledge or skill requires only deliberate practice and enough time. Be humble enough to absorb the knowledge of everybody around you. Learn to constantly ask critical questions. Be resourceful with the amount of information you can find both locally and <a href="https://medium.com/@brennanbrown/guide-to-self-learning-7ea651650d11" target="_blank" rel="noopener noreferrer">online</a>.

Figure out priorities, examine what work needs to be done as opposed to what’s just easy and non-essential filler. The next part is vital: look at your schedule and block out large chunks of time (four to seven hours) where you _just work_ on what’s most important.

You cannot allow yourself to be interrupted by others, or distract yourself with the plethora of attention-grabbing media that’s currently at our disposal. This can be extremely difficult at first, but don’t be afraid to communicate with others that you’re busy with something and that you’ll talk to them later.

Similarly, push yourself to sticking to one tab or application open at a time. Stop yourself from constantly jump from one inquiry to another. Be mindful of how you’re using technology — take a break every once in awhile.

A lot of people say they simply don’t have the time in their schedules to devote themselves so deeply to something. But the truth of the matter is that even if you have other responsibilities, you can fit this work into your calendar by understanding and eliminating the time you’re currently wasting — because we all waste time.

<b>CONCLUSION:</b>  
I believe we’re all given the opportunity to achieve goodness in the world that’s beyond ourselves — whether it’s in small ways or big ways. We’re all born being good at something — technical or creative — and with an intense curiosity of the world we live in.

It is far too easy to veer off the path of pioneering, to instead be comfortable with letting life pass us by. I believe that we can make the conscious decision to change that — at any point in our lives — and instead <a href="https://medium.com/@brennanbrown/our-finite-everything-8ed4d9d70a2f" target="_blank" rel="noopener noreferrer">aspire to greatness</a>. All it takes is a little courage, and a lot of reckless abandon.
