Attribute VB_Name = "Module1"
' Ejemplo de Uso de Interface COM con Web Service Factura Electrnica Exportacin AFIP
' 2010 (C) Mariano Reingart <reingart@gmail.com>

Sub Main()
    Dim WSAA As Object, WSFEX As Object
    
    On Error GoTo ManejoError
    
    ' Crear objeto interface Web Service Autenticacin y Autorizacin
    Set WSAA = CreateObject("WSAA")
    
    ' Generar un Ticket de Requerimiento de Acceso (TRA) para WSFEX
    tra = WSAA.CreateTRA("wsfex")
    Debug.Print tra
    
    ' Especificar la ubicacion de los archivos certificado y clave privada
    Path = CurDir() + "\"
    ' Certificado: certificado es el firmado por la AFIP
    ' ClavePrivada: la clave privada usada para crear el certificado
    Certificado = "..\..\reingart.crt" ' certificado de prueba
    ClavePrivada = "..\..\reingart.key" ' clave privada de prueba
    
    ' Generar el mensaje firmado (CMS)
    cms = WSAA.SignTRA(tra, Path + Certificado, Path + ClavePrivada)
    Debug.Print cms
    
    ' Llamar al web service para autenticar:
    ta = WSAA.CallWSAA(cms, "https://wsaahomo.afip.gov.ar/ws/services/LoginCms") ' Homologacin

    ' Imprimir el ticket de acceso, ToKen y Sign de autorizacin
    Debug.Print ta
    Debug.Print "Token:", WSAA.Token
    Debug.Print "Sign:", WSAA.Sign
    
    ' Una vez obtenido, se puede usar el mismo token y sign por 24 horas
    ' (este perodo se puede cambiar)
    
    ' Crear objeto interface Web Service de Factura Electrnica de Exportacin
    Set WSFEX = CreateObject("WSFEX")
    ' Setear tocken y sing de autorizacin (pasos previos)
    WSFEX.Token = WSAA.Token
    WSFEX.Sign = WSAA.Sign
    
    ' CUIT del emisor (debe estar registrado en la AFIP)
    WSFEX.Cuit = "20267565393"
    
    ' Conectar al Servicio Web de Facturacin
    ok = WSFEX.Conectar("http://wswhomo.afip.gov.ar/WSFEX/service.asmx") ' homologacin
        
    ' Prueba de tablas referenciales de parmetros
        
    ' recupero tabla de parmetros de moneda ("id: descripcin")
    For Each x In WSFEX.GetParamMon()
        Debug.Print x
    Next

    ' recupero tabla de tipos de comprobantes("id: descripcin")
    For Each x In WSFEX.GetParamTipoCbte()
        Debug.Print x
    Next
    
    ' recupero tabla de tipos de exportacin ("id: descripcin")
    For Each x In WSFEX.GetParamTipoExpo()
        Debug.Print x
    Next
    
    ' recupero tabla de idiomas de comprobantes ("id: descripcin")
    For Each x In WSFEX.GetParamIdiomas()
        Debug.Print x
    Next
    
    ' recupero tabla de unidades de medida ("id: descripcin")
    For Each x In WSFEX.GetParamUMed()
        Debug.Print x
    Next
    
    ' recupero tabla de terminos de comercio exterior ("id: descripcin")
    For Each x In WSFEX.GetParamIncoterms()
        Debug.Print x
    Next
        
    ' recupero tabla de cdigo de pais destino ("codigo: descripcin")
    For Each x In WSFEX.GetParamDstPais()
        Debug.Print x
    Next
    
    ' recupero tabla de cuit de pais destino ("cuit: descripcin")
    For Each x In WSFEX.GetParamDstCUIT()
        Debug.Print x
    Next
        
    ' busco la cotizacin del dolar (ver Param Mon)
    ctz = WSFEX.GetParamCtz("DOL")
    MsgBox "Cotizacin Dlar: " & ctz
    
    Exit Sub
ManejoError:
    ' Si hubo error:
    Debug.Print Err.Description            ' descripcin error afip
    Debug.Print Err.Number - vbObjectError ' codigo error afip
    Select Case MsgBox(Err.Description, vbCritical + vbRetryCancel, "Error:" & Err.Number - vbObjectError & " en " & Err.Source)
        Case vbRetry
            Debug.Assert False
            Resume
        Case vbCancel
            Debug.Print Err.Description
    End Select
    Debug.Print WSFEX.XmlRequest
    Debug.Assert False

End Sub
