import React from 'react'
import { object, string, func, bool } from 'prop-types';
import { reduxForm } from 'redux-form';

import MetadataEvaluator from './metadata/evaluator/MetadataEvaluator';
import ModelParser from './metadata/model/ModelParser';

@reduxForm()
export default class AutoFormInternal extends React.Component {
    static propTypes = {
        uiType: string,
        fields: object.isRequired,
        handleSubmit: func.isRequired,
        resetForm: func.isRequired,
        submitting: bool.isRequired,
        pristine: bool.isRequired,
        componentFactory: object,
        entity: object.isRequired,
        layout: object,
        buttonBar: func.isRequired,
        fieldLayout: string
    };

    getFactory = () => this.props.componentFactory;

    buildGroupComponent = () => {
        //Fields: this is not the fields passed from AutoForm. This is generated by ReduxForm. 
        //This object has a property for each field. Each property contains all redux props for the given field
        let { fields, fieldMetadata, layout, values } = this.props;

        let modelProcessed = ModelParser.process(values, fieldMetadata);
        let fieldMetadataEvaluated = MetadataEvaluator.evaluate(fieldMetadata, modelProcessed, '', fields);
        let componentFactory = this.getFactory();

        return componentFactory.buildGroupComponent({
            component: layout.component,
            layout: layout,
            fields: fieldMetadataEvaluated,
            componentFactory: componentFactory
        });
    };

	getSubErrors = (fields) => {
		let arr = fields.map(field => {
			let result = null;

			for (let key in field) {
				if (field.hasOwnProperty(key)) {
					if (field[key].error) {
						result = {...result, ...{[field[key].name]: field[key].error}};
					}
				}
			}

			return result;
		});

		return arr.filter(field => {
			return (field !== null)? true : false;
		});
	};

	getErrors = (fields) => {
		let arr = [];

		for (let key in fields) {
			if (fields.hasOwnProperty(key)) {
				if (Array.isArray(fields[key])) {
					let subArr = this.getSubErrors(fields[key]);

					//Merge both arrays into one to get the values up to date
					arr = [...arr, ...subArr];
				}
				else if (fields[key].error) {
					arr.push({[fields[key].name]: fields[key].error});
				}
			}
		}

		return arr;
	};

	getButtonBar = () => {
		//Because redux-form always force a re-render with different kinds of events,
		//we got the errors up to date in fields object
		const { buttonBar, submitting, pristine, fields } = this.props;

		const errors = this.getErrors(fields);
		const buttonBarProps = { submitting, pristine, errors };

		return React.createElement(buttonBar, buttonBarProps);
	};

    render() {
        let groupComponent = this.buildGroupComponent();
        let componentFactory = this.getFactory();
	    let buttonBar = this.getButtonBar();
        let Root = componentFactory.getRoot();

        return (
            <Root {...this.props}>
                { groupComponent }
                { buttonBar }
            </Root>
        )
    }
}