<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [Metadata](#metadata)
  - [Schema](#schema)
  - [Entity](#entity)
  - [Layout](#layout)
  - [Group](#group)
  - [Field](#field)
  - [Schema format](#schema-format)
  - [Common metadata](#common-metadata)
- [Lib](#lib)
  - [Component factories](#component-factories)
  - [Localization](#localization)
- [Components](#components)
  - [AutoForm](#autoform)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

> Be patient. This documentation is still under construction. Pull-requests are welcome.

For an introduction to the library, as well as instructions on how to install, build and run it, please refer to the [README.md](https://gearz-lab.github.io/redux-autoform/blob/master/readme.md).

Metadata
===

Metadata is the single most important thing to understand in order to work with `redux-autoform`. Basically, you pass a
`schema` to the `Redux-Autoform` component, along with a component factory, and it renders itself.

These are the most important things you should know about Metadata:

 - The application `schema` is composed of `entities` and `layouts`.
 - `Fields` are defined in `entities` and `layouts`.
 - Each `field` is going to become a component.
 - `Field`'s metadata is passed to the components as `props`.
 - `Field` metadata is merged from the `layout` to the `entity` before being passed to the components. It's possible to override `field` metadata in the `layout`. 
 - Each `Field` metadata can be either a literal or a function. When it's a function, it's evaluated automatically every time the
 form changes.

Schema
---

The root of all metadata. It may represent your entire application schema or just a subset of it. If you choose to pass only
a subset to the `AutoForm`, make sure it contains all the referenced `entities`.
 
Metadata | Description
--- | ---
entities | An array of `entity`.

Entity
---

Represents an `entity`. 

Metadata | Description
--- | ---
name | The `entity` name
fields | An array or `field`.
layouts | An array or `layout`.

Layout
---

Represents a visualization of an `entity`. Examples of layouts would be `edit` and `details`.  Every `entity` field that
 should be displayed in a `layout`  should be declared both in the `entity.fields` and in the `layout.fields` or `layout.someGroup.fields`.
  Fields are  merged based on the `name` metadata.
  
Metadata | Description
--- | ---
name | The `layout` name
orientation | How the fields to should be laid out. Valid values are "vertical" and "horizontal". It defaults to "vertical". When a layout/group is "vertical", the default size for the component is 12. When it's "horizontal", the default size is 12/[number of components]. 
fields | An array of `field`. These `fields` are merged with the fields from the `entity` this layout belongs to. Fields are merged based on the `name` metadata.
groups | (optional) An array of `group`.

Group
---

Represents a group in the `layout`. Groups exist just so the `layouts` are flexible and customizable.

Metadata | Description
--- | ---
name | The name of the group. Only useful when you want to render a group inside a layout field.
orientation | How the fields to should be laid out. Valid values are "vertical" and "horizontal". It defaults to "vertical". When a layout/group is "vertical", the default size for the component is 12. When it's "horizontal", the default size is 12/[number of components].
fields | An array of `field`. These `fields` are merged with the fields from the `entity` this layout belongs to. Fields are merged based on the `name` metadata.
groups | (optional) An array of `group`.

Field
---

Represents a `field`. `Fields` can exist in `entities`, `layouts` or `groups`. `Field` metadata are passed to the component as `props`.
 
 Each `field` metadata's value can be in one of the following formats:
 
 Format | Description
 --- | ---
 Literal | Example: 'Andre' or 2.
 Function | When a field metadata value is a function, it's evaluated and the value is passed to the target component as a `prop`.  Functions receive two parameters: `m`, which is the current model, and `h`, which is a collection of helper methods for dealing with number formats, for instance.  Example: function(m, h) { return m.name }
 
Fields can have any sorts of metadata, as long as the component registered in the `ComponentFactory` takes this metadata into account.

These are the metadata that are component agnostic: 

Metadata | Description
--- | ---
name | The `field` name. This is how a field is identified and merged.
type | The `field` type. This is the default way to determine which component should render this `field`.
 The list of possible values for `type` depends on which component is registered in the `ComponentFactory`. That is,
 `foo` is a valid value for `type`, as long as the `ComponentFactory` registered a component for `foo`.
 The list of valid types for the `DefaultEditComponentFactory` can be found [here](https://gearz-lab.github.io/redux-autoform/blob/master/src/MaterialUiComponentFactoryHelper.js).
size | The size of the component, in grid units. Values can range from 1 to 12.
component | Which component to use. If no component is set, the default one will be used.

Other `field` metadata will depend on the component.


Schema format
-------------

Redux-Autoform supports a canonical schema definition form, but variations are also supported.

**Canonical form**

Entities, fields, layouts and groups are arrays.

Example:

    {
        entities: [
            {
                name: "contact",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "dateOfBirth",
                        type: "date"
                    }
                ],
                layouts: [
                    {
                        name: "edit",
                        fields: [
                            {  name: "name", displayName: "Name" },
                            {  name: "name", displayName: "Date of Birth" },
                        ]
                    }
                ]
            }
        ]
    }

**Alternative form**

Entities, fields, layouts and groups can optionally be objects.

Example:

    {
        entities: [
            {
               contact: {
               fields: {
                       name: {
                           type: "string"
                       },
                       dateOfBirth: {
                           type: "date"
                       }
               }
                layouts: {
                    edit: {
                        fields: {
                            name: { displayName: "Name" },
                            dateOfBirth: { displayName: "Date of Birth" }
                        }
                    }
                }
            }
        ]
    }
 
**Simple form**

On the simple form, you only specify the fields, and Redux-Autoform will automatically generate an entity called 'default'. When using the simple form, 
the `AutoForm` props for `entityName` and `layoutName` should be null or undefined or ''. If the schema is in simple form, layouts are not supported.

Example: 

    {
        name: {
            displayName: 'Name',
            type: 'string'
        },
        dateOfBirth: {
            displayName: 'Date of birth',
            type: 'date'
        }
    }

 
Common field metadata
---------------

Metadata that is common to most of the components.

Metadata | Description
--- | ---
displayName | The user-friendly name for the field.
component | Which component to use. 
readOnly | Whether or not the component should be in read-only state.
help | Additional help so the end-user knows what the field is about.


Lib
===

Component factories
---

The `ComponentFactory` is responsible for determining which React component to use for a given field metadata. `redux-autoform` doesn't have any built-in factory, for that you can use either
[Bootstrap](https://github.com/redux-autoform/redux-autoform-bootstrap-ui) (beta state) or [Material-UI](https://github.com/redux-autoform/redux-autoform-material-ui) (under development).

Assuming Bootstrap, you can get the factories like this:
 
```js
import { EditComponentFactory, DetailsComponentFactory } from 'redux-autoform-bootstrap-ui';
```


Localization
---

AutoForm doesn't directly depend on localization, but the default component factories do. So, if you're using the default component factories, this is what you should do:

 - Install [numbro](http://numbrojs.com/). This is the library used for number localization.
 - Install [moment](http://momentjs.com/). This is the library used for datetime localization.
 - Then...
 
    // import moment and numbro
    import moment from 'moment';
    import numbro from 'numbro';
    // import the localizers
    import { momentLocalizer, numbroLocalizer } from '../../src/lib/localization/momentDateLocalizer';
    // if you are using react-widgets, which is used by default on the standard factories, you need to import it's localizer too:
    import reactWidgetsMomentLocalizer from 'react-widgets/lib/localizers/moment';
    // set up the localizers
    momentLocalizer(moment);
    numbroLocalizer(numbro);
    reactWidgetsMomentLocalizer(moment);

    
Components
===

AutoForm
---

A form component that renders itself based on metadata

Prop | Description
--- | ---
componentFactory | The `ComponentFactory` that should be used
schema | The application schema. See [Metadata](https://gearz-lab.github.io/redux-autoform/blob/master/docs-md/Documentation.md#metadata)
entityName | The name of the `entity` in the `schema`
layoutName | The name of the `layout` in the `entity`
bottomBar | A component for rendering the bottom bar. This component should include a submit input.
errorRenderer | Function that should render an error component in case something goes wrong. The function should receive an `exception` and return a component.
onSubmit | Function called when the form is successfully submitted. 
