// Code generated by ring-buffer-gen. DO NOT EDIT.
//go:generate ring-buffer-gen -o buffer.go -p memlog -t Record -i github.com/reddec/trusted-cgi/stats --synchronized
package memlog

import (
	stats "github.com/reddec/trusted-cgi/stats"
	"sync"
)

// New instance of ring buffer
func NewRingBuffer(size uint) *RingBuffer {
	return &RingBuffer{data: make([]stats.Record, size)}
}

// Wrap pre-allocated buffer to ring buffer
func WrapRingBuffer(buffer []stats.Record) *RingBuffer {
	return &RingBuffer{data: buffer}
}

// Ring buffer for type Record
type RingBuffer struct {
	seq  uint64
	data []stats.Record
	lock sync.RWMutex
}

// Add new element to the ring buffer. If buffer is full, the oldest element will be overwritten
func (rb *RingBuffer) Add(value stats.Record) {
	rb.lock.Lock()
	defer rb.lock.Unlock()
	rb.data[rb.seq%uint64(len(rb.data))] = value
	rb.seq++
}

// Get element by index. Negative index is counting from end
func (rb *RingBuffer) Get(index int) (ans stats.Record) {
	rb.lock.RLock()
	defer rb.lock.RUnlock()
	if index < 0 {
		index = len(rb.data) + index
	}
	return rb.data[(rb.seq+uint64(index))%uint64(len(rb.data))]
}

// Length of used elements. Always in range between zero and maximum capacity
func (rb *RingBuffer) Len() int {
	rb.lock.RLock()
	defer rb.lock.RUnlock()
	if n := len(rb.data); rb.seq < uint64(n) {
		return int(rb.seq)
	} else {
		return n
	}
}

// Clone of ring buffer with shallow copy of underlying buffer
func (rb *RingBuffer) Clone() *RingBuffer {
	rb.lock.RLock()
	defer rb.lock.RUnlock()
	cp := make([]stats.Record, len(rb.data))
	copy(cp, rb.data)
	return &RingBuffer{seq: rb.seq, data: cp}
}

// Flatten copy of underlying buffer. Data is always ordered in an insertion order
func (rb *RingBuffer) Flatten() []stats.Record {
	rb.lock.RLock()
	defer rb.lock.RUnlock()
	ulen := uint64(len(rb.data))
	cp := make([]stats.Record, ulen)
	if rb.seq < ulen {
		copy(cp, rb.data)
		return cp[:rb.seq]
	}
	sep := rb.seq % ulen
	head := rb.data[sep:]
	copy(cp, head)
	copy(cp[len(head):], rb.data[:sep])
	return cp
}
