# Contributing

If you have found an issue or would like to request a new feature, simply create a new issue detailing the request. We also welcome pull requests. See below for information on getting started with development and submitting pull requests.

## Found an Issue?

If you find a bug in the source code or a mistake in the documentation, you can help us by
submitting an issue to our [GitHub Repository](https://github.com/reactstrap/reactstrap/issues/new). Even better you can submit a Pull Request
with a fix.

**Please see the Submission Guidelines below**.

## Want a Feature?

You can request a new feature by submitting an issue to our [GitHub Repository](https://github.com/reactstrap/reactstrap/issues/new). If you
would like to implement a new feature then consider what kind of change it is:

- **Major Changes** that you wish to contribute to the project should be discussed first in a [GitHub Issue](https://github.com/reactstrap/reactstrap/issues/new) or [Slack](https://reactstrap.slack.com) so that we can better coordinate our efforts, prevent
  duplication of work, and help you to craft the change so that it is successfully accepted into the
  project. Slack invites can be obtained [here](https://reactstrap.herokuapp.com/).
- **Small Changes** can be crafted and submitted to the [GitHub Repository](https://github.com/reactstrap/reactstrap) as a Pull Request.

### Submitting a Pull Request

If you wish to submit a pull request for a new feature or issue, you should start by forking this repository first. After you have forked and cloned the repository locally, create a new branch with a name that loosely describes the issue on which you will be working. Once you think you have the addressed the issue in question, submit a pull request. Here are some guidelines to follow when writing code for reactstrap:

- Commit messages should follow Angular's [Git Commit Guidelines](https://github.com/angular/angular.js/blob/master/CONTRIBUTING.md#-git-commit-guidelines).
- Intermediate and work-in-progress commits should be rebased out.
- Keep pull requests tightly scoped to the issue or feature being addressed.
- All changes from every developer must go through code review before they will be merged.
- All changes must pass the CI build. Travis CI will automatically update your PR with the build status.
- All changes must have unit tests.
- All changes must have Typescript types in the [`types`](./types) directory.
- All components must have a demo implementation in the `docs/lib/examples` directory.
- Make sure to run `yarn lint` and `yarn prettier` on your work before submitting the PR

## Resources

- [Codepen Demo](http://codepen.io/eddywashere/pen/ZOjmkm)
- [Slack](https://reactstrap.slack.com)
  - [Get Slack Invite](https://reactstrap.herokuapp.com/)
- [Ask Stackoverflow](http://stackoverflow.com/questions/ask?tags=reactstrap+react)
  - [View Stackoverflow reactstrap tag](http://stackoverflow.com/questions/tagged/reactstrap)
