<!DOCTYPE html>
<html>
<head>
    <title>Part listing</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap core CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.4/css/bootstrap.min.css" rel="stylesheet" media="screen">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.2/html5shiv.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/respond.js/1.4.2/respond.js"></script>
    <![endif]-->
</head>
<body>
{Controller:examples\cms\NavigationBar}
<div class="container">
    <h1>{RES:PartsList}</h1>
    <div class="table table-responsive">
        <table class="table table-bordered" id="parts">
            <thead>
                <tr>
                    <th>{RES:part_code}</th>
                    <th>{RES:description}</th>
                    <th>{RES:source}</th>
                    <th>{RES:source_lead_time}</th>
                    <th>{RES:measurement_unit_code}</th>
                    <th>{RES:part_type_code}</th>
                    <th>{RES:part_category_code}</th>
                    <th>{RES:wastage}</th>
                    <th>{RES:bom_levels}</th>
                </tr>
            </thead>
            <tbody>
                <!-- BEGIN Parts -->
                <tr>
                    <td>{part_code}</td>
                    <td>{description}</td>
                    <td>{source}</td>
                    <td>{source_lead_time}</td>
                    <td>{measurement_unit_code}</td>
                    <td>{part_type_code}</td>
                    <td>{part_category_code}</td>
                    <td>{wastage}</td>
                    <td>{bom_levels}</td>
                </tr>
                <!-- END Parts -->
            </tbody>
            <tfoot>
                <tr>
                    <td class = "text-center" colspan="9">{RES:AllParts}</td>
                </tr>
            </tfoot>
        </table>

        <hr>
        <a href="{GLOBAL:SITEURL}/examples/about/example/partList" class="btn btn-info">{RES:ShowCode}</a>
        <a href="{GLOBAL:SITEURL}/examples/db/part_list/" class="btn btn-success">{RES:ShowTemplate}</a>
        <a href="{GLOBAL:SITEURL}/examples/db/part_list" class="btn btn-success">{RES:ShowRun}</a>
        <a href="{GLOBAL:SITEURL}/examples/" class="btn btn-primary">{RES:ShowToc}</a>
    </div>

</div>

<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

<!-- Include all compiled plugins (below), or include individual files as needed -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.4/js/bootstrap.min.js"></script>
<script>
    function myCallBack() {
        console.log("Call back from custom call back");
    }

    function observerCallBack() {
        console.log("Call back from observer");
    }
</script>
</body>
</html>