---
title: Thoughts to Words - An Introduction to Aaron Simumba's Website
author: Aaron Simumba
date: '2018-02-19'
slug: introduction-to-aaron-simumba-website
categories:
  - Blogdown
  - R
  - Hugo
tags:
  - blogdown
  - netlify
  - github
  - blog
description: "A brief introduction to my blogging journey, and how I crafted my personal website"
---


# Introduction

Hi, my name is Aaron Simumba, and you can find my website on the following URL: [https://asimumba.rbind.io/](https://asimumba.rbind.io/). And on  [Github](https://github.com/asimumba), plus you can follow me on [Twitter](https://twitter.com/asimumba21). A brief background about myself: I often like to refer to myself as a "Lost Accountant" - because professionally I trained as an accountant, who lost his way to practise accounting and ended up into the data science space. I was excited to be in finance and accounting, I loved all the glory that came with working with financial data. But at heart, I loved computers and statistics. Statistics was probably one of my favourite courses at university. If there is one thing I got out of the accounting degree was that: "Debits should equal credits and vice versa"; and this has been my motivation to try to always find a reconciliation point for all I do.


# Blogging journey

I have always had a knack to express my thoughts. Previously I blogged with `blogger` and `Wordpress`. Mostly I blogged about random stuff that today I am ashamed to re-read. But that provided a very good foundation for harnessing my interest in blogging. 

# Getting lost in the wilderness

During my final undergraduate year, I so looked forward to finishing and venture into other interesting life persuasions. But that was one half of finishing all the university business - the other half involved writing my final year thesis. I was happy to finally get on with challenging my thought process. Unfortunately this enthusiasm was short lived. SPSS was in my way! I hated the work process of analysis in SPSS, and then copy the output to Microsoft word. Oh lord! cant there be something better? At the end of the day I went on with this process until the bitter end.


Post university, I started looking for a better analysis environment, luckily I stumbled on R and all the tools in its ecosystem. And as you can guess I have not looked back. Been using R and its tools for  now 1 year 7 months. If I'm to describe the experience, I would say, it's been fun and challenging. With plenty of promises for the future. 


# Website

If there is one thing hard to be satisfied with is the visual aesthetics of the website. I first created my **blogdown** powered website in 2017 right around July. But between then and now, I have changed a minimum four website themes. This was mainly due the fact I had zero knowledge of `HTML`, let alone `CSS`. I took each theme as it came and simply replaced template filled sections with my own details. This left a hole which needed to be filled. I wanted to have control over even the most miniature website aspect. Fast forward, I crashed HTML and CSS courses to try and learn enough skills to be dangerous, of course in a minimal way. I want to thank [Yihui Xie](https://yihui.name/), from whom I have learnt a lot. His blog has great material to both his tools and his take on other open source software. Of course don't forget to read the [blogdown book](https://bookdown.org/yihui/blogdown/).

My website is built on the `hugo`, `github`, `netlify` and `blogdown` platform. I am using the [Beautiful Hugo](https://github.com/halogenica/beautifulhugo) theme. I like this theme for the following reasons: natively it comes with support for syntax highlighting, mathjax, a big image cover for the landing page and photoswipe, embedding a gallery of images is something I wanted.

![screenshot](https://user-images.githubusercontent.com/24398851/36398695-035a64fe-15d1-11e8-87b1-6a7c5ab65ad9.png)


The theme has quite a clean design, which you can get started with a new website in minutes. Minimalistic design if you decide to strip out the images. Looking at the amount of work I did to achieve the visual effects as seen below. I must say I'm pleased and happy to call this a personal website!

![website](https://user-images.githubusercontent.com/24398851/36397146-09733e62-15ca-11e8-9be1-a91244efc209.jpg)



I broke and repositioned a lot of the native features to achieve the design as seen above. I let go of the avatar container on the navigation bar, re-aligned the navbar links to the right from their original left hand position. Added font awesome icons to some links. 

![navbar](https://user-images.githubusercontent.com/24398851/36397152-0f79484c-15ca-11e8-9974-f8be9bef098a.png)


For the landing page, I moved posts preview to the `blog` tab. And in addition, adjusted the big image of the landing page to cover the whole page. Resized the footer to accommodate the big front image.

I love the post preview from the blog section. It gives a brief section to preview the content before delving fully into the post. From the original theme structure, this is presented on the front page if you use `/content/post/` structure. To avoid this, I changed it to `/content/blog/`. All my posts reside in the `/blog` subdirectory.

![blog](https://user-images.githubusercontent.com/24398851/36397317-016df4c2-15cb-11e8-986f-b33a31689bc6.jpg)

# End goal

Going forward, I will use this website to document my R learning path. And occasionally anything I find remotely interesting for the future me for reference purposes. More like turning my wild thoughts to written engravings. Happy blogging...

I cannot document all the small but significant changes I made. The best option would be to fork the site and have a look at the changes made. For the source to my website, you can find it [here](https://github.com/rbind/asimumba).


