---
title: Launching the Rbind support website
author: The Rbind Team
date: '2017-04-24'
tags:
  - announcement
slug: launching-rbind-support
description: One organization to bind them (websites) all.
---

As we quoted Carlos Scheidegger in the [**blogdown** book](https://bookdown.org/yihui/blogdown/): "if you don't have a website nowadays, you don't exist." So we hope to help as many people to set up their own websites as possible. There are extremely mature solutions like WordPress, and why Rbind? Of course, Rbind is not for everyone, and it is based on the following philosophies in which we believe:

1. Static websites are easier to maintain. A website is a collection of static files built from Markdown source files, and they work almost everywhere (locally or remotely). No databases, no PHP, faster, and much more secure.
1. R Markdown is simple in syntax, but you can do most common things you want. Headers, paragraphs, lists, tables, footnotes, math equations, plots, theorems, proofs, citations, HTML widgets, and cross-references. What else do you need as a statistician or data analyst?
1. "Social coding" is tremendously helpful. If you share the source of your website, say, on Github, other people can both learn from you and contribute to your website. Don't isolate people using login credentials (you, and only the poor and lonely you, have access to your website) --- bind them using pull requests instead.
1. Your website should be truly yours, and you have control over almost everything, including the content, style, theme, and JavaScript libraries that you are interested in. When you want to move (even move away from Rbind), there is nothing to import or export. Your website is a self-contained folder, and you can move it anywhere you like.

If you do not agree with them, Rbind is probably not for you, otherwise welcome to Rbind, and please see the [About](/about/) page for how to join us. There is a group of volunteers behind Rbind, and they will be happy to assist you with your website.

![one after another cat](https://slides.yihui.name/gif/cat-flow.gif)

Looking forward to more websites under Rbind!
