# raylib bindings and wrappers

Some people ported raylib to other languages in the form of bindings or wrappers to the library. Here is a list with all the ports available. Feel free to send a PR if you know of any binding/wrapper not in this list.

### Language Bindings

| Name                                                                                     | raylib Version   | Language                                                             | License              |
| :--------------------------------------------------------------------------------------- | :--------------: | :------------------------------------------------------------------: | :------------------: |
| [raylib](https://github.com/raysan5/raylib)                                              | **5.5**          | [C/C++](https://en.wikipedia.org/wiki/C_(programming_language))      | Zlib                 |
| [raylib-beef](https://github.com/Starpelly/raylib-beef)                                  | **5.5**          | [Beef](https://www.beeflang.org)                                     | MIT                  |
| [raybit](https://github.com/Alex-Velez/raybit)                                           | **5.0**          | [Brainfuck](https://en.wikipedia.org/wiki/Brainfuck)                 | MIT                  |
| [raylib-c3](https://github.com/c3lang/vendor/tree/main/libraries/raylib55.c3l)           | **5.5**          | [C3](https://c3-lang.org)                                            | MIT                  |
| [Raylib-cs](https://github.com/ChrisDill/Raylib-cs)                                      | **5.0**          | [C#](https://en.wikipedia.org/wiki/C_Sharp_(programming_language))   | Zlib                 |
| [Raylib-CsLo](https://github.com/NotNotTech/Raylib-CsLo)                                 | 4.2              | [C#](https://en.wikipedia.org/wiki/C_Sharp_(programming_language))   | MPL-2.0              |
| [Raylib-CSharp-Vinculum](https://github.com/ZeroElectric/Raylib-CSharp-Vinculum)         | **5.0**          | [C#](https://en.wikipedia.org/wiki/C_Sharp_(programming_language))   | MPL-2.0              |
| [Raylib-CSharp](https://github.com/MrScautHD/Raylib-CSharp)                              | **5.1-dev**      | [C#](https://en.wikipedia.org/wiki/C_Sharp_(programming_language))   | MIT                  |
| [cl-raylib](https://github.com/longlene/cl-raylib)                                       | 4.0              | [Common Lisp](https://common-lisp.net)                               | MIT                  |
| [claylib/wrap](https://github.com/defun-games/claylib)                                   | 4.5              | [Common Lisp](https://common-lisp.net)                               | Zlib                 |
| [claw-raylib](https://github.com/bohonghuang/claw-raylib)                                | **auto**         | [Common Lisp](https://common-lisp.net)                               | Apache-2.0           |
| [chez-raylib](https://github.com/Yunoinsky/chez-raylib)                                  | **auto**         | [Chez Scheme](https://cisco.github.io/ChezScheme)                    | GPLv3                |
| [CLIPSraylib](https://github.com/mrryanjohnston/CLIPSraylib)                             | **auto**         | [CLIPS](https://www.clipsrules.net/)                                 | MIT                  |
| [raylib-cr](https://github.com/sol-vin/raylib-cr)                                        | 4.6-dev (5e1a81) | [Crystal](https://crystal-lang.org)                                  | Apache-2.0           |
| [ray-cyber](https://github.com/fubark/ray-cyber)                                         | **5.0**          | [Cyber](https://cyberscript.dev)                                     | MIT                  |
| [dart-raylib](https://gitlab.com/wolfenrain/dart-raylib)                                 | 4.0              | [Dart](https://dart.dev)                                             | MIT                  |
| [bindbc-raylib3](https://github.com/o3o/bindbc-raylib3)                                  | **5.0**          | [D](https://dlang.org)                                               | BSL-1.0              |
| [dray](https://github.com/redthing1/dray)                                                | **5.0**          | [D](https://dlang.org)                                               | Apache-2.0           |
| [raylib-d](https://github.com/schveiguy/raylib-d)                                        | **5.5**          | [D](https://dlang.org)                                               | Zlib                 |
| [rayex](https://github.com/shiryel/rayex)                                                | 3.7              | [elixir](https://elixir-lang.org)                                    | Apache-2.0           |
| [raylib-factor](https://github.com/factor/factor/blob/master/extra/raylib/raylib.factor) | 4.5              | [Factor](https://factorcode.org)                                     | BSD                  |
| [raylib-freebasic](https://github.com/WIITD/raylib-freebasic)                            | **5.0**          | [FreeBASIC](https://www.freebasic.net)                               | MIT                  |
| [fortran-raylib](https://github.com/interkosmos/fortran-raylib)                          | **5.5**          | [Fortran](https://fortran-lang.org)                                  | ISC                  |
| [raylib-go](https://github.com/gen2brain/raylib-go)                                      | **5.5**          | [Go](https://golang.org)                                             | Zlib                 |
| [raylib-guile](https://github.com/petelliott/raylib-guile)                               | **auto**         | [Guile](https://www.gnu.org/software/guile)                          | Zlib                 |
| [gforth-raylib](https://github.com/ArnautDaniel/gforth-raylib)                           | 3.5              | [Gforth](https://gforth.org)                                         | **???**              |
| [h-raylib](https://github.com/Anut-py/h-raylib)                                          | **5.5-dev**      | [Haskell](https://haskell.org)                                       | Apache-2.0           |
| [raylib-hx](https://github.com/foreignsasquatch/raylib-hx)                               | 4.2              | [Haxe](https://haxe.org)                                             | Zlib                 |
| [hb-raylib](https://github.com/MarcosLeonardoMendezGerencir/hb-raylib)                   | 3.5              | [Harbour](https://harbour.github.io)                                 | MIT                  |
| [jaylib](https://github.com/janet-lang/jaylib)                                           | **5.0**          | [Janet](https://janet-lang.org)                                      | MIT                  |
| [jaylib](https://github.com/electronstudio/jaylib/)                                      | **5.5**          | [Java](https://en.wikipedia.org/wiki/Java_(programming_language))    | GPLv3+CE             |
| [raylib-j](https://github.com/CreedVI/Raylib-J)                                          | 4.0              | [Java](https://en.wikipedia.org/wiki/Java_(programming_language))    | Zlib                 |
| [Raylib.jl](https://github.com/chengchingwen/Raylib.jl)                                  | 4.2              | [Julia](https://julialang.org)                                       | Zlib                 |
| [kaylib](https://github.com/electronstudio/kaylib)                                       | 3.7              | [Kotlin/native](https://kotlinlang.org)                              | **???**              |
| [KaylibKit](https://codeberg.org/Kenta/KaylibKit)                                        | 4.5              | [Kotlin/native](https://kotlinlang.org)                              | Zlib                 |
| [raylib-lua](https://github.com/TSnake41/raylib-lua)                                     | 5.0              | [Lua](http://www.lua.org)                                            | ISC                  |
| [raylib-lua-bindings (WIP)](https://github.com/legendaryredfox/raylib-lua-bindings)      | 5.5              | [Lua](http://www.lua.org)                                            | ISC                  |
| [ReiLua](https://github.com/nullstare/ReiLua)                                            | 5.5              | [Lua](http://www.lua.org)                                            | MIT                  |
| [raylib-matte](https://github.com/jcorks/raylib-matte)                                   | 4.6-dev          | [Matte](https://github.com/jcorks/matte)                             |  **???**             |
| [Raylib.nelua](https://github.com/AuzFox/Raylib.nelua)                                   | **5.0**          | [nelua](https://nelua.io)                                            | Zlib                 |
| [raylib-bindings](https://github.com/vaiorabbit/raylib-bindings)                         | 5.6-dev              | [Ruby](https://www.ruby-lang.org/en)                                 | Zlib                 |
| [naylib](https://github.com/planetis-m/naylib)                                           | **5.1-dev**      | [Nim](https://nim-lang.org)                                          | MIT                  |
| [node-raylib](https://github.com/RobLoach/node-raylib)                                   | 4.5              | [Node.js](https://nodejs.org/en)                                     | Zlib                 |
| [raylib-odin](https://github.com/odin-lang/Odin/tree/master/vendor/raylib)               | **5.5**          | [Odin](https://odin-lang.org)                                        | BSD-3Clause          |
| [raylib_odin_bindings](https://github.com/Deathbat2190/raylib_odin_bindings)             | 4.0-dev          | [Odin](https://odin-lang.org)                                        | MIT                  |
| [raylib-ocaml](https://github.com/tjammer/raylib-ocaml)                                  | **5.0**          | [OCaml](https://ocaml.org)                                           | MIT                  |
| [TurboRaylib](https://github.com/turborium/TurboRaylib)                                  | 4.5              | [Object Pascal](https://en.wikipedia.org/wiki/Object_Pascal)         | MIT                  |
| [Ray4Laz](https://github.com/GuvaCode/Ray4Laz)                                           | **5.5**          | [Free Pascal](https://en.wikipedia.org/wiki/Free_Pascal)             | Zlib                 |
| [Raylib.4.0.Pascal](https://github.com/sysrpl/Raylib.4.0.Pascal)                         | 4.0              | [Free Pascal](https://en.wikipedia.org/wiki/Free_Pascal)             | Zlib                 |
| [pyraylib](https://github.com/Ho011/pyraylib)                                            | 3.7              | [Python](https://www.python.org)                                     | Zlib                 |
| [raylib-python-cffi](https://github.com/electronstudio/raylib-python-cffi)               | **5.5**              | [Python](https://www.python.org)                                     | EPL-2.0              |
| [raylibpyctbg](https://github.com/overdev/raylibpyctbg)                                  | 5.5              | [Python](https://www.python.org)                                     | MIT                  |
| [raylib-py](https://github.com/overdev/raylib-py)                                        | 5.5              | [Python](https://www.python.org)                                     | MIT                  |
| [raylib-python-ctypes](https://github.com/sDos280/raylib-python-ctypes)                  | 4.6-dev          | [Python](https://www.python.org)                                     | MIT                  |
| [raylib-pkpy-bindings](https://github.com/blueloveTH/pkpy-bindings)                      | 5.1-dev          | [pocketpy](https://pocketpy.dev)                                     | MIT                  |
| [raylib-php](https://github.com/joseph-montanez/raylib-php)                              | 4.5              | [PHP](https://en.wikipedia.org/wiki/PHP)                             | Zlib                 |
| [raylib-phpcpp](https://github.com/oraoto/raylib-phpcpp)                                 | 3.5              | [PHP](https://en.wikipedia.org/wiki/PHP)                             | Zlib                 |
| [raylibr](https://github.com/jeroenjanssens/raylibr)                                     | 4.0              | [R](https://www.r-project.org)                                       | MIT                  |
| [raylib-ffi](https://github.com/ewpratten/raylib-ffi)                                    | 5.5              | [Rust](https://www.rust-lang.org)                                    | GPLv3                |
| [raylib-rs](https://github.com/raylib-rs/raylib-rs)                                      | **5.5**          | [Rust](https://www.rust-lang.org)                                    | Zlib                 |
| [Relib](https://github.com/RedCubeDev-ByteSpace/Relib)                                   | 3.5              | [ReCT](https://github.com/RedCubeDev-ByteSpace/ReCT)                 | **???**              |
| [racket-raylib](https://github.com/eutro/racket-raylib)                                  | 4.0              | [Racket](https://racket-lang.org)                                    | MIT/Apache-2.0       |
| [raylib-swift](https://github.com/STREGAsGate/Raylib)                                    | 4.0              | [Swift](https://swift.org)                                           | MIT                  |
| [raylib-scopes](https://github.com/salotz/raylib-scopes)                                 | auto             | [Scopes](http://scopes.rocks)                                        | MIT                  |
| [raylib-SmallBASIC](https://github.com/smallbasic/smallbasic.plugins/tree/master/raylib) | **5.5**          | [SmallBASIC](https://github.com/smallbasic/SmallBASIC)               | GPLv3                |
| [raylib-umka](https://github.com/robloach/raylib-umka)                                   | 4.5              | [Umka](https://github.com/vtereshkov/umka-lang)                      | Zlib                 |
| [raylib.v](https://github.com/irishgreencitrus/raylib.v)                                 | 4.2              | [V](https://vlang.io)                                                | Zlib                 |
| [raylib-vapi](https://github.com/lxmcf/raylib-vapi)                                      | **5.0**          | [Vala](https://vala.dev)                                             | Zlib                 |
| [raylib-wren](https://github.com/TSnake41/raylib-wren)                                   | 4.5              | [Wren](http://wren.io)                                               | ISC                  |
| [raylib-zig](https://github.com/Not-Nik/raylib-zig)                                      | **5.5**          | [Zig](https://ziglang.org)                                           | MIT                  |
| [raylib.zig](https://github.com/ryupold/raylib.zig)                                      | **5.1-dev**      | [Zig](https://ziglang.org)                                           | MIT                  |
| [raylib-zig-bindings](https://github.com/L-Briand/raylib-zig-bindings)                   | **5.0**          | [Zig](https://ziglang.org)                                           | Zlib                 |
| [hare-raylib](https://git.sr.ht/~evantj/hare-raylib)                                     | **auto**         | [Hare](https://harelang.org)                                         | Zlib                 |
| [raylib-sunder](https://github.com/ashn-dot-dev/raylib-sunder)                           | **auto**         | [Sunder](https://github.com/ashn-dot-dev/sunder)                     | 0BSD                 |
| [raylib-bqn](https://github.com/Brian-ED/raylib-bqn)                                     | **5.0**          | [BQN](https://mlochbaum.github.io/BQN)                               | MIT                  |
| [rayjs](https://github.com/mode777/rayjs)                                                | 4.6-dev          | [QuickJS](https://bellard.org/quickjs)                               | MIT                  |
| [raylib-raku](https://github.com/vushu/raylib-raku)                                      | **auto**         | [Raku](https://www.raku.org)                                         | Artistic License 2.0 |
| [Raylib.lean](https://github.com/KislyjKisel/Raylib.lean)                                | **5.5-dev**      | [Lean4](https://lean-lang.org)                                       | BSD-3-Clause         |
| [raylib-cobol](https://codeberg.org/glowiak/raylib-cobol)                                | **auto**         | [COBOL](https://gnucobol.sourceforge.io)                             | Public domain        |
| [raylib-apl](https://github.com/Brian-ED/raylib-apl)                                     | **5.0**          | [Dyalog APL](https://www.dyalog.com/)                                | MIT                  |
| [raylib-jai](https://github.com/ahmedqarmout2/raylib-jai)                                | **5.5**          | [Jai](https://github.com/BSVino/JaiPrimer/blob/master/JaiPrimer.md)  | MIT                  |
| [fnl-raylib](https://github.com/0riginaln0/fnl-raylib)                                   | **5.5**          | [Fennel](https://fennel-lang.org/)                                   | MIT                  |

### Utility Wrapers

These are utility wrappers for specific languages, they are not required to use raylib in the language but may adapt the raylib API to be more inline with the language's paradigm.
| Name                                                 | raylib Version | Language                                     | License |
| ---------------------------------------------------- | :------------: | :------------------------------------------: | :-----: |
| [raylib-cpp](https://github.com/robloach/raylib-cpp) | **5.5**        | [C++](https://en.wikipedia.org/wiki/C%2B%2B) | Zlib    |
| [claylib](https://github.com/defun-games/claylib)    | 4.5            | [Common Lisp](https://common-lisp.net)       | Zlib    |
| [rayed-bqn](https://github.com/Brian-ED/rayed-bqn)   | **5.0**        | [BQN](https://mlochbaum.github.io/BQN)       | MIT     |
| [DOOR](https://github.com/RealDoigt/DOOR)            | 4.0            | [D](https://dlang.org)                       | MIT     |

### Older or Unmaintained Language Bindings

These are older raylib bindings that are more than 2 versions old or have not been maintained.
| Name                                                                               | raylib Version | Language                                                                |
| ---------------------------------------------------------------------------------- | :------------: | :---------------------------------------------------------------------: |
| [raylib-cppsharp](https://github.com/phxvyper/raylib-cppsharp)                     | 2.5            | [C#](https://en.wikipedia.org/wiki/C_Sharp_(programming_language))    |
| [RaylibFS](https://github.com/dallinbeutler/RaylibFS)                              | 2.5            | [F#](https://fsharp.org)                                                |
| [raylib\*d](https://github.com/Sepheus/raylib_d)                                   | 2.5            | [D](https://dlang.org)                                                  |
| [bindbc-raylib](https://github.com/o3o/bindbc-raylib)                              | 3.0            | [D](https://dlang.org)                                                  |
| [go-raylib](https://github.com/chunqian/go-raylib)                                 | 3.5            | [Go](https://golang.org)                                                |
| [raylib-goplus](https://github.com/Lachee/raylib-goplus)                           | 2.6-dev        | [Go](https://golang.org)                                                |
| [ray-go](https://github.com/hecate-tech/ray-go)                                    | 2.6-dev        | [Go](https://golang.org)                                                |
| [raylib-luamore](https://github.com/HDPLocust/raylib-luamore)                      | 3.0            | [Lua](http://www.lua.org)                                               |
| [LuaJIT-Raylib](https://github.com/Bambofy/LuaJIT-Raylib)                          | 2.6            | [Lua](http://www.lua.org)                                               |
| [raylib-lua-sol](https://github.com/RobLoach/raylib-lua-sol)                       | 2.5            | [Lua](http://www.lua.org)                                               |
| [raylib-lua-ffi](https://github.com/raysan5/raylib/issues/693)                     | 2.0            | [Lua](http://www.lua.org)                                               |
| [raylib-lua](https://github.com/raysan5/raylib-lua)                                | 1.7            | [Lua](http://www.lua.org)                                               |
| [raylib-nelua](https://github.com/Andre-LA/raylib-nelua)                           | 3.0            | [Nelua](https://nelua.io)                                               |
| [raylib-nim](https://github.com/Skrylar/raylib-nim)                                | 2.0            | [Nim](https://nim-lang.org)                                             |
| [raylib-Nim](https://gitlab.com/define-private-public/raylib-Nim)                  | 1.7            | [Nim](https://nim-lang.org)                                             |
| [nim-raylib](https://github.com/tomc1998/nim-raylib)                               | 3.1-dev        | [Nim](https://nim-lang.org)                                             |
| [raylib-Forever](https://github.com/Guevara-chan/Raylib-Forever)                   | auto           | [Nim](https://nim-lang.org)                                             |
| [NimraylibNow!](https://github.com/greenfork/nimraylib_now)                        | 4.2            | [Nim](https://nim-lang.org)                                            |
| [raylib-haskell](https://github.com/DevJac/raylib-haskell)                         | 2.0            | [Haskell](https://www.haskell.org)                                      |
| [raylib-cr](https://github.com/AregevDev/raylib-cr)                                | 2.5-dev        | [Crystal](https://crystal-lang.org)                                     |
| [raylib.cr](https://github.com/sam0x17/raylib.cr)                                  | 2.0            | [Crystal](https://crystal-lang.org)                                     |
| [cray](https://gitlab.com/Zatherz/cray)                                            | 1.8            | [Crystal](https://crystal-lang.org)                                     |
| [raylib-pas](https://github.com/tazdij/raylib-pas)                                 | 3.0            | [Pascal](https://en.wikipedia.org/wiki/Pascal*(programming*language)) |
| [raylib-pascal](https://github.com/drezgames/raylib-pascal)                        | 2.0            | [Pascal](https://en.wikipedia.org/wiki/Pascal*(programming*language)) |
| [Graphics-Raylib](https://github.com/athreef/Graphics-Raylib)                      | 1.4            | [Perl](https://www.perl.org)                                            |
| [raylib-ruby](https://github.com/a0/raylib-ruby)                                   | 2.6            | [Ruby](https://www.ruby-lang.org/en)                                    |
| [raylib-ruby-ffi](https://github.com/D3nX/raylib-ruby-ffi)                         | 2.0            | [Ruby](https://www.ruby-lang.org/en)                                    |
| [raylib-mruby](https://github.com/lihaochen910/raylib-mruby)                       | 2.5-dev        | [mruby](https://github.com/mruby/mruby)                                 |
| [raylib-java](https://github.com/XoanaIO/raylib-java)                              | 2.0            | [Java](https://en.wikipedia.org/wiki/Java*(programming_language))     |
| [clj-raylib](https://github.com/lsevero/clj-raylib)                                | 3.0            | [Clojure](https://clojure.org)                                          |
| [QuickJS-raylib](https://github.com/sntg-p/QuickJS-raylib)                         | 3.0            | [QuickJS](https://bellard.org/quickjs)                                  |
| [raylib-duktape](https://github.com/RobLoach/raylib-duktape)                       | 2.6            | [JavaScript (Duktape)](https://en.wikipedia.org/wiki/JavaScript)        |
| [raylib-v7](https://github.com/Rabios/raylib-v7)                                   | 3.5            | [JavaScript (v7)](https://en.wikipedia.org/wiki/JavaScript)             |
| [raylib-chaiscript](https://github.com/RobLoach/raylib-chaiscript)                 | 2.6            | [ChaiScript](http://chaiscript.com)                                     |
| [raylib-squirrel](https://github.com/RobLoach/raylib-squirrel)                     | 2.5            | [Squirrel](http://www.squirrel-lang.org)                                |
| [racket-raylib-2d](https://github.com/arvyy/racket-raylib-2d)                      | 2.5            | [Racket](https://racket-lang.org)                                       |
| [raylib-php-ffi](https://github.com/oraoto/raylib-php-ffi)                         | 2.4-dev        | [PHP](https://en.wikipedia.org/wiki/PHP)                                |
| [raylib-haxe](https://github.com/ibilon/raylib-haxe)                               | 2.4            | [Haxe](https://haxe.org)                                                |
| [ringraylib](https://github.com/ringpackages/ringraylib)                           | 2.6            | [Ring](http://ring-lang.sourceforge.net)                                |
| [raylib-scm](https://github.com/yashrk/raylib-scm)                                 | 2.5            | [Chicken Scheme](https://www.call-cc.org)                               |
| [raylib-chibi](https://github.com/VincentToups/raylib-chibi)                       | 2.5            | [Chibi-Scheme](https://github.com/ashinn/chibi-scheme)                  |
| [raylib-gambit-scheme](https://github.com/georgjz/raylib-gambit-scheme)            | 3.1-dev        | [Gambit Scheme](https://github.com/gambit/gambit)                       |
| [Euraylib](https://github.com/gAndy50/Euraylib)                                    | 3.0            | [Euphoria](https://openeuphoria.org)                                    |
| [raylib-odin](https://github.com/kevinw/raylib-odin)                               | 3.0            | [Odin](https://odin-lang.org)                                           |
| [vraylib](https://github.com/waotzi/vraylib)                                       | 3.5            | [V](https://vlang.io)                                                   |
| [raylib-vala](https://code.guddler.uk/mart/raylibVapi)                             | 3.0            | [Vala](https://wiki.gnome.org/Projects/Vala)                            |
| [raylib-jai](https://github.com/kujukuju/raylib-jai)                               | 3.1-dev        | [Jai](https://github.com/BSVino/JaiPrimer/blob/master/JaiPrimer.md)     |
| [ray.zig](https://github.com/BitPuffin/zig-raylib-experiments)                     | 2.5            | [Zig](https://ziglang.org)                                              |
| [raylib-Ada](https://github.com/mimo/raylib-Ada)                                   | 3.0            | [Ada](https://www.adacore.com/about-ada)                                |
| [raykit](https://github.com/Gamerfiend/raykit)                                     | **???**        | [Kit](https://www.kitlang.org)                                          |
| [ray.mod](https://github.com/bmx-ng/ray.mod)                                       | 3.0            | [BlitzMax](https://blitzmax.org)                                        |
| [raylib-mosaic](https://github.com/pluckyporcupine/raylib-mosaic)                  | 3.0            | [Mosaic](https://github.com/sal55/langs/tree/master/Mosaic)             |
| [raylib-xdpw](https://github.com/vtereshkov/raylib-xdpw)                           | 2.6            | [XD Pascal](https://github.com/vtereshkov/xdpw)                         |
| [raylib-carp](https://github.com/sacredbirdman/raylib-carp)                        | 3.0            | [Carp](https://github.com/carp-lang/Carp)                               |
| [raylib-fb](https://github.com/IchMagBier/raylib-fb)                               | 3.0            | [FreeBasic](https://www.freebasic.net)                                  |
| [raylib-purebasic](https://github.com/D-a-n-i-l-o/raylib-purebasic)                | 3.0            | [PureBasic](https://www.purebasic.com)                                  |
| [raylib-ats2](https://github.com/mephistopheles-8/raylib-ats2)                     | 3.0            | [ATS2](http://www.ats-lang.org)                                         |
| [raylib-beef](https://github.com/M0n7y5/raylib-beef)                               | 3.0            | [Beef](https://www.beeflang.org)                                        |
| [raylib-never](https://github.com/never-lang/raylib-never)                         | 3.0            | [Never](https://github.com/never-lang/never)                            |
| [raylib.cbl](https://github.com/Martinfx/Cobol/tree/master/OpenCobol/Games/raylib) | 2.0            | [COBOL](https://en.wikipedia.org/wiki/COBOL)                            |

Missing some language or wrapper? Feel free to create a new one! :)

Usually, raylib bindings follow the convention: `raylib-{language}`

Let me know if you're writing a new binding for raylib, I will list it here!
