
# Naming conventions 
RawPHP follows standard naming conventions, that is, there are certain names you must name your files in other to leverage RawPHP's power:

### Database naming convention
Your database tables must all be in smallcaps andin plural, multiple words should be joined with an underscore. The below are valid names:
 * `customer_accounts`
 * `posts`
 * `books`
 
### Model naming convention
Your models must be singular and Capitalized, multiple words are camel cased. Below are examples of corresponding models for the above tables:
 * `CustomerAccount.php`
 * `Post.php`
 * `Book.php`
 
### Controller naming convention
Your controller names must be capitalized, plural and must end with the `Controller` suffix. Multiple words are camel cased. Below are examples of corresponding controllers for the above models
 * `CustomerAccountsController.php`
 * `PostsController.php`
 * `BooksController.php`
 
### Views naming convention
Your view folder should bear the same name as your database table and must be named in the same way - small caps and plural.
The view files should bear the same name as their corresponding controller methods. Below are examples
* `/customer_accounts` folder may contain the following files
* ` add.twig`
* `create.twig`
* `checkIfCustomerAccountIsActive.twig`

