---
title: Contributor Guidelines
---

I encourage everyone to contribute to the RawPHP Framework project. You can find the latest code on GitHub at <https://github.com/daveozoalor/RawPHP-framework>.

## Issue Tracker

You can find outstanding issues on the [GitHub Issue Tracker](https://github.com/daveozoalor/RawPHP-framework/issues). If you intend to work on a specific issue, leave a comment on the appropriate thread to inform other project contributors.

## Pull Requests

* Each pull request should contain only one new feature or improvement.
* Pull requests should be submitted to the `master` branch
* Pull requests must have passed PHPUnit tests

## Code Style

All pull requests must use the [PSR-2](http://www.php-fig.org/psr/psr-2/) code style.

* Code MUST use the [PSR-1](http://www.php-fig.org/psr/psr-1/) code style.
* Code MUST use 4 spaces for indenting, not tabs.
* There MUST NOT be a hard limit on line length; the soft limit MUST be 120 characters; lines SHOULD be 80 characters or less.
* There MUST be one blank line after the namespace declaration, and there MUST be one blank line after the block of use declarations.
* Opening braces for classes MUST go on the next line, and closing braces MUST go on the next line after the body.
* Opening braces for methods MUST go on the next line, and closing braces MUST go on the next line after the body.
* Visibility MUST be declared on all properties and methods; abstract and final MUST be declared before the visibility; static MUST be declared after the visibility.
* Control structure keywords MUST have one space after them; method and function calls MUST NOT.
* Opening braces for control structures MUST go on the same line, and closing braces MUST go on the next line after the body.
* Opening parentheses for control structures MUST NOT have a space after them, and closing parentheses for control structures MUST NOT have a space before.
