# RawPHP documentation

This is the official documentation for [RawPHP Framework](https://github.com/rawphp-framework/RawPHP-framework)

### Tutorials
 * [Build a Sample Blog Application - Written tutorials](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/tutorial/first-app.md)
 * [Build A Powerful Job Recruitment Platform - Video Tutorials](https://www.youtube.com/watch?v=hzRXYrdR4m0&list=PLnBvgoOXZNCM_cxMH8rhLVch_YQbUL5el)

### Get Started
  * [Installation](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/installation.md)
  * [Upgrade Guide](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/upgrade.md)
  * [Web Servers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/web-servers.md)
  * [Deployment](https://github.com/rawphp-framework/RawPHP-docs/docs/deployment/deployment.md)
### Naming conventions
 * [Databases](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/naming-conventions.md)
 * [Models](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/naming-conventions.md)
  * [Views](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/naming-conventions.md)
  * [Controllers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/naming-conventions.md)
### Console 
  * [Models](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/console.md)
  * [Controllers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/console.md)
  * [Views](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/start/console.md)
  
### Concepts
  * [PSR 7](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/concepts/value-objects.md)
  * [Middleware](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/concepts/middleware.md)
  * [Dependency Container](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/concepts/di.md)
  
### The Application
  * [Overview](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/application.md)
  * [Configuration](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/application.md#application-configuration)
  * [Default settings](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/application.md#slim-default-settings)
  
### The Request
  * [Overview](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Method](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Headers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Body](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Uploaded Files](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Helpers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Route object](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  * [Media type parsers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/request.md)
  
### The Response
  * [Overview](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/response.md)
  * [Status](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/response.md)
  * [Headers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/response.md)
  * [Body](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/response.md)
  * [JSON](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/response.md)
  
### Routing
  * [Overview](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Create Routes](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Callbacks](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Strategies](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Placeholders](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Names](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Groups](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Middleware](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  * [Container Resolution](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/objects/router.md)
  
### Error Handling
  * [Error Handlers](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/handlers/error.md)
  * [404 Not Found](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/handlers/not-found.md)
  * [405 Not Allowed](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/handlers/not-allowed.md)
  * [PHP Runtime Error](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/handlers/php-error.md)
  
  ### Cook book
  * [Trailing / in routes](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/route-patterns.md)
  * [Retrieving IP address](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/ip-address.md)
  * [Retrieving Current Route](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/retrieving-current-route.md)
  * [Using Eloquent with RawPHP](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/database-eloquent.md)
  * [Enabling CORS](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/enable-cors.md)
  * [Getting and Mocking the Environment](https://github.com/rawphp-framework/rawphp-docs/blob/master/docs/cookbook/environment.md)
  * [Uploading Files using POST forms](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/cookbook/uploading-files.md)
  
### Add Ons
  * [Templates](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/features/templates.md)
  * [HTTP Caching](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/features/caching.md)
  * [CSRF Protection](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/features/csrf.md)
  * [Flash Messages](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/features/flash.md)

### Contributing
  * [Branching Strategy](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/contributors/strategy.md)
  * [Guidelines](https://github.com/rawphp-framework/RawPHP-docs/blob/master/docs/contributors/guidelines.md)

## Bring your own components

RawPHP is designed to play well with other PHP components, too. You can register
additional first-party components , packages and middlewares used in other frameworks into .

## How to read this documentation

If you are new to RawPHP, I recommend you read this documentation from start
to finish. If you are already familiar with RawPHP, you can instead jump straight
to the appropriate section.

This documentation begins by explaining RawPHP's concepts and architecture
before venturing into specific topics like request and response handling,
routing, and error handling.

[symfony](http://symfony.com/)
[CakePHP](http://cakephp.org/)
[Slim](http://slimframework.com)
[laravel](http://laravel.com/)
[httpcache](https://github.com/slimphp/Slim-HttpCache)
[doctrine](http://www.doctrine-project.org/projects/orm.html)
