# [code2d](http://code2d.net)

[![wercker status](https://app.wercker.com/status/aa4ef4ba73e65111e51e0d90049cdf88/s/master "wercker status")](https://app.wercker.com/project/byKey/aa4ef4ba73e65111e51e0d90049cdf88)
[![license](https://img.shields.io/github/license/raviqqe/code2d.svg)](LICENSE)

Todo management tools for software engineers.

## Stack

- Frontend
  - [TypeScript](https://www.typescriptlang.org/)
  - [React](https://reactjs.org/)
  - [Redux](https://github.com/reactjs/redux)

- Backend
  - [Firebase Functions](https://firebase.google.com/docs/functions/)

- User authentication
  - [Firebase Authentication](https://firebase.google.com/docs/auth/)

- Remote storage
  - Firebase
    - [Realtime Database](https://firebase.google.com/docs/database/)
    - [Storage](https://firebase.google.com/docs/storage/)

- CDN
  - [Firebase Hosting](https://firebase.google.com/docs/hosting/)

- DNS
  - [AWS Route 53](https://aws.amazon.com/route53/)

- CI
  - [Wercker](http://www.wercker.com/)

- Task automation
  - [Rake](https://github.com/ruby/rake)

- Others
  - [Chrome extension](https://chrome.google.com/webstore/detail/code2d/fmbpjfldodgfbmhnbpahimhabjmipojd?hl=en)
  - YouTube Data API
  - Google Analytics Reporting API

## Screenshots

### Desktop

#### Tasks

![tasks page](images/screenshots/original/tasks.png)

#### Articles

![articles page](images/screenshots/original/articles.png)

#### Videos

![videos page](images/screenshots/original/videos.png)

#### Books

![books page](images/screenshots/original/books.png)

### Mobile

#### Tasks

![tasks page on mobile](images/screenshots/small/mobile_tasks.png)

#### Menu

![menu on mobile](images/screenshots/small/mobile_menu.png)

#### Articles

![articles page on mobile](images/screenshots/small/mobile_articles.png)

#### Trending articles

![trending page on mobile](images/screenshots/small/mobile_trending.png)

## License

[MIT](LICENSE)
