#ifndef __TURBOPILOT_GPTJ_H
#define __TURBOPILOT_GPTJ_H

#include <turbopilot/model.hpp>

#include <vector>
#include <map>

// default hparams (GPT-J 6B)
struct gptj_hparams {
    int32_t n_vocab = 50400;
    int32_t n_ctx   = 2048;
    int32_t n_embd  = 4096;
    int32_t n_head  = 16;
    int32_t n_layer = 28;
    int32_t n_rot   = 64;
    int32_t ftype   = 1;
};

struct gptj_layer {
    // normalization
    struct ggml_tensor * ln_1_g;
    struct ggml_tensor * ln_1_b;

    // attention
    struct ggml_tensor * c_attn_q_proj_w;
    struct ggml_tensor * c_attn_k_proj_w;
    struct ggml_tensor * c_attn_v_proj_w;

    struct ggml_tensor * c_attn_proj_w;

    // ff
    struct ggml_tensor * c_mlp_fc_w;
    struct ggml_tensor * c_mlp_fc_b;

    struct ggml_tensor * c_mlp_proj_w;
    struct ggml_tensor * c_mlp_proj_b;
};

struct gptj_model {
    gptj_hparams hparams;

    // normalization
    struct ggml_tensor * ln_f_g;
    struct ggml_tensor * ln_f_b;

    struct ggml_tensor * wte; // position embedding

    struct ggml_tensor * lmh_g; // language model head
    struct ggml_tensor * lmh_b; // language model bias

    std::vector<gptj_layer> layers;

    // key + value memory
    struct ggml_tensor * memory_k;
    struct ggml_tensor * memory_v;

    //
    struct ggml_context * ctx;
    std::map<std::string, struct ggml_tensor *> tensors;
};



class GPTJModel : public TurbopilotModel {

public:
    GPTJModel(ModelConfig config, std::mt19937 &rng) : TurbopilotModel(config, rng){
        this->model = new gptj_model{};
        this->vocab = new gpt_vocab{};
    }
    virtual ~GPTJModel();
    bool load_model(std::string path);
    virtual std::stringstream predict_impl(std::string prompt, int max_length, bool include_prompt);

private:
    gptj_model *model = NULL;
    gpt_vocab *vocab = NULL;


};

#endif