// Automatically generated by Interoptopus.

#pragma warning disable 0105
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using My.Company;
using My.Company.Common;
#pragma warning restore 0105

namespace My.Company
{
    public static partial class Interop
    {
        public const string NativeLib = "library";

        static Interop()
        {
            var api_version = Interop.pattern_api_guard();
            if (api_version != 5600732245307200640ul)
            {
                throw new TypeLoadException($"API reports hash {api_version} which differs from hash in bindings (5600732245307200640). You probably forgot to update / copy either the bindings or the library.");
            }
        }

        public const byte U8 = (byte) 255;

        public const float F32_MIN_POSITIVE = (float) 0.000000000000000000000000000000000000011754944;

        public const int COMPUTED_I32 = (int) -2147483647;


        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_void")]
        public static extern void primitive_void();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_void2")]
        public static extern void primitive_void2();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_bool")]
        public static extern bool primitive_bool(bool x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_u8")]
        public static extern byte primitive_u8(byte x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_u16")]
        public static extern ushort primitive_u16(ushort x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_u32")]
        public static extern uint primitive_u32(uint x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_u64")]
        public static extern ulong primitive_u64(ulong x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_i8")]
        public static extern sbyte primitive_i8(sbyte x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_i16")]
        public static extern short primitive_i16(short x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_i32")]
        public static extern int primitive_i32(int x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "primitive_i64")]
        public static extern long primitive_i64(long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "boolean_alignment")]
        public static extern BooleanAlignment boolean_alignment(BooleanAlignment x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "boolean_alignment2")]
        public static extern BooleanAlignment boolean_alignment2(bool rval);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "packed_to_packed1")]
        public static extern Packed2 packed_to_packed1(Packed1 a);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "many_args_5")]
        public static extern long many_args_5(long x0, long x1, long x2, long x3, long x4);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "many_args_10")]
        public static extern long many_args_10(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7, long x8, long x9);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ptr")]
        public static extern IntPtr ptr(ref long x);

        /// # Safety
        ///
        /// Parameter x must point to valid data.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ptr_mut")]
        public static extern IntPtr ptr_mut(out long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ptr_ptr")]
        public static extern IntPtr ptr_ptr(ref IntPtr x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ref_simple")]
        public static extern IntPtr ref_simple(ref long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ref_mut_simple")]
        public static extern IntPtr ref_mut_simple(out long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ref_option")]
        public static extern bool ref_option(ref long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ref_mut_option")]
        public static extern bool ref_mut_option(out long x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "call_tupled")]
        public static extern Tupled call_tupled(Tupled x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "complex_args_1")]
        public static extern FFIError complex_args_1(Vec3f32 a, ref Tupled b);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "callback")]
        public static extern byte callback(InteropDelegate_fn_u8_rval_u8 callback, byte value);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_1a")]
        public static extern uint generic_1a(Genericu32 x, Phantomu8 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_1b")]
        public static extern byte generic_1b(Genericu8 x, Phantomu8 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_1c")]
        public static extern byte generic_1c(ref Genericu8 x, ref Genericu8 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_2")]
        public static extern byte generic_2(IntPtr x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_3")]
        public static extern byte generic_3(IntPtr x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "generic_4")]
        public static extern byte generic_4(IntPtr x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "array_1")]
        public static extern byte array_1(Array x);

        /// This function has documentation.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "documented")]
        public static extern EnumDocumented documented(StructDocumented x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ambiguous_1")]
        public static extern Vec1 ambiguous_1(Vec1 x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ambiguous_2")]
        public static extern Vec2 ambiguous_2(Vec2 x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "ambiguous_3")]
        public static extern bool ambiguous_3(Vec1 x, Vec2 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "namespaced_type")]
        public static extern Vec namespaced_type(Vec x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "namespaced_inner_option")]
        public static extern OptionVec namespaced_inner_option(OptionVec x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "namespaced_inner_slice")]
        public static extern SliceVec namespaced_inner_slice(SliceVec x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "namespaced_inner_slice_mut")]
        public static extern SliceMutVec namespaced_inner_slice_mut(SliceMutVec x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "panics")]
        public static extern FFIError panics();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "renamed")]
        public static extern EnumRenamed renamed(StructRenamed x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "sleep")]
        public static extern void sleep(ulong millis);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "weird_1")]
        public static extern bool weird_1(Weird1u32 x, Weird2u8 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "visibility")]
        public static extern void visibility(Visibility1 x, Visibility2 y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "repr_transparent")]
        public static extern Tupled repr_transparent(Tupled x, ref Tupled r);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ascii_pointer_1")]
        public static extern uint pattern_ascii_pointer_1(string x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ascii_pointer_2")]
        public static extern IntPtr pattern_ascii_pointer_2();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ascii_pointer_len")]
        public static extern uint pattern_ascii_pointer_len(string x, UseAsciiStringPattern y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ascii_pointer_return_slice")]
        public static extern SliceUseAsciiStringPattern pattern_ascii_pointer_return_slice();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_1")]
        public static extern uint pattern_ffi_slice_1(SliceU32 ffi_slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_1b")]
        public static extern uint pattern_ffi_slice_1b(SliceMutU32 ffi_slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_2")]
        public static extern Vec3f32 pattern_ffi_slice_2(SliceVec3f32 ffi_slice, int i);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_3")]
        public static extern void pattern_ffi_slice_3(SliceMutU8 slice, CallbackSliceMut callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_4")]
        public static extern void pattern_ffi_slice_4(SliceU8 slice, SliceMutU8 slice2);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_5")]
        public static extern void pattern_ffi_slice_5(ref SliceU8 slice, ref SliceMutU8 slice2);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_6")]
        public static extern void pattern_ffi_slice_6(ref SliceMutU8 slice, CallbackU8 callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_7")]
        public static extern uint pattern_ffi_slice_7(SliceMutConstPtrI8 slices);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_delegate")]
        public static extern byte pattern_ffi_slice_delegate(CallbackFFISlice callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_slice_delegate_huge")]
        public static extern Vec3f32 pattern_ffi_slice_delegate_huge(CallbackHugeVecSlice callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_option_1")]
        public static extern OptionInner pattern_ffi_option_1(OptionInner ffi_slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_option_2")]
        public static extern Inner pattern_ffi_option_2(OptionInner ffi_slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_bool")]
        public static extern Bool pattern_ffi_bool(Bool ffi_bool);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_cchar")]
        public static extern sbyte pattern_ffi_cchar(sbyte ffi_cchar);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_cchar_const_pointer")]
        public static extern IntPtr pattern_ffi_cchar_const_pointer(IntPtr ffi_cchar);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_ffi_cchar_mut_pointer")]
        public static extern IntPtr pattern_ffi_cchar_mut_pointer(IntPtr ffi_cchar);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_api_guard")]
        public static extern ulong pattern_api_guard();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_1")]
        public static extern uint pattern_callback_1(MyCallback callback, uint x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_2")]
        public static extern MyCallbackVoid pattern_callback_2(MyCallbackVoid callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_3")]
        public static extern void pattern_callback_3(DelegateCallbackMyCallbackContextual callback, uint x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_4")]
        public static extern uint pattern_callback_4(MyCallbackNamespaced callback, uint x);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_5")]
        public static extern SumDelegate1 pattern_callback_5();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_6")]
        public static extern SumDelegate2 pattern_callback_6();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_callback_7")]
        public static extern FFIError pattern_callback_7(SumDelegateReturn c1, SumDelegateReturn2 c2, int x, int i, out int o);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "pattern_surrogates_1")]
        public static extern void pattern_surrogates_1(Local s, out Container c);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "basic_service_destroy")]
        public static extern FFIError basic_service_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "basic_service_new")]
        public static extern FFIError basic_service_new(ref IntPtr context);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_on_panic_destroy")]
        public static extern FFIError service_on_panic_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_on_panic_new")]
        public static extern FFIError service_on_panic_new(ref IntPtr context);

        /// Methods returning a Result<(), _> are the default and do not
        /// need annotations.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_on_panic_return_result")]
        public static extern FFIError service_on_panic_return_result(IntPtr context, uint anon1);

        /// Methods returning a value need an `on_panic` annotation.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_on_panic_return_default_value")]
        public static extern uint service_on_panic_return_default_value(IntPtr context, uint x);

        /// This function has no panic safeguards. It will be a bit faster to
        /// call, but if it panics your host app will be in an undefined state.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_on_panic_return_ub_on_panic")]
        public static extern IntPtr service_on_panic_return_ub_on_panic(IntPtr context);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_destroy")]
        public static extern FFIError service_callbacks_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_new")]
        public static extern FFIError service_callbacks_new(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_callback_simple")]
        public static extern FFIError service_callbacks_callback_simple(IntPtr context, MyCallback callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_callback_ffi_return")]
        public static extern FFIError service_callbacks_callback_ffi_return(IntPtr context, SumDelegateReturn callback);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_callback_with_slice")]
        public static extern FFIError service_callbacks_callback_with_slice(IntPtr context, SumDelegateReturn callback, SliceI32 input);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_set_delegate_table")]
        public static extern void service_callbacks_set_delegate_table(IntPtr context, ref DelegateTable table);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_callbacks_invoke_delegates")]
        public static extern FFIError service_callbacks_invoke_delegates(IntPtr context);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_ignoring_methods_destroy")]
        public static extern FFIError service_ignoring_methods_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_ignoring_methods_new")]
        public static extern FFIError service_ignoring_methods_new(ref IntPtr context);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_multiple_ctors_destroy")]
        public static extern FFIError service_multiple_ctors_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_multiple_ctors_new_with")]
        public static extern FFIError service_multiple_ctors_new_with(ref IntPtr context, uint some_value);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_multiple_ctors_new_without")]
        public static extern FFIError service_multiple_ctors_new_without(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_multiple_ctors_new_with_string")]
        public static extern FFIError service_multiple_ctors_new_with_string(ref IntPtr context, string anon0);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_multiple_ctors_new_failing")]
        public static extern FFIError service_multiple_ctors_new_failing(ref IntPtr context, byte some_value);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_using_lifetimes_destroy")]
        public static extern FFIError service_using_lifetimes_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_using_lifetimes_new_with")]
        public static extern FFIError service_using_lifetimes_new_with(ref IntPtr context, ref uint some_value);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_using_lifetimes_lifetime_1")]
        public static extern void service_using_lifetimes_lifetime_1(IntPtr context, SliceBool slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_using_lifetimes_lifetime_2")]
        public static extern void service_using_lifetimes_lifetime_2(IntPtr context, SliceBool slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_using_lifetimes_return_string_accept_slice")]
        public static extern IntPtr service_using_lifetimes_return_string_accept_slice(IntPtr anon0, SliceU8 anon1);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_destroy")]
        public static extern FFIError service_various_slices_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_new")]
        public static extern FFIError service_various_slices_new(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self")]
        public static extern byte service_various_slices_mut_self(IntPtr context, SliceU8 slice);

        /// Single line.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_void")]
        public static extern void service_various_slices_mut_self_void(IntPtr context, SliceBool slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_ref")]
        public static extern byte service_various_slices_mut_self_ref(IntPtr context, ref byte x, out byte y);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_ref_slice")]
        public static extern byte service_various_slices_mut_self_ref_slice(IntPtr context, ref byte x, out byte y, SliceU8 slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_ref_slice_limited")]
        public static extern byte service_various_slices_mut_self_ref_slice_limited(IntPtr context, ref byte x, out byte y, SliceU8 slice, SliceU8 slice2);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_ffi_error")]
        public static extern FFIError service_various_slices_mut_self_ffi_error(IntPtr context, SliceMutU8 slice);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_mut_self_no_error")]
        public static extern FFIError service_various_slices_mut_self_no_error(IntPtr context, SliceMutU8 slice);

        /// Warning, you _must_ discard the returned slice object before calling into this service
        /// again, as otherwise undefined behavior might happen.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_return_slice")]
        public static extern SliceU32 service_various_slices_return_slice(IntPtr context);

        /// Warning, you _must_ discard the returned slice object before calling into this service
        /// again, as otherwise undefined behavior might happen.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_various_slices_return_slice_mut")]
        public static extern SliceMutU32 service_various_slices_return_slice_mut(IntPtr context);

        /// Destroys the given instance.
        ///
        /// # Safety
        ///
        /// The passed parameter MUST have been created with the corresponding init function;
        /// passing any other value results in undefined behavior.
        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_strings_destroy")]
        public static extern FFIError service_strings_destroy(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_strings_new")]
        public static extern FFIError service_strings_new(ref IntPtr context);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_strings_pass_string")]
        public static extern void service_strings_pass_string(IntPtr context, string anon1);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "service_strings_return_string")]
        public static extern IntPtr service_strings_return_string(IntPtr context);

    }

    /// Documented enum.
    public enum EnumDocumented
    {
        /// Variant A.
        A = 0,
        /// Variant B.
        B = 1,
        /// Variant B.
        C = 2,
    }

    public enum EnumRenamed
    {
        X = 0,
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Array
    {
        public byte data0;
        public byte data1;
        public byte data2;
        public byte data3;
        public byte data4;
        public byte data5;
        public byte data6;
        public byte data7;
        public byte data8;
        public byte data9;
        public byte data10;
        public byte data11;
        public byte data12;
        public byte data13;
        public byte data14;
        public byte data15;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct BooleanAlignment
    {
        public int a;
        public short b;
        public short c;
        public byte d;
        public byte e;
        public byte f;
        public byte g;
        public byte h;
        public byte i;
        public byte j;
        public byte k;
        public ulong id;
        [MarshalAs(UnmanagedType.I1)]
        public bool is_valid;
        public ulong datum;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Container
    {
        public Local foreign;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct DelegateCallbackMyCallbackContextual
    {
        public MyCallbackContextual callback;
        public IntPtr context;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct DelegateTable
    {
        public MyCallback my_callback;
        public MyCallbackNamespaced my_callback_namespaced;
        public MyCallbackVoid my_callback_void;
        public MyCallbackContextual my_callback_contextual;
        public SumDelegate1 sum_delegate_1;
        public SumDelegate2 sum_delegate_2;
        public SumDelegateReturn sum_delegate_return;
        public SumDelegateReturn2 sum_delegate_return_2;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct ExtraTypef32
    {
        public float x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Genericu32
    {
        public IntPtr x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Genericu8
    {
        public IntPtr x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Inner
    {
        float x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Local
    {
        uint x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public partial struct Packed1
    {
        public byte x;
        public ushort y;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public partial struct Packed2
    {
        public ushort y;
        public byte x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Phantomu8
    {
        public uint x;
    }

    /// Documented struct.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct StructDocumented
    {
        /// Documented field.
        public float x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct StructRenamed
    {
        public EnumRenamed e;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Tupled
    {
        public byte x0;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct UseAsciiStringPattern
    {
        public string ascii_string;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Vec
    {
        public double x;
        public double z;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Vec1
    {
        public float x;
        public float y;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Vec2
    {
        public double x;
        public double z;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Vec3f32
    {
        public float x;
        public float y;
        public float z;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Visibility1
    {
        public byte pblc;
        byte prvt;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Visibility2
    {
        public byte pblc1;
        public byte pblc2;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Weird1u32
    {
        uint x;
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Weird2u8
    {
        byte t;
        byte a0;
        byte a1;
        byte a2;
        byte a3;
        byte a4;
        IntPtr r;
    }

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate byte InteropDelegate_fn_u8_rval_u8(byte x0);

    public enum FFIError
    {
        Ok = 0,
        Null = 100,
        Panic = 200,
        Delegate = 300,
        Fail = 400,
    }

    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceBool
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceBool : IEnumerable<Bool>
    {
        public SliceBool(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceBool(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public Bool this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(Bool));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<Bool>(ptr);
            }
        }
        public Bool[] Copied
        {
            get
            {
                var rval = new Bool[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<Bool> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceI32
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceI32 : IEnumerable<int>
    {
        public SliceI32(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceI32(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public int this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(int));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<int>(ptr);
            }
        }
        public int[] Copied
        {
            get
            {
                var rval = new int[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<int> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceU32
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceU32 : IEnumerable<uint>
    {
        public SliceU32(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceU32(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public uint this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(uint));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<uint>(ptr);
            }
        }
        public uint[] Copied
        {
            get
            {
                var rval = new uint[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<uint> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceU8
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceU8 : IEnumerable<byte>
    {
        public SliceU8(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceU8(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public byte this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(byte));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<byte>(ptr);
            }
        }
        public byte[] Copied
        {
            get
            {
                var rval = new byte[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<byte> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceUseAsciiStringPattern
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceUseAsciiStringPattern : IEnumerable<UseAsciiStringPattern>
    {
        public SliceUseAsciiStringPattern(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceUseAsciiStringPattern(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public UseAsciiStringPattern this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(UseAsciiStringPattern));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<UseAsciiStringPattern>(ptr);
            }
        }
        public UseAsciiStringPattern[] Copied
        {
            get
            {
                var rval = new UseAsciiStringPattern[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<UseAsciiStringPattern> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceVec
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceVec : IEnumerable<Vec>
    {
        public SliceVec(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceVec(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public Vec this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(Vec));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<Vec>(ptr);
            }
        }
        public Vec[] Copied
        {
            get
            {
                var rval = new Vec[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<Vec> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceVec3f32
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceVec3f32 : IEnumerable<Vec3f32>
    {
        public SliceVec3f32(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceVec3f32(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public Vec3f32 this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(Vec3f32));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<Vec3f32>(ptr);
            }
        }
        public Vec3f32[] Copied
        {
            get
            {
                var rval = new Vec3f32[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<Vec3f32> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceMutConstPtrI8
    {
        ///Pointer to start of mutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceMutConstPtrI8 : IEnumerable<IntPtr>
    {
        public SliceMutConstPtrI8(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceMutConstPtrI8(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public IntPtr this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(IntPtr));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<IntPtr>(ptr);
            }
            set
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(IntPtr));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                Marshal.StructureToPtr<IntPtr>(value, ptr, false);
            }
        }
        public IntPtr[] Copied
        {
            get
            {
                var rval = new IntPtr[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<IntPtr> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceMutU32
    {
        ///Pointer to start of mutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceMutU32 : IEnumerable<uint>
    {
        public SliceMutU32(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceMutU32(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public uint this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(uint));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<uint>(ptr);
            }
            set
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(uint));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                Marshal.StructureToPtr<uint>(value, ptr, false);
            }
        }
        public uint[] Copied
        {
            get
            {
                var rval = new uint[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<uint> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceMutU8
    {
        ///Pointer to start of mutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceMutU8 : IEnumerable<byte>
    {
        public SliceMutU8(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceMutU8(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public byte this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(byte));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<byte>(ptr);
            }
            set
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(byte));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                Marshal.StructureToPtr<byte>(value, ptr, false);
            }
        }
        public byte[] Copied
        {
            get
            {
                var rval = new byte[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<byte> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///A pointer to an array of data someone else owns which may be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct SliceMutVec
    {
        ///Pointer to start of mutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    public partial struct SliceMutVec : IEnumerable<Vec>
    {
        public SliceMutVec(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public SliceMutVec(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public Vec this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(Vec));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<Vec>(ptr);
            }
            set
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(Vec));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                Marshal.StructureToPtr<Vec>(value, ptr, false);
            }
        }
        public Vec[] Copied
        {
            get
            {
                var rval = new Vec[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<Vec> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }


    ///Option type containing boolean flag and maybe valid data.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct OptionInner
    {
        ///Element that is maybe valid.
        Inner t;
        ///Byte where `1` means element `t` is valid.
        byte is_some;
    }

    public partial struct OptionInner
    {
        public static OptionInner FromNullable(Inner? nullable)
        {
            var result = new OptionInner();
            if (nullable.HasValue)
            {
                result.is_some = 1;
                result.t = nullable.Value;
            }

            return result;
        }

        public Inner? ToNullable()
        {
            return this.is_some == 1 ? this.t : (Inner?)null;
        }
    }


    ///Option type containing boolean flag and maybe valid data.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct OptionVec
    {
        ///Element that is maybe valid.
        Vec t;
        ///Byte where `1` means element `t` is valid.
        byte is_some;
    }

    public partial struct OptionVec
    {
        public static OptionVec FromNullable(Vec? nullable)
        {
            var result = new OptionVec();
            if (nullable.HasValue)
            {
                result.is_some = 1;
                result.t = nullable.Value;
            }

            return result;
        }

        public Vec? ToNullable()
        {
            return this.is_some == 1 ? this.t : (Vec?)null;
        }
    }


    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public partial struct Bool
    {
        byte value;
    }

    public partial struct Bool
    {
        public static readonly Bool True = new Bool { value =  1 };
        public static readonly Bool False = new Bool { value =  0 };
        public Bool(bool b)
        {
            value = (byte) (b ? 1 : 0);
        }
        public bool Is => value == 1;
    }


    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate byte CallbackFFISlice(SliceU8 slice);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate Vec3f32 CallbackHugeVecSlice(SliceVec3f32 slice);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void CallbackSliceMut(SliceMutU8 slice);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate byte CallbackU8(byte value);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate uint MyCallback(uint value);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void MyCallbackContextual(IntPtr context, uint value);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate uint MyCallbackNamespaced(uint value);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void MyCallbackVoid(IntPtr ptr);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void SumDelegate1();

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate int SumDelegate2(int x, int y);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate FFIError SumDelegateReturn(int x, int y);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void SumDelegateReturn2(int x, int y);


    public partial class BasicService : IDisposable
    {
        private IntPtr _context;

        private BasicService() {}

        public static BasicService New()
        {
            var self = new BasicService();
            var rval = Interop.basic_service_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.basic_service_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public IntPtr Context => _context;
    }


    /// Some struct we want to expose as a class.
    public partial class ServiceOnPanic : IDisposable
    {
        private IntPtr _context;

        private ServiceOnPanic() {}

        public static ServiceOnPanic New()
        {
            var self = new ServiceOnPanic();
            var rval = Interop.service_on_panic_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_on_panic_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        /// Methods returning a Result<(), _> are the default and do not
        /// need annotations.
        public void ReturnResult(uint anon1)
        {
            var rval = Interop.service_on_panic_return_result(_context, anon1);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        /// Methods returning a value need an `on_panic` annotation.
        public uint ReturnDefaultValue(uint x)
        {
            return Interop.service_on_panic_return_default_value(_context, x);
        }

        /// This function has no panic safeguards. It will be a bit faster to
        /// call, but if it panics your host app will be in an undefined state.
        public string ReturnUbOnPanic()
        {
            var s = Interop.service_on_panic_return_ub_on_panic(_context);
            return Marshal.PtrToStringAnsi(s);
        }

        public IntPtr Context => _context;
    }


    /// Some struct we want to expose as a class.
    public partial class ServiceCallbacks : IDisposable
    {
        private IntPtr _context;

        private ServiceCallbacks() {}

        public static ServiceCallbacks New()
        {
            var self = new ServiceCallbacks();
            var rval = Interop.service_callbacks_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_callbacks_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void CallbackSimple(MyCallback callback)
        {
            var rval = Interop.service_callbacks_callback_simple(_context, callback);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void CallbackFfiReturn(SumDelegateReturn callback)
        {
            var callback_safe_delegate = new SumDelegateReturnExceptionSafe(callback);
            var rval = Interop.service_callbacks_callback_ffi_return(_context, callback_safe_delegate.Call);
            callback_safe_delegate.Rethrow();
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void CallbackWithSlice(SumDelegateReturn callback, SliceI32 input)
        {
            var callback_safe_delegate = new SumDelegateReturnExceptionSafe(callback);
            var rval = Interop.service_callbacks_callback_with_slice(_context, callback_safe_delegate.Call, input);
            callback_safe_delegate.Rethrow();
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void SetDelegateTable(ref DelegateTable table)
        {
            Interop.service_callbacks_set_delegate_table(_context, ref table);
        }

        public void InvokeDelegates()
        {
            var rval = Interop.service_callbacks_invoke_delegates(_context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public IntPtr Context => _context;
    }


    public partial class ServiceIgnoringMethods : IDisposable
    {
        private IntPtr _context;

        private ServiceIgnoringMethods() {}

        public static ServiceIgnoringMethods New()
        {
            var self = new ServiceIgnoringMethods();
            var rval = Interop.service_ignoring_methods_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_ignoring_methods_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public IntPtr Context => _context;
    }


    /// Some struct we want to expose as a class.
    public partial class ServiceMultipleCtors : IDisposable
    {
        private IntPtr _context;

        private ServiceMultipleCtors() {}

        public static ServiceMultipleCtors NewWith(uint some_value)
        {
            var self = new ServiceMultipleCtors();
            var rval = Interop.service_multiple_ctors_new_with(ref self._context, some_value);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public static ServiceMultipleCtors NewWithout()
        {
            var self = new ServiceMultipleCtors();
            var rval = Interop.service_multiple_ctors_new_without(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public static ServiceMultipleCtors NewWithString(string anon0)
        {
            var self = new ServiceMultipleCtors();
            var rval = Interop.service_multiple_ctors_new_with_string(ref self._context, anon0);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public static ServiceMultipleCtors NewFailing(byte some_value)
        {
            var self = new ServiceMultipleCtors();
            var rval = Interop.service_multiple_ctors_new_failing(ref self._context, some_value);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_multiple_ctors_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public IntPtr Context => _context;
    }


    /// Services can use lifetimes. However, they are more dangerous to use
    /// via FFI, since you will not get any help tracking lifetimes there.
    public partial class ServiceUsingLifetimes : IDisposable
    {
        private IntPtr _context;

        private ServiceUsingLifetimes() {}

        public static ServiceUsingLifetimes NewWith(ref uint some_value)
        {
            var self = new ServiceUsingLifetimes();
            var rval = Interop.service_using_lifetimes_new_with(ref self._context, ref some_value);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_using_lifetimes_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void Lifetime1(SliceBool slice)
        {
            Interop.service_using_lifetimes_lifetime_1(_context, slice);
        }

        public void Lifetime2(SliceBool slice)
        {
            Interop.service_using_lifetimes_lifetime_2(_context, slice);
        }

        public string ReturnStringAcceptSlice(SliceU8 anon1)
        {
            var s = Interop.service_using_lifetimes_return_string_accept_slice(_context, anon1);
            return Marshal.PtrToStringAnsi(s);
        }

        public IntPtr Context => _context;
    }


    /// Some struct we want to expose as a class.
    public partial class ServiceVariousSlices : IDisposable
    {
        private IntPtr _context;

        private ServiceVariousSlices() {}

        public static ServiceVariousSlices New()
        {
            var self = new ServiceVariousSlices();
            var rval = Interop.service_various_slices_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_various_slices_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public byte MutSelf(SliceU8 slice)
        {
            return Interop.service_various_slices_mut_self(_context, slice);
        }

        /// Single line.
        public void MutSelfVoid(SliceBool slice)
        {
            Interop.service_various_slices_mut_self_void(_context, slice);
        }

        public byte MutSelfRef(ref byte x, out byte y)
        {
            return Interop.service_various_slices_mut_self_ref(_context, ref x, out y);
        }

        public byte MutSelfRefSlice(ref byte x, out byte y, SliceU8 slice)
        {
            return Interop.service_various_slices_mut_self_ref_slice(_context, ref x, out y, slice);
        }

        public byte MutSelfRefSliceLimited(ref byte x, out byte y, SliceU8 slice, SliceU8 slice2)
        {
            return Interop.service_various_slices_mut_self_ref_slice_limited(_context, ref x, out y, slice, slice2);
        }

        public void MutSelfFfiError(SliceMutU8 slice)
        {
            var rval = Interop.service_various_slices_mut_self_ffi_error(_context, slice);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void MutSelfNoError(SliceMutU8 slice)
        {
            var rval = Interop.service_various_slices_mut_self_no_error(_context, slice);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        /// Warning, you _must_ discard the returned slice object before calling into this service
        /// again, as otherwise undefined behavior might happen.
        public SliceU32 ReturnSlice()
        {
            return Interop.service_various_slices_return_slice(_context);
        }

        /// Warning, you _must_ discard the returned slice object before calling into this service
        /// again, as otherwise undefined behavior might happen.
        public SliceMutU32 ReturnSliceMut()
        {
            return Interop.service_various_slices_return_slice_mut(_context);
        }

        public IntPtr Context => _context;
    }


    /// Some struct we want to expose as a class.
    public partial class ServiceStrings : IDisposable
    {
        private IntPtr _context;

        private ServiceStrings() {}

        public static ServiceStrings New()
        {
            var self = new ServiceStrings();
            var rval = Interop.service_strings_new(ref self._context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
            return self;
        }

        public void Dispose()
        {
            var rval = Interop.service_strings_destroy(ref _context);
            if (rval != FFIError.Ok)
            {
                throw new InteropException<FFIError>(rval);
            }
        }

        public void PassString(string anon1)
        {
            Interop.service_strings_pass_string(_context, anon1);
        }

        public string ReturnString()
        {
            var s = Interop.service_strings_return_string(_context);
            return Marshal.PtrToStringAnsi(s);
        }

        public IntPtr Context => _context;
    }



    public class InteropException<T> : Exception
    {
        public T Error { get; private set; }

        public InteropException(T error): base($"Something went wrong: {error}")
        {
            Error = error;
        }
    }

}
