# FFI Call Overheads

The numbers below are to help FFI design decisions by giving order-of-magnitude estimates how
expensive certain constructs are.

Times were determined by running the given construct 1M times, taking the elapsed time in ticks,
and computing the cost per 1k invocations.


## System

The following system was used:    
    
```
System: AMD Ryzen 9 7950X3D, 64 GB RAM; Windows 11
rustc: stable (i.e., 1.82 or later)
profile: --release
Python: 3.11.5
```
    
## Results

| Construct | ns per call |
| --- | --- |
| `primitive_void()`                                 | 150 |
| `primitive_u8(0)`                                  | 254 |
| `primitive_u16(0)`                                 | 265 |
| `primitive_u32(0)`                                 | 241 |
| `primitive_u64(0)`                                 | 231 |
| `many_args_5(0, 0, 0, 0, 0)`                       | 501 |
| `ptr(x)`                                           | 281 |
| `tupled(r.Tupled())`                               | 281 |
| `complex_args_1(r.Vec3f32(), empty)`               | 508 |
| `callback(lambda x: x, 0)`                         | 755 |
| `pattern_ffi_slice_delegate(lambda x: x[0])`       | 850 |
