### Code generated by codegen/main.go. DO NOT EDIT. ###

extends RefCounted
class_name NakamaAPI

# A single user-role pair.
class GroupUserListGroupUser extends NakamaAsyncResult:

	const _SCHEMA = {
		"state": {"name": "_state", "type": TYPE_INT, "required": false},
		"user": {"name": "_user", "type": "ApiUser", "required": false},
	}

	# Their relationship to the group.
	var _state
	var state : int:
		get:
			return 0 if not _state is int else int(_state)

	# User.
	var _user
	var user : ApiUser:
		get:
			return _user as ApiUser

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> GroupUserListGroupUser:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "GroupUserListGroupUser", p_dict), GroupUserListGroupUser) as GroupUserListGroupUser

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "state: %s, " % _state
		output += "user: %s, " % _user
		return output

# A single group-role pair.
class UserGroupListUserGroup extends NakamaAsyncResult:

	const _SCHEMA = {
		"group": {"name": "_group", "type": "ApiGroup", "required": false},
		"state": {"name": "_state", "type": TYPE_INT, "required": false},
	}

	# Group.
	var _group
	var group : ApiGroup:
		get:
			return _group as ApiGroup

	# The user's relationship to the group.
	var _state
	var state : int:
		get:
			return 0 if not _state is int else int(_state)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> UserGroupListUserGroup:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "UserGroupListUserGroup", p_dict), UserGroupListUserGroup) as UserGroupListUserGroup

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "group: %s, " % _group
		output += "state: %s, " % _state
		return output

# Record values to write.
class WriteLeaderboardRecordRequestLeaderboardRecordWrite extends NakamaAsyncResult:

	const _SCHEMA = {
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"operator": {"name": "_operator", "type": TYPE_INT, "required": false},
		"score": {"name": "_score", "type": TYPE_STRING, "required": false},
		"subscore": {"name": "_subscore", "type": TYPE_STRING, "required": false},
	}

	# Optional record metadata.
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# Operator override.
	var _operator
	var operator : int:
		get:
			return ApiOperator.values()[0] if not ApiOperator.values().has(_operator) else _operator

	# The score value to submit.
	var _score
	var score : String:
		get:
			return "" if not _score is String else String(_score)

	# An optional secondary value.
	var _subscore
	var subscore : String:
		get:
			return "" if not _subscore is String else String(_subscore)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> WriteLeaderboardRecordRequestLeaderboardRecordWrite:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "WriteLeaderboardRecordRequestLeaderboardRecordWrite", p_dict), WriteLeaderboardRecordRequestLeaderboardRecordWrite) as WriteLeaderboardRecordRequestLeaderboardRecordWrite

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "metadata: %s, " % _metadata
		output += "operator: %s, " % _operator
		output += "score: %s, " % _score
		output += "subscore: %s, " % _subscore
		return output

# Record values to write.
class WriteTournamentRecordRequestTournamentRecordWrite extends NakamaAsyncResult:

	const _SCHEMA = {
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"operator": {"name": "_operator", "type": TYPE_INT, "required": false},
		"score": {"name": "_score", "type": TYPE_STRING, "required": false},
		"subscore": {"name": "_subscore", "type": TYPE_STRING, "required": false},
	}

	# A JSON object of additional properties (optional).
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# Operator override.
	var _operator
	var operator : int:
		get:
			return ApiOperator.values()[0] if not ApiOperator.values().has(_operator) else _operator

	# The score value to submit.
	var _score
	var score : String:
		get:
			return "" if not _score is String else String(_score)

	# An optional secondary value.
	var _subscore
	var subscore : String:
		get:
			return "" if not _subscore is String else String(_subscore)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> WriteTournamentRecordRequestTournamentRecordWrite:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "WriteTournamentRecordRequestTournamentRecordWrite", p_dict), WriteTournamentRecordRequestTournamentRecordWrite) as WriteTournamentRecordRequestTournamentRecordWrite

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "metadata: %s, " % _metadata
		output += "operator: %s, " % _operator
		output += "score: %s, " % _score
		output += "subscore: %s, " % _subscore
		return output

# A user with additional account details. Always the current user.
class ApiAccount extends NakamaAsyncResult:

	const _SCHEMA = {
		"custom_id": {"name": "_custom_id", "type": TYPE_STRING, "required": false},
		"devices": {"name": "_devices", "type": TYPE_ARRAY, "required": false, "content": "ApiAccountDevice"},
		"disable_time": {"name": "_disable_time", "type": TYPE_STRING, "required": false},
		"email": {"name": "_email", "type": TYPE_STRING, "required": false},
		"user": {"name": "_user", "type": "ApiUser", "required": false},
		"verify_time": {"name": "_verify_time", "type": TYPE_STRING, "required": false},
		"wallet": {"name": "_wallet", "type": TYPE_STRING, "required": false},
	}

	# The custom id in the user's account.
	var _custom_id
	var custom_id : String:
		get:
			return "" if not _custom_id is String else String(_custom_id)

	# The devices which belong to the user's account.
	var _devices
	var devices : Array:
		get:
			return Array() if not _devices is Array else Array(_devices)

	# The UNIX time when the user's account was disabled/banned.
	var _disable_time
	var disable_time : String:
		get:
			return "" if not _disable_time is String else String(_disable_time)

	# The email address of the user.
	var _email
	var email : String:
		get:
			return "" if not _email is String else String(_email)

	# The user object.
	var _user
	var user : ApiUser:
		get:
			return _user as ApiUser

	# The UNIX time when the user's email was verified.
	var _verify_time
	var verify_time : String:
		get:
			return "" if not _verify_time is String else String(_verify_time)

	# The user's wallet data.
	var _wallet
	var wallet : String:
		get:
			return "" if not _wallet is String else String(_wallet)

	var _wallet_dict = null
	var wallet_dict : Dictionary:
		get:
			if _wallet_dict == null:
				if _wallet == null:
					return {}
				var json = JSON.new()
				if json.parse(_wallet) != OK:
					return {}
				_wallet_dict = json.get_data()
			return _wallet_dict as Dictionary


	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccount:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccount", p_dict), ApiAccount) as ApiAccount

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "custom_id: %s, " % _custom_id
		output += "devices: %s, " % [_devices]
		output += "disable_time: %s, " % _disable_time
		output += "email: %s, " % _email
		output += "user: %s, " % _user
		output += "verify_time: %s, " % _verify_time
		output += "wallet: %s, " % _wallet
		return output

# Send a Apple Sign In token to the server. Used with authenticate/link/unlink.
class ApiAccountApple extends NakamaAsyncResult:

	const _SCHEMA = {
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# The ID token received from Apple to validate.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountApple:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountApple", p_dict), ApiAccountApple) as ApiAccountApple

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "token: %s, " % _token
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a custom ID to the server. Used with authenticate/link/unlink.
class ApiAccountCustom extends NakamaAsyncResult:

	const _SCHEMA = {
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# A custom identifier.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountCustom:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountCustom", p_dict), ApiAccountCustom) as ApiAccountCustom

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "id: %s, " % _id
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a device to the server. Used with authenticate/link/unlink and user.
class ApiAccountDevice extends NakamaAsyncResult:

	const _SCHEMA = {
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# A device identifier. Should be obtained by a platform-specific device API.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountDevice:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountDevice", p_dict), ApiAccountDevice) as ApiAccountDevice

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "id: %s, " % _id
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send an email with password to the server. Used with authenticate/link/unlink.
class ApiAccountEmail extends NakamaAsyncResult:

	const _SCHEMA = {
		"email": {"name": "_email", "type": TYPE_STRING, "required": false},
		"password": {"name": "_password", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# A valid RFC-5322 email address.
	var _email
	var email : String:
		get:
			return "" if not _email is String else String(_email)

	# A password for the user account.
	var _password
	var password : String:
		get:
			return "" if not _password is String else String(_password)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountEmail:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountEmail", p_dict), ApiAccountEmail) as ApiAccountEmail

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "email: %s, " % _email
		output += "password: %s, " % _password
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a Facebook token to the server. Used with authenticate/link/unlink.
class ApiAccountFacebook extends NakamaAsyncResult:

	const _SCHEMA = {
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# The OAuth token received from Facebook to access their profile API.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountFacebook:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountFacebook", p_dict), ApiAccountFacebook) as ApiAccountFacebook

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "token: %s, " % _token
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a Facebook Instant Game token to the server. Used with authenticate/link/unlink.
class ApiAccountFacebookInstantGame extends NakamaAsyncResult:

	const _SCHEMA = {
		"signed_player_info": {"name": "_signed_player_info", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	#
	var _signed_player_info
	var signed_player_info : String:
		get:
			return "" if not _signed_player_info is String else String(_signed_player_info)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountFacebookInstantGame:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountFacebookInstantGame", p_dict), ApiAccountFacebookInstantGame) as ApiAccountFacebookInstantGame

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "signed_player_info: %s, " % _signed_player_info
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send Apple's Game Center account credentials to the server. Used with authenticate/link/unlink.
class ApiAccountGameCenter extends NakamaAsyncResult:

	const _SCHEMA = {
		"bundle_id": {"name": "_bundle_id", "type": TYPE_STRING, "required": false},
		"player_id": {"name": "_player_id", "type": TYPE_STRING, "required": false},
		"public_key_url": {"name": "_public_key_url", "type": TYPE_STRING, "required": false},
		"salt": {"name": "_salt", "type": TYPE_STRING, "required": false},
		"signature": {"name": "_signature", "type": TYPE_STRING, "required": false},
		"timestamp_seconds": {"name": "_timestamp_seconds", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# Bundle ID (generated by GameCenter).
	var _bundle_id
	var bundle_id : String:
		get:
			return "" if not _bundle_id is String else String(_bundle_id)

	# Player ID (generated by GameCenter).
	var _player_id
	var player_id : String:
		get:
			return "" if not _player_id is String else String(_player_id)

	# The URL for the public encryption key.
	var _public_key_url
	var public_key_url : String:
		get:
			return "" if not _public_key_url is String else String(_public_key_url)

	# A random "NSString" used to compute the hash and keep it randomized.
	var _salt
	var salt : String:
		get:
			return "" if not _salt is String else String(_salt)

	# The verification signature data generated.
	var _signature
	var signature : String:
		get:
			return "" if not _signature is String else String(_signature)

	# Time since UNIX epoch when the signature was created.
	var _timestamp_seconds
	var timestamp_seconds : String:
		get:
			return "" if not _timestamp_seconds is String else String(_timestamp_seconds)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountGameCenter:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountGameCenter", p_dict), ApiAccountGameCenter) as ApiAccountGameCenter

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "bundle_id: %s, " % _bundle_id
		output += "player_id: %s, " % _player_id
		output += "public_key_url: %s, " % _public_key_url
		output += "salt: %s, " % _salt
		output += "signature: %s, " % _signature
		output += "timestamp_seconds: %s, " % _timestamp_seconds
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a Google token to the server. Used with authenticate/link/unlink.
class ApiAccountGoogle extends NakamaAsyncResult:

	const _SCHEMA = {
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# The OAuth token received from Google to access their profile API.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountGoogle:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountGoogle", p_dict), ApiAccountGoogle) as ApiAccountGoogle

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "token: %s, " % _token
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# Send a Steam token to the server. Used with authenticate/link/unlink.
class ApiAccountSteam extends NakamaAsyncResult:

	const _SCHEMA = {
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# The account token received from Steam to access their profile API.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiAccountSteam:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiAccountSteam", p_dict), ApiAccountSteam) as ApiAccountSteam

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "token: %s, " % _token
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# A message sent on a channel.
class ApiChannelMessage extends NakamaAsyncResult:

	const _SCHEMA = {
		"channel_id": {"name": "_channel_id", "type": TYPE_STRING, "required": false},
		"code": {"name": "_code", "type": TYPE_INT, "required": false},
		"content": {"name": "_content", "type": TYPE_STRING, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"group_id": {"name": "_group_id", "type": TYPE_STRING, "required": false},
		"message_id": {"name": "_message_id", "type": TYPE_STRING, "required": false},
		"persistent": {"name": "_persistent", "type": TYPE_BOOL, "required": false},
		"room_name": {"name": "_room_name", "type": TYPE_STRING, "required": false},
		"sender_id": {"name": "_sender_id", "type": TYPE_STRING, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"user_id_one": {"name": "_user_id_one", "type": TYPE_STRING, "required": false},
		"user_id_two": {"name": "_user_id_two", "type": TYPE_STRING, "required": false},
		"username": {"name": "_username", "type": TYPE_STRING, "required": false},
	}

	# The channel this message belongs to.
	var _channel_id
	var channel_id : String:
		get:
			return "" if not _channel_id is String else String(_channel_id)

	# The code representing a message type or category.
	var _code
	var code : int:
		get:
			return 0 if not _code is int else int(_code)

	# The content payload.
	var _content
	var content : String:
		get:
			return "" if not _content is String else String(_content)

	# The UNIX time when the message was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The ID of the group, or an empty string if this message was not sent through a group channel.
	var _group_id
	var group_id : String:
		get:
			return "" if not _group_id is String else String(_group_id)

	# The unique ID of this message.
	var _message_id
	var message_id : String:
		get:
			return "" if not _message_id is String else String(_message_id)

	# True if the message was persisted to the channel's history, false otherwise.
	var _persistent
	var persistent : bool:
		get:
			return false if not _persistent is bool else bool(_persistent)

	# The name of the chat room, or an empty string if this message was not sent through a chat room.
	var _room_name
	var room_name : String:
		get:
			return "" if not _room_name is String else String(_room_name)

	# Message sender, usually a user ID.
	var _sender_id
	var sender_id : String:
		get:
			return "" if not _sender_id is String else String(_sender_id)

	# The UNIX time when the message was last updated.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# The ID of the first DM user, or an empty string if this message was not sent through a DM chat.
	var _user_id_one
	var user_id_one : String:
		get:
			return "" if not _user_id_one is String else String(_user_id_one)

	# The ID of the second DM user, or an empty string if this message was not sent through a DM chat.
	var _user_id_two
	var user_id_two : String:
		get:
			return "" if not _user_id_two is String else String(_user_id_two)

	# The username of the message sender, if any.
	var _username
	var username : String:
		get:
			return "" if not _username is String else String(_username)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiChannelMessage:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiChannelMessage", p_dict), ApiChannelMessage) as ApiChannelMessage

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "channel_id: %s, " % _channel_id
		output += "code: %s, " % _code
		output += "content: %s, " % _content
		output += "create_time: %s, " % _create_time
		output += "group_id: %s, " % _group_id
		output += "message_id: %s, " % _message_id
		output += "persistent: %s, " % _persistent
		output += "room_name: %s, " % _room_name
		output += "sender_id: %s, " % _sender_id
		output += "update_time: %s, " % _update_time
		output += "user_id_one: %s, " % _user_id_one
		output += "user_id_two: %s, " % _user_id_two
		output += "username: %s, " % _username
		return output

# A list of channel messages, usually a result of a list operation.
class ApiChannelMessageList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cacheable_cursor": {"name": "_cacheable_cursor", "type": TYPE_STRING, "required": false},
		"messages": {"name": "_messages", "type": TYPE_ARRAY, "required": false, "content": "ApiChannelMessage"},
		"next_cursor": {"name": "_next_cursor", "type": TYPE_STRING, "required": false},
		"prev_cursor": {"name": "_prev_cursor", "type": TYPE_STRING, "required": false},
	}

	# Cacheable cursor to list newer messages. Durable and designed to be stored, unlike next/prev cursors.
	var _cacheable_cursor
	var cacheable_cursor : String:
		get:
			return "" if not _cacheable_cursor is String else String(_cacheable_cursor)

	# A list of messages.
	var _messages
	var messages : Array:
		get:
			return Array() if not _messages is Array else Array(_messages)

	# The cursor to send when retrieving the next page, if any.
	var _next_cursor
	var next_cursor : String:
		get:
			return "" if not _next_cursor is String else String(_next_cursor)

	# The cursor to send when retrieving the previous page, if any.
	var _prev_cursor
	var prev_cursor : String:
		get:
			return "" if not _prev_cursor is String else String(_prev_cursor)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiChannelMessageList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiChannelMessageList", p_dict), ApiChannelMessageList) as ApiChannelMessageList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cacheable_cursor: %s, " % _cacheable_cursor
		output += "messages: %s, " % [_messages]
		output += "next_cursor: %s, " % _next_cursor
		output += "prev_cursor: %s, " % _prev_cursor
		return output

# Create a group with the current user as owner.
class ApiCreateGroupRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"avatar_url": {"name": "_avatar_url", "type": TYPE_STRING, "required": false},
		"description": {"name": "_description", "type": TYPE_STRING, "required": false},
		"lang_tag": {"name": "_lang_tag", "type": TYPE_STRING, "required": false},
		"max_count": {"name": "_max_count", "type": TYPE_INT, "required": false},
		"name": {"name": "_name", "type": TYPE_STRING, "required": false},
		"open": {"name": "_open", "type": TYPE_BOOL, "required": false},
	}

	# A URL for an avatar image.
	var _avatar_url
	var avatar_url : String:
		get:
			return "" if not _avatar_url is String else String(_avatar_url)

	# A description for the group.
	var _description
	var description : String:
		get:
			return "" if not _description is String else String(_description)

	# The language expected to be a tag which follows the BCP-47 spec.
	var _lang_tag
	var lang_tag : String:
		get:
			return "" if not _lang_tag is String else String(_lang_tag)

	# Maximum number of group members.
	var _max_count
	var max_count : int:
		get:
			return 0 if not _max_count is int else int(_max_count)

	# A unique name for the group.
	var _name
	var name : String:
		get:
			return "" if not _name is String else String(_name)

	# Mark a group as open or not where only admins can accept members.
	var _open
	var open : bool:
		get:
			return false if not _open is bool else bool(_open)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiCreateGroupRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiCreateGroupRequest", p_dict), ApiCreateGroupRequest) as ApiCreateGroupRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "avatar_url: %s, " % _avatar_url
		output += "description: %s, " % _description
		output += "lang_tag: %s, " % _lang_tag
		output += "max_count: %s, " % _max_count
		output += "name: %s, " % _name
		output += "open: %s, " % _open
		return output

# Storage objects to delete.
class ApiDeleteStorageObjectId extends NakamaAsyncResult:

	const _SCHEMA = {
		"collection": {"name": "_collection", "type": TYPE_STRING, "required": false},
		"key": {"name": "_key", "type": TYPE_STRING, "required": false},
		"version": {"name": "_version", "type": TYPE_STRING, "required": false},
	}

	# The collection which stores the object.
	var _collection
	var collection : String:
		get:
			return "" if not _collection is String else String(_collection)

	# The key of the object within the collection.
	var _key
	var key : String:
		get:
			return "" if not _key is String else String(_key)

	# The version hash of the object.
	var _version
	var version : String:
		get:
			return "" if not _version is String else String(_version)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiDeleteStorageObjectId:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiDeleteStorageObjectId", p_dict), ApiDeleteStorageObjectId) as ApiDeleteStorageObjectId

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "collection: %s, " % _collection
		output += "key: %s, " % _key
		output += "version: %s, " % _version
		return output

# Batch delete storage objects.
class ApiDeleteStorageObjectsRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"object_ids": {"name": "_object_ids", "type": TYPE_ARRAY, "required": false, "content": "ApiDeleteStorageObjectId"},
	}

	# Batch of storage objects.
	var _object_ids
	var object_ids : Array:
		get:
			return Array() if not _object_ids is Array else Array(_object_ids)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiDeleteStorageObjectsRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiDeleteStorageObjectsRequest", p_dict), ApiDeleteStorageObjectsRequest) as ApiDeleteStorageObjectsRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "object_ids: %s, " % [_object_ids]
		return output

# Represents an event to be passed through the server to registered event handlers.
class ApiEvent extends NakamaAsyncResult:

	const _SCHEMA = {
		"external": {"name": "_external", "type": TYPE_BOOL, "required": false},
		"name": {"name": "_name", "type": TYPE_STRING, "required": false},
		"properties": {"name": "_properties", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
		"timestamp": {"name": "_timestamp", "type": TYPE_STRING, "required": false},
	}

	# True if the event came directly from a client call, false otherwise.
	var _external
	var external : bool:
		get:
			return false if not _external is bool else bool(_external)

	# An event name, type, category, or identifier.
	var _name
	var name : String:
		get:
			return "" if not _name is String else String(_name)

	# Arbitrary event property values.
	var _properties
	var properties : Dictionary:
		get:
			return Dictionary() if not _properties is Dictionary else _properties.duplicate()

	# The time when the event was triggered.
	var _timestamp
	var timestamp : String:
		get:
			return "" if not _timestamp is String else String(_timestamp)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiEvent:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiEvent", p_dict), ApiEvent) as ApiEvent

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "external: %s, " % _external
		output += "name: %s, " % _name
		var map_string : String = ""
		if typeof(_properties) == TYPE_DICTIONARY:
			for k in _properties:
				map_string += "{%s=%s}, " % [k, _properties[k]]
		output += "properties: [%s], " % map_string
		output += "timestamp: %s, " % _timestamp
		return output

# A friend of a user.
class ApiFriend extends NakamaAsyncResult:

	const _SCHEMA = {
		"state": {"name": "_state", "type": TYPE_INT, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"user": {"name": "_user", "type": "ApiUser", "required": false},
	}

	# The friend status.
	var _state
	var state : int:
		get:
			return 0 if not _state is int else int(_state)

	# Time of the latest relationship update.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# The user object.
	var _user
	var user : ApiUser:
		get:
			return _user as ApiUser

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiFriend:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiFriend", p_dict), ApiFriend) as ApiFriend

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "state: %s, " % _state
		output += "update_time: %s, " % _update_time
		output += "user: %s, " % _user
		return output

# A collection of zero or more friends of the user.
class ApiFriendList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"friends": {"name": "_friends", "type": TYPE_ARRAY, "required": false, "content": "ApiFriend"},
	}

	# Cursor for the next page of results, if any.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# The Friend objects.
	var _friends
	var friends : Array:
		get:
			return Array() if not _friends is Array else Array(_friends)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiFriendList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiFriendList", p_dict), ApiFriendList) as ApiFriendList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "friends: %s, " % [_friends]
		return output

# A group in the server.
class ApiGroup extends NakamaAsyncResult:

	const _SCHEMA = {
		"avatar_url": {"name": "_avatar_url", "type": TYPE_STRING, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"creator_id": {"name": "_creator_id", "type": TYPE_STRING, "required": false},
		"description": {"name": "_description", "type": TYPE_STRING, "required": false},
		"edge_count": {"name": "_edge_count", "type": TYPE_INT, "required": false},
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"lang_tag": {"name": "_lang_tag", "type": TYPE_STRING, "required": false},
		"max_count": {"name": "_max_count", "type": TYPE_INT, "required": false},
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"name": {"name": "_name", "type": TYPE_STRING, "required": false},
		"open": {"name": "_open", "type": TYPE_BOOL, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
	}

	# A URL for an avatar image.
	var _avatar_url
	var avatar_url : String:
		get:
			return "" if not _avatar_url is String else String(_avatar_url)

	# The UNIX time when the group was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The id of the user who created the group.
	var _creator_id
	var creator_id : String:
		get:
			return "" if not _creator_id is String else String(_creator_id)

	# A description for the group.
	var _description
	var description : String:
		get:
			return "" if not _description is String else String(_description)

	# The current count of all members in the group.
	var _edge_count
	var edge_count : int:
		get:
			return 0 if not _edge_count is int else int(_edge_count)

	# The id of a group.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# The language expected to be a tag which follows the BCP-47 spec.
	var _lang_tag
	var lang_tag : String:
		get:
			return "" if not _lang_tag is String else String(_lang_tag)

	# The maximum number of members allowed.
	var _max_count
	var max_count : int:
		get:
			return 0 if not _max_count is int else int(_max_count)

	# Additional information stored as a JSON object.
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# The unique name of the group.
	var _name
	var name : String:
		get:
			return "" if not _name is String else String(_name)

	# Anyone can join open groups, otherwise only admins can accept members.
	var _open
	var open : bool:
		get:
			return false if not _open is bool else bool(_open)

	# The UNIX time when the group was last updated.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiGroup:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiGroup", p_dict), ApiGroup) as ApiGroup

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "avatar_url: %s, " % _avatar_url
		output += "create_time: %s, " % _create_time
		output += "creator_id: %s, " % _creator_id
		output += "description: %s, " % _description
		output += "edge_count: %s, " % _edge_count
		output += "id: %s, " % _id
		output += "lang_tag: %s, " % _lang_tag
		output += "max_count: %s, " % _max_count
		output += "metadata: %s, " % _metadata
		output += "name: %s, " % _name
		output += "open: %s, " % _open
		output += "update_time: %s, " % _update_time
		return output

# One or more groups returned from a listing operation.
class ApiGroupList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"groups": {"name": "_groups", "type": TYPE_ARRAY, "required": false, "content": "ApiGroup"},
	}

	# A cursor used to get the next page.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# One or more groups.
	var _groups
	var groups : Array:
		get:
			return Array() if not _groups is Array else Array(_groups)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiGroupList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiGroupList", p_dict), ApiGroupList) as ApiGroupList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "groups: %s, " % [_groups]
		return output

# A list of users belonging to a group, along with their role.
class ApiGroupUserList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"group_users": {"name": "_group_users", "type": TYPE_ARRAY, "required": false, "content": "GroupUserListGroupUser"},
	}

	# Cursor for the next page of results, if any.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# User-role pairs for a group.
	var _group_users
	var group_users : Array:
		get:
			return Array() if not _group_users is Array else Array(_group_users)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiGroupUserList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiGroupUserList", p_dict), ApiGroupUserList) as ApiGroupUserList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "group_users: %s, " % [_group_users]
		return output

# Represents a complete leaderboard record with all scores and associated metadata.
class ApiLeaderboardRecord extends NakamaAsyncResult:

	const _SCHEMA = {
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"expiry_time": {"name": "_expiry_time", "type": TYPE_STRING, "required": false},
		"leaderboard_id": {"name": "_leaderboard_id", "type": TYPE_STRING, "required": false},
		"max_num_score": {"name": "_max_num_score", "type": TYPE_INT, "required": false},
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"num_score": {"name": "_num_score", "type": TYPE_INT, "required": false},
		"owner_id": {"name": "_owner_id", "type": TYPE_STRING, "required": false},
		"rank": {"name": "_rank", "type": TYPE_STRING, "required": false},
		"score": {"name": "_score", "type": TYPE_STRING, "required": false},
		"subscore": {"name": "_subscore", "type": TYPE_STRING, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"username": {"name": "_username", "type": TYPE_STRING, "required": false},
	}

	# The UNIX time when the leaderboard record was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The UNIX time when the leaderboard record expires.
	var _expiry_time
	var expiry_time : String:
		get:
			return "" if not _expiry_time is String else String(_expiry_time)

	# The ID of the leaderboard this score belongs to.
	var _leaderboard_id
	var leaderboard_id : String:
		get:
			return "" if not _leaderboard_id is String else String(_leaderboard_id)

	# The maximum number of score updates allowed by the owner.
	var _max_num_score
	var max_num_score : int:
		get:
			return 0 if not _max_num_score is int else int(_max_num_score)

	# Metadata.
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# The number of submissions to this score record.
	var _num_score
	var num_score : int:
		get:
			return 0 if not _num_score is int else int(_num_score)

	# The ID of the score owner, usually a user or group.
	var _owner_id
	var owner_id : String:
		get:
			return "" if not _owner_id is String else String(_owner_id)

	# The rank of this record.
	var _rank
	var rank : String:
		get:
			return "" if not _rank is String else String(_rank)

	# The score value.
	var _score
	var score : String:
		get:
			return "" if not _score is String else String(_score)

	# An optional subscore value.
	var _subscore
	var subscore : String:
		get:
			return "" if not _subscore is String else String(_subscore)

	# The UNIX time when the leaderboard record was updated.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# The username of the score owner, if the owner is a user.
	var _username
	var username : String:
		get:
			return "" if not _username is String else String(_username)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiLeaderboardRecord:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiLeaderboardRecord", p_dict), ApiLeaderboardRecord) as ApiLeaderboardRecord

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "create_time: %s, " % _create_time
		output += "expiry_time: %s, " % _expiry_time
		output += "leaderboard_id: %s, " % _leaderboard_id
		output += "max_num_score: %s, " % _max_num_score
		output += "metadata: %s, " % _metadata
		output += "num_score: %s, " % _num_score
		output += "owner_id: %s, " % _owner_id
		output += "rank: %s, " % _rank
		output += "score: %s, " % _score
		output += "subscore: %s, " % _subscore
		output += "update_time: %s, " % _update_time
		output += "username: %s, " % _username
		return output

# A set of leaderboard records, may be part of a leaderboard records page or a batch of individual records.
class ApiLeaderboardRecordList extends NakamaAsyncResult:

	const _SCHEMA = {
		"next_cursor": {"name": "_next_cursor", "type": TYPE_STRING, "required": false},
		"owner_records": {"name": "_owner_records", "type": TYPE_ARRAY, "required": false, "content": "ApiLeaderboardRecord"},
		"prev_cursor": {"name": "_prev_cursor", "type": TYPE_STRING, "required": false},
		"records": {"name": "_records", "type": TYPE_ARRAY, "required": false, "content": "ApiLeaderboardRecord"},
	}

	# The cursor to send when retrieving the next page, if any.
	var _next_cursor
	var next_cursor : String:
		get:
			return "" if not _next_cursor is String else String(_next_cursor)

	# A batched set of leaderboard records belonging to specified owners.
	var _owner_records
	var owner_records : Array:
		get:
			return Array() if not _owner_records is Array else Array(_owner_records)

	# The cursor to send when retrieving the previous page, if any.
	var _prev_cursor
	var prev_cursor : String:
		get:
			return "" if not _prev_cursor is String else String(_prev_cursor)

	# A list of leaderboard records.
	var _records
	var records : Array:
		get:
			return Array() if not _records is Array else Array(_records)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiLeaderboardRecordList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiLeaderboardRecordList", p_dict), ApiLeaderboardRecordList) as ApiLeaderboardRecordList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "next_cursor: %s, " % _next_cursor
		output += "owner_records: %s, " % [_owner_records]
		output += "prev_cursor: %s, " % _prev_cursor
		output += "records: %s, " % [_records]
		return output

# Link Steam to the current user's account.
class ApiLinkSteamRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"account": {"name": "_account", "type": "ApiAccountSteam", "required": false},
		"sync": {"name": "_sync", "type": TYPE_BOOL, "required": false},
	}

	# The Facebook account details.
	var _account
	var account : ApiAccountSteam:
		get:
			return _account as ApiAccountSteam

	# Import Steam friends for the user.
	var _sync
	var sync : bool:
		get:
			return false if not _sync is bool else bool(_sync)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiLinkSteamRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiLinkSteamRequest", p_dict), ApiLinkSteamRequest) as ApiLinkSteamRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "account: %s, " % _account
		output += "sync: %s, " % _sync
		return output

# List user subscriptions.
class ApiListSubscriptionsRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"limit": {"name": "_limit", "type": TYPE_INT, "required": false},
	}

	#
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	#
	var _limit
	var limit : int:
		get:
			return 0 if not _limit is int else int(_limit)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiListSubscriptionsRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiListSubscriptionsRequest", p_dict), ApiListSubscriptionsRequest) as ApiListSubscriptionsRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "limit: %s, " % _limit
		return output

# Represents a realtime match.
class ApiMatch extends NakamaAsyncResult:

	const _SCHEMA = {
		"authoritative": {"name": "_authoritative", "type": TYPE_BOOL, "required": false},
		"handler_name": {"name": "_handler_name", "type": TYPE_STRING, "required": false},
		"label": {"name": "_label", "type": TYPE_STRING, "required": false},
		"match_id": {"name": "_match_id", "type": TYPE_STRING, "required": false},
		"size": {"name": "_size", "type": TYPE_INT, "required": false},
		"tick_rate": {"name": "_tick_rate", "type": TYPE_INT, "required": false},
	}

	# True if it's an server-managed authoritative match, false otherwise.
	var _authoritative
	var authoritative : bool:
		get:
			return false if not _authoritative is bool else bool(_authoritative)

	#
	var _handler_name
	var handler_name : String:
		get:
			return "" if not _handler_name is String else String(_handler_name)

	# Match label, if any.
	var _label
	var label : String:
		get:
			return "" if not _label is String else String(_label)

	# The ID of the match, can be used to join.
	var _match_id
	var match_id : String:
		get:
			return "" if not _match_id is String else String(_match_id)

	# Current number of users in the match.
	var _size
	var size : int:
		get:
			return 0 if not _size is int else int(_size)

	#
	var _tick_rate
	var tick_rate : int:
		get:
			return 0 if not _tick_rate is int else int(_tick_rate)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiMatch:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiMatch", p_dict), ApiMatch) as ApiMatch

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "authoritative: %s, " % _authoritative
		output += "handler_name: %s, " % _handler_name
		output += "label: %s, " % _label
		output += "match_id: %s, " % _match_id
		output += "size: %s, " % _size
		output += "tick_rate: %s, " % _tick_rate
		return output

# A list of realtime matches.
class ApiMatchList extends NakamaAsyncResult:

	const _SCHEMA = {
		"matches": {"name": "_matches", "type": TYPE_ARRAY, "required": false, "content": "ApiMatch"},
	}

	# A number of matches corresponding to a list operation.
	var _matches
	var matches : Array:
		get:
			return Array() if not _matches is Array else Array(_matches)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiMatchList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiMatchList", p_dict), ApiMatchList) as ApiMatchList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "matches: %s, " % [_matches]
		return output

# A notification in the server.
class ApiNotification extends NakamaAsyncResult:

	const _SCHEMA = {
		"code": {"name": "_code", "type": TYPE_INT, "required": false},
		"content": {"name": "_content", "type": TYPE_STRING, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"persistent": {"name": "_persistent", "type": TYPE_BOOL, "required": false},
		"sender_id": {"name": "_sender_id", "type": TYPE_STRING, "required": false},
		"subject": {"name": "_subject", "type": TYPE_STRING, "required": false},
	}

	# Category code for this notification.
	var _code
	var code : int:
		get:
			return 0 if not _code is int else int(_code)

	# Content of the notification in JSON.
	var _content
	var content : String:
		get:
			return "" if not _content is String else String(_content)

	# The UNIX time when the notification was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# ID of the Notification.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# True if this notification was persisted to the database.
	var _persistent
	var persistent : bool:
		get:
			return false if not _persistent is bool else bool(_persistent)

	# ID of the sender, if a user. Otherwise 'null'.
	var _sender_id
	var sender_id : String:
		get:
			return "" if not _sender_id is String else String(_sender_id)

	# Subject of the notification.
	var _subject
	var subject : String:
		get:
			return "" if not _subject is String else String(_subject)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiNotification:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiNotification", p_dict), ApiNotification) as ApiNotification

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "code: %s, " % _code
		output += "content: %s, " % _content
		output += "create_time: %s, " % _create_time
		output += "id: %s, " % _id
		output += "persistent: %s, " % _persistent
		output += "sender_id: %s, " % _sender_id
		output += "subject: %s, " % _subject
		return output

# A collection of zero or more notifications.
class ApiNotificationList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cacheable_cursor": {"name": "_cacheable_cursor", "type": TYPE_STRING, "required": false},
		"notifications": {"name": "_notifications", "type": TYPE_ARRAY, "required": false, "content": "ApiNotification"},
	}

	# Use this cursor to paginate notifications. Cache this to catch up to new notifications.
	var _cacheable_cursor
	var cacheable_cursor : String:
		get:
			return "" if not _cacheable_cursor is String else String(_cacheable_cursor)

	# Collection of notifications.
	var _notifications
	var notifications : Array:
		get:
			return Array() if not _notifications is Array else Array(_notifications)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiNotificationList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiNotificationList", p_dict), ApiNotificationList) as ApiNotificationList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cacheable_cursor: %s, " % _cacheable_cursor
		output += "notifications: %s, " % [_notifications]
		return output

# Operator that can be used to override the one set in the leaderboard.
#  - NO_OVERRIDE: Do not override the leaderboard operator.
#  - BEST: Override the leaderboard operator with BEST.
#  - SET: Override the leaderboard operator with SET.
#  - INCREMENT: Override the leaderboard operator with INCREMENT.
#  - DECREMENT: Override the leaderboard operator with DECREMENT.# [ - NO_OVERRIDE: Do not override the leaderboard operator.  - BEST: Override the leaderboard operator with BEST.  - SET: Override the leaderboard operator with SET.  - INCREMENT: Override the leaderboard operator with INCREMENT.  - DECREMENT: Override the leaderboard operator with DECREMENT.]
enum ApiOperator {NO_OVERRIDE = 0,BEST = 1,SET = 2,INCREMENT = 3,DECREMENT = 4,}

# Storage objects to get.
class ApiReadStorageObjectId extends NakamaAsyncResult:

	const _SCHEMA = {
		"collection": {"name": "_collection", "type": TYPE_STRING, "required": false},
		"key": {"name": "_key", "type": TYPE_STRING, "required": false},
		"user_id": {"name": "_user_id", "type": TYPE_STRING, "required": false},
	}

	# The collection which stores the object.
	var _collection
	var collection : String:
		get:
			return "" if not _collection is String else String(_collection)

	# The key of the object within the collection.
	var _key
	var key : String:
		get:
			return "" if not _key is String else String(_key)

	# The user owner of the object.
	var _user_id
	var user_id : String:
		get:
			return "" if not _user_id is String else String(_user_id)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiReadStorageObjectId:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiReadStorageObjectId", p_dict), ApiReadStorageObjectId) as ApiReadStorageObjectId

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "collection: %s, " % _collection
		output += "key: %s, " % _key
		output += "user_id: %s, " % _user_id
		return output

# Batch get storage objects.
class ApiReadStorageObjectsRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"object_ids": {"name": "_object_ids", "type": TYPE_ARRAY, "required": false, "content": "ApiReadStorageObjectId"},
	}

	# Batch of storage objects.
	var _object_ids
	var object_ids : Array:
		get:
			return Array() if not _object_ids is Array else Array(_object_ids)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiReadStorageObjectsRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiReadStorageObjectsRequest", p_dict), ApiReadStorageObjectsRequest) as ApiReadStorageObjectsRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "object_ids: %s, " % [_object_ids]
		return output

# Execute an Lua function on the server.
class ApiRpc extends NakamaAsyncResult:

	const _SCHEMA = {
		"http_key": {"name": "_http_key", "type": TYPE_STRING, "required": false},
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"payload": {"name": "_payload", "type": TYPE_STRING, "required": false},
	}

	# The authentication key used when executed as a non-client HTTP request.
	var _http_key
	var http_key : String:
		get:
			return "" if not _http_key is String else String(_http_key)

	# The identifier of the function.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# The payload of the function which must be a JSON object.
	var _payload
	var payload : String:
		get:
			return "" if not _payload is String else String(_payload)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiRpc:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiRpc", p_dict), ApiRpc) as ApiRpc

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "http_key: %s, " % _http_key
		output += "id: %s, " % _id
		output += "payload: %s, " % _payload
		return output

# A user's session used to authenticate messages.
class ApiSession extends NakamaAsyncResult:

	const _SCHEMA = {
		"created": {"name": "_created", "type": TYPE_BOOL, "required": false},
		"refresh_token": {"name": "_refresh_token", "type": TYPE_STRING, "required": false},
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
	}

	# True if the corresponding account was just created, false otherwise.
	var _created
	var created : bool:
		get:
			return false if not _created is bool else bool(_created)

	# Refresh token that can be used for session token renewal.
	var _refresh_token
	var refresh_token : String:
		get:
			return "" if not _refresh_token is String else String(_refresh_token)

	# Authentication credentials.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiSession:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiSession", p_dict), ApiSession) as ApiSession

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "created: %s, " % _created
		output += "refresh_token: %s, " % _refresh_token
		output += "token: %s, " % _token
		return output

# Log out a session, invalidate a refresh token, or log out all sessions/refresh tokens for a user.
class ApiSessionLogoutRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"refresh_token": {"name": "_refresh_token", "type": TYPE_STRING, "required": false},
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
	}

	# Refresh token to invalidate.
	var _refresh_token
	var refresh_token : String:
		get:
			return "" if not _refresh_token is String else String(_refresh_token)

	# Session token to log out.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiSessionLogoutRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiSessionLogoutRequest", p_dict), ApiSessionLogoutRequest) as ApiSessionLogoutRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "refresh_token: %s, " % _refresh_token
		output += "token: %s, " % _token
		return output

# Authenticate against the server with a refresh token.
class ApiSessionRefreshRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"token": {"name": "_token", "type": TYPE_STRING, "required": false},
		"vars": {"name": "_vars", "type": TYPE_DICTIONARY, "required": false, "content": TYPE_STRING},
	}

	# Refresh token.
	var _token
	var token : String:
		get:
			return "" if not _token is String else String(_token)

	# Extra information that will be bundled in the session token.
	var _vars
	var vars : Dictionary:
		get:
			return Dictionary() if not _vars is Dictionary else _vars.duplicate()

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiSessionRefreshRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiSessionRefreshRequest", p_dict), ApiSessionRefreshRequest) as ApiSessionRefreshRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "token: %s, " % _token
		var map_string : String = ""
		if typeof(_vars) == TYPE_DICTIONARY:
			for k in _vars:
				map_string += "{%s=%s}, " % [k, _vars[k]]
		output += "vars: [%s], " % map_string
		return output

# An object within the storage engine.
class ApiStorageObject extends NakamaAsyncResult:

	const _SCHEMA = {
		"collection": {"name": "_collection", "type": TYPE_STRING, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"key": {"name": "_key", "type": TYPE_STRING, "required": false},
		"permission_read": {"name": "_permission_read", "type": TYPE_INT, "required": false},
		"permission_write": {"name": "_permission_write", "type": TYPE_INT, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"user_id": {"name": "_user_id", "type": TYPE_STRING, "required": false},
		"value": {"name": "_value", "type": TYPE_STRING, "required": false},
		"version": {"name": "_version", "type": TYPE_STRING, "required": false},
	}

	# The collection which stores the object.
	var _collection
	var collection : String:
		get:
			return "" if not _collection is String else String(_collection)

	# The UNIX time when the object was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The key of the object within the collection.
	var _key
	var key : String:
		get:
			return "" if not _key is String else String(_key)

	# The read access permissions for the object.
	var _permission_read
	var permission_read : int:
		get:
			return 0 if not _permission_read is int else int(_permission_read)

	# The write access permissions for the object.
	var _permission_write
	var permission_write : int:
		get:
			return 0 if not _permission_write is int else int(_permission_write)

	# The UNIX time when the object was last updated.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# The user owner of the object.
	var _user_id
	var user_id : String:
		get:
			return "" if not _user_id is String else String(_user_id)

	# The value of the object.
	var _value
	var value : String:
		get:
			return "" if not _value is String else String(_value)

	# The version hash of the object.
	var _version
	var version : String:
		get:
			return "" if not _version is String else String(_version)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiStorageObject:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiStorageObject", p_dict), ApiStorageObject) as ApiStorageObject

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "collection: %s, " % _collection
		output += "create_time: %s, " % _create_time
		output += "key: %s, " % _key
		output += "permission_read: %s, " % _permission_read
		output += "permission_write: %s, " % _permission_write
		output += "update_time: %s, " % _update_time
		output += "user_id: %s, " % _user_id
		output += "value: %s, " % _value
		output += "version: %s, " % _version
		return output

# A storage acknowledgement.
class ApiStorageObjectAck extends NakamaAsyncResult:

	const _SCHEMA = {
		"collection": {"name": "_collection", "type": TYPE_STRING, "required": false},
		"key": {"name": "_key", "type": TYPE_STRING, "required": false},
		"user_id": {"name": "_user_id", "type": TYPE_STRING, "required": false},
		"version": {"name": "_version", "type": TYPE_STRING, "required": false},
	}

	# The collection which stores the object.
	var _collection
	var collection : String:
		get:
			return "" if not _collection is String else String(_collection)

	# The key of the object within the collection.
	var _key
	var key : String:
		get:
			return "" if not _key is String else String(_key)

	# The owner of the object.
	var _user_id
	var user_id : String:
		get:
			return "" if not _user_id is String else String(_user_id)

	# The version hash of the object.
	var _version
	var version : String:
		get:
			return "" if not _version is String else String(_version)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiStorageObjectAck:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiStorageObjectAck", p_dict), ApiStorageObjectAck) as ApiStorageObjectAck

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "collection: %s, " % _collection
		output += "key: %s, " % _key
		output += "user_id: %s, " % _user_id
		output += "version: %s, " % _version
		return output

# Batch of acknowledgements for the storage object write.
class ApiStorageObjectAcks extends NakamaAsyncResult:

	const _SCHEMA = {
		"acks": {"name": "_acks", "type": TYPE_ARRAY, "required": false, "content": "ApiStorageObjectAck"},
	}

	# Batch of storage write acknowledgements.
	var _acks
	var acks : Array:
		get:
			return Array() if not _acks is Array else Array(_acks)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiStorageObjectAcks:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiStorageObjectAcks", p_dict), ApiStorageObjectAcks) as ApiStorageObjectAcks

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "acks: %s, " % [_acks]
		return output

# List of storage objects.
class ApiStorageObjectList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"objects": {"name": "_objects", "type": TYPE_ARRAY, "required": false, "content": "ApiStorageObject"},
	}

	# The cursor for the next page of results, if any.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# The list of storage objects.
	var _objects
	var objects : Array:
		get:
			return Array() if not _objects is Array else Array(_objects)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiStorageObjectList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiStorageObjectList", p_dict), ApiStorageObjectList) as ApiStorageObjectList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "objects: %s, " % [_objects]
		return output

# Batch of storage objects.
class ApiStorageObjects extends NakamaAsyncResult:

	const _SCHEMA = {
		"objects": {"name": "_objects", "type": TYPE_ARRAY, "required": false, "content": "ApiStorageObject"},
	}

	# The batch of storage objects.
	var _objects
	var objects : Array:
		get:
			return Array() if not _objects is Array else Array(_objects)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiStorageObjects:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiStorageObjects", p_dict), ApiStorageObjects) as ApiStorageObjects

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "objects: %s, " % [_objects]
		return output

# Environment where a purchase/subscription took place,
# - UNKNOWN: Unknown environment.
#  - SANDBOX: Sandbox/test environment.
#  - PRODUCTION: Production environment.# [- UNKNOWN: Unknown environment.  - SANDBOX: Sandbox/test environment.  - PRODUCTION: Production environment.]
enum ApiStoreEnvironment {UNKNOWN = 0,SANDBOX = 1,PRODUCTION = 2,}

# Validation Provider,
# - APPLE_APP_STORE: Apple App Store
#  - GOOGLE_PLAY_STORE: Google Play Store
#  - HUAWEI_APP_GALLERY: Huawei App Gallery# [- APPLE_APP_STORE: Apple App Store  - GOOGLE_PLAY_STORE: Google Play Store  - HUAWEI_APP_GALLERY: Huawei App Gallery]
enum ApiStoreProvider {APPLE_APP_STORE = 0,GOOGLE_PLAY_STORE = 1,HUAWEI_APP_GALLERY = 2,}

# A list of validated subscriptions stored by Nakama.
class ApiSubscriptionList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"prev_cursor": {"name": "_prev_cursor", "type": TYPE_STRING, "required": false},
		"validated_subscriptions": {"name": "_validated_subscriptions", "type": TYPE_ARRAY, "required": false, "content": "ApiValidatedSubscription"},
	}

	# The cursor to send when retrieving the next page, if any.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# The cursor to send when retrieving the previous page, if any.
	var _prev_cursor
	var prev_cursor : String:
		get:
			return "" if not _prev_cursor is String else String(_prev_cursor)

	# Stored validated subscriptions.
	var _validated_subscriptions
	var validated_subscriptions : Array:
		get:
			return Array() if not _validated_subscriptions is Array else Array(_validated_subscriptions)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiSubscriptionList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiSubscriptionList", p_dict), ApiSubscriptionList) as ApiSubscriptionList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "prev_cursor: %s, " % _prev_cursor
		output += "validated_subscriptions: %s, " % [_validated_subscriptions]
		return output

# A tournament on the server.
class ApiTournament extends NakamaAsyncResult:

	const _SCHEMA = {
		"authoritative": {"name": "_authoritative", "type": TYPE_BOOL, "required": false},
		"can_enter": {"name": "_can_enter", "type": TYPE_BOOL, "required": false},
		"category": {"name": "_category", "type": TYPE_INT, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"description": {"name": "_description", "type": TYPE_STRING, "required": false},
		"duration": {"name": "_duration", "type": TYPE_INT, "required": false},
		"end_active": {"name": "_end_active", "type": TYPE_INT, "required": false},
		"end_time": {"name": "_end_time", "type": TYPE_STRING, "required": false},
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"max_num_score": {"name": "_max_num_score", "type": TYPE_INT, "required": false},
		"max_size": {"name": "_max_size", "type": TYPE_INT, "required": false},
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"next_reset": {"name": "_next_reset", "type": TYPE_INT, "required": false},
		"operator": {"name": "_operator", "type": TYPE_INT, "required": false},
		"prev_reset": {"name": "_prev_reset", "type": TYPE_INT, "required": false},
		"size": {"name": "_size", "type": TYPE_INT, "required": false},
		"sort_order": {"name": "_sort_order", "type": TYPE_INT, "required": false},
		"start_active": {"name": "_start_active", "type": TYPE_INT, "required": false},
		"start_time": {"name": "_start_time", "type": TYPE_STRING, "required": false},
		"title": {"name": "_title", "type": TYPE_STRING, "required": false},
	}

	# Whether the leaderboard was created authoritatively or not.
	var _authoritative
	var authoritative : bool:
		get:
			return false if not _authoritative is bool else bool(_authoritative)

	# True if the tournament is active and can enter. A computed value.
	var _can_enter
	var can_enter : bool:
		get:
			return false if not _can_enter is bool else bool(_can_enter)

	# The category of the tournament. e.g. "vip" could be category 1.
	var _category
	var category : int:
		get:
			return 0 if not _category is int else int(_category)

	# The UNIX time when the tournament was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The description of the tournament. May be blank.
	var _description
	var description : String:
		get:
			return "" if not _description is String else String(_description)

	# Duration of the tournament in seconds.
	var _duration
	var duration : int:
		get:
			return 0 if not _duration is int else int(_duration)

	# The UNIX time when the tournament stops being active until next reset. A computed value.
	var _end_active
	var end_active : int:
		get:
			return 0 if not _end_active is int else int(_end_active)

	# The UNIX time when the tournament will be stopped.
	var _end_time
	var end_time : String:
		get:
			return "" if not _end_time is String else String(_end_time)

	# The ID of the tournament.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# The maximum score updates allowed per player for the current tournament.
	var _max_num_score
	var max_num_score : int:
		get:
			return 0 if not _max_num_score is int else int(_max_num_score)

	# The maximum number of players for the tournament.
	var _max_size
	var max_size : int:
		get:
			return 0 if not _max_size is int else int(_max_size)

	# Additional information stored as a JSON object.
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# The UNIX time when the tournament is next playable. A computed value.
	var _next_reset
	var next_reset : int:
		get:
			return 0 if not _next_reset is int else int(_next_reset)

	# Operator.
	var _operator
	var operator : int:
		get:
			return ApiOperator.values()[0] if not ApiOperator.values().has(_operator) else _operator

	# The UNIX time when the tournament was last reset. A computed value.
	var _prev_reset
	var prev_reset : int:
		get:
			return 0 if not _prev_reset is int else int(_prev_reset)

	# The current number of players in the tournament.
	var _size
	var size : int:
		get:
			return 0 if not _size is int else int(_size)

	# ASC (0) or DESC (1) sort mode of scores in the tournament.
	var _sort_order
	var sort_order : int:
		get:
			return 0 if not _sort_order is int else int(_sort_order)

	# The UNIX time when the tournament start being active. A computed value.
	var _start_active
	var start_active : int:
		get:
			return 0 if not _start_active is int else int(_start_active)

	# The UNIX time when the tournament will start.
	var _start_time
	var start_time : String:
		get:
			return "" if not _start_time is String else String(_start_time)

	# The title for the tournament.
	var _title
	var title : String:
		get:
			return "" if not _title is String else String(_title)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiTournament:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiTournament", p_dict), ApiTournament) as ApiTournament

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "authoritative: %s, " % _authoritative
		output += "can_enter: %s, " % _can_enter
		output += "category: %s, " % _category
		output += "create_time: %s, " % _create_time
		output += "description: %s, " % _description
		output += "duration: %s, " % _duration
		output += "end_active: %s, " % _end_active
		output += "end_time: %s, " % _end_time
		output += "id: %s, " % _id
		output += "max_num_score: %s, " % _max_num_score
		output += "max_size: %s, " % _max_size
		output += "metadata: %s, " % _metadata
		output += "next_reset: %s, " % _next_reset
		output += "operator: %s, " % _operator
		output += "prev_reset: %s, " % _prev_reset
		output += "size: %s, " % _size
		output += "sort_order: %s, " % _sort_order
		output += "start_active: %s, " % _start_active
		output += "start_time: %s, " % _start_time
		output += "title: %s, " % _title
		return output

# A list of tournaments.
class ApiTournamentList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"tournaments": {"name": "_tournaments", "type": TYPE_ARRAY, "required": false, "content": "ApiTournament"},
	}

	# A pagination cursor (optional).
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# The list of tournaments returned.
	var _tournaments
	var tournaments : Array:
		get:
			return Array() if not _tournaments is Array else Array(_tournaments)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiTournamentList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiTournamentList", p_dict), ApiTournamentList) as ApiTournamentList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "tournaments: %s, " % [_tournaments]
		return output

# A set of tournament records which may be part of a tournament records page or a batch of individual records.
class ApiTournamentRecordList extends NakamaAsyncResult:

	const _SCHEMA = {
		"next_cursor": {"name": "_next_cursor", "type": TYPE_STRING, "required": false},
		"owner_records": {"name": "_owner_records", "type": TYPE_ARRAY, "required": false, "content": "ApiLeaderboardRecord"},
		"prev_cursor": {"name": "_prev_cursor", "type": TYPE_STRING, "required": false},
		"records": {"name": "_records", "type": TYPE_ARRAY, "required": false, "content": "ApiLeaderboardRecord"},
	}

	# The cursor to send when retireving the next page (optional).
	var _next_cursor
	var next_cursor : String:
		get:
			return "" if not _next_cursor is String else String(_next_cursor)

	# A batched set of tournament records belonging to specified owners.
	var _owner_records
	var owner_records : Array:
		get:
			return Array() if not _owner_records is Array else Array(_owner_records)

	# The cursor to send when retrieving the previous page (optional).
	var _prev_cursor
	var prev_cursor : String:
		get:
			return "" if not _prev_cursor is String else String(_prev_cursor)

	# A list of tournament records.
	var _records
	var records : Array:
		get:
			return Array() if not _records is Array else Array(_records)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiTournamentRecordList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiTournamentRecordList", p_dict), ApiTournamentRecordList) as ApiTournamentRecordList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "next_cursor: %s, " % _next_cursor
		output += "owner_records: %s, " % [_owner_records]
		output += "prev_cursor: %s, " % _prev_cursor
		output += "records: %s, " % [_records]
		return output

# Update a user's account details.
class ApiUpdateAccountRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"avatar_url": {"name": "_avatar_url", "type": TYPE_STRING, "required": false},
		"display_name": {"name": "_display_name", "type": TYPE_STRING, "required": false},
		"lang_tag": {"name": "_lang_tag", "type": TYPE_STRING, "required": false},
		"location": {"name": "_location", "type": TYPE_STRING, "required": false},
		"timezone": {"name": "_timezone", "type": TYPE_STRING, "required": false},
		"username": {"name": "_username", "type": TYPE_STRING, "required": false},
	}

	# A URL for an avatar image.
	var _avatar_url
	var avatar_url : String:
		get:
			return "" if not _avatar_url is String else String(_avatar_url)

	# The display name of the user.
	var _display_name
	var display_name : String:
		get:
			return "" if not _display_name is String else String(_display_name)

	# The language expected to be a tag which follows the BCP-47 spec.
	var _lang_tag
	var lang_tag : String:
		get:
			return "" if not _lang_tag is String else String(_lang_tag)

	# The location set by the user.
	var _location
	var location : String:
		get:
			return "" if not _location is String else String(_location)

	# The timezone set by the user.
	var _timezone
	var timezone : String:
		get:
			return "" if not _timezone is String else String(_timezone)

	# The username of the user's account.
	var _username
	var username : String:
		get:
			return "" if not _username is String else String(_username)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiUpdateAccountRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiUpdateAccountRequest", p_dict), ApiUpdateAccountRequest) as ApiUpdateAccountRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "avatar_url: %s, " % _avatar_url
		output += "display_name: %s, " % _display_name
		output += "lang_tag: %s, " % _lang_tag
		output += "location: %s, " % _location
		output += "timezone: %s, " % _timezone
		output += "username: %s, " % _username
		return output

# Update fields in a given group.
class ApiUpdateGroupRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"avatar_url": {"name": "_avatar_url", "type": TYPE_STRING, "required": false},
		"description": {"name": "_description", "type": TYPE_STRING, "required": false},
		"group_id": {"name": "_group_id", "type": TYPE_STRING, "required": false},
		"lang_tag": {"name": "_lang_tag", "type": TYPE_STRING, "required": false},
		"name": {"name": "_name", "type": TYPE_STRING, "required": false},
		"open": {"name": "_open", "type": TYPE_BOOL, "required": false},
	}

	# Avatar URL.
	var _avatar_url
	var avatar_url : String:
		get:
			return "" if not _avatar_url is String else String(_avatar_url)

	# Description string.
	var _description
	var description : String:
		get:
			return "" if not _description is String else String(_description)

	# The ID of the group to update.
	var _group_id
	var group_id : String:
		get:
			return "" if not _group_id is String else String(_group_id)

	# Lang tag.
	var _lang_tag
	var lang_tag : String:
		get:
			return "" if not _lang_tag is String else String(_lang_tag)

	# Name.
	var _name
	var name : String:
		get:
			return "" if not _name is String else String(_name)

	# Open is true if anyone should be allowed to join, or false if joins must be approved by a group admin.
	var _open
	var open : bool:
		get:
			return false if not _open is bool else bool(_open)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiUpdateGroupRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiUpdateGroupRequest", p_dict), ApiUpdateGroupRequest) as ApiUpdateGroupRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "avatar_url: %s, " % _avatar_url
		output += "description: %s, " % _description
		output += "group_id: %s, " % _group_id
		output += "lang_tag: %s, " % _lang_tag
		output += "name: %s, " % _name
		output += "open: %s, " % _open
		return output

# A user in the server.
class ApiUser extends NakamaAsyncResult:

	const _SCHEMA = {
		"apple_id": {"name": "_apple_id", "type": TYPE_STRING, "required": false},
		"avatar_url": {"name": "_avatar_url", "type": TYPE_STRING, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"display_name": {"name": "_display_name", "type": TYPE_STRING, "required": false},
		"edge_count": {"name": "_edge_count", "type": TYPE_INT, "required": false},
		"facebook_id": {"name": "_facebook_id", "type": TYPE_STRING, "required": false},
		"facebook_instant_game_id": {"name": "_facebook_instant_game_id", "type": TYPE_STRING, "required": false},
		"gamecenter_id": {"name": "_gamecenter_id", "type": TYPE_STRING, "required": false},
		"google_id": {"name": "_google_id", "type": TYPE_STRING, "required": false},
		"id": {"name": "_id", "type": TYPE_STRING, "required": false},
		"lang_tag": {"name": "_lang_tag", "type": TYPE_STRING, "required": false},
		"location": {"name": "_location", "type": TYPE_STRING, "required": false},
		"metadata": {"name": "_metadata", "type": TYPE_STRING, "required": false},
		"online": {"name": "_online", "type": TYPE_BOOL, "required": false},
		"steam_id": {"name": "_steam_id", "type": TYPE_STRING, "required": false},
		"timezone": {"name": "_timezone", "type": TYPE_STRING, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"username": {"name": "_username", "type": TYPE_STRING, "required": false},
	}

	# The Apple Sign In ID in the user's account.
	var _apple_id
	var apple_id : String:
		get:
			return "" if not _apple_id is String else String(_apple_id)

	# A URL for an avatar image.
	var _avatar_url
	var avatar_url : String:
		get:
			return "" if not _avatar_url is String else String(_avatar_url)

	# The UNIX time when the user was created.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# The display name of the user.
	var _display_name
	var display_name : String:
		get:
			return "" if not _display_name is String else String(_display_name)

	# Number of related edges to this user.
	var _edge_count
	var edge_count : int:
		get:
			return 0 if not _edge_count is int else int(_edge_count)

	# The Facebook id in the user's account.
	var _facebook_id
	var facebook_id : String:
		get:
			return "" if not _facebook_id is String else String(_facebook_id)

	# The Facebook Instant Game ID in the user's account.
	var _facebook_instant_game_id
	var facebook_instant_game_id : String:
		get:
			return "" if not _facebook_instant_game_id is String else String(_facebook_instant_game_id)

	# The Apple Game Center in of the user's account.
	var _gamecenter_id
	var gamecenter_id : String:
		get:
			return "" if not _gamecenter_id is String else String(_gamecenter_id)

	# The Google id in the user's account.
	var _google_id
	var google_id : String:
		get:
			return "" if not _google_id is String else String(_google_id)

	# The id of the user's account.
	var _id
	var id : String:
		get:
			return "" if not _id is String else String(_id)

	# The language expected to be a tag which follows the BCP-47 spec.
	var _lang_tag
	var lang_tag : String:
		get:
			return "" if not _lang_tag is String else String(_lang_tag)

	# The location set by the user.
	var _location
	var location : String:
		get:
			return "" if not _location is String else String(_location)

	# Additional information stored as a JSON object.
	var _metadata
	var metadata : String:
		get:
			return "" if not _metadata is String else String(_metadata)

	# Indicates whether the user is currently online.
	var _online
	var online : bool:
		get:
			return false if not _online is bool else bool(_online)

	# The Steam id in the user's account.
	var _steam_id
	var steam_id : String:
		get:
			return "" if not _steam_id is String else String(_steam_id)

	# The timezone set by the user.
	var _timezone
	var timezone : String:
		get:
			return "" if not _timezone is String else String(_timezone)

	# The UNIX time when the user was last updated.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# The username of the user's account.
	var _username
	var username : String:
		get:
			return "" if not _username is String else String(_username)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiUser:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiUser", p_dict), ApiUser) as ApiUser

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "apple_id: %s, " % _apple_id
		output += "avatar_url: %s, " % _avatar_url
		output += "create_time: %s, " % _create_time
		output += "display_name: %s, " % _display_name
		output += "edge_count: %s, " % _edge_count
		output += "facebook_id: %s, " % _facebook_id
		output += "facebook_instant_game_id: %s, " % _facebook_instant_game_id
		output += "gamecenter_id: %s, " % _gamecenter_id
		output += "google_id: %s, " % _google_id
		output += "id: %s, " % _id
		output += "lang_tag: %s, " % _lang_tag
		output += "location: %s, " % _location
		output += "metadata: %s, " % _metadata
		output += "online: %s, " % _online
		output += "steam_id: %s, " % _steam_id
		output += "timezone: %s, " % _timezone
		output += "update_time: %s, " % _update_time
		output += "username: %s, " % _username
		return output

# A list of groups belonging to a user, along with the user's role in each group.
class ApiUserGroupList extends NakamaAsyncResult:

	const _SCHEMA = {
		"cursor": {"name": "_cursor", "type": TYPE_STRING, "required": false},
		"user_groups": {"name": "_user_groups", "type": TYPE_ARRAY, "required": false, "content": "UserGroupListUserGroup"},
	}

	# Cursor for the next page of results, if any.
	var _cursor
	var cursor : String:
		get:
			return "" if not _cursor is String else String(_cursor)

	# Group-role pairs for a user.
	var _user_groups
	var user_groups : Array:
		get:
			return Array() if not _user_groups is Array else Array(_user_groups)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiUserGroupList:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiUserGroupList", p_dict), ApiUserGroupList) as ApiUserGroupList

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "cursor: %s, " % _cursor
		output += "user_groups: %s, " % [_user_groups]
		return output

# A collection of zero or more users.
class ApiUsers extends NakamaAsyncResult:

	const _SCHEMA = {
		"users": {"name": "_users", "type": TYPE_ARRAY, "required": false, "content": "ApiUser"},
	}

	# The User objects.
	var _users
	var users : Array:
		get:
			return Array() if not _users is Array else Array(_users)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiUsers:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiUsers", p_dict), ApiUsers) as ApiUsers

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "users: %s, " % [_users]
		return output

#
class ApiValidatePurchaseAppleRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"persist": {"name": "_persist", "type": TYPE_BOOL, "required": false},
		"receipt": {"name": "_receipt", "type": TYPE_STRING, "required": false},
	}

	#
	var _persist
	var persist : bool:
		get:
			return false if not _persist is bool else bool(_persist)

	# Base64 encoded Apple receipt data payload.
	var _receipt
	var receipt : String:
		get:
			return "" if not _receipt is String else String(_receipt)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatePurchaseAppleRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatePurchaseAppleRequest", p_dict), ApiValidatePurchaseAppleRequest) as ApiValidatePurchaseAppleRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "persist: %s, " % _persist
		output += "receipt: %s, " % _receipt
		return output

#
class ApiValidatePurchaseGoogleRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"persist": {"name": "_persist", "type": TYPE_BOOL, "required": false},
		"purchase": {"name": "_purchase", "type": TYPE_STRING, "required": false},
	}

	#
	var _persist
	var persist : bool:
		get:
			return false if not _persist is bool else bool(_persist)

	# JSON encoded Google purchase payload.
	var _purchase
	var purchase : String:
		get:
			return "" if not _purchase is String else String(_purchase)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatePurchaseGoogleRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatePurchaseGoogleRequest", p_dict), ApiValidatePurchaseGoogleRequest) as ApiValidatePurchaseGoogleRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "persist: %s, " % _persist
		output += "purchase: %s, " % _purchase
		return output

#
class ApiValidatePurchaseHuaweiRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"persist": {"name": "_persist", "type": TYPE_BOOL, "required": false},
		"purchase": {"name": "_purchase", "type": TYPE_STRING, "required": false},
		"signature": {"name": "_signature", "type": TYPE_STRING, "required": false},
	}

	#
	var _persist
	var persist : bool:
		get:
			return false if not _persist is bool else bool(_persist)

	# JSON encoded Huawei InAppPurchaseData.
	var _purchase
	var purchase : String:
		get:
			return "" if not _purchase is String else String(_purchase)

	# InAppPurchaseData signature.
	var _signature
	var signature : String:
		get:
			return "" if not _signature is String else String(_signature)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatePurchaseHuaweiRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatePurchaseHuaweiRequest", p_dict), ApiValidatePurchaseHuaweiRequest) as ApiValidatePurchaseHuaweiRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "persist: %s, " % _persist
		output += "purchase: %s, " % _purchase
		output += "signature: %s, " % _signature
		return output

# Validate IAP response.
class ApiValidatePurchaseResponse extends NakamaAsyncResult:

	const _SCHEMA = {
		"validated_purchases": {"name": "_validated_purchases", "type": TYPE_ARRAY, "required": false, "content": "ApiValidatedPurchase"},
	}

	# Newly seen validated purchases.
	var _validated_purchases
	var validated_purchases : Array:
		get:
			return Array() if not _validated_purchases is Array else Array(_validated_purchases)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatePurchaseResponse:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatePurchaseResponse", p_dict), ApiValidatePurchaseResponse) as ApiValidatePurchaseResponse

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "validated_purchases: %s, " % [_validated_purchases]
		return output

#
class ApiValidateSubscriptionAppleRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"persist": {"name": "_persist", "type": TYPE_BOOL, "required": false},
		"receipt": {"name": "_receipt", "type": TYPE_STRING, "required": false},
	}

	# Persist the subscription.
	var _persist
	var persist : bool:
		get:
			return false if not _persist is bool else bool(_persist)

	# Base64 encoded Apple receipt data payload.
	var _receipt
	var receipt : String:
		get:
			return "" if not _receipt is String else String(_receipt)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidateSubscriptionAppleRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidateSubscriptionAppleRequest", p_dict), ApiValidateSubscriptionAppleRequest) as ApiValidateSubscriptionAppleRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "persist: %s, " % _persist
		output += "receipt: %s, " % _receipt
		return output

#
class ApiValidateSubscriptionGoogleRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"persist": {"name": "_persist", "type": TYPE_BOOL, "required": false},
		"receipt": {"name": "_receipt", "type": TYPE_STRING, "required": false},
	}

	# Persist the subscription.
	var _persist
	var persist : bool:
		get:
			return false if not _persist is bool else bool(_persist)

	# JSON encoded Google purchase payload.
	var _receipt
	var receipt : String:
		get:
			return "" if not _receipt is String else String(_receipt)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidateSubscriptionGoogleRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidateSubscriptionGoogleRequest", p_dict), ApiValidateSubscriptionGoogleRequest) as ApiValidateSubscriptionGoogleRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "persist: %s, " % _persist
		output += "receipt: %s, " % _receipt
		return output

# Validate Subscription response.
class ApiValidateSubscriptionResponse extends NakamaAsyncResult:

	const _SCHEMA = {
		"validated_subscription": {"name": "_validated_subscription", "type": "ApiValidatedSubscription", "required": false},
	}

	#
	var _validated_subscription
	var validated_subscription : ApiValidatedSubscription:
		get:
			return _validated_subscription as ApiValidatedSubscription

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidateSubscriptionResponse:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidateSubscriptionResponse", p_dict), ApiValidateSubscriptionResponse) as ApiValidateSubscriptionResponse

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "validated_subscription: %s, " % _validated_subscription
		return output

# Validated Purchase stored by Nakama.
class ApiValidatedPurchase extends NakamaAsyncResult:

	const _SCHEMA = {
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"environment": {"name": "_environment", "type": TYPE_INT, "required": false},
		"product_id": {"name": "_product_id", "type": TYPE_STRING, "required": false},
		"provider_response": {"name": "_provider_response", "type": TYPE_STRING, "required": false},
		"purchase_time": {"name": "_purchase_time", "type": TYPE_STRING, "required": false},
		"refund_time": {"name": "_refund_time", "type": TYPE_STRING, "required": false},
		"seen_before": {"name": "_seen_before", "type": TYPE_BOOL, "required": false},
		"store": {"name": "_store", "type": TYPE_INT, "required": false},
		"transaction_id": {"name": "_transaction_id", "type": TYPE_STRING, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"user_id": {"name": "_user_id", "type": TYPE_STRING, "required": false},
	}

	# Timestamp when the receipt validation was stored in DB.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# Whether the purchase was done in production or sandbox environment.
	var _environment
	var environment : int:
		get:
			return ApiStoreEnvironment.values()[0] if not ApiStoreEnvironment.values().has(_environment) else _environment

	# Purchase Product ID.
	var _product_id
	var product_id : String:
		get:
			return "" if not _product_id is String else String(_product_id)

	# Raw provider validation response.
	var _provider_response
	var provider_response : String:
		get:
			return "" if not _provider_response is String else String(_provider_response)

	# Timestamp when the purchase was done.
	var _purchase_time
	var purchase_time : String:
		get:
			return "" if not _purchase_time is String else String(_purchase_time)

	#
	var _refund_time
	var refund_time : String:
		get:
			return "" if not _refund_time is String else String(_refund_time)

	# Whether the purchase had already been validated by Nakama before.
	var _seen_before
	var seen_before : bool:
		get:
			return false if not _seen_before is bool else bool(_seen_before)

	#
	var _store
	var store : int:
		get:
			return ApiStoreProvider.values()[0] if not ApiStoreProvider.values().has(_store) else _store

	# Purchase Transaction ID.
	var _transaction_id
	var transaction_id : String:
		get:
			return "" if not _transaction_id is String else String(_transaction_id)

	# Timestamp when the receipt validation was updated in DB.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# Purchase User ID.
	var _user_id
	var user_id : String:
		get:
			return "" if not _user_id is String else String(_user_id)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatedPurchase:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatedPurchase", p_dict), ApiValidatedPurchase) as ApiValidatedPurchase

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "create_time: %s, " % _create_time
		output += "environment: %s, " % _environment
		output += "product_id: %s, " % _product_id
		output += "provider_response: %s, " % _provider_response
		output += "purchase_time: %s, " % _purchase_time
		output += "refund_time: %s, " % _refund_time
		output += "seen_before: %s, " % _seen_before
		output += "store: %s, " % _store
		output += "transaction_id: %s, " % _transaction_id
		output += "update_time: %s, " % _update_time
		output += "user_id: %s, " % _user_id
		return output

#
class ApiValidatedSubscription extends NakamaAsyncResult:

	const _SCHEMA = {
		"active": {"name": "_active", "type": TYPE_BOOL, "required": false},
		"create_time": {"name": "_create_time", "type": TYPE_STRING, "required": false},
		"environment": {"name": "_environment", "type": TYPE_INT, "required": false},
		"expiry_time": {"name": "_expiry_time", "type": TYPE_STRING, "required": false},
		"original_transaction_id": {"name": "_original_transaction_id", "type": TYPE_STRING, "required": false},
		"product_id": {"name": "_product_id", "type": TYPE_STRING, "required": false},
		"provider_notification": {"name": "_provider_notification", "type": TYPE_STRING, "required": false},
		"provider_response": {"name": "_provider_response", "type": TYPE_STRING, "required": false},
		"purchase_time": {"name": "_purchase_time", "type": TYPE_STRING, "required": false},
		"refund_time": {"name": "_refund_time", "type": TYPE_STRING, "required": false},
		"store": {"name": "_store", "type": TYPE_INT, "required": false},
		"update_time": {"name": "_update_time", "type": TYPE_STRING, "required": false},
		"user_id": {"name": "_user_id", "type": TYPE_STRING, "required": false},
	}

	# Whether the subscription is currently active or not.
	var _active
	var active : bool:
		get:
			return false if not _active is bool else bool(_active)

	# UNIX Timestamp when the receipt validation was stored in DB.
	var _create_time
	var create_time : String:
		get:
			return "" if not _create_time is String else String(_create_time)

	# Whether the purchase was done in production or sandbox environment.
	var _environment
	var environment : int:
		get:
			return ApiStoreEnvironment.values()[0] if not ApiStoreEnvironment.values().has(_environment) else _environment

	# Subscription expiration time. The subscription can still be auto-renewed to extend the expiration time further.
	var _expiry_time
	var expiry_time : String:
		get:
			return "" if not _expiry_time is String else String(_expiry_time)

	# Purchase Original transaction ID (we only keep track of the original subscription, not subsequent renewals).
	var _original_transaction_id
	var original_transaction_id : String:
		get:
			return "" if not _original_transaction_id is String else String(_original_transaction_id)

	# Purchase Product ID.
	var _product_id
	var product_id : String:
		get:
			return "" if not _product_id is String else String(_product_id)

	# Raw provider notification body.
	var _provider_notification
	var provider_notification : String:
		get:
			return "" if not _provider_notification is String else String(_provider_notification)

	# Raw provider validation response body.
	var _provider_response
	var provider_response : String:
		get:
			return "" if not _provider_response is String else String(_provider_response)

	# UNIX Timestamp when the purchase was done.
	var _purchase_time
	var purchase_time : String:
		get:
			return "" if not _purchase_time is String else String(_purchase_time)

	# Subscription refund time. If this time is set, the subscription was refunded.
	var _refund_time
	var refund_time : String:
		get:
			return "" if not _refund_time is String else String(_refund_time)

	#
	var _store
	var store : int:
		get:
			return ApiStoreProvider.values()[0] if not ApiStoreProvider.values().has(_store) else _store

	# UNIX Timestamp when the receipt validation was updated in DB.
	var _update_time
	var update_time : String:
		get:
			return "" if not _update_time is String else String(_update_time)

	# Subscription User ID.
	var _user_id
	var user_id : String:
		get:
			return "" if not _user_id is String else String(_user_id)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiValidatedSubscription:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiValidatedSubscription", p_dict), ApiValidatedSubscription) as ApiValidatedSubscription

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "active: %s, " % _active
		output += "create_time: %s, " % _create_time
		output += "environment: %s, " % _environment
		output += "expiry_time: %s, " % _expiry_time
		output += "original_transaction_id: %s, " % _original_transaction_id
		output += "product_id: %s, " % _product_id
		output += "provider_notification: %s, " % _provider_notification
		output += "provider_response: %s, " % _provider_response
		output += "purchase_time: %s, " % _purchase_time
		output += "refund_time: %s, " % _refund_time
		output += "store: %s, " % _store
		output += "update_time: %s, " % _update_time
		output += "user_id: %s, " % _user_id
		return output

# The object to store.
class ApiWriteStorageObject extends NakamaAsyncResult:

	const _SCHEMA = {
		"collection": {"name": "_collection", "type": TYPE_STRING, "required": false},
		"key": {"name": "_key", "type": TYPE_STRING, "required": false},
		"permission_read": {"name": "_permission_read", "type": TYPE_INT, "required": false},
		"permission_write": {"name": "_permission_write", "type": TYPE_INT, "required": false},
		"value": {"name": "_value", "type": TYPE_STRING, "required": false},
		"version": {"name": "_version", "type": TYPE_STRING, "required": false},
	}

	# The collection to store the object.
	var _collection
	var collection : String:
		get:
			return "" if not _collection is String else String(_collection)

	# The key for the object within the collection.
	var _key
	var key : String:
		get:
			return "" if not _key is String else String(_key)

	# The read access permissions for the object.
	var _permission_read
	var permission_read : int:
		get:
			return 0 if not _permission_read is int else int(_permission_read)

	# The write access permissions for the object.
	var _permission_write
	var permission_write : int:
		get:
			return 0 if not _permission_write is int else int(_permission_write)

	# The value of the object.
	var _value
	var value : String:
		get:
			return "" if not _value is String else String(_value)

	# The version hash of the object to check. Possible values are: ["", "*", "#hash#"].
	var _version
	var version : String:
		get:
			return "" if not _version is String else String(_version)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiWriteStorageObject:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiWriteStorageObject", p_dict), ApiWriteStorageObject) as ApiWriteStorageObject

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "collection: %s, " % _collection
		output += "key: %s, " % _key
		output += "permission_read: %s, " % _permission_read
		output += "permission_write: %s, " % _permission_write
		output += "value: %s, " % _value
		output += "version: %s, " % _version
		return output

# Write objects to the storage engine.
class ApiWriteStorageObjectsRequest extends NakamaAsyncResult:

	const _SCHEMA = {
		"objects": {"name": "_objects", "type": TYPE_ARRAY, "required": false, "content": "ApiWriteStorageObject"},
	}

	# The objects to store on the server.
	var _objects
	var objects : Array:
		get:
			return Array() if not _objects is Array else Array(_objects)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ApiWriteStorageObjectsRequest:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ApiWriteStorageObjectsRequest", p_dict), ApiWriteStorageObjectsRequest) as ApiWriteStorageObjectsRequest

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "objects: %s, " % [_objects]
		return output

# 
class ProtobufAny extends NakamaAsyncResult:

	const _SCHEMA = {
		"type_url": {"name": "_type_url", "type": TYPE_STRING, "required": false},
		"value": {"name": "_value", "type": TYPE_STRING, "required": false},
	}

	# 
	var _type_url
	var type_url : String:
		get:
			return "" if not _type_url is String else String(_type_url)

	# 
	var _value
	var value : String:
		get:
			return "" if not _value is String else String(_value)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> ProtobufAny:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "ProtobufAny", p_dict), ProtobufAny) as ProtobufAny

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "type_url: %s, " % _type_url
		output += "value: %s, " % _value
		return output

#
class RpcStatus extends NakamaAsyncResult:

	const _SCHEMA = {
		"code": {"name": "_code", "type": TYPE_INT, "required": false},
		"details": {"name": "_details", "type": TYPE_ARRAY, "required": false, "content": "ProtobufAny"},
		"message": {"name": "_message", "type": TYPE_STRING, "required": false},
	}

	#
	var _code
	var code : int:
		get:
			return 0 if not _code is int else int(_code)

	#
	var _details
	var details : Array:
		get:
			return Array() if not _details is Array else Array(_details)

	#
	var _message
	var message : String:
		get:
			return "" if not _message is String else String(_message)

	func _init(p_exception = null):
		super(p_exception)

	static func create(p_ns : GDScript, p_dict : Dictionary) -> RpcStatus:
		return _safe_ret(NakamaSerializer.deserialize(p_ns, "RpcStatus", p_dict), RpcStatus) as RpcStatus

	func serialize() -> Dictionary:
		return NakamaSerializer.serialize(self)

	func _to_string() -> String:
		if is_exception():
			return get_exception()._to_string()
		var output : String = ""
		output += "code: %s, " % _code
		output += "details: %s, " % [_details]
		output += "message: %s, " % _message
		return output

# The low level client for the Nakama API.
class ApiClient extends RefCounted:

	var _base_uri : String

	var _http_adapter
	var _namespace : GDScript
	var _server_key : String
	var auto_refresh := true
	var auto_refresh_time := 300

	var auto_retry : bool:
		set(p_value):
			_http_adapter.auto_retry = p_value
		get:
			return _http_adapter.auto_retry

	var auto_retry_count : int:
		set(p_value):
			_http_adapter.auto_retry_count = p_value
		get:
			return _http_adapter.auto_retry_count

	var auto_retry_backoff_base : int:
		set(p_value):
			_http_adapter.auto_retry_backoff_base = p_value
		get:
			return _http_adapter.auto_retry_backoff_base

	var last_cancel_token:
		get:
			return _http_adapter.get_last_token()

	func _init(p_base_uri : String, p_http_adapter, p_namespace : GDScript, p_server_key : String, p_timeout : int = 10):
		_base_uri = p_base_uri
		_http_adapter = p_http_adapter
		_http_adapter.timeout = p_timeout
		_namespace = p_namespace
		_server_key = p_server_key

	func _refresh_session(p_session : NakamaSession):
		if auto_refresh and p_session.is_valid() and p_session.refresh_token and not p_session.is_refresh_expired() and p_session.would_expire_in(auto_refresh_time):
			var request = ApiSessionRefreshRequest.new()
			request._token = p_session.refresh_token
			return await session_refresh_async(_server_key, "", request)
		return null

	func cancel_request(p_token):
		if p_token:
			_http_adapter.cancel_request(p_token)

	# A healthcheck which load balancers can use to check the service.
	func healthcheck_async(
		p_session : NakamaSession
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/healthcheck"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Delete the current user's account.
	func delete_account_async(
		p_session : NakamaSession
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "DELETE"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Fetch the current user's account.
	func get_account_async(
		p_session : NakamaSession
	) -> ApiAccount:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiAccount.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiAccount.new(result)
		var out : ApiAccount = NakamaSerializer.deserialize(_namespace, "ApiAccount", result)
		return out

	# Update fields in the current user's account.
	func update_account_async(
		p_session : NakamaSession
		, p_body : ApiUpdateAccountRequest
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "PUT"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Authenticate a user with an Apple ID against the server.
	func authenticate_apple_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountApple
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/apple"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with a custom id against the server.
	func authenticate_custom_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountCustom
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/custom"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with a device id against the server.
	func authenticate_device_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountDevice
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/device"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with an email+password against the server.
	func authenticate_email_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountEmail
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/email"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with a Facebook OAuth token against the server.
	func authenticate_facebook_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountFacebook
		, p_create = null # : boolean
		, p_username = null # : string
		, p_sync = null # : boolean
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/facebook"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		if p_sync != null:
			query_params += "sync=%s&" % str(bool(p_sync)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with a Facebook Instant Game token against the server.
	func authenticate_facebook_instant_game_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountFacebookInstantGame
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/facebookinstantgame"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with Apple's GameCenter against the server.
	func authenticate_game_center_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountGameCenter
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/gamecenter"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with Google against the server.
	func authenticate_google_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountGoogle
		, p_create = null # : boolean
		, p_username = null # : string
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/google"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Authenticate a user with Steam against the server.
	func authenticate_steam_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_account : ApiAccountSteam
		, p_create = null # : boolean
		, p_username = null # : string
		, p_sync = null # : boolean
	) -> ApiSession:
		var urlpath : String = "/v2/account/authenticate/steam"
		var query_params = ""
		if p_create != null:
			query_params += "create=%s&" % str(bool(p_create)).to_lower()
		if p_username != null:
			query_params += "username=%s&" % NakamaSerializer.escape_http(p_username)
		if p_sync != null:
			query_params += "sync=%s&" % str(bool(p_sync)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Add an Apple ID to the social profiles on the current user's account.
	func link_apple_async(
		p_session : NakamaSession
		, p_body : ApiAccountApple
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/apple"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add a custom ID to the social profiles on the current user's account.
	func link_custom_async(
		p_session : NakamaSession
		, p_body : ApiAccountCustom
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/custom"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add a device ID to the social profiles on the current user's account.
	func link_device_async(
		p_session : NakamaSession
		, p_body : ApiAccountDevice
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/device"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add an email+password to the social profiles on the current user's account.
	func link_email_async(
		p_session : NakamaSession
		, p_body : ApiAccountEmail
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/email"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add Facebook to the social profiles on the current user's account.
	func link_facebook_async(
		p_session : NakamaSession
		, p_account : ApiAccountFacebook
		, p_sync = null # : boolean
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/facebook"
		var query_params = ""
		if p_sync != null:
			query_params += "sync=%s&" % str(bool(p_sync)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add Facebook Instant Game to the social profiles on the current user's account.
	func link_facebook_instant_game_async(
		p_session : NakamaSession
		, p_body : ApiAccountFacebookInstantGame
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/facebookinstantgame"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add Apple's GameCenter to the social profiles on the current user's account.
	func link_game_center_async(
		p_session : NakamaSession
		, p_body : ApiAccountGameCenter
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/gamecenter"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add Google to the social profiles on the current user's account.
	func link_google_async(
		p_session : NakamaSession
		, p_body : ApiAccountGoogle
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/google"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add Steam to the social profiles on the current user's account.
	func link_steam_async(
		p_session : NakamaSession
		, p_body : ApiLinkSteamRequest
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/link/steam"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Refresh a user's session using a refresh token retrieved from a previous authentication request.
	func session_refresh_async(
		p_basic_auth_username : String
		, p_basic_auth_password : String
		, p_body : ApiSessionRefreshRequest
	) -> ApiSession:
		var urlpath : String = "/v2/account/session/refresh"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var credentials = Marshalls.utf8_to_base64(p_basic_auth_username + ":" + p_basic_auth_password)
		var header = "Basic %s" % credentials
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSession.new(result)
		var out : ApiSession = NakamaSerializer.deserialize(_namespace, "ApiSession", result)
		return out

	# Remove the Apple ID from the social profiles on the current user's account.
	func unlink_apple_async(
		p_session : NakamaSession
		, p_body : ApiAccountApple
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/apple"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove the custom ID from the social profiles on the current user's account.
	func unlink_custom_async(
		p_session : NakamaSession
		, p_body : ApiAccountCustom
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/custom"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove the device ID from the social profiles on the current user's account.
	func unlink_device_async(
		p_session : NakamaSession
		, p_body : ApiAccountDevice
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/device"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove the email+password from the social profiles on the current user's account.
	func unlink_email_async(
		p_session : NakamaSession
		, p_body : ApiAccountEmail
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/email"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove Facebook from the social profiles on the current user's account.
	func unlink_facebook_async(
		p_session : NakamaSession
		, p_body : ApiAccountFacebook
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/facebook"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove Facebook Instant Game profile from the social profiles on the current user's account.
	func unlink_facebook_instant_game_async(
		p_session : NakamaSession
		, p_body : ApiAccountFacebookInstantGame
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/facebookinstantgame"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove Apple's GameCenter from the social profiles on the current user's account.
	func unlink_game_center_async(
		p_session : NakamaSession
		, p_body : ApiAccountGameCenter
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/gamecenter"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove Google from the social profiles on the current user's account.
	func unlink_google_async(
		p_session : NakamaSession
		, p_body : ApiAccountGoogle
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/google"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Remove Steam from the social profiles on the current user's account.
	func unlink_steam_async(
		p_session : NakamaSession
		, p_body : ApiAccountSteam
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/account/unlink/steam"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List a channel's message history.
	func list_channel_messages_async(
		p_session : NakamaSession
		, p_channel_id : String
		, p_limit = null # : integer
		, p_forward = null # : boolean
		, p_cursor = null # : string
	) -> ApiChannelMessageList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiChannelMessageList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/channel/{channelId}"
		urlpath = urlpath.replace("{channelId}", NakamaSerializer.escape_http(p_channel_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_forward != null:
			query_params += "forward=%s&" % str(bool(p_forward)).to_lower()
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiChannelMessageList.new(result)
		var out : ApiChannelMessageList = NakamaSerializer.deserialize(_namespace, "ApiChannelMessageList", result)
		return out

	# Submit an event for processing in the server's registered runtime custom events handler.
	func event_async(
		p_session : NakamaSession
		, p_body : ApiEvent
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/event"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Delete one or more users by ID or username.
	func delete_friends_async(
		p_session : NakamaSession
		, p_ids = null # : array
		, p_usernames = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend"
		var query_params = ""
		if p_ids != null:
			for elem in p_ids:
				query_params += "ids=%s&" % elem
		if p_usernames != null:
			for elem in p_usernames:
				query_params += "usernames=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "DELETE"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List all friends for the current user.
	func list_friends_async(
		p_session : NakamaSession
		, p_limit = null # : integer
		, p_state = null # : integer
		, p_cursor = null # : string
	) -> ApiFriendList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiFriendList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend"
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_state != null:
			query_params += "state=%d&" % p_state
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiFriendList.new(result)
		var out : ApiFriendList = NakamaSerializer.deserialize(_namespace, "ApiFriendList", result)
		return out

	# Add friends by ID or username to a user's account.
	func add_friends_async(
		p_session : NakamaSession
		, p_ids = null # : array
		, p_usernames = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend"
		var query_params = ""
		if p_ids != null:
			for elem in p_ids:
				query_params += "ids=%s&" % elem
		if p_usernames != null:
			for elem in p_usernames:
				query_params += "usernames=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Block one or more users by ID or username.
	func block_friends_async(
		p_session : NakamaSession
		, p_ids = null # : array
		, p_usernames = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend/block"
		var query_params = ""
		if p_ids != null:
			for elem in p_ids:
				query_params += "ids=%s&" % elem
		if p_usernames != null:
			for elem in p_usernames:
				query_params += "usernames=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Import Facebook friends and add them to a user's account.
	func import_facebook_friends_async(
		p_session : NakamaSession
		, p_account : ApiAccountFacebook
		, p_reset = null # : boolean
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend/facebook"
		var query_params = ""
		if p_reset != null:
			query_params += "reset=%s&" % str(bool(p_reset)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Import Steam friends and add them to a user's account.
	func import_steam_friends_async(
		p_session : NakamaSession
		, p_account : ApiAccountSteam
		, p_reset = null # : boolean
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/friend/steam"
		var query_params = ""
		if p_reset != null:
			query_params += "reset=%s&" % str(bool(p_reset)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_account.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List groups based on given filters.
	func list_groups_async(
		p_session : NakamaSession
		, p_name = null # : string
		, p_cursor = null # : string
		, p_limit = null # : integer
		, p_lang_tag = null # : string
		, p_members = null # : integer
		, p_open = null # : boolean
	) -> ApiGroupList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiGroupList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group"
		var query_params = ""
		if p_name != null:
			query_params += "name=%s&" % NakamaSerializer.escape_http(p_name)
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_lang_tag != null:
			query_params += "lang_tag=%s&" % NakamaSerializer.escape_http(p_lang_tag)
		if p_members != null:
			query_params += "members=%d&" % p_members
		if p_open != null:
			query_params += "open=%s&" % str(bool(p_open)).to_lower()
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiGroupList.new(result)
		var out : ApiGroupList = NakamaSerializer.deserialize(_namespace, "ApiGroupList", result)
		return out

	# Create a new group with the current user as the owner.
	func create_group_async(
		p_session : NakamaSession
		, p_body : ApiCreateGroupRequest
	) -> ApiGroup:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiGroup.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiGroup.new(result)
		var out : ApiGroup = NakamaSerializer.deserialize(_namespace, "ApiGroup", result)
		return out

	# Delete a group by ID.
	func delete_group_async(
		p_session : NakamaSession
		, p_group_id : String
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "DELETE"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Update fields in a given group.
	func update_group_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_body : ApiUpdateGroupRequest
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "PUT"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Add users to a group.
	func add_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_user_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/add"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_user_ids != null:
			for elem in p_user_ids:
				query_params += "user_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Ban a set of users from a group.
	func ban_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_user_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/ban"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_user_ids != null:
			for elem in p_user_ids:
				query_params += "user_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Demote a set of users in a group to the next role down.
	func demote_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_user_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/demote"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_user_ids != null:
			for elem in p_user_ids:
				query_params += "user_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Immediately join an open group, or request to join a closed one.
	func join_group_async(
		p_session : NakamaSession
		, p_group_id : String
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/join"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Kick a set of users from a group.
	func kick_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_user_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/kick"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_user_ids != null:
			for elem in p_user_ids:
				query_params += "user_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Leave a group the user is a member of.
	func leave_group_async(
		p_session : NakamaSession
		, p_group_id : String
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/leave"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Promote a set of users in a group to the next role up.
	func promote_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_user_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/promote"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_user_ids != null:
			for elem in p_user_ids:
				query_params += "user_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List all users that are part of a group.
	func list_group_users_async(
		p_session : NakamaSession
		, p_group_id : String
		, p_limit = null # : integer
		, p_state = null # : integer
		, p_cursor = null # : string
	) -> ApiGroupUserList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiGroupUserList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/group/{groupId}/user"
		urlpath = urlpath.replace("{groupId}", NakamaSerializer.escape_http(p_group_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_state != null:
			query_params += "state=%d&" % p_state
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiGroupUserList.new(result)
		var out : ApiGroupUserList = NakamaSerializer.deserialize(_namespace, "ApiGroupUserList", result)
		return out

	# Validate Apple IAP Receipt
	func validate_purchase_apple_async(
		p_session : NakamaSession
		, p_body : ApiValidatePurchaseAppleRequest
	) -> ApiValidatePurchaseResponse:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidatePurchaseResponse.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/purchase/apple"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidatePurchaseResponse.new(result)
		var out : ApiValidatePurchaseResponse = NakamaSerializer.deserialize(_namespace, "ApiValidatePurchaseResponse", result)
		return out

	# Validate Google IAP Receipt
	func validate_purchase_google_async(
		p_session : NakamaSession
		, p_body : ApiValidatePurchaseGoogleRequest
	) -> ApiValidatePurchaseResponse:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidatePurchaseResponse.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/purchase/google"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidatePurchaseResponse.new(result)
		var out : ApiValidatePurchaseResponse = NakamaSerializer.deserialize(_namespace, "ApiValidatePurchaseResponse", result)
		return out

	# Validate Huawei IAP Receipt
	func validate_purchase_huawei_async(
		p_session : NakamaSession
		, p_body : ApiValidatePurchaseHuaweiRequest
	) -> ApiValidatePurchaseResponse:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidatePurchaseResponse.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/purchase/huawei"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidatePurchaseResponse.new(result)
		var out : ApiValidatePurchaseResponse = NakamaSerializer.deserialize(_namespace, "ApiValidatePurchaseResponse", result)
		return out

	# List user's subscriptions.
	func list_subscriptions_async(
		p_session : NakamaSession
		, p_body : ApiListSubscriptionsRequest
	) -> ApiSubscriptionList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiSubscriptionList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/subscription"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiSubscriptionList.new(result)
		var out : ApiSubscriptionList = NakamaSerializer.deserialize(_namespace, "ApiSubscriptionList", result)
		return out

	# Validate Apple Subscription Receipt
	func validate_subscription_apple_async(
		p_session : NakamaSession
		, p_body : ApiValidateSubscriptionAppleRequest
	) -> ApiValidateSubscriptionResponse:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidateSubscriptionResponse.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/subscription/apple"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidateSubscriptionResponse.new(result)
		var out : ApiValidateSubscriptionResponse = NakamaSerializer.deserialize(_namespace, "ApiValidateSubscriptionResponse", result)
		return out

	# Validate Google Subscription Receipt
	func validate_subscription_google_async(
		p_session : NakamaSession
		, p_body : ApiValidateSubscriptionGoogleRequest
	) -> ApiValidateSubscriptionResponse:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidateSubscriptionResponse.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/subscription/google"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidateSubscriptionResponse.new(result)
		var out : ApiValidateSubscriptionResponse = NakamaSerializer.deserialize(_namespace, "ApiValidateSubscriptionResponse", result)
		return out

	# Get subscription by product id.
	func get_subscription_async(
		p_session : NakamaSession
		, p_product_id : String
	) -> ApiValidatedSubscription:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiValidatedSubscription.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/iap/subscription/{productId}"
		urlpath = urlpath.replace("{productId}", NakamaSerializer.escape_http(p_product_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiValidatedSubscription.new(result)
		var out : ApiValidatedSubscription = NakamaSerializer.deserialize(_namespace, "ApiValidatedSubscription", result)
		return out

	# Delete a leaderboard record.
	func delete_leaderboard_record_async(
		p_session : NakamaSession
		, p_leaderboard_id : String
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/leaderboard/{leaderboardId}"
		urlpath = urlpath.replace("{leaderboardId}", NakamaSerializer.escape_http(p_leaderboard_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "DELETE"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List leaderboard records.
	func list_leaderboard_records_async(
		p_session : NakamaSession
		, p_leaderboard_id : String
		, p_owner_ids = null # : array
		, p_limit = null # : integer
		, p_cursor = null # : string
		, p_expiry = null # : string
	) -> ApiLeaderboardRecordList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiLeaderboardRecordList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/leaderboard/{leaderboardId}"
		urlpath = urlpath.replace("{leaderboardId}", NakamaSerializer.escape_http(p_leaderboard_id))
		var query_params = ""
		if p_owner_ids != null:
			for elem in p_owner_ids:
				query_params += "owner_ids=%s&" % elem
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		if p_expiry != null:
			query_params += "expiry=%s&" % NakamaSerializer.escape_http(p_expiry)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiLeaderboardRecordList.new(result)
		var out : ApiLeaderboardRecordList = NakamaSerializer.deserialize(_namespace, "ApiLeaderboardRecordList", result)
		return out

	# Write a record to a leaderboard.
	func write_leaderboard_record_async(
		p_session : NakamaSession
		, p_leaderboard_id : String
		, p_record : WriteLeaderboardRecordRequestLeaderboardRecordWrite
	) -> ApiLeaderboardRecord:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiLeaderboardRecord.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/leaderboard/{leaderboardId}"
		urlpath = urlpath.replace("{leaderboardId}", NakamaSerializer.escape_http(p_leaderboard_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_record.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiLeaderboardRecord.new(result)
		var out : ApiLeaderboardRecord = NakamaSerializer.deserialize(_namespace, "ApiLeaderboardRecord", result)
		return out

	# List leaderboard records that belong to a user.
	func list_leaderboard_records_around_owner_async(
		p_session : NakamaSession
		, p_leaderboard_id : String
		, p_owner_id : String
		, p_limit = null # : integer
		, p_expiry = null # : string
		, p_cursor = null # : string
	) -> ApiLeaderboardRecordList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiLeaderboardRecordList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/leaderboard/{leaderboardId}/owner/{ownerId}"
		urlpath = urlpath.replace("{leaderboardId}", NakamaSerializer.escape_http(p_leaderboard_id))
		urlpath = urlpath.replace("{ownerId}", NakamaSerializer.escape_http(p_owner_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_expiry != null:
			query_params += "expiry=%s&" % NakamaSerializer.escape_http(p_expiry)
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiLeaderboardRecordList.new(result)
		var out : ApiLeaderboardRecordList = NakamaSerializer.deserialize(_namespace, "ApiLeaderboardRecordList", result)
		return out

	# Fetch list of running matches.
	func list_matches_async(
		p_session : NakamaSession
		, p_limit = null # : integer
		, p_authoritative = null # : boolean
		, p_label = null # : string
		, p_min_size = null # : integer
		, p_max_size = null # : integer
		, p_query = null # : string
	) -> ApiMatchList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiMatchList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/match"
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_authoritative != null:
			query_params += "authoritative=%s&" % str(bool(p_authoritative)).to_lower()
		if p_label != null:
			query_params += "label=%s&" % NakamaSerializer.escape_http(p_label)
		if p_min_size != null:
			query_params += "min_size=%d&" % p_min_size
		if p_max_size != null:
			query_params += "max_size=%d&" % p_max_size
		if p_query != null:
			query_params += "query=%s&" % NakamaSerializer.escape_http(p_query)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiMatchList.new(result)
		var out : ApiMatchList = NakamaSerializer.deserialize(_namespace, "ApiMatchList", result)
		return out

	# Delete one or more notifications for the current user.
	func delete_notifications_async(
		p_session : NakamaSession
		, p_ids = null # : array
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/notification"
		var query_params = ""
		if p_ids != null:
			for elem in p_ids:
				query_params += "ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "DELETE"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Fetch list of notifications.
	func list_notifications_async(
		p_session : NakamaSession
		, p_limit = null # : integer
		, p_cacheable_cursor = null # : string
	) -> ApiNotificationList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiNotificationList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/notification"
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cacheable_cursor != null:
			query_params += "cacheable_cursor=%s&" % NakamaSerializer.escape_http(p_cacheable_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiNotificationList.new(result)
		var out : ApiNotificationList = NakamaSerializer.deserialize(_namespace, "ApiNotificationList", result)
		return out

	# Execute a Lua function on the server.
	func rpc_func2_async(
		p_bearer_token : String
		, p_id : String
		, p_payload = null # : string
		, p_http_key = null # : string
	) -> ApiRpc:
		var urlpath : String = "/v2/rpc/{id}"
		urlpath = urlpath.replace("{id}", NakamaSerializer.escape_http(p_id))
		var query_params = ""
		if p_payload != null:
			query_params += "payload=%s&" % NakamaSerializer.escape_http(p_payload)
		if p_http_key != null:
			query_params += "http_key=%s&" % NakamaSerializer.escape_http(p_http_key)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		if (p_bearer_token):
			var header = "Bearer %s" % p_bearer_token
			headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiRpc.new(result)
		var out : ApiRpc = NakamaSerializer.deserialize(_namespace, "ApiRpc", result)
		return out

	# Execute a Lua function on the server.
	func rpc_func_async(
		p_bearer_token : String
		, p_id : String
		, p_payload : String
		, p_http_key = null # : string
	) -> ApiRpc:
		var urlpath : String = "/v2/rpc/{id}"
		urlpath = urlpath.replace("{id}", NakamaSerializer.escape_http(p_id))
		var query_params = ""
		if p_http_key != null:
			query_params += "http_key=%s&" % NakamaSerializer.escape_http(p_http_key)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		if (p_bearer_token):
			var header = "Bearer %s" % p_bearer_token
			headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_payload).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiRpc.new(result)
		var out : ApiRpc = NakamaSerializer.deserialize(_namespace, "ApiRpc", result)
		return out

	# Log out a session, invalidate a refresh token, or log out all sessions/refresh tokens for a user.
	func session_logout_async(
		p_session : NakamaSession
		, p_body : ApiSessionLogoutRequest
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/session/logout"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# Get storage objects.
	func read_storage_objects_async(
		p_session : NakamaSession
		, p_body : ApiReadStorageObjectsRequest
	) -> ApiStorageObjects:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiStorageObjects.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/storage"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiStorageObjects.new(result)
		var out : ApiStorageObjects = NakamaSerializer.deserialize(_namespace, "ApiStorageObjects", result)
		return out

	# Write objects into the storage engine.
	func write_storage_objects_async(
		p_session : NakamaSession
		, p_body : ApiWriteStorageObjectsRequest
	) -> ApiStorageObjectAcks:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiStorageObjectAcks.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/storage"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "PUT"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiStorageObjectAcks.new(result)
		var out : ApiStorageObjectAcks = NakamaSerializer.deserialize(_namespace, "ApiStorageObjectAcks", result)
		return out

	# Delete one or more objects by ID or username.
	func delete_storage_objects_async(
		p_session : NakamaSession
		, p_body : ApiDeleteStorageObjectsRequest
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/storage/delete"
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "PUT"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_body.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List publicly readable storage objects in a given collection.
	func list_storage_objects_async(
		p_session : NakamaSession
		, p_collection : String
		, p_user_id = null # : string
		, p_limit = null # : integer
		, p_cursor = null # : string
	) -> ApiStorageObjectList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiStorageObjectList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/storage/{collection}"
		urlpath = urlpath.replace("{collection}", NakamaSerializer.escape_http(p_collection))
		var query_params = ""
		if p_user_id != null:
			query_params += "user_id=%s&" % NakamaSerializer.escape_http(p_user_id)
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiStorageObjectList.new(result)
		var out : ApiStorageObjectList = NakamaSerializer.deserialize(_namespace, "ApiStorageObjectList", result)
		return out

	# List publicly readable storage objects in a given collection.
	func list_storage_objects2_async(
		p_session : NakamaSession
		, p_collection : String
		, p_user_id : String
		, p_limit = null # : integer
		, p_cursor = null # : string
	) -> ApiStorageObjectList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiStorageObjectList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/storage/{collection}/{userId}"
		urlpath = urlpath.replace("{collection}", NakamaSerializer.escape_http(p_collection))
		urlpath = urlpath.replace("{userId}", NakamaSerializer.escape_http(p_user_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiStorageObjectList.new(result)
		var out : ApiStorageObjectList = NakamaSerializer.deserialize(_namespace, "ApiStorageObjectList", result)
		return out

	# List current or upcoming tournaments.
	func list_tournaments_async(
		p_session : NakamaSession
		, p_category_start = null # : integer
		, p_category_end = null # : integer
		, p_start_time = null # : integer
		, p_end_time = null # : integer
		, p_limit = null # : integer
		, p_cursor = null # : string
	) -> ApiTournamentList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiTournamentList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament"
		var query_params = ""
		if p_category_start != null:
			query_params += "category_start=%d&" % p_category_start
		if p_category_end != null:
			query_params += "category_end=%d&" % p_category_end
		if p_start_time != null:
			query_params += "start_time=%d&" % p_start_time
		if p_end_time != null:
			query_params += "end_time=%d&" % p_end_time
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiTournamentList.new(result)
		var out : ApiTournamentList = NakamaSerializer.deserialize(_namespace, "ApiTournamentList", result)
		return out

	# List tournament records.
	func list_tournament_records_async(
		p_session : NakamaSession
		, p_tournament_id : String
		, p_owner_ids = null # : array
		, p_limit = null # : integer
		, p_cursor = null # : string
		, p_expiry = null # : string
	) -> ApiTournamentRecordList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiTournamentRecordList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament/{tournamentId}"
		urlpath = urlpath.replace("{tournamentId}", NakamaSerializer.escape_http(p_tournament_id))
		var query_params = ""
		if p_owner_ids != null:
			for elem in p_owner_ids:
				query_params += "owner_ids=%s&" % elem
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		if p_expiry != null:
			query_params += "expiry=%s&" % NakamaSerializer.escape_http(p_expiry)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiTournamentRecordList.new(result)
		var out : ApiTournamentRecordList = NakamaSerializer.deserialize(_namespace, "ApiTournamentRecordList", result)
		return out

	# Write a record to a tournament.
	func write_tournament_record2_async(
		p_session : NakamaSession
		, p_tournament_id : String
		, p_record : WriteTournamentRecordRequestTournamentRecordWrite
	) -> ApiLeaderboardRecord:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiLeaderboardRecord.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament/{tournamentId}"
		urlpath = urlpath.replace("{tournamentId}", NakamaSerializer.escape_http(p_tournament_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_record.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiLeaderboardRecord.new(result)
		var out : ApiLeaderboardRecord = NakamaSerializer.deserialize(_namespace, "ApiLeaderboardRecord", result)
		return out

	# Write a record to a tournament.
	func write_tournament_record_async(
		p_session : NakamaSession
		, p_tournament_id : String
		, p_record : WriteTournamentRecordRequestTournamentRecordWrite
	) -> ApiLeaderboardRecord:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiLeaderboardRecord.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament/{tournamentId}"
		urlpath = urlpath.replace("{tournamentId}", NakamaSerializer.escape_http(p_tournament_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "PUT"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray
		content = JSON.stringify(p_record.serialize()).to_utf8_buffer()

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiLeaderboardRecord.new(result)
		var out : ApiLeaderboardRecord = NakamaSerializer.deserialize(_namespace, "ApiLeaderboardRecord", result)
		return out

	# Attempt to join an open and running tournament.
	func join_tournament_async(
		p_session : NakamaSession
		, p_tournament_id : String
	) -> NakamaAsyncResult:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return NakamaAsyncResult.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament/{tournamentId}/join"
		urlpath = urlpath.replace("{tournamentId}", NakamaSerializer.escape_http(p_tournament_id))
		var query_params = ""
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "POST"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return NakamaAsyncResult.new(result)
		return NakamaAsyncResult.new()

	# List tournament records for a given owner.
	func list_tournament_records_around_owner_async(
		p_session : NakamaSession
		, p_tournament_id : String
		, p_owner_id : String
		, p_limit = null # : integer
		, p_expiry = null # : string
		, p_cursor = null # : string
	) -> ApiTournamentRecordList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiTournamentRecordList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/tournament/{tournamentId}/owner/{ownerId}"
		urlpath = urlpath.replace("{tournamentId}", NakamaSerializer.escape_http(p_tournament_id))
		urlpath = urlpath.replace("{ownerId}", NakamaSerializer.escape_http(p_owner_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_expiry != null:
			query_params += "expiry=%s&" % NakamaSerializer.escape_http(p_expiry)
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiTournamentRecordList.new(result)
		var out : ApiTournamentRecordList = NakamaSerializer.deserialize(_namespace, "ApiTournamentRecordList", result)
		return out

	# Fetch zero or more users by ID and/or username.
	func get_users_async(
		p_session : NakamaSession
		, p_ids = null # : array
		, p_usernames = null # : array
		, p_facebook_ids = null # : array
	) -> ApiUsers:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiUsers.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/user"
		var query_params = ""
		if p_ids != null:
			for elem in p_ids:
				query_params += "ids=%s&" % elem
		if p_usernames != null:
			for elem in p_usernames:
				query_params += "usernames=%s&" % elem
		if p_facebook_ids != null:
			for elem in p_facebook_ids:
				query_params += "facebook_ids=%s&" % elem
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiUsers.new(result)
		var out : ApiUsers = NakamaSerializer.deserialize(_namespace, "ApiUsers", result)
		return out

	# List groups the current user belongs to.
	func list_user_groups_async(
		p_session : NakamaSession
		, p_user_id : String
		, p_limit = null # : integer
		, p_state = null # : integer
		, p_cursor = null # : string
	) -> ApiUserGroupList:
		var try_refresh = await _refresh_session(p_session)
		if try_refresh != null:
			if try_refresh.is_exception():
				return ApiUserGroupList.new(try_refresh.get_exception())
			await p_session.refresh(try_refresh)
		var urlpath : String = "/v2/user/{userId}/group"
		urlpath = urlpath.replace("{userId}", NakamaSerializer.escape_http(p_user_id))
		var query_params = ""
		if p_limit != null:
			query_params += "limit=%d&" % p_limit
		if p_state != null:
			query_params += "state=%d&" % p_state
		if p_cursor != null:
			query_params += "cursor=%s&" % NakamaSerializer.escape_http(p_cursor)
		var uri = "%s%s%s" % [_base_uri, urlpath, "?" + query_params if query_params else ""]
		var method = "GET"
		var headers = {}
		var header = "Bearer %s" % p_session.token
		headers["Authorization"] = header

		var content : PackedByteArray

		var result = await _http_adapter.send_async(method, uri, headers, content)
		if result is NakamaException:
			return ApiUserGroupList.new(result)
		var out : ApiUserGroupList = NakamaSerializer.deserialize(_namespace, "ApiUserGroupList", result)
		return out
