# Traffic Police Management System
>The Traffic Police Management System is a mini-project designed to facilitate efficient traffic law enforcement and violation management by the police department. The system aims to streamline the process of issuing traffic violation invoices to violators and maintaining accurate records of violations and payments.

The system provides a user-friendly interface for traffic police officers to manage various tasks related to traffic violations. Some of the key features of the Traffic Police Management System include:

- Violation Invoicing: The system allows police officers to generate violation invoices by capturing the necessary details such as the vehicle registration number, date, time, location, type of violation, and additional comments if required. The system calculates the fine amount based on predefined rules and generates a printable invoice for the violator.

- Violation Records: The system maintains a comprehensive database of all traffic violations, including information such as the violator's details, vehicle details, date and time of the violation, type of violation, and the corresponding fine amount. This data helps in tracking repeat offenders and generating reports for analysis.

- Payment Tracking: The system tracks the payment status of each violation invoice. Once a violator pays the fine, the officer can update the payment status in the system, ensuring accurate records of outstanding fines and payments.

- Search and Reporting: The system provides search functionality to retrieve specific violation records based on various parameters such as vehicle registration number, date, location, or violator's details. It also generates reports summarizing the total number of violations, collected fines, and outstanding payments.

- User Management: The system includes user management features to control access and privileges of traffic police officers. It ensures that only authorized personnel can issue invoices, update payment status, or access sensitive information.

The Traffic Police Management System aims to automate and simplify the process of traffic violation management, reducing manual paperwork and improving overall efficiency. By maintaining accurate records and providing insightful reports, it helps traffic police departments to enforce traffic rules effectively and promote road safety.

### Technology used :

- phpmyadmin used for mysql database

- php used for backend

- html5 | css | javascript | bootstrap4 for frontend

- Xampp server

### Guidline :

step 1:- Install Xampp

step 2:- Open Xampp folder and paste the whole project inside htdocs folder

step 3:- Start Xampp server and start apache and mysql

step 4:- open phpmyadmin using this link http://localhost/phpmyadmin/ and create a database with name (traffic) name should be same otherwise it so error

step 5:- inside the project folder a file is traffic.sql is import in phpmyadmin inside traffic database

step 6:- check your project http://localhost/TrafficPolice/


## Connect with me ~Rajesh Rathore

[![Linkedin Badge](https://img.shields.io/badge/-LinkedIn-0e76a8?style=flat-square&logo=Linkedin&logoColor=white)](https://www.linkedin.com/in/rajesh-rathore-0501/)
[![Website Badge](https://img.shields.io/badge/Website-3b5998?style=flat-square&logo=google-chrome&logoColor=white)](https://linktr.ee/rajesh_rathore)
[![Twitter Badge](https://img.shields.io/badge/-Twitter-00acee?style=flat-square&logo=Twitter&logoColor=white)](https://twitter.com/Rajesh946055)
[![Instagram Badge](https://img.shields.io/badge/-Instagram-e4405f?style=flat-square&logo=Instagram&logoColor=white)](https://www.instagram.com/raj_rathod1313/?hl=en)


***Do star, fork and share the repo to show your support, it would help others too!***   <br>
 <br>
 Let me know your views or any changes or improvements or contribute to make better for others 
 
 :heart: ***Thank you all for Forking this repository and contribute***  :heart:
