---
title: Building eDSLs in functional TypeScript
slug: 2020-05-11-building-edsls-in-functional-typescript
authors: Yuriy Bogomolov
videoId: 8VFhePZZGdc
language: ru
tags: typescript, functional programming, fp, fp-ts
start: 2020-05-11 11:00 AM
end: 2020-05-11 3:00 PM
timezone: Moscow
location: Online
difficulty: advanced
---

Бизнес-логика может быть выражена с помощью ограниченного подмножества хостового языка, позволяя коду быть корректным на этапе написания, надежным, поддающимся оптимизации. Такой процесс называется построенеим eDSL — встраиваемых предметно-ориентированных языков — и их интерпретацией; этот процесс широко распространен в функциональных языках вроде Haskell, Scala, OCaml. Тем не менее, эта тема всё еще является терра инкогнита для многих JS/TS-разработчиков.

В ходе этого воркшопа я рассмотрю два способа построения eDSL на функциональном TypeScript с помощью библиотеки fp-ts:

1. Free-монады
2. Tagless Final

Мы сравним эти подходы и обсудим их компромиссы.

Вы получите практические навыки описания бизнес-домена таким образом, который позволяет отделить построение выражений вашей бизнес-логики от ее интерпретации и исполнения.

## Требования

- Ноутбук с редактором кода или браузер с CodeSandbox.
- Работающее окружение Node.js 10+.
- Загруженный шаблон воркшопа.
- Понимание базовых концепций функционального программирования: иммутабельность, тотальность, чистота, композиция функций, принцип наименьшего знания, и т.п.
- Понимание, что такое монада и функтор.
- Большим плюсом будет опыт работы с библиотекой `fp-ts`.

## Подготовка к воркшопу

1. Клонируйте репозиторий воркшопа к себе на компьютер.
2. Установите все зависимости с помощью `npm ci`.
3. Откройте репозиторий в редакторе и следуйте объяснениям лектора.
4. Если вы застряли, то можете использовать одну из точек восстановления (см. ниже).

Точки восстановления это ветки, в которых реализованы важные для понимания материала вехи. Имена этих веток:

- `01-free-api`
- `02-free-example`
- `03-free-interpreters`
- `04-tagless-api`
- `05-tagless-examples`
- `06-tagless-interpreters`
