---
title: Clean project history with SemVer and changelogs
slug: 2020-05-10-clean-project-history-with-semver-and-changelogs
authors: Sergei Orlov
videoId: xJlaohTDtr4
language: en
tags: javascript, nodejs, semver, devtools
start: 2020-05-10 12:00 PM
end: 2020-05-10 4:00 PM
timezone: Moscow
location: Online
difficulty: intermediate
---

Learn how to share the updates of your software with collaborators, users and other stakeholders in a clear and understandable way.

Automate the process of writing the project history following the industry standards and best practices.

In this workshop we will:

- discuss various approaches to versioning
- deep-dive into Semantic Versioning, by far the most popular versioning scheme nowadays
- talk about different sources of truth about the history of a project
- define what a changelog is and where we can store it to make it accessible for everyone
- learn how to maintain parallel flows of versioning within a project
- write some ahead of the curve functional code featuring monoids, mjs and tagged templates
- build from scratch a dependency-free versioning tool in Node that is capable of deducing the next version to come up and creating changelogs

## List of requirements

- basic knowledge of Git including common commands (`commit`, `push`, `log`)
- good understanding of JavaScript (ES6+)
- at least intermediate English
- a laptop with Internet access and a code editor of your choice
- an active GitHub account
- GitHub repo (link to be added soon) forked and cloned to the local machine
- Node Latest installed on the machine (v13.12.0 at the time of writing)
- Git installed on the machine (v2.21.0 at the time of writing)
