---
title: Course Difficulty
slug: course-difficulty
---

There are five difficulty levels for courses, workshops and other events that occur in Raini.dev. This document outlines their meaning.

The five possible difficulty levels are:

- [n/a](#n/a)
- [novice](#novice)
- [elementary](#elementary)
- [intermediate](#intermediate)
- [advanced](#advanced)

The difficulty level of the content MUST be defined as a [shield.io](http://shields.io) badge nested inside a link to this page (Difficulty Levels). To add badges to your repository, copy the suitable snippet from the ones given below, and put it at the very top of the `README.md` file.

## A note on prerequisites

Difficulty levels of elementary and higher provide requirements from attendees that need to be met to feel comfortable during the workshop. The prerequisites MUST be outlined in the description of the workshop. If the prerequisites provide specific information to be studied, the information MUST be publicly available, free or paid. The prerequisites MAY be workshops, articles, books, tutorials, etc.

## Difficulty level descriptions

### n/a

This badge indicates that the difficulty of the content was not specified.

[![difficulty: n/a](https://img.shields.io/badge/difficulty-n%2Fa-lightgrey)](https://raini.dev/docs/content-difficulty)

```markdown
[![difficulty: n/a](https://img.shields.io/badge/difficulty-n%2Fa-lightgrey)](https://raini.dev/docs/content-difficulty)
```

### novice

The workshop is self-explanatory and NO prerequisites are required from attendees.

[![difficulty: novice](https://img.shields.io/badge/difficulty-novice-green)](https://raini.dev/docs/content-difficulty)

```markdown
[![difficulty: novice](https://img.shields.io/badge/difficulty-novice-green)](https://raini.dev/docs/content-difficulty)
```

### elementary

The content requires basic understanding of the concepts from the workshop.

[![difficulty: elementary](https://img.shields.io/badge/difficulty-elementary-yellow)](https://raini.dev/docs/content-difficulty)

```markdown
[![difficulty: elementary](https://img.shields.io/badge/difficulty-elementary-yellow)](https://raini.dev/docs/content-difficulty)
```

### intermediate

The content requires good understanding and experience with the concepts.

[![difficulty: intermediate](https://img.shields.io/badge/difficulty-intermediate-orange)](https://raini.dev/docs/content-difficulty)

```markdown
[![difficulty: intermediate](https://img.shields.io/badge/difficulty-intermediate-orange)](https://raini.dev/docs/content-difficulty)
```

### advanced

The content requires deep understanding and experience with the concepts. MAY cover non-standard approaches. MAY require additional preparation.

[![difficulty: advanced](https://img.shields.io/badge/difficulty-advanced-red)](https://raini.dev/docs/content-difficulty)

```markdown
[![difficulty: advanced](https://img.shields.io/badge/difficulty-advanced-red)](https://raini.dev/docs/content-difficulty)
```
