# Raini

[![Netlify Status](https://api.netlify.com/api/v1/badges/e4b681e6-2727-4575-89fb-826b0f165e73/deploy-status)](https://app.netlify.com/sites/raini/deploys)
![lint](https://github.com/raini-dev/raini/workflows/lint/badge.svg)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg)](https://github.com/prettier/prettier)

[![twitter: raini_dev](https://img.shields.io/twitter/follow/raini_dev?color=blue&label=raini_dev&logo=twitter&logoColor=white&style=flat)](https://twitter.com/raini_dev)
[![slack: raini-dev](https://img.shields.io/badge/slack-raini--dev-7C2852?logo=slack)](https://raini-dev.slack.com)

[![notion: workshop schedule](https://img.shields.io/badge/raini.dev-workshops%20schedule-blue)](https://www.notion.so/raini/7c40f420d87b4e2bbb043b00d3807b09?v=55912bedce61427a8c63ccf0509f7655)

Raini.dev is a free open source platform for creating and sharing educational programs related to software development and all the things around it. Our mission is to evolve the tech industry through accessible education. We rely on the workshop education form with relatively small composable educational programs.

> The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL NOT", "SHOULD", "SHOULD NOT", "RECOMMENDED", "MAY", and "OPTIONAL" in this document are to be interpreted as described in [RFC 2119](https://tools.ietf.org/html/rfc2119).

## Why workshops

First, we would like to outline what we mean by "a workshop". We define workshop as follows:

> Workshop is a relatively small single- or multistep educational program designed to teach a group of people theory and practice on a specific topic, including techniques or ideas, which they can then use in their work or daily lives.

- Unlike _mentoring programs_, workshops aim at teaching a group of people at once. If a workshop is held offline, the groups are rather small (10-25 people) so that everyone has a chance to be heared and paid attention to. Online workshops accomodate far more people (actually, infinite amount of people) at a price of shortened attendee feedback. But that's what online format always does to us.
- Unlike _courses and trainings_, workshops do not aim at covering everything. Instead, we build small and effective educational programs that can be composed into courses and reused in many places.
- Unlike _meetups and tech talks_, workshops provide a comfortable time span and environment for covering topics deeper and encourage discussion rather than teaching through listening.

Thus, we see workshops as an effective (and heavily underestimated) way to create good educational programs.

## Goals

- Raise advanced expertise globally
- Empower people regardless of their prior experience
- Provide hands-on education
- Be open sourced
- Collaborate in teaching (and learning)

## How to participate

Take a look at our [Contribution Guide](https://github.com/priestine/not-node-school/blob/master/.github/CONTRIBUTING.md).
