+++
Categories = []
Description = ""
Keywords = []
Tags = []
date = "2017-12-21T19:42:01+09:00"
title = "index"
type = "index"
+++

<br/>

- Github: https://github.com/r9y9/deepvoice3_pytorch

This page provides audio samples for the open source implementation of [Deep Voice 3](https://arxiv.org/abs/1710.07654). Samples from single speaker and multi-speaker models follow.

## Single speaker

- Samples from a model trained for 210k steps (~12 hours)[^1] on the [LJSpeech dataset](https://keithito.com/LJ-Speech-Dataset/).
- Pretrained model: [link](https://www.dropbox.com/s/cs6d070ommy2lmh/20171213_deepvoice3_checkpoint_step000210000.pth?dl=0)
- Git commit: [4357976](https://github.com/r9y9/deepvoice3_pytorch/tree/43579764f35de6b8bac2b18b52a06e4e11b705b2)

[^1]: I'm afraid I don't remember correctly, I may have trained a bit more.

Scientists at the CERN laboratory say they have discovered a new particle.

(74 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/0_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/0_checkpoint_step000210000_alignment.png" /></div>


There's a way to measure the acute emotional intelligence that has never gone out of style.

(91 chars, 18 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/1_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/1_checkpoint_step000210000_alignment.png" /></div>


President Trump met with other leaders at the Group of 20 conference.

(69 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/2_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/2_checkpoint_step000210000_alignment.png" /></div>


The Senate's bill to repeal and replace the Affordable Care Act is now imperiled.

(81 chars, 16 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/3_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/3_checkpoint_step000210000_alignment.png" /></div>


Generative adversarial network or variational auto-encoder.

(59 chars, 7 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/4_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/4_checkpoint_step000210000_alignment.png" /></div>


The buses aren't the problem, they actually provide a solution.

(63 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/5_checkpoint_step000210000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3/3_keithito/5_checkpoint_step000210000_alignment.png" /></div>

## Multi-speaker

- Samples from a model trained for 600k steps (~22 hours) on the [VCTK dataset](http://homepages.inf.ed.ac.uk/jyamagis/page3/page58/page58.html) (108 speakers)
- Pretrained model: [link](https://www.dropbox.com/s/uzmtzgcedyu531k/20171222_deepvoice3_vctk108_checkpoint_step000300000.pth?dl=0)
- Git commit: [0421749](https://github.com/r9y9/deepvoice3_pytorch/tree/0421749af908905d181f089f06956fddd0982d47)

### Same text with 12 different speakers

Some have accepted this as a miracle without any physical explanation

 (69 chars, 11 words)

**225, 23,  F,    English,    Southern,  England** (ID, AGE,  GENDER,  ACCENTS,  REGION)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker0.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**226,  22,  M,    English,    Surrey**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker1.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**227,  38,  M,    English,    Cumbria**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker2.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**228,  22,  F,    English,    Southern  England**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker3.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**229,  23,  F,    English,    Southern  England**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker4.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**230,  22,  F,    English,    Stockton-on-tees**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker5.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**231,  23,  F,    English,    Southern  England**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker6.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**232,  23,  M,    English,    Southern  England**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker7.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**233,  23,  F,    English,    Staffordshire**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker8.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**234,  22,  F,    Scottish,  West  Dumfries**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker9.wav" autoplay/>
Your browser does not support the audio element.
</audio>



**236,  23,  F,    English,    Manchester**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker10.wav" autoplay/>
Your browser does not support the audio element.
</audio>

**237,  22,  M,    Scottish,  Fife**

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/loop/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker11.wav" autoplay/>
Your browser does not support the audio element.
</audio>

### Five unknown texts with two (male/female) speakers with attention plot

- Male (292,  23,  M,    NorthernIrish,  Belfast)
- Female (288,  22,  F,    Irish,  Dublin)

Scientists at the CERN laboratory say they have discovered a new particle.

(74 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>


<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/0_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>


There's a way to measure the acute emotional intelligence that has never gone out of style.

(91 chars, 18 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/1_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/1_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/1_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/1_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>


President Trump met with other leaders at the Group of 20 conference.

(69 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/2_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/2_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/2_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/2_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>


The Senate's bill to repeal and replace the Affordable Care Act is now imperiled.

(81 chars, 16 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/3_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/3_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/3_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/3_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>


Generative adversarial network or variational auto-encoder.

(59 chars, 7 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/4_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/4_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/4_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/4_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>


The buses aren't the problem, they actually provide a solution.

(63 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/5_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/5_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker62_alignment.png" /></div>

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/5_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/deepvoice3_multispeaker/3_keithito/5_20171222_deepvoice3_vctk108_checkpoint_step000300000_speaker61_alignment.png" /></div>

## Single speaker ([arXiv:1710.08969 [cs.SD]](https://arxiv.org/abs/1710.08969))

This is not the result of DeepVoice3, but there's a very similar approach I also implemented.

- Samples from a model trained for 585k steps on the [LJSpeech dataset](https://keithito.com/LJ-Speech-Dataset/).
- Pretrained model: [link](https://www.dropbox.com/s/1y8bt6bnggbzzlp/20171129_nyanko_checkpoint_step000585000.pth?dl=0)
- Git commit: [ba59dc7](https://github.com/r9y9/deepvoice3_pytorch/tree/ba59dc75374ca3189281f6028201c15066830116)


Scientists at the CERN laboratory say they have discovered a new particle.

(74 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/0_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/0_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>


There's a way to measure the acute emotional intelligence that has never gone out of style.

(91 chars, 18 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/1_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/1_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>


President Trump met with other leaders at the Group of 20 conference.

(69 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/2_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/2_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>


The Senate's bill to repeal and replace the Affordable Care Act is now imperiled.

(81 chars, 16 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/3_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/3_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>


Generative adversarial network or variational auto-encoder.

(59 chars, 7 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/4_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/4_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>


The buses aren't the problem, they actually provide a solution.

(63 chars, 13 words)

<audio controls="controls" >
<source src="/deepvoice3_pytorch/audio/nyanko/3_keithito/5_20171129_nyanko_checkpoint_step000585000.wav" autoplay/>
Your browser does not support the audio element.
</audio>

<div align="center"><img src="/deepvoice3_pytorch/audio/nyanko/3_keithito/5_20171129_nyanko_checkpoint_step000585000_alignment.png" /></div>

## References

- [Wei Ping, Kainan Peng, Andrew Gibiansky, et al, "Deep Voice 3: Scaling Text-to-Speech with Convolutional Sequence Learning", arXiv:1710.07654, Oct. 2017.](https://arxiv.org/abs/1710.07654)
- [Hideyuki Tachibana, Katsuya Uenoyama, Shunsuke Aihara, "Efficiently Trainable Text-to-Speech System Based on Deep Convolutional Networks with Guided Attention". arXiv:1710.08969, Oct 2017.](https://arxiv.org/abs/1710.08969)
