# Guide to naming a 🌳 branch
<a id="markdown-guide-to-naming-a-%F0%9F%8C%B3-branch" name="guide-to-naming-a-%F0%9F%8C%B3-branch"></a>

<!-- TOC -->

- [🎈 Why is it important to write good branch names?](#-why-is-it-important-to-write-good-branch-names)
- [✏️ How to name a branch](#-how-to-name-a-branch)
- [🌺 Examples](#-examples)
  - [Example 1](#example-1)
  - [Example 2](#example-2)

<!-- /TOC -->

## 🎈 Why is it important to write good branch names?
<a id="markdown-%F0%9F%8E%88-why-is-it-important-to-write-good-branch-names%3F" name="%F0%9F%8E%88-why-is-it-important-to-write-good-branch-names%3F"></a>

If you name your branches properly, it will be easier for you and others to find them.

## ✏️ How to name a branch
<a id="markdown-%E2%9C%8F%EF%B8%8F-how-to-name-a-branch" name="%E2%9C%8F%EF%B8%8F-how-to-name-a-branch"></a>


- **Use `username/change` format**: Use your GitHub username, followed by a slash (/), followed by a
  short description of the change. For example, `nazmulidris/add-section-to-style-guide`.
- **Use a descriptive name**: If possible use a name similar to the **title of the issue** you are
  working on.

## 🌺 Examples
<a id="markdown-%F0%9F%8C%BA-examples" name="%F0%9F%8C%BA-examples"></a>


### Example 1
<a id="markdown-example-1" name="example-1"></a>


```
nazmulidris/add-section-to-style-guide
```

**Breaking down the branch name**:

- **`nazmulidris`**: GitHub username.
- **`add-section-to-style-guide`**: This is the descriptive name with the issue number.

### Example 2
<a id="markdown-example-2" name="example-2"></a>


```
nazmulidris/201-add-section-to-style-guide
```

**Breaking down the branch name**:

- **`nazmulidris`**: GitHub username.
- **`201`**: This is the issue number.
- **`add-section-to-style-guide`**: This is a short descriptive name.
