# r3bl-open-core
<a id="markdown-r3bl-open-core" name="r3bl-open-core"></a>

Welcome to this [monorepo](https://en.wikipedia.org/wiki/Monorepo). All the folders in
this repo are separate Rust projects (crates) that are probably published to crates.io.
And this constitutes a Rust workspace.

Here's the [changelog](https://github.com/r3bl-org/r3bl-open-core/blob/main/CHANGELOG.md)
for this monorepo or Rust workspace. This is a great place to start to get familiar with
what has changed recently in each of the projects in this Rust workspace.

Table of contents:

<!-- TOC -->

- [This workspace contains many TUI, CLI, TTY crates](#this-workspace-contains-many-tui-cli-tty-crates)
  - [Full TUI async, raw mode, full screen for immersive TUI apps](#full-tui-async-raw-mode-full-screen-for-immersive-tui-apps)
  - [Partial TUI async, partial raw mode for async REPL and shell programs](#partial-tui-async-partial-raw-mode-for-async-repl-and-shell-programs)
  - [Minimum TUI sync, blocking, partial raw mode for simple CLI programs with blocking interaction](#minimum-tui-sync-blocking-partial-raw-mode-for-simple-cli-programs-with-blocking-interaction)
  - [Underlying crates](#underlying-crates)
  - [Top level user facing crate](#top-level-user-facing-crate)
- [Learn how these crates are built, provide feedback](#learn-how-these-crates-are-built-provide-feedback)
- [Building the workspace, CI/CD, and testing](#building-the-workspace-cicd-and-testing)
- [Star History](#star-history)
- [Archive](#archive)

<!-- /TOC -->

## This workspace contains many TUI, CLI, TTY crates
<a id="markdown-this-workspace-contains-many-tui%2C-cli%2C-tty-crates" name="this-workspace-contains-many-tui%2C-cli%2C-tty-crates"></a>

The following is a high level overview of each of the crates that constitute this Rust
[workspace](https://github.com/r3bl-org/r3bl-open-core).

There are crates that range from "full" TUI to "partial" TUI, and everything in the middle.

### Full TUI (async, raw mode, full screen) for immersive TUI apps
<a id="markdown-full-tui-async%2C-raw-mode%2C-full-screen-for-immersive-tui-apps" name="full-tui-async%2C-raw-mode%2C-full-screen-for-immersive-tui-apps"></a>

[`r3bl_tui`](https://github.com/r3bl-org/r3bl-open-core/tree/main/tui) gives you raw mode
"alternate screen" and "full screen" support, while being totally async. An example of
this is the "Full TUI" app `edi` in the `r3bl-cmdr` crate. You can install & run this with
the following command:

```sh
cargo install r3bl-cmdr
edi
```

### Partial TUI (async, partial raw mode) for async REPL and shell programs
<a id="markdown-partial-tui-async%2C-partial-raw-mode-for-async-repl-and-shell-programs" name="partial-tui-async%2C-partial-raw-mode-for-async-repl-and-shell-programs"></a>

[`r3bl_terminal_async`](https://github.com/r3bl-org/r3bl-open-core/tree/main/terminal_async)
gives you the ability to easily build your own async shell programs using "async readline
& stdout".

Here are examples of this:
1. https://github.com/nazmulidris/rust-scratch/tree/main/tcp-api-server
2. https://github.com/r3bl-org/r3bl-open-core/tree/main/terminal_async/examples

### Minimum TUI (sync, blocking, partial raw mode) for simple CLI programs with blocking interaction
<a id="markdown-minimum-tui-sync%2C-blocking%2C-partial-raw-mode-for-simple-cli-programs-with-blocking-interaction" name="minimum-tui-sync%2C-blocking%2C-partial-raw-mode-for-simple-cli-programs-with-blocking-interaction"></a>

[`r3bl_tuify`](https://github.com/r3bl-org/r3bl-open-core/tree/main/tuify) gives you the
ability to easily build your own CLI programs with blocking interaction. This is a great
to get user input, while blocking the main thread, and using raw mode while the main thread is blocked.
An example app of this is the `giti` app in the `r3bl-cmdr` crate. You can install & run this with
the following command:

```sh
cargo install r3bl-cmdr
giti
```

### Underlying crates
<a id="markdown-underlying-crates" name="underlying-crates"></a>

There are many other underlying crates that are used to build these top level crates.
Here's a short list of them:

- [`r3bl_core`](https://github.com/r3bl-org/r3bl-open-core/tree/main/core)
  contains lots of low level utilities that are used in the other crates. This includes
  things like declarative macros, colors, styles, unicode support, etc. Over time, if some
  code is created in a "higher level" crate, and it's useful in other crates, it's moved
  to this crate. And this is documented in the
  [changelog](https://github.com/r3bl-org/r3bl-open-core/blob/main/CHANGELOG.md).

- [`r3bl_test_fixtures`](https://github.com/r3bl-org/r3bl-open-core/tree/main/test_fixtures)
  contains lots of test fixtures that are used in the other crates. This includes things
  like mocks for stdio, and event streams (input events that are generated by user
  interaction).

- [`r3bl_ansi_color`](https://github.com/r3bl-org/r3bl-open-core/tree/main/ansi_color) is
  a somewhat unrelated crate to the others in this workspace. It provides a clean API that
  allows you to easily use ANSI colors in your terminal programs. If you don't want to use
  the more complex crates and you just need to output some styled text to the terminal,
  then this is the crate for you.

### Top level user facing crate
<a id="markdown-top-level-user-facing-crate" name="top-level-user-facing-crate"></a>

There's even a crate that only contains user facing apps that are built using these
underlying crates. This is the
[`r3bl-cmdr`](https://github.com/r3bl-org/r3bl-open-core/tree/main/cmdr) crate, which
gives you the `giti` and `edi` apps (described above). You can install & run this with the
following command:

```sh
cargo install r3bl-cmdr
```

## Learn how these crates are built, provide feedback
<a id="markdown-learn-how-these-crates-are-built%2C-provide-feedback" name="learn-how-these-crates-are-built%2C-provide-feedback"></a>

To learn how we built this crate, please take a look at the following resources.
- If you like consuming video content, here's our [YT channel](https://www.youtube.com/@developerlifecom). Please consider [subscribing](https://www.youtube.com/channel/CHANNEL_ID?sub_confirmation=1).
- If you like consuming written content, here's our developer [site](https://developerlife.com/). Please consider subscribing to our [newsletter](https://developerlife.com/subscribe.html).
- If you have questions, please join our [discord server](https://discord.gg/8M2ePAevaM).

## Building the workspace, CI/CD, and testing
<a id="markdown-building-the-workspace%2C-ci%2Fcd%2C-and-testing" name="building-the-workspace%2C-ci%2Fcd%2C-and-testing"></a>

There's a `nushell` script that you can use to run the CI/CD pipeline for this workspace,
and more (local only operations). To get a list of these, you can view the `nushell`
script in the root of this repo
[`run`](https://github.com/r3bl-org/r3bl-open-core/blob/main/run). To get an idea of the
commands that you can run, try running the following command:

```sh
cargo install nu
nu run
```

You should see output that looks like this:

```text
Usage: run <command> [args]
<command> can be:
    all
    all-cicd
    build
    build-full
    clean
    install-cargo-tools
    test
    docs
    check
    check-watch
    clippy
    clippy-watch
    serve-docs
    upgrade-deps
    rustfmt
    help
```

For example:
- The `nu run all-cicd` command will run the CI/CD pipeline for this workspace.
- However, you can run the `nu run all` command to run the CI/CD pipeline, and more (local
  only operations).

Each crate that's contained in this workspace may also have its own `nushell` script that
is also named `run`. This is a convention that is used in this workspace. You can run the
`run` script in each of the crates to get a list of commands that are specific to that
crate.

## Star History
<a id="markdown-star-history" name="star-history"></a>

<a href="https://star-history.com/#r3bl-org/r3bl-open-core&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=r3bl-org/r3bl-open-core&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=r3bl-org/r3bl-open-core&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=r3bl-org/r3bl-open-core&type=Date" />
 </picture>
</a>

## Archive

As this repo grows, changes, and matures, pruning is necessary. The
[`r3bl-open-core-archive`](https://github.com/r3bl-org/r3bl-open-core-archive) is where
all the code and artifacts that are no longer needed are moved to.

This way nothing is "lost" and if you need to use some of the code that was removed, you
can find it there.

Also if you want to make changes to this code and maintain it yourself, please let us
know.

1. You can submit PRs and we can also accept them, and publish them to crates.io if that
   makes sense.
2. Or we can even work out and arrangements to move ownership of the code & crate to you
   if you would like to commit to maintaining it.