<p align="center">
  <img src="./r3bl-term.svg" height="128px">
</p>

# 🎨🖌️ Contributing to r3bl-open-core repo
<a id="markdown-%F0%9F%8E%A8%F0%9F%96%8C%EF%B8%8F-contributing-to-r3bl-open-core-repo" name="%F0%9F%8E%A8%F0%9F%96%8C%EF%B8%8F-contributing-to-r3bl-open-core-repo"></a>

Thank you for considering contributing to the `r3bl-open-core` repo! We welcome contributions from
everyone, regardless of your level of experience or expertise. If you would like to contribute, but
don't know where to start, check out the issues that are labeled `good first issue` or
`help wanted`.

<!-- TOC -->

  - [Discord server](#discord-server)
  - [Code of conduct](#code-of-conduct)
  - [Style guide](#style-guide)
- [🤝 Contribute](#-contribute)
  - [Explore our guides](#explore-our-guides)
  - [Working on issues](#working-on-issues)
  - [Feature requests and bug reports](#feature-requests-and-bug-reports)
  - [Documentation improvements](#documentation-improvements)
- [License](#license)

<!-- /TOC -->

### Discord server
<a id="markdown-discord-server" name="discord-server"></a>

Please join our [Discord server](https://discord.gg/8M2ePAevaM) to discuss the `r3bl-open-core` project and ask questions.

### Code of conduct
<a id="markdown-code-of-conduct" name="code-of-conduct"></a>

Before you start contributing, please take a moment to read the
[code of conduct](https://www.rust-lang.org/policies/code-of-conduct). We expect all contributors to
abide by this code of conduct in all interactions related to the project.

### Style guide
<a id="markdown-style-guide" name="style-guide"></a>

Please make sure your code adheres to our
[code style guide](docs/contributing_guides/STYLE_GUIDE.md). We also recommend that you open an 🗒️
issue to discuss your proposed changes before submitting a pull request.

If you're new to the project, you may want to check out our [README](README.md) file for an overview
of the project and its goals.

## 🤝 Contribute
<a id="markdown-%F0%9F%A4%9D-contribute" name="%F0%9F%A4%9D-contribute"></a>

We welcome contributions in the form of bug reports, feature requests, documentation improvements,
and code contributions.

### Explore our guides
<a id="markdown-explore-our-guides" name="explore-our-guides"></a>

Below are some guides to help you get started:

- [How to create an issue](docs/contributing_guides/ISSUE.md)
- [How to name a branch](docs/contributing_guides/BRANCH.md)
- [How to write a commit message](docs/contributing_guides/COMMIT_MESSAGE.md)
- [How to create a pull request](docs/contributing_guides/PULL_REQUEST.md)

### Working on issues
<a id="markdown-working-on-issues" name="working-on-issues"></a>

If you want to work on an issue, please comment on the issue asking to be assigned to it, so that we
can assign the issue to you. If you have any questions about the issue, we can discuss them in the
comments or on [R3BL Discord server](https://discord.gg/8M2ePAevaM).

### Feature requests and bug reports
<a id="markdown-feature-requests-and-bug-reports" name="feature-requests-and-bug-reports"></a>

If you encounter a bug or have an idea for a new feature, please open an issue on our
[GitHub repository](https://github.com/r3bl-org/r3bl-open-core/issues). Please provide as much
detail as possible, including steps to reproduce the issue and any relevant error messages.

Read more on
[how to create a good issue](https://github.com/r3bl-org/r3bl-open-core/blob/fe8ef6b8bbc2b1f73730659b1863216c8b8f0909/docs/contributing_guides/ISSUE.md).

### Documentation improvements
<a id="markdown-documentation-improvements" name="documentation-improvements"></a>

If you notice any errors or omissions in our documentation, please open an issue on our
[GitHub repository](https://github.com/r3bl-org/r3bl-open-core/issues) or submit a pull request with
your proposed changes.

Read more on
[how to create a good issue](https://github.com/r3bl-org/r3bl-open-core/blob/fe8ef6b8bbc2b1f73730659b1863216c8b8f0909/docs/contributing_guides/ISSUE.md).

## License
<a id="markdown-license" name="license"></a>

[`r3bl-open-core`](https://github.com/r3bl-org/r3bl-open-core) is released under the
[Apache 2.0](LICENSE).
