# Changelog

- [global-config](#global-config)
  - [-12-04](#-12-04)
- [r3bl-cmdr](#r3bl-cmdr)
  - [next](#v_next_release_cmdr)
  - [v0.0.16 2024-09-13](#v0016-2024-09-13)
  - [v0.0.15 2024-09-12](#v0015-2024-09-12)
  - [v0.0.14 2024-06-29](#v0014-2024-06-29)
  - [v0.0.13 2024-05-20](#v0013-2024-05-20)
  - [v0.0.12 2024-05-12](#v0012-2024-05-12)
  - [v0.0.11 2024-01-14](#v0011-2024-01-14)
  - [v0.0.10 2024-01-02](#v0010-2024-01-02)
  - [v0.0.9 2023-12-31](#v009-2023-12-31)
  - [v0.0.8 2023-12-22](#v008-2023-12-22)
- [r3bl_tuify](#r3bl_tuify)
  - [v0.2.0 2024-10-21](#v020-2024-10-21)
  - [v0.1.27 2024-09-12](#v0127-2024-09-12)
  - [v0.1.26 2024-04-15](#v0126-2024-04-15)
  - [v0.1.25 2024-01-14](#v0125-2024-01-14)
  - [v0.1.24 2023-12-31](#v0124-2023-12-31)
  - [v0.1.23 2023-12-22](#v0123-2023-12-22)
  - [v0.1.22 2023-12-20](#v0122-2023-12-20)
  - [v0.1.21 2023-10-21](#v0121-2023-10-21)
  - [v0.1.20 2023-10-21](#v0120-2023-10-21)
  - [v0.1.19 2023-10-17](#v0119-2023-10-17)
  - [v0.1.18 2023-10-17](#v0118-2023-10-17)
  - [v0.1.17 2023-10-14](#v0117-2023-10-14)
- [r3bl_tui](#r3bl_tui)
  - [v0.6.0 2024-10-21](#v060-2024-10-21)
  - [v0.5.9 2024-09-12](#v059-2024-09-12)
  - [v0.5.8 2024-09-07](#v058-2024-09-07)
  - [v0.5.7 2024-08-13](#v057-2024-08-13)
  - [v0.5.6 2024-06-29](#v056-2024-06-29)
  - [v0.5.5 2024-05-20](#v055-2024-05-20)
  - [v0.5.4 2024-05-20](#v054-2024-05-20)
  - [v0.5.3 2024-04-15](#v053-2024-04-15)
  - [v0.5.2 2024-01-14](#v052-2024-01-14)
  - [v0.5.1 2024-01-09](#v051-2024-01-09)
  - [v0.5.0 2023-12-31](#v050-2023-12-31)
  - [v0.4.0 2023-12-22](#v040-2023-12-22)
  - [v0.3.10 2023-10-29](#v0310-2023-10-29)
  - [v0.3.9 2023-10-29](#v039-2023-10-29)
  - [v0.3.7 2023-10-21](#v037-2023-10-21)
  - [v0.3.6 2023-10-17](#v036-2023-10-17)
  - [v0.3.5 2023-10-14](#v035-2023-10-14)
  - [v0.3.3 2023-04-20](#v033-2023-04-20)
  - [v0.3.2 2023-03-06](#v032-2023-03-06)
  - [v0.3.1 2023-03-06](#v031-2023-03-06)
- [r3bl_core](#r3bl_core)
  - [next](#v_next_release_r3bl_core)
  - [v0.10.0 2024-10-20](#v0100-2024-10-20)
- [r3bl_analytics_schema](#r3bl_analytics_schema)
  - [v0.0.2 2024-09-12](#v002-2024-09-12)
  - [v0.0.1 2023-12-31](#v001-2023-12-31)
- [r3bl_macro](#r3bl_macro)
  - [v0.10.0 2024-10-20](#v0100-2024-10-20)
- [r3bl_test_fixtures](#r3bl_test_fixtures)
  - [next](#v_next_release_r3bl_test_fixtures)
  - [v0.1.0 2024-10-21](#v010-2024-10-21)
  - [v0.0.3 2024-09-12](#v003-2024-09-12)
  - [v0.0.2 2024-07-13](#v002-2024-07-13)
  - [v0.0.1 2024-07-12](#v001-2024-07-12)
- [r3bl_terminal_async](#r3bl_terminal_async)
  - [v0.6.0 2024-10-21](#v060-2024-10-21)
  - [v0.5.7 2024-09-12](#v057-2024-09-12)
  - [v0.5.6 2024-08-13](#v056-2024-08-13)
  - [v0.5.5 2024-07-13](#v055-2024-07-13)
  - [v0.5.4 2024-07-12](#v054-2024-07-12)
  - [v0.5.3 2024-05-22](#v053-2024-05-22)
  - [v0.5.2 2020-05-06](#v052-2020-05-06)
  - [v0.5.1 2024-04-28](#v051-2024-04-28)
  - [v0.5.0 2024-04-22](#v050-2024-04-22)
  - [v0.4.0 2024-04-21](#v040-2024-04-21)
  - [v0.3.1 2024-04-17](#v031-2024-04-17)
  - [v0.3.0 2024-04-15](#v030-2024-04-15)
- [r3bl_ansi_color](#r3bl_ansi_color)
  - [v0.7.0 2024-10-18](#v070-2024-10-18)
  - [v0.6.10 2024-09-12](#v0610-2024-09-12)
  - [v0.6.9 2023-10-21](#v069-2023-10-21)
  - [v0.6.8 2023-10-16](#v068-2023-10-16)
  - [v0.6.7 2023-09-12](#v067-2023-09-12)
- [r3bl_rs_utils_macro](#r3bl_rs_utils_macro)
  - [Rename to r3bl_macro](#rename-to-r3bl_macro)
  - [v0.9.10 2024-09-12](#v0910-2024-09-12)
  - [v0.9.9 2024-04-16](#v099-2024-04-16)
  - [v0.9.8 2023-12-22](#v098-2023-12-22)
  - [v0.9.7 2023-10-21](#v097-2023-10-21)
  - [v0.9.6 2023-10-17](#v096-2023-10-17)
  - [v0.9.5 2023-10-14](#v095-2023-10-14)
- [r3bl_rs_utils_core](#r3bl_rs_utils_core)
  - [Rename to r3bl_core](#rename-to-r3bl_core)
  - [v0.9.16 2024-09-12](#v0916-2024-09-12)
  - [v0.9.15 2024-09-07](#v0915-2024-09-07)
  - [v0.9.14 2024-08-13](#v0914-2024-08-13)
  - [v0.9.13 2024-04-15](#v0913-2024-04-15)
  - [v0.9.12 2024-01-07](#v0912-2024-01-07)
  - [v0.9.11 2024-01-02](#v0911-2024-01-02)
  - [v0.9.10 2023-12-22](#v0910-2023-12-22)
  - [v0.9.9 2023-10-21](#v099-2023-10-21)
  - [v0.9.8 2023-10-21](#v098-2023-10-21)
  - [v0.9.7 2023-10-17](#v097-2023-10-17)
  - [v0.9.6 2023-10-17](#v096-2023-10-17)
  - [v0.9.5 2023-10-14](#v095-2023-10-14)
  - [v0.9.1 2023-03-06](#v091-2023-03-06)
- [r3bl_simple_logger](#r3bl_simple_logger)
  - [Archived 2024-09-27](#archived-2024-09-27)
  - [v0.1.4 2024-09-12](#v014-2024-09-12)
  - [v0.1.3 2023-10-21](#v013-2023-10-21)
  - [v0.1.2 2023-10-21](#v012-2023-10-21)
  - [v0.1.1 2023-10-17](#v011-2023-10-17)
  - [v0.1.0 2023-10-14](#v010-2023-10-14)
- [r3bl_redux](#r3bl_redux)
  - [Archived 2024-09-29](#archived-2024-09-29)
  - [v0.2.8 2024-09-12](#v028-2024-09-12)
  - [v0.2.7 2024-09-07](#v027-2024-09-07)
  - [v0.2.6 2023-10-21](#v026-2023-10-21)
  - [v0.2.5 2023-10-17](#v025-2023-10-17)
  - [v0.2.4 2023-10-14](#v024-2023-10-14)
- [r3bl_rs_utils](#r3bl_rs_utils)
  - [Archived 2024-09-30](#archived-2024-09-30)
  - [v0.9.16 2024-09-12](#v0916-2024-09-12)
  - [v0.9.15 2023-12-22](#v0915-2023-12-22)
  - [v0.9.14 2023-10-29](#v0914-2023-10-29)
  - [v0.9.13 2023-10-29](#v0913-2023-10-29)
  - [v0.9.12 2023-10-29](#v0912-2023-10-29)
  - [v0.9.11 2023-10-28](#v0911-2023-10-28)
  - [v0.9.10 2023-10-21](#v0910-2023-10-21)
  - [v0.9.9](#v099)
- [Renamed](#renamed)
  - [r3bl_rs_utils_macro](#r3bl_rs_utils_macro)
  - [r3bl_rs_utils_core](#r3bl_rs_utils_core)
- [Archived](#archived)
  - [r3bl_simple_logger](#r3bl_simple_logger)
  - [r3bl_redux](#r3bl_redux)
  - [r3bl_rs_utils](#r3bl_rs_utils)
- [More info on changelogs](#more-info-on-changelogs)

<!-- Global config section -->

## `global-config`

This section contains all the changes that are made to global configuration to build and
test the `r3bl-open-core` repo. This includes all the `run` scripts in each crate
contained in the monorepo, along with the top level `run` script. Things like RUSTSEC
advisory whitelist and which tasks are run in CICD are included here.

### 2024-12-04

This [PR](https://github.com/r3bl-org/r3bl-open-core/pull/370) contains the details for
the following:

- Updated:
  - Add a few RUSTSEC advisories to the whitelist in `deny.toml` file. These are
    persistent warnings and errors for 3 crates that are unmaintained. The main one is
    `syntect` which has not been updated in 10 months. I think there is some activity in
    their repo that will allow this issue to be resolved.
  - Run the `audit-deps` function in the `all-cicd` function, which is run in GitHub
    Actions. With the whitelist in place, this is ok to run and won't produce errors
    (since we already know about these 3 crates). The `unmaintained` function takes too
    long to run so it is still not included in teh `all-cicd` function.

<!-- Active crates section -->

## `r3bl-cmdr`

### v_next_release_cmdr

This is part of a total reorganization of the `r3bl-open-core` repo. This is a breaking
change for almost every crate in the repo. This
[PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

- Updated:
  - This release just uses the latest deps from `r3bl-open-core` repo, since so many
    crates have been reorganized and renamed. The functionality has not changed at all,
    just the imports.

### v0.0.16 (2024-09-13)

- Updated:
  - Minor fix to documentation in `lib.rs` and `README.md` to use GIF instead of MP4 files
    for the `edi` and `giti` videos. The MP4 files were not showing on docs.rs, crates.io,
    or github.com.

### v0.0.15 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.
  - Update `UPDATE_IF_NOT_THIS_VERSION` to `0.0.15`. This is kept in sync w/ the deployed
    backend `r3bl-base`.

### v0.0.14 (2024-06-29)

The most significant change in this release is the use of the latest release of the
Markdown parser from `r3bl_tui`, which improves the editing experience of writing each
individual line of Markdown text. Common edge cases that were not handled before are now
handled correctly. And these are cases that come up quite frequently when editing Markdown
in a text editor.

- Fixed:
  - Use the latest release of the `r3bl_tui` crate version `0.5.6` which fixes a lot of
    common bugs with the Markdown parser. This are critical bug fixes that are needed for
    the `edi` binary target, to make it a stable and usable Markdown editor for daily use.

- Changed:
  - Use the latest release of the `r3bl_tui` crate version `0.5.5`.
  - Clean up `main_event_loop` and get rid of needless `'static` in `AS` trait bound.
  - Fix cargo clippy doc warnings.
  - Update `UPDATE_IF_NOT_THIS_VERSION` to `0.0.14`. This is kept in sync w/ the deployed
    backend `r3bl-base`.

- Updated:
  - Dependencies for `syntect`, `strum`, `strum-macros`, `reedline`, `serial_test` bumped
    to their latest versions.

### v0.0.13 (2024-05-20)

- Changed:
  - `Cargo.toml` now points to the correct documentation link on docs.rs.
  - `README.md` now has the correct URL for the hero image (that will load on crates.io
    and not just github.com).
  - `lib.rs` has the same URL for the hero image as `README.md`.
  - Update `UPDATE_IF_NOT_THIS_VERSION` to `0.0.13`. This is kept in sync w/ the deployed
    backend `r3bl-base`.

### v0.0.12 (2024-05-12)

- Changed:
  - Use the latest deps of all the `r3bl_*` crates to fix breaking build when `cargo
    install r3bl-cmdr` is run. Not sure how long this has been broken. Moving forwards,
    this will be checked using a VM on every release. Update `release-guide.md`
    instructions with this info.
    - `r3bl_ansi_color = { path = "../ansi_color", version = "0.6.9" }`
    - `r3bl_rs_utils_core = { path = "../core", version = "0.9.13" }`
    - `r3bl_rs_utils_macro = { path = "../macro", version = "0.9.9" }`
    - `r3bl_tui = { path = "../tui", version = "0.5.3" }`
    - `r3bl_tuify = { path = "../tuify", version = "0.1.26" }`
  - Update the `UPDATE_IF_NOT_THIS_VERSION` to `0.0.12`. This is kept in sync w/ the
    deployed backend `r3bl-base`.

### v0.0.11 (2024-01-14)

- Added:
  - `edi`, `giti`: Add checks to see if binary needs to be upgraded.
    - Search for `UPDATE_IF_NOT_THIS_VERSION` in `r3bl-open-core` repo (in `cmdr` folder),
      and in `r3bl-base` repo. `UPDATE_IF_NOT_THIS_VERSION` is set to `0.0.11` for this
      release.
    - If upgrade is needed, then display a message to the user asking them to run `cargo
    install r3bl-cmdr` again.
  - `giti` add feature: `giti branch checkout`
  - `giti` add feature: `giti branch new`
  - Add `reedline` version `0.28.0` dependency in `Cargo.toml`.

### v0.0.10 (2024-01-02)

- Fixed:
  - Refactor & clean up the analytics client code.

- Updated:
  - Use the latest `r3bl_rs_utils_core` version `0.9.11`.

### v0.0.9 (2023-12-31)

- Added:
  - Anonymized analytics reporting to prioritize feature development for `edi` and `giti`.

- Changed:
  - Replace the `run` command with `examples` in the `run` nushell script. To run an
    example you use `nu run examples`. and provide instructions on the `run` script at the
    top level folder of this monorepo. Update `lib.rs` and `README.md` to reflect this
    change. The behavior of the `run` nushell script is more uniform across all crates in
    this repo.

### v0.0.8 (2023-12-22)

- Changed:
  - Rename `run.nu` to `run` and update `README.md` and `lib.rs` to reflect this change.
    This is a more ergonomic command to use, when using it directly eg: `./run build`
    (macOS, Linux), or `nu run build` (Windows).

- Added:
  - Add binary target `giti`. This is an interactive git client that is tuified. It is a
    productivity tool for git workflows, and is meant as a replacement for directly using
    `git`. This also serves as a real world example of using the `r3bl_tuify` crate.
    - View all the `giti branch` subcommands (e.g. `delete`, `checkout`, `new`, etc.) and
      select one subcommand using the `select_from_list()` when `giti branch` runs.
    - Delete one or more branches using `select_from_list()` when  `giti branch delete`
      command runs.
  - Add binary target `edi`. This is a powerful TUI Markdown editor. You can use it to
    create new MD files, or edit any type of text file. It supports syntax highlighting
    for most file formats (though `.toml` and `.todo` are missing).
  - Add binary target `rc` aka `r3bl-cmdr`.

## `r3bl_tuify`

### v0.2.0 (2024-10-21)

This is part of a total reorganization of the `r3bl-open-core` repo. This is a breaking
change for almost every crate in the repo. This
[PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

- Updated:
  - This release just uses the latest deps from `r3bl-open-core` repo, since so many
    crates have been reorganized and renamed. The functionality has not changed at all,
    just the imports.

- Removed:
  - Move some of `term.rs` into:
    - `r3bl_core` - The functions to get the terminal window size and width.
    - `r3bl_ansi_color` - The functions to detect whether the current process is running
      in an interactive TTY or not.

### v0.1.27 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.1.26 (2024-04-15)

- Updated:
  - Make `clip_string_to_width_with_ellipsis` pub so that other crates can use it (eg:
    `r3bl_terminal_async`).
  - Change the names of enums to be more readable.
    - `IsTTYResult::IsTTY` -> `TTYResult::IsInteractive`.
    - `IsTTYResult::IsNotTTY` -> `TTYResult::IsNotInteractive`.
  - Using latest deps for `r3bl_rs_utils_core` version `0.9.13`, and `r3bl_rs_utils_macro`
    version `0.9.9`.

### v0.1.25 (2024-01-14)

- Updated:
  - Dependency updated `reedline` version `0.28.0`, `r3bl_rs_utils_core` version `0.9.12`.
- Added:
  - Add `tuify/src/constants.rs` with color constants.

### v0.1.24 (2023-12-31)

- Changed:
  - Rename `run.nu` to `run`. This simplifies commands to run it, eg: `nu run build`, or
    `./run build`.
  - Replace the `run` command with `examples` in the `run` nushell script. To run an
    example you use `nu run examples`. and provide instructions on the `run` script at the
    top level folder of this monorepo. Update `lib.rs` and `README.md` to reflect this
    change. The behavior of the `run` nushell script is more uniform across all crates in
    this repo.

- Added:
  - Add a new top level function `select_from_list_with_multi_line_header()` in
    `public_api.rs` to allow for multi-line headers in the list selection menu. This
    allows ANSI formatted strings to be used in each header line.

- Fixed:
  - In `select_from_list()`, the `max_width_col_count` is now respected to limit the max
    width of the terminal window that is used.

### v0.1.23 (2023-12-22)

- Updated:
  - Update dependency on `r3bl_rs_utils_core` to `0.9.10`.

### v0.1.22 (2023-12-20)

- Updated:
  - Update dependency on `reedline` crate to `0.27.1`.
  - Update dependency on `r3bl_rs_utils_core` to `0.9.9`.

- Removed:
  - Remove dependency on `r3bl_tui` crate.

- Changed:
  - Change the default theme so that it is better looking and more readable on Mac, Linux,
    and Windows. Add many different themes to choose from.

- Added:
  - `Ctrl + c` now behaves just like the `Escape` key. In the past, pressing `Ctrl + c`
    would do nothing the user could not exit the app by pressing this shortcut.
  - More code quality and ability to test the main event loop, by creating a new
    `TestVecKeyPressReader` struct, and abstracting the `read()` (from `stdin`) into a
    `KeyPressReader` trait. This is similar to what is done for `TestStringWriter` (to
    `stdout`).

### v0.1.21 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.1.20 (2023-10-21)

- Updated:
  - Bug fix: <https://github.com/r3bl-org/r3bl-open-core/issues/170>

### v0.1.19 (2023-10-17)

- Updated:
  - Use the latest `r3bl_rs_utils_core` crate due to
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>, and `ansi_term` not being
    maintained anymore.

### v0.1.18 (2023-10-17)

- Updated:
  - Use the latest `r3bl_rs_utils_core` crate due to
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>, and `ansi_term` not being
    maintained anymore.

### v0.1.17 (2023-10-14)

- Updated:
  - Dependency on `simplelog` is replaced w/ `r3bl_simple_logger` (which is in the
    `r3bl_rs_utils` repo workspace as `simple_logger`).

## `r3bl_tui`

### v0.6.0 (2024-10-21)

This is a major release that not only includes new functionality, but is a radical
reorganization of the crates. The reason for paying down this technical debt now is to
ensure that the codebase is easier to maintain and understand, and easier to add new
features to in the future. The separation of concerns is now much clearer, and they
reflect how the functionality is used in the real world.

Another huge change is the method signature of `main_event_loop()`. This is a breaking
change, and it uses dependency injection, to provide an input device, output device,
state, and app to the function! This allows for new types of applications to be built,
which can carry state around between "applets".

This is part of a total reorganization of the `r3bl-open-core` repo. This is a breaking
change for almost every crate in the repo. This
[PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

- Added:
  - Provide a totally new interface for the `main_event_loop()` that allows for more
    flexibility in how the event loop is run, using dependency injection. This is a
    breaking change, but it is needed to make the codebase more maintainable and possible
    to test end to end. This new change introduces the concept of providing some
    dependencies to the function itself in order to use it: state, input device, output
    device, and app. The function now returns these dependencies as well, so that they can
    be used to create a running pipeline of small "applets" where all of these
    dependencies are passed around, allowing a new generation of experiences to be built,
    that are not monolithic, but are composable and testable.
  - End to end test for the `main_event_loop_impl()` which tests everything in the TUI
    engine! 🎉 This feature has taken about 2 years and 7 months to implement
    (`2024-10-07`)! This repo was created in `2022-02-23`, which you can get using
    `curl https://api.github.com/repos/r3bl-org/r3bl-open-core | jq .created_at`.

- Changed:
  - Refactor lots of styling related code in preparation for the move to `core`. This will
    make it easier to maintain and test the codebase, and clean up the dependencies.
  - The latest version of `unicode-width` crate `v2.0.0` changes the widths of many of the
    emoji. This requires lots of tests to be changed in order to work w/ the new constant
    width values.

- Removed:
  - Move the `color_wheel` module into `r3bl_core` crate. This is to ensure that it is
    possible to import just color wheel and lolcat related functionality without having to
    import the entire `r3bl_tui` crate. And de-tangles the dependency tree, making it
    easier to maintain. The reason they ended up in `r3bl_tui` in the first place is
    because it was easier to develop them there, but since then, lots of other consumers
    of this functionality have emerged, including crates that are created by "3rd party
    developers" (people not R3BL and not part of `r3bl-open-core` repo).

### v0.5.9 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.5.8 (2024-09-07)

- Removed:
  - Remove `get-size` crate from `Cargo.toml`. This was causing some [issues with
    `RUSTSEC-2024-0370`](https://github.com/r3bl-org/r3bl-open-core/issues/359).

- Added:
   - Add `size-of` crate.
    - This new crate is used to calculate the size of structs in bytes.
    - Change the implementations of many structs in the following modules:
      `editor_buffer`, `dialog_buffer`, `editor_component`, `editor_engine`,
      `color_wheel`, `lolcat`, and following files: `offscreen_buffer.rs`,
      `main_event_loop.rs`.

- Updated:
  - Use the latest deps for all crates in `Cargo.toml` and `Cargo.lock`.

### v0.5.7 (2024-08-13)

The biggest change in this release is rewriting the example runner using the latest
`r3bl_terminal_async` crate, and dropping the use of `reedline` crate (which is no longer
used to run the examples).

`r3bl_terminal_async` is fully async and allows seamless creation of REPLs and shells. It
also supports pause and resume for spinners, along with many other features.

- Updated:
  - Change the main examples launcher (which you can run using `nu run examples`) so that
    it correctly handles raw mode transitions, and also correctly uses the
    `r3bl_terminal_async` crate to ask the user for input (using "async readline").
  - Drop dependency on `reedline`. Use `r3bl_terminal_async` instead to get async readline
    capabilities. Update examples to use this new crate, and make example launcher easier
    to maintain.

- Fixed:
  - Fix a minor and subtle bug with shutdown signal in the main event loop.
    [PR](https://github.com/r3bl-org/r3bl-open-core/pull/336/) to fix this
    [issue](https://github.com/r3bl-org/r3bl-open-core/issues/331).

### v0.5.6 (2024-06-29)

The biggest change in this release is the rewrite of the Markdown parser. This was done
because the previous parser was not able to handle many corner cases in parsing complex
fragments from a single line of text, which is common in Markdown. The new parser is
exhaustively tested and is able to handle many more corner cases.

- Fixed:
  - Rewrite most of the Markdown parser and add exhaustive tests and lots of corner cases
    which were not covered before. A lot of these issues were found by using the `edi`
    binary target for a few weeks as a Markdown editor. Here's the
    [PR](https://github.com/r3bl-org/r3bl-open-core/pull/332) with these fixes.

- Updated:
  - Fix docs (for docs.rs and README.md for github and crates.io).
  - Fix clippy warnings.
  - Make minor refactors and cleanups.

### v0.5.5 (2024-05-20)

- Updated:
  - Fix typos in `README.md`.

### v0.5.4 (2024-05-20)

- Updated:
  - `README.md`
    - Fix image loading problems on crates.io. The `README.md` is shown in crates.io, and
      `lib.rs` is shown in docs.rs.
    - Clean up the content in the `README.md` file, and make it current, and update
      `lib.rs` to match.

### v0.5.3 (2024-04-15)

- Updated:
  - Dependency changes inherited from `r3bl_rs_utils_core` version `0.9.13`, and
    `r3bl_rs_utils_macro` version `0.9.9`.
  - Lots of clippy fixes.

### v0.5.2 (2024-01-14)

- Updated:
  - Dependency updated `reedline` version `0.28.0`, `r3bl_rs_utils_core` version `0.9.12`.

### v0.5.1 (2024-01-09)

- Added:
  - Simple function `ColorWheel::lolcat_into_string()` that receives a string and
    colorizes it using some defaults. It is similar to the
    `ColorWheel::colorize_into_string()` which it uses under the hood, but it is simpler
    to use.

### v0.5.0 (2023-12-31)

- Changed:
  - Rename `run.nu` to `run` in the `tui` folder. This simplifies commands to run it, eg:
    `nu run build`, or `./run build`.
  - Rename `run.nu` to `run` in the top level folder as well.
  - Replace the `run` command with `examples` in the `run` nushell script. To run an
    example you use `nu run examples`. and provide instructions on the `run` script at the
    top level folder of this monorepo. Update `lib.rs` and `README.md` to reflect this
    change. The behavior of the `run` nushell script is more uniform across all crates in
    this repo.
  - In `app.rs`, change `App` trait function `app_handle_signal()` to receive 2 new
    arguments: `component_registry_map`, and `has_focus`. This makes it similar to
    `app_handle_input_event()`.

- Fixed:
  - Editor component now cleans up state correctly after new content loads. This includes
    the undo/redo stack, and the render ops cache (for the content).
  - Fix `tui/examples/demo/ex_pitch` example to correctly move back and forward between
    slides.

- Added:
  - <kbd>Escape</kbd> key now clears the selection.
  - <kbd>Ctrl+A</kbd> now selects all text.
  - Tests for `EditorComponent` for undo / redo history, text selection, and clipboard service.
  - Add tests to editor component for clipboard service.

### v0.4.0 (2023-12-22)

- Changed:
  - Drop the use of Redux for state management entirely. Replace this with mutable state.
    And a new architecture for App and Component, that is more like Elm, rather than React
    and Redux.
  - Async middleware functions no longer use Redux for propagating state transitions to
    the app; instead, they now achieve this through [async `tokio::mpsc`
    channels](https://tokio.rs/tokio/tutorial/channels). Here's a [design
    doc](https://docs.google.com/document/d/1OMB1rX6cUL_Jxpl-OUWMhJijM7c4FoDrK6qDViVXBWk/edit)
    for this change. Here's the
    [issue](https://github.com/r3bl-org/r3bl-open-core/issues/196) and
    [PR](https://github.com/r3bl-org/r3bl-open-core/pull/205) for this change. Here are
    some videos that go over this massive change:
    - <https://youtu.be/o2CVEikbEAQ>
    - <https://youtu.be/Ne5-MXxt97A>
  - In the editor component, disable the syntect highlighter for the editor by default
    and just use the custom MD parser. For files that are not Markdown, we will probably
    need to enable syntect in the future since it is not covered by the custom MD parser &
    highlighter combo.

- Fixed:
  - Fix the custom MD parser so that it correctly parses plain text.

- Added:
  - Add undo, redo support for the editor component.
  - Add binary target for `edi` which is going to be a Markdown editor similar to `nano`
    or `micro`. It is meant to showcase what the `r3bl_tui` crate can do. It is also meant
    to be a useful productivity tool.
  - Add function `colorize_into_string()` to make it easy to apply color wheel to a string
    and then convert it into an ANSI styled string that can be used to print to the
    terminal emulator. Also added conversion function
    `convert_tui_color_into_r3bl_ansi_color()` to convert from `TuiColor` to
    `r3bl_ansi_term::Color`.
  - In editor component, add support for caching rendered output of content. When the
    content changes, or the viewport size or window size change, the cache is invalidated.
    This is useful for performance reasons. It also leverages the undo/redo system for
    cache invalidation (which makes it fast to invalidate the render ops cache w/out
    having to do a content comparison to detect changes).
  - Add lots of editor component tests for selection, content cache.

- Updated:
  - Update dependency on `reedline` crate to `0.27.1`.
  - Update dependency on `r3bl_rs_utils_core` to `0.9.10`.
  - Update dependency on `r3bl_rs_utils_macro` to `0.9.8`.

### v0.3.10 (2023-10-29)

- Changed:
  - Replaced `arboard` crate with `copypasta-ext`.
    - `arboard` was not working well on macOS and Windows.
    - The `copypasta-ext` crate should fix the problem w/ dropping the clipboard contents
      when an app using the editor component exits.
  - Added deps are upgraded to their latest versions.
  - Changed `cargo.deny` so that it now accepts `ISC` license.
- Added:
  - Support for select, copy, cut, paste, and delete have been added to the editor component.

### v0.3.9 (2023-10-29)

- Changed:
  - Dropped support for `clipboard` crate. Used `arboard` instead which is actively
    maintained and supported by 1Password. New Github Actions have been added to ensure
    that `cargo-deny` is used in order to check for crates going unmaintained (along w/
    license audit checks). There are known issues w/ this crate on Wayland & Arch.
    <https://github.com/r3bl-org/r3bl-open-core/commit/3ba4ff821373361bedcd0b7185a4b6ba15b745c8>

### v0.3.7 (2023-10-21)

- Changed:
  - Dropped support for `palette` crate. Use `colorgrad` instead. More info here:
    <https://github.com/r3bl-org/r3bl-open-core/issues/162>

- Updated:
  - Upgraded all deps to their latest versions.

### v0.3.6 (2023-10-17)

- Changed:
  - Switched to using `r3bl_ansi_color` to detect terminal color capabilities and color
    output and conversions.
  - Apply `#[serial]` on tests that mutate global variables to make those tests un-flaky.
    This was already being done in `r3bl_ansi_color`, just bringing this over to the
    `r3bl_tui` crate with this release.

- Removed:
  - Dependency on `ansi_term` which is no longer maintained
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>.
  - Needless dependencies on crates that are not used.

### v0.3.5 (2023-10-14)

- Added:
  - Support for selecting text using keyboard.
  - Support for copying text to clipboard using keyboard.
- Fixed:
    - Main event loop was actually doing the wrong thing and blocking on the thread. Even though it
      accepted an input event asynchronously using `AsyncEventStream` (`EventStream` is provided by
      `crossterm` and built using tokio async streams), it was blocking this task (running in
      parallel on a thread) as it was waiting for the input event to be processed by the app. The
      fix allows the main thread to simply spawn a new task (in parallel, on a thread) to process
      the input event. An `mpsc` channel is used in order for the async work done to signal to the
      main thread that it should break out of its infinite loop.

### v0.3.3 (2023-04-20)

- Added:
  - Add `ColorSupport` as a way to detect terminal emulator capabilities at runtime. This uses the
    [`concolor_query`](https://docs.rs/concolor-query/latest/concolor_query/) crate to detect
    terminal emulator capabilities at runtime.
  - At the `RenderOps` level, update `to_crossterm_color()` so that it uses `ColorSupport` to
    determine the best color to use based on terminal emulator capabilities at runtime. It can
    automatically convert from truecolor to ANSI 256 to grayscale. Note that if a color is specified
    as truecolor, then it will automatically be downgraded. If it is specified as ANSI or grayscale
    then it will not be downgraded.
  - Add `ColorWheel` as a way to consolidate all gradient related coloring. Gradients can be
    specified in truecolor, ANSI 256, or grayscale. The `ColorWheel` will automatically use the
    correct colors based on the terminal emulator capabilities at runtime using `ColorSupport`.
  - Add new Markdown parser written using [`nom`](https://crates.io/crates/nom) crate called
    `parse_markdown()`.
    - This parser not only parses regular Markdown but it also supports R3BL extensions for notes
      (metadata: tags, title, authors, date).
    - And it also supports smart lists (ordered and unordered). Smart lists also have support for
      todos (in the form of checked and unchecked items).
  - Add a new syntax highlighting engine for the new Markdown parser, in the `EditorComponent`
    called `try_parse_and_highlight()`.
    - It formats headings using different gradients for each heading levels 1-6. It also has elegant
      fallbacks for ANSI256 and grayscale.
    - It formats metadata (tags, title, authors, date) using different fg and bg colors.
    - Smart lists are formatted using different fg and bg colors. Ordered and unordered lists are
      formatted differently. Checked and unchecked items are formatted differently.
    - For code blocks, the `syntect` crate is used to do syntax highlighting based on the correct
      language of the code block. Since the R3BL theme `r3bl.tmTheme` specifies colors in truecolor,
      they will automatically be downgraded to ANSI256 or grayscale based on terminal emulator
      capabilities at runtime thanks to `to_crossterm_color()`.
  - To make console log debugging nicer, some new traits have been added `ConsoleLogInColor`,
    `PrettyPrintDebug`. These traits work together. If a struct implements `PrettyPrintDebug` then
    it gets the implementation of `ConsoleLogInColor` for free (which gives it the ability to print
    using fg and bg colors to the console).

### v0.3.2 (2023-03-06)

- Fixed:
  - Bug when trying to render an app that's taller than the offscreen buffer / terminal height

### v0.3.1 (2023-03-06)

- Added:
  - First changelog entry.
  - Remove dependency on ansi-parser crate:
    [issue](https://github.com/r3bl-org/r3bl-open-core/issues/91).
  - Make lolcat code better: [issue](https://github.com/r3bl-org/r3bl-open-core/issues/76).
    - Add `ColorSupport` as a way to detect terminal emulator capabilities at runtime.
    - Add `ColorWheel` as a way to consolidate all gradient related coloring. Use `ColorSupport` as
      a way to fallback from truecolor, to ANSI 256, to grayscale gracefully based on terminal
      emulator capabilities at runtime.
  - Provide for ANSI 256 color fallback for MacOS terminal app:
    [issue](https://github.com/r3bl-org/r3bl-open-core/issues/79)

- Removed:
  - Removed lolcat example from demo.

- Changed:
  - The first demo example (`ex_app_no_layout`) now has support for animation. It automatically
    increments the state every second and the gradient color wheel is updated accordingly.

## `r3bl_core`

### v_next_release_r3bl_core

This release does not have any major changes. Here are the highlights:
- [PR](https://github.com/r3bl-org/r3bl-open-core/pull/370/commits/20fe5e730a0f592c203c85a68ee6e5b345136f44)
  1. Add a new declarative macro to effortlessly create global mutable thread safe
     singletons (without using `unsafe`).
  2. Replace all the ignored doc tests with `no_run` (just compile) or compile and run. For
     all Rust source files (in the entire monorepo, and not just this crate / folder).
- [PR](https://github.com/r3bl-org/r3bl-open-core/pull/376/commits/39bf421bb86d4de004bffd08f35df12ce3ef8541)
  1. There's a new converter `convert_to_ansi_color_styles` which converts a `TuiStyle` into
     a `Vec` of `r3bl_ansi_term::Style`.
  2. This is for `lolcat_api` enhancements which now
     allow for an optional default style to be passed in, that will be applied to the
     generated lolcat output.

Changed:
  - Fix all the Rust doc tests that were marked with `ignore`. Remove the `ignore` with
    either run and compile, or just `no_run` (compile only) in some cases where the code
    can't be run, but needs to be compiled.

- Updated:
  - Fix all the Rust docs that are ignored (in all Rust source files in this crate), and
    replace them with doc comments that compile successfully.

- Added:
  - `lolcat_api` enhancements that now allow for an optional default style to be passed in
    to `ColorWheel::lolcat_into_string` and `ColorWheel::colorize_into_string`, that will
    be applied to the generated lolcat output.
  - `convert_to_ansi_color_styles` module that adds the ability to convert a `TuiStyle`
    into a `Vec` of `r3bl_ansi_term::Style`.
  - A new declarative macro `create_global_singleton!` that takes a struct (which must
    implement `Default` trait) and allows it to be simply turned into a singleton.
    - You can still use the struct directly. Or just use the supplied generated associated
      function on the struct called `get_mut_singleton()` and use the singleton directly.
      It does *NOT* use `unsafe`.
    - The code is safe and uses `Arc<Mutex<T: Default>>`, where `T` is your struct, under
      the covers with `std::sync::Once` to make all this work.
    - Please take a look at the code itself for more details, and the docs have usage
      examples.
    - Another neat thing about this declarative macro is that it generates Rust docs for
      the generated code itself and these docs include references to the types and static
      variables that are generated.

- Removed:
  - Remove the following declarative macros that were not being used anywhere, and there
    are suitable candidates in the standard library that can be used instead:
    - `unwrap_option_or_run_fn_returning_err!`
    - `unwrap_option_or_compute_if_none!`

### v0.10.0 (2024-10-20)

This is a major release that does not include any new functionality, but is a radical
reorganization & rename of the crate, it used to be
[`r3bl_rs_utils_core`](#rename-to-r3bl_core).

The `r3bl-open-core` repo was started in `2022-02-23`, about 2 years, 7 months ago, (which
you can get using `curl https://api.github.com/repos/r3bl-org/r3bl-open-core | jq
.created_at`). We have learned many lessons since then after writing about 125K lines of
Rust code.

And it is time to pay down the accrued technical debt, to ensure that the codebase is
easier to maintain and understand, and easier to add new features to in the future. The
separation of concerns is now much clearer, and they reflect how the functionality is used
in the real world.

- Removed:
  - Remove the dependency on `r3bl_simple_logger` and archive it. You can read the details
    in its [CHANGELOG entry](#archived-2024-09-27). Tokio tracing is now used under the
    covers.
  - Remove all the functions like `log_debug`, `log_info`, etc. and favor directly using
    tokio tracing macros for logging, eg: `tracing::debug!`, `tracing::info!`, etc.

- Changed:
  - Rename the `debug!` macro, which is confusing, since it clashes with logging, to
    `console_log!`. This macro is used in many places in the codebase for quick formatted
    output to console (via `eprintln!`). The code to format the output is in the
    `console_log_impl.rs` file.
  - Reorganize the `src` folder to make sure that there aren't any top level files, and that
    everything is in a module. This is to make it easier to add new modules in the future.
  - The latest version of `unicode-width` crate `v2.0.0` changes the widths of many of the
    emoji. This requires lots of tests to be changed in order to work w/ the new constant
    width values.

- Added:
  - Simplify the actual logging API into a single function, and allow use of tokio
    tracing, macros for for logging, eg: `tracing::debug!`, `tracing::info!`, etc. See
    `logging_api.rs` for more details.
  - Move the `color_wheel` module into `r3bl_core` crate. This is to ensure that it is
    possible to import just color wheel and lolcat related functionality without having to
    import the entire `r3bl_tui` crate. And de-tangles the dependency tree, making it
    easier to maintain. The reason they ended up in `r3bl_tui` in the first place is
    because it was easier to develop them there, but since then, lots of other consumers
    of this functionality have emerged, including crates that are created by "3rd party
    developers" (people not R3BL and not part of `r3bl-open-core` repo).
  - Move the `kv.rs` module into `storage` from the
    `nazmulidris/rust-scratch/tcp-api-server` repo. This provides an in-memory /
    in-process key value store that is built on top of
    [`sled`](https://docs.rs/sled/latest/sled/). This eliminates the need to use files to
    save / load data.
  - Move the `miette_setup_global_report_handler.rs` from the
    [`nazmulidris/rust-scratch/tcp-api-server`](https://github.com/nazmulidris/rust-scratch/)
    repo. This allows customization of the miette global report handler at the process
    level. Useful for apps that need to override the default report handler formatting.
  - Add `OutputDevice` that abstracts away the output device (eg: `stdout`, `stderr`,
    `SharedWriter`, etc.). This is useful for end to end testing, and adapting to a
    variety of different input and output devices (in the future). Support for this is
    provided in [`r3bl_test_fixtures`](#r3bl_test_fixtures).
  - Add `InputDevice` that abstracts away the input device (eg: `stdin`). This is useful
    for end to end testing. This is useful for end to end testing, and adapting to a
    variety of different input and output devices (in the future). Support for this is
    provided in [`r3bl_test_fixtures`](#r3bl_test_fixtures).
    - Moved:
  - Move some code from `r3bl_tuify`'s `term.rs` into `r3bl_core`. This module provides a
    simple API to detect the size of a terminal window and its width.

## `r3bl_analytics_schema`

### v0.0.2 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.0.1 (2023-12-31)

- Added:
  - Initial support structs for use by `r3bl-base` and `r3bl-cmdr`.

## `r3bl_macro`

### v0.10.0 (2024-10-20)

This is a major release that does not include any new functionality, but is a radical
reorganization & rename of the crate, it used to be
[`r3bl_rs_utils_macro`](#rename-to-r3bl_macro).

The `r3bl-open-core` repo was started in `2022-02-23`, about 1 year, 7 months, and 11 days
ago, (which you can get using `curl https://api.github.com/repos/r3bl-org/r3bl-open-core |
jq .created_at`). We have learned many lessons since then after writing about 125K lines
of Rust code.

And it is time to pay down the accrued technical debt, to ensure that the codebase is
easier to maintain and understand, and easier to add new features to in the future. The
separation of concerns is now much clearer, and they reflect how the functionality is used
in the real world.

This [PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

Changed:
  - The name of this repo used to be [`r3bl_rs_utils_macro`](#rename-to-r3bl_macro).
  - The modules and functions in this crate which are used (by other crates in this monorepo)
    are left unchanged. Only the unused modules and functions are moved to the
    [`r3bl-open-core-archive`](https://github.com/r3bl-open-core-archive) repo.

Deleted:
  - Move all the unused modules and functions to the
    [`r3bl-open-core-archive`](https://github.com/r3bl-open-core-archive) repo.

## `r3bl_test_fixtures`

### v_next_release_r3bl_test_fixtures

This release adds a new fixture to make it easy to create temporary directories for tests.

- Added:
  - Add a new fixture `temp_dir::create_temp_dir()` to make it easy to create temporary
    directories for tests. Any temporary directories created are automatically cleaned up
    after the test is done. The `TempDir` struct implements many traits that make it
    ergonomic to use with `std::fs`, `std::path` and `std::fmt`. Here are the PRs for this
    change:
    - [PR 1](https://github.com/r3bl-org/r3bl-open-core/pull/372)
    - [PR 2](https://github.com/r3bl-org/r3bl-open-core/pull/373)

### v0.1.0 (2024-10-21)

This is part of a total reorganization of the `r3bl-open-core` repo. This is a breaking
change for almost every crate in the repo. This
[PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

- Changed:
  - Some type aliases were defined here redundantly, since they were also defined in
    `r3bl_core` crate. Remove these duplicate types and add a dependency to `r3bl_core`
    crate.

- Added:
  - Add ability for `StdoutMock` to be turned into an `OutputDevice` struct for mocks that
    are needed in tests. This is done via the `OutputDeviceExt` trait that is implemented
    for `OutputDevice`, which adds this method: `OutputDevice::new_mock()`.
  - Add ability for `mod@async_input_stream` to be turned into an `InputDevice` struct for
    mocks that are needed in tests. This is done via the `InputDeviceExt` trait that is implemented
    for `InputDevice`, which adds this method: `InputDevice::new_mock(vec![])`.

### v0.0.3 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.0.2 (2024-07-13)

This release adds a new function to create an async stream that yields results (from a
vec) at a specified interval. This is useful for testing async functions that need to
simulate a stream of events with a delay.

- Added:
  - Add `gen_input_stream_with_delay()` to create an async stream that yields results (from
    a vec) at a specified interval. This is useful for testing async functions that need to
    simulate a stream of events with a delay.
  - Add more tests.

- Misc:
  - The
    [async_cancel_safe](https://github.com/nazmulidris/rust-scratch/tree/main/async_cancel_safe)
    example repo now uses this crate. Here's a
    [tutorial](https://developerlife.com/2024/07/10/rust-async-cancellation-safety-tokio/)
    about it.

### v0.0.1 (2024-07-12)

This is the first release of this crate. It is a top level crate in the `r3bl-open-core`
that is meant to hold all the test fixtures for all the other crates in this monorepo. It
primarily tests input events coming from user input via keyboard and mouse (eg: crossterm
events). And it tests output that is sent to `stdout` which it mocks. Here are all the
links for this release: [crates.io](https://crates.io/crates/r3bl_test_fixtures),
[docs.rs](https://docs.rs/r3bl_test_fixtures),
[GitHub](https://github.com/r3bl-org/r3bl-open-core/tree/main/test_fixtures).

- Added:
  - Add a new top level crate in the `r3bl-open-core` monorepo called `r3bl_test_fixtures`.
    This is to make it easier to maintain and test the fixtures and allow all the other
    crates in this monorepo to use them. These fixtures are migrated from `r3bl_terminal_async`
    crate, where they were gestated, before being graduated for use by the entire monorepo.

## `r3bl_terminal_async`

### v0.6.0 (2024-10-21)

This is a major version upgrade and potentially a breaking change if you use the tracing
modules in this crate. This [PR](https://github.com/r3bl-org/r3bl-open-core/pull/360)
contains all the changes.

- Added:
  - Add tests to ensure that the tracing module works as expected. This includes using the
    `assert_cmd` trait to test the output of a test binary that is run as a subprocess.
    Ensure that stdout and stderr are captured and can be tested for correctness. Also
    ensure that `SharedWriter` works as expected. Also ensure that file log output works
    as expected.

- Changed:
  - Refactor the tracing and Jaeger related code into 2 separate modules. This is laying
    the groundwork for these modules to be moved into `r3bl_core` crate.
    Radically simplify the tracing configuration design and init mechanisms, so they are
    easy to understand, use, and maintain.
  - Introduce the use of `InputDevice` and `OutputDevice` to make it consistent with
    `r3bl_tui` crate on how DI is used to provide input and output devices. The input
    device provides a way to get user input events from stdin (or from a test fixture).
    The output device provides a way to output to stdout (or to a test fixture). Replace
    the use of type aliases with the actual structs from `r3bl_core` crate.

- Deleted:
  - Move the Jaeger tracing module to the `tcp-api-server` crate in the
    [`rust-scratch`](https://github.comnazmulidris/rust-scratch/) repo. This wasn't really
    used anywhere else. Also remove all the OpenTelemetry related dependencies from this
    crate.
  - Move the tracing module into the `r3bl_core` crate, in the mono repo.

### v0.5.7 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.5.6 (2024-08-13)

The biggest change in this release is complete support for pause and resume. Now when the
output is paused, input is also paused, with the exception of allowing <kbd>Ctrl+C</kbd>
and <kbd>Ctrl+D</kbd> through.

The second big change is how spinners now work. Once a spinner is started, <kbd>Ctrl+C</kbd>
and <kbd>Ctrl+D</kbd> are directed to the spinner, to cancel it. Spinners can also be checked
for completion or cancellation by long running tasks, to ensure that they exit as a response
to user cancellation.

The third (and final) change is that `TerminalAsync::try_new()` now accepts prompts that
can have ANSI escape sequences in them. By using `r3bl_rs_utils_core::StringLength` to
calculate the display width of strings containing ANSI escape sequences (by memoizing the
results of the calculations), the cost of repeatedly calculating this display width is
almost eliminated.

Here's the [PR](https://github.com/r3bl-org/r3bl-open-core/pull/349) with all the code
related to this release.

- Added:
  - Add support to extend pause and resume functionality to the entire crate. Now, when
    the output is paused, for eg, when the spinner is running, then the input to the
    readline is also stopped, until output is resumed. This wasn't the case in the past,
    and it was possible to type and update the prompt while the output was paused.
  - Add user cancellation support for spinners. Once a spinner is started,
    <kbd>Ctrl+C</kbd> and <kbd>Ctrl+D</kbd> are directed to the spinner, to cancel it.
    Spinners can also be checked for completion or cancellation by long running tasks, to
    ensure that they exit as a response to user cancellation. Update the
    `examples/terminal_async.rs` to show how to best use this new feature.
  - Add better examples for how to use `TerminalAsync::try_new()` in Rust docs.
  - Add a new example `async_shell.rs` to demonstrate how to use `TerminalAsync` to create
    an interactive shell (with `bash` under the covers) that can orchestrate a shell
    asynchronously using
    [`tokio::process`](https://docs.rs/tokio/latest/tokio/process/struct.Child.html).

- Changed:
  - Clean up the shutdown mechanism for `TerminalAsync` and `Readline` so that it is
    automatic, and doesn't require the use of `close()` anymore. By simply dropping the
    `Readline` instance, it will automatically clean up after itself (and correctly handle
    raw mode entry and exit).

### v0.5.5 (2024-07-13)

This minor release just updates the `r3bl_test_fixtures` crate to version `0.0.2` which
adds a new function to create an async stream that yields results (from a vec) at a
specified interval.

- Changed:
  - Bump dependency on `r3bl_test_fixtures` to version `0.0.2`.

### v0.5.4 (2024-07-12)

This release migrates the test fixtures out of this crate and into a new top level crate
in the `r3bl-open-core` monorepo called `r3bl_test_fixtures`. This is to make it
easier to maintain and test the fixtures and allow all the other crates in this monorepo
to use them. Here are all the links for this release:
[crates.io](https://crates.io/crates/r3bl_terminal_async),
[docs.rs](https://docs.rs/r3bl_terminal_async),
[GitHub](https://github.com/r3bl-org/r3bl-open-core/tree/main/terminal_async).

- Changed:
  - Remove the test fixtures out of this crate and into a new top level crate in the
    `r3bl-open-core` monorepo called `r3bl_test_fixtures`. This is to make it easier to
    maintain and test the fixtures and allow all the other crates in this monorepo to use
    them.

- Added:
  - Add `r3bl_test_fixtures` version `0.0.1` as a `dev-dependency` to this crate.

### v0.5.3 (2024-05-22)

This release adds a new module for checking port availability on a host, and adds a new
function to clean up the prompt when the CLI exits. It also adds a new module to allow for
OpenTelemetry (OTel) tracing to be added to the tracing setup. This uses the latest
version of Jaeger and OpenTelemetry.

- Added:
  - New module to check for port availability on a host called `port_availability`. This
    is useful for checking if a port is available before starting a server (which is a
    common use case for interactive CLI programs).
  - Add `TerminalAsync::print_exit_message()` - This cleans the prompt so it doesn't
    linger in the display output. This is intended to be used as the final display message
    when the CLI exits.
  - For greater flexibility `tracing_setup.rs` `try_create_layers(..)` now returns a
    `Vec<Layer>`. This allows for more flexibility in the future to add more layers to the
    tracing setup, such as adding an OTel (OpenTelemetry) layer, or a Jaeger layer, etc.
  - Add `jaeger_setup` module, to allow OTel layer to be added to the tracing setup. It
    uses the latest version of Jaeger and OpenTelemetry. The docs in `tokio.rs`
    [website](https://tokio.rs/tokio/topics/tracing-next-steps) (at the time of this
    writing) are out of date and use version `0.16.0` of `opentelemetry-jaeger` crate who's
    exporter component has already been deprecated and will be removed
    [soon](https://github.com/open-telemetry/opentelemetry-specification/pull/2858/files).
    Details are in [PR 326](https://github.com/r3bl-org/r3bl-open-core/pull/326). More
    info in this [blog post](https://broch.tech/posts/rust-tracing-opentelemetry/).

- Changed:
  - `try_create_layers(..)` also adds a level filter layer to the layers it returns. This
    is to ensure that the log level is set correctly for the log output, even if other
    layers (like the OTel / Jaeger) layer are sandwiched later. This is a minor change
    that should not affect the public API. Details are in [PR
    326](https://github.com/r3bl-org/r3bl-open-core/pull/326).

### v0.5.2 (2020-05-06)

- Changed:
   - Rewrite the `tracing_setup.rs` file so that it is easier to understand and maintain.
     The creation of multiple layers in tracing is now streamlined with no code
     redundancy. The `r3bl_terminal_async::tracing_writer_config::Writer` is renamed to
     `r3bl_terminal_async::WriterArg`. This is minor change that should only affect `clap`
     configuration in CLI programs that use this. Use the best practices from the tokio
     tracing docs
     [here](https://docs.rs/tracing-subscriber/latest/tracing_subscriber/layer/index.html#runtime-configuration-with-layers)
     as inspiration for this change.

### v0.5.1 (2024-04-28)

- Changed:
  - Simplify `SpinnerRenderer` so that it is no longer a trait. Replace with plain
    functions receive a mutable ref to a `SpinnerStyle`. This trait just added more noise,
    making it more difficult to grok what this code does.
  - `SharedWriter` now silently ignores errors on `write()` for all cloned instances. Only
    the very first instance will return an error. This is to prevent needless error
    messages being displayed when using tokio tracing. This default behavior can easily be
    overridden by setting the `silent_error` field to `false` in the `SharedWriter`
    struct. Added tests for this as well.

- Added:
  - `ReadlineEvent::Resized` is a new variant that reports when the terminal has been
    resized. This is a feature request from
    [here](https://github.com/r3bl-org/r3bl-open-core/issues/321).
  - `SharedWriter` now has a constructor `new(...)` so that it is easier to create a new
    instance of it.

### v0.5.0 (2024-04-22)

- Changed:
  - Refactor `TracingConfig`` with better expression of display preference:
    - Require a `SharedWriter` for `TracingConfig` (no longer optional).
    - Fix log filename bug (now file extensions are used when supplied).
    - Redo `TracingConfig` with better expression of display preference (`stdin`,
      `stdout`, `SharedWriter`).
  - Update example `examples/terminal_async.rs` to use the `tracing_setup::init` and
    provide a real `TracingConfig` struct, which outputs logs to display (`SharedWriter`)
    and file.

### v0.4.0 (2024-04-21)

- Changed:
  - Remove use of `TokioMutex`. There are some dangers to being "cancel safe" when using
    async Rust. This is outlined in the following:
    [docs](https://docs.rs/tokio/latest/tokio/sync/struct.Mutex.html), and
    [video](https://www.youtube.com/watch?v=1zOd52_tUWg&t=2088s). It is better to avoid
    using a `TokioMutex` to check for cancellation and instead to use broadcast channel
    for shutdown signals, just like the code already does. The changes made in this
    release are related to removing the use of `TokioMutex` all together in favor of the
    `StdMutex` since there is really no need to use it at all. And thus avoid any
    potential of "cancel safe" errors cropping up!

### v0.3.1 (2024-04-17)

- Updated:
  - Minor refactoring to remove the use of `JoinHandle::abort()` and replace it with a
    tokio broadcast channel to signal tasks to stop. This is a more graceful, flexible,
    and powerful way to stop tasks that are running in parallel. This change is applied to
    `spinner.rs` and `readline.rs`. The public API remains exactly the same.

### v0.3.0 (2024-04-15)

This is the first release of this crate.

- Added:
  - A new crate in this repo that allows for async terminal input and output. This is
    useful for building TUIs that are async and can handle input and output in parallel.
    To build apps that are not full TUI, this is a great option to create interactive CLIs
    and REPLs that are fully async and multithreaded (with input and output) with a really
    powerful (multi) line editor and prompt.

## `r3bl_ansi_color`

### v0.7.0 (2024-10-18)

This is part of a total reorganization of the `r3bl-open-core` repo. This is a breaking
change for almost every crate in the repo. This
[PR](https://github.com/r3bl-org/r3bl-open-core/pull/360) contains all the changes.

- Added:
  - Move code from `r3bl_core`'s `term.rs` to detect whether `stdin`, `stdout`, `stderr`
    is interactive. This has a dependency on the standard library, and not `crossterm`
    anymore. The API exposed here is ergonomic, and returns an `enum` rather than `bool`,
    which make it easier to use and understand.

### v0.6.10 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.6.9 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.6.8 (2023-10-16)

- Added:
  - Support for `Grayscale` color output. This is in preparation of making the color
    support work across all platforms (MacOS, Linux, Windows). And use this in the
    `r3bl_tui` crate. Update tests to reflect this.

- Removed:
  - Dependency on `once-cell` removed by replacing `Arc<Mutex<_>>` with `unsafe` and
    `AtomicI8`.

### v0.6.7 (2023-09-12)

- Added:
  - Tests.

- Replaced:
  - `justfile` is now replaced with `nu` script `run.nu`.

# Renamed

<!-- Renamed section -->

## `r3bl_rs_utils_macro`

### Rename to `r3bl_macro`

This crate is now renamed to `r3bl_macro` to make it consistent with the naming for all
crates in this repo. Please look at the [`r3bl_macro`](#r3bl_macro) for more details.

### v0.9.10 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.9.9 (2024-04-16)

- Updated:
  - Use the latest `r3bl_rs_utils_core` version `0.9.13`.

### v0.9.8 (2023-12-22)

- Updated:
  - Use latest `r3bl_rs_utils_core` version `0.9.10`. Remove unused dependencies, and
    update to the latest ones.

### v0.9.7 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.9.6 (2023-10-17)

- Updated:
  - Update `r3bl_rs_utils_core` crate due to
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>, and `ansi_term` not being
    maintained anymore.

### v0.9.5 (2023-10-14)

- Updated:
  - Dependency on `simplelog` is replaced w/ `r3bl_simple_logger` (which is in the
    `r3bl_rs_utils` repo workspace as `simple_logger`).

## `r3bl_rs_utils_core`

### Rename to `r3bl_core`

This crate is now renamed to `r3bl_core` to make it consistent with the naming for all
crates in this repo. Please look at the [`r3bl_core`](#r3bl_core) for more details.

### v0.9.16 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.9.15 (2024-09-07)

- Removed:
  - Remove `get-size` crate from `Cargo.toml`. This was causing some [issues with
    `RUSTSEC-2024-0370`](https://github.com/r3bl-org/r3bl-open-core/issues/359).

- Added:
   - Add `size-of` crate.
    - This new crate is used to calculate the size of structs in bytes
      (eg: `Vec<UnicodeString>` which is on the heap).
    - Change the implementations of many structs in the following modules: `tui_core`.
   - Add `common_math.rs` to `common` module, to make it easy to format numbers with
     commas. This is useful for displaying size in bytes or kilobytes, etc. in log output
     messages.

- Updated:
  - Use the latest deps for all crates in `Cargo.toml` and `Cargo.lock`.

### v0.9.14 (2024-08-13)

The main additions to this release are the `StringLength` enum, the `timed!()` macro, and
the `ok!()` macro.

- Added:
  - New enum `StringLength` that can be used to calculate the length of strings that have
    ANSI escape sequences in them. It also uses `UnicodeWidth` to calculate the "display"
    width of the (stripped) string. It also memoizes the result so that it is fast to
    calculate the length of the same string multiple times. This is used in the
    `r3bl_terminal_async` crate. It also has a method to calculate the SHA256 hash of a
    given `String`, and return it as a `u8`.
  - New declarative macro `timed!()` that measures the time the given expression takes to
    run using `time::Instant::now()`. If you use `timed!($expr)` then it will return a
    tuple of `($expr, duration)`.
  - New declarative macro `ok!()` that is just syntactic sugar for `Ok(())`. If you use
    `ok!($expr)` then it will return `Ok($expr)`.
  - Here's the [PR](https://github.com/r3bl-org/r3bl-open-core/pull/349) with all the code
    related to this release.

### v0.9.13 (2024-04-15)

- Changed:
  - Removed `syntect` dep.
  - Rename `Style` to `TuiStyle`.
  - Lots of cargo clippy fixes.

### v0.9.12 (2024-01-07)

- Added:
  - Add `generate_friendly_random_id()` to generate human readable and friendly IDs.

### v0.9.11 (2024-01-02)

- Added:
  - Add more variants to the `CommonErrorType` enum: `ConfigFolderCountNotBeCreated`,
    `ConfigFolderPathCouldNotBeGenerated`.

### v0.9.10 (2023-12-22)

- Updated:
  - Upgrade all the deps to their latest versions: `serde` version `1.0.190`. Propagate
    this to all the other crates in the `r3bl-open-core` repo, and bump their version
    numbers: e.g. `tuify`, `macro`, `tui`, `cmdr`.

### v0.9.9 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.9.8 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.9.7 (2023-10-17)

- Updated:
  - Dependency on `simple_logger` updated due to this security advisory
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>. `simple_logger` itself had to
    drop `ansi_term`.

### v0.9.6 (2023-10-17)

- Removed:
  - Dependency on `ansi_term` is dropped due to this security advisory
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>. Flagged when running CI/CD
    job on Ockam [repo](https://github.com/build-trust/ockam).

- Updated:
  - Documentation for `r3bl_simple_logger` crate. And how to think about it vs. using log
    facilities from the `r3bl_rs_utils_core` crate. Update docs there too.

### v0.9.5 (2023-10-14)

- Updated:
  - Dependency on `simplelog` is replaced w/ `r3bl_simple_logger` (which is in the
    `r3bl_rs_utils` repo workspace as `simple_logger`).
  - `TuiColor` has a few new variants. They can be `RgbValue`, `AnsiValue`, or `ANSIBasicColor`. It
    is safe to use just `RgbValue` since the library will degrade gracefully to ANSI 256 or
    grayscale based on terminal emulator capabilities at runtime (provided by `to_crossterm_color()`
    and `ColorSupport`). If a color is specified as `AnsiValue` or `ANSIBasicColor` then it will not
    be downgraded.

### v0.9.1 (2023-03-06)

- Added:
  - First changelog entry.
  - Move lolcat into `tui_core` crate.
- Removed:
  - ANSI escape sequences are no longer used internally in any intermediate format used by the TUI
    engine. It is reserved exclusively for output to stdout using (for now) crossterm. This opens
    the door for future support for GUI app (not just terminal emulators).

# Archived

<!-- Archived section -->

## `r3bl_simple_logger`

### Archived (2024-09-27)

This crate has been moved into the
[r3bl-open-core-archive](https://github.com/r3bl-org/r3bl-open-core-archive) repo for
archival purposes. It is no longer maintained. This crate was only added to this mono repo
since it had become unmaintained. We now use tokio tracing, so this is no longer required.

### v0.1.4 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.1.3 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.1.2 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.1.1 (2023-10-17)

- Replaced:
  - Dependency on `ansi_term` is dropped due to this security advisory
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>. Replaced with
    `r3bl_ansi_color`.

- Added:
  - Documentation for `r3bl_simple_logger` crate. And how to think about it vs. using log
    facilities from the `r3bl_rs_utils_core` crate. Update docs there too.

### v0.1.0 (2023-10-14)

- Added:
  - First changelog entry. This crate is a fork of the
    [`simplelog`](https://crates.io/crates/simplelog) repo w/ conditional compilation
    (feature flags) removed. This crate was causing transitive dependency issues in
    upstream repos that added `r3bl_tuify` as a dependency. Here's a link to the related
    [issue](https://github.com/r3bl-org/r3bl-open-core/issues/160).

## `r3bl_redux`

### Archived (2024-09-29)

This crate has been moved into the
[r3bl-open-core-archive](https://github.com/r3bl-org/r3bl-open-core-archive) repo for
archival purposes. It is no longer maintained. The redux pattern was removed from the TUI
engine in 2024, in favor of "Elm style" or "signals" based architecture.

### v0.2.8 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.2.7 (2024-09-07)

- Removed:
  - Remove `get-size` crate from `Cargo.toml`. This was causing some [issues with
    `RUSTSEC-2024-0370`](https://github.com/r3bl-org/r3bl-open-core/issues/359).

- Updated:
  - Use the latest deps for all crates in `Cargo.toml` and `Cargo.lock`.

### v0.2.6 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.2.5 (2023-10-17)

- Updated:
  - Dependency on `r3bl_rs_utils_core` & `r3bl_rs_utils_macro` crates due to
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>, and `ansi_term` not being
    maintained anymore.

### v0.2.4 (2023-10-14)

- Updated:
  - Dependency on `simplelog` is replaced w/ `r3bl_simple_logger` (which is in the
    `r3bl_rs_utils` repo workspace as `simple_logger`).

- Removed:
  - Dependency on `ansi_term` which is no longer maintained
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>.
  - Needless dependencies on crates that are not used.

## `r3bl_rs_utils`

### Archived (2024-09-30)

This crate has been moved into the
[r3bl-open-core-archive](https://github.com/r3bl-org/r3bl-open-core-archive) repo for
archival purposes. It is no longer maintained.

### v0.9.16 (2024-09-12)

- Updated:
  - Upgrade all deps to their latest versions in `Cargo.toml` and `Cargo.lock`.
  - Improve docs in `lib.rs` and `README.md`.

### v0.9.15 (2023-12-22)

- Updated:
  - Add single dependency on `r3bl_rs_utils_core` version `0.9.10`.

- Removed:
  - Remove all the unnecessary dependencies from `Cargo.toml`.
  - Remove all unnecessary `dev-dependencies` from `Cargo.toml`.

- Moved:
  - All the source code from the top level folder of the `r3bl-open-core` repo into the
    `utils` sub folder. The crate `r3bl_rs_utils` used to reside at the top level folder
    of this repo. It has been moved into the `utils` sub folder. At the top level, only a
    workspace remains to link all the contained crates together for efficient builds.

### v0.9.14 (2023-10-29)

- Updated:
  - Upgrade all deps to their latest versions (including `r3bl_tui` w/ latest copy, paste,
    cut, delete support).

### v0.9.13 (2023-10-29)

- Updated:
  - Upgraded `r3bl_tui` to latest version.

### v0.9.12 (2023-10-29)

- Forgot to update the r3bl_tui dependency in Cargo.toml.

### v0.9.11 (2023-10-28)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.9.10 (2023-10-21)

- Updated:
  - Upgrade all deps to their latest versions.

### v0.9.9

- Changes:
  - Use latest dependencies on the `r3bl_rs_utils` repo. Lots of needless dependencies
    have been dropped.
  - Drop `ansi_term` dependency due to security advisory
    <https://rustsec.org/advisories/RUSTSEC-2021-0139.html>.

<!-- changelog info section -->

# More info on changelogs

- https://keepachangelog.com/en/1.0.0/
- https://co-pilot.dev/changelog