# Python tools using playground

<p align="center">
<a href="https://github.com/quickhack/pytound/actions/workflows/ci.yml"><img src="https://img.shields.io/github/actions/workflow/status/quickhack/pytound/ci.yml?branch=main&logo=github&logoColor=white" alt="Github Workflow Build Status"></a>
<a href="https://app.codecov.io/gh/quickhack/pytound/tree/main"><img src="https://img.shields.io/codecov/c/github/quickhack/pytound/main?logo=codecov&logoColor=white" alt="Codecov"></a>
<a href="https://devguide.python.org/versions/"><img src="https://img.shields.io/badge/3.8+-339933?label=python&logo=python&logoColor=white" alt="support python versions"></a>
<a href="https://www.apache.org/licenses/LICENSE-2.0.html"><img src="https://img.shields.io/github/license/quickhack/pytound?color=4D7A97&logo=apache" alt="License"></a>
<a href="https://github.com/quickhack/pytound"><img src="https://img.shields.io/github/repo-size/quickhack/pytound" alt="GitHub repo size"></a>
<a href="https://gitpod.io/#https://github.com/quickhack/pytound"><img src="https://img.shields.io/badge/Gitpod-ready to code-339933?label=gitpod&logo=gitpod&logoColor=white" alt="gitpod: Ready to Code"></a>
</p>

## Essential tools

- `poetry`: a tool for dependency management and packaging in Python. It allows you to declare the libraries your project depends on and it will manage (install/update) them for you. Poetry offers a lockfile to ensure repeatable installs, and can build your project for distribution.
  - https://python-poetry.org/docs/
  - https://github.com/python-poetry/poetry
- `pytest`: a mature full-featured Python testing tool that helps you write better programs.
  - https://docs.pytest.org/
  - https://github.com/pytest-dev/pytest
- `coverage.py`(`pytest-cov`/`codecov.io`): a tool for measuring code coverage of Python programs.
  - https://coverage.readthedocs.org/
  - https://github.com/nedbat/coveragepy
  - https://github.com/pytest-dev/pytest-cov
  - https://docs.codecov.com/docs/code-coverage-with-python
- `hypothesis`: an advanced Quickcheck style property based testing library.
  - https://hypothesis.readthedocs.io/
  - https://github.com/HypothesisWorks/hypothesis

## QA tools

- `mypy`: a static type checker for Python.
  - https://mypy.readthedocs.io/
  - https://github.com/python/mypy
- `Flake8`: Your Tool For Style Guide Enforcement.
  - https://flake8.pycqa.org/
  - https://github.com/PyCQA/flake8
- `isort`:  isort your imports, so you don't have to.
  - https://pycqa.github.io/isort/
  - https://github.com/PyCQA/isort
- `black`: The uncompromising Python code formatter.
  - https://black.readthedocs.io/
  - https://github.com/psf/black

## Advanced tools

- `tox`: automate and standardize testing in Python.
  - https://tox.wiki/
  - https://github.com/tox-dev/tox

## More resources

- `awesome-python`: https://github.com/vinta/awesome-python
