<?php

declare(strict_types=1);

namespace Quartetcom\StaticAnalysisKit\EasyCodingStandard;

use Quartetcom\StaticAnalysisKit\ProcessTtyTrait;
use Symfony\Component\Process\Process;

class Runner
{
    use ProcessTtyTrait;

    /**
     * @param list<string> $command
     */
    public function __construct(
        private readonly array $command = ['php', './vendor/bin/ecs', 'check', '--config=./ecs.local.php'],
        private readonly string $distConfigPath = './ecs.php',
        private readonly string $configPath = './ecs.local.php',
    ) {
    }

    /**
     * @param list<string> $additionalArguments
     */
    public function run(bool $risky, array $additionalArguments = []): int
    {
        $distConfigPath = $this->distConfigPath;
        $configPath = $this->configPath;

        $useRiskyRules = $risky ? 'true' : 'false';
        $config = <<<"EOF"
            <?php // GENERATED BY quartetcom/static-analysis-kit. DO NOT EDIT.

            declare(strict_types=1);

            use Quartetcom\\StaticAnalysisKit\\EasyCodingStandard\\Config;
            use Symplify\\EasyCodingStandard\\Config\\ECSConfig;

            return function (ECSConfig \$ecsConfig): void {
                if ({$useRiskyRules}) {
                    Config::useRisky(\$ecsConfig);
                }

                \$distConfig = @include('{$distConfigPath}');
                if (\$distConfig) {
                    \$distConfig(\$ecsConfig);
                } else {
                    Config::use(\$ecsConfig);
                }
            };

            EOF;

        if (file_exists($configPath)) {
            throw new \RuntimeException(
                "File '{$configPath}' already exists. Use '{$distConfigPath}' instead.",
            );
        }

        file_put_contents($configPath, $config);

        $exitCode = $this->runInTtyOrFallback(new Process([...$this->command, ...$additionalArguments], timeout: null));

        @unlink($configPath);

        return $exitCode;
    }
}
