﻿unit VisitStripEmptySpace;

{ AFS 7 March 2003
  needed after SpaceBeforeColon
  It is possible that some tokens will be spaces
  with sourcecode = '' null/empty string
  discared these
}

{(*}
(*------------------------------------------------------------------------------
 Delphi Code formatter source code 

The Original Code is VisitStripEmptySpace, released May 2003.
The Initial Developer of the Original Code is Anthony Steele. 
Portions created by Anthony Steele are Copyright (C) 1999-2008 Anthony Steele.
All Rights Reserved. 
Contributor(s): Anthony Steele. 

The contents of this file are subject to the Mozilla Public License Version 1.1
(the "License"). you may not use this file except in compliance with the License.
You may obtain a copy of the License at http://www.mozilla.org/NPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.
See the License for the specific language governing rights and limitations 
under the License.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 or later (the "GPL") 
See http://www.gnu.org/licenses/gpl.html
------------------------------------------------------------------------------*)
{*)}

{$I JcfGlobal.inc}

interface

uses BaseVisitor;

type
  TVisitStripEmptySpace = class(TBaseTreeNodeVisitor)
  public
    function VisitSourceToken(const pcToken: TObject): Boolean; override;
  end;

implementation

uses SourceToken, Tokens;

function TVisitStripEmptySpace.VisitSourceToken(const pcToken: TObject): Boolean;
var
  lcSourceToken, lcNext: TSourceToken;
begin
  Result := False;
  lcSourceToken := TSourceToken(pcToken);

  if (lcSourceToken <> nil) and (lcSourceToken.TokenType = ttWhiteSpace) then
    if (lcSourceToken.SourceCode = '') then
    begin
      lcSourceToken.Free;
      Result := True;
    end
    else
    begin
      lcNext := lcSourceToken.NextToken;
      { consolidate }
      if (lcNext <> nil) and (lcNext.TokenType = ttWhiteSpace) then
      begin
        lcNext.SourceCode := lcNext.SourceCode + lcSourceToken.SourceCode;
        lcSourceToken.Free;
        Result := True;
      end;
    end{ remove };
end;

end.
